/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.spark.pyramid;

import geotrellis.layer.Boundable;
import geotrellis.layer.Bounds;
import geotrellis.layer.EmptyBounds$;
import geotrellis.layer.KeyBounds;
import geotrellis.layer.KeyBounds$;
import geotrellis.layer.LayoutDefinition;
import geotrellis.layer.LayoutLevel;
import geotrellis.layer.LayoutScheme;
import geotrellis.layer.LocalLayoutScheme;
import geotrellis.layer.Metadata;
import geotrellis.layer.SpatialKey;
import geotrellis.raster.CellGrid;
import geotrellis.raster.GridBounds;
import geotrellis.raster.Raster;
import geotrellis.raster.RasterExtent;
import geotrellis.raster.RasterExtent$;
import geotrellis.raster.merge.TileMergeMethods;
import geotrellis.raster.prototype.TilePrototypeMethods;
import geotrellis.raster.resample.Average$;
import geotrellis.raster.resample.CubicConvolution$;
import geotrellis.raster.resample.CubicSpline$;
import geotrellis.raster.resample.Lanczos$;
import geotrellis.raster.resample.NearestNeighbor$;
import geotrellis.raster.resample.PointResampleMethod;
import geotrellis.raster.resample.ResampleMethod;
import geotrellis.spark.ContextRDD;
import geotrellis.spark.pyramid.Pyramid;
import geotrellis.spark.pyramid.Pyramid$Options$;
import geotrellis.spark.store.LayerReader;
import geotrellis.store.LayerId;
import geotrellis.store.avro.AvroRecordCodec;
import geotrellis.util.Component;
import geotrellis.util.GetComponent;
import geotrellis.util.SetComponent;
import geotrellis.vector.Extent;
import io.circe.Decoder;
import io.circe.Encoder;
import java.io.Serializable;
import org.apache.spark.Partitioner;
import org.apache.spark.rdd.PairRDDFunctions;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.serializer.Serializer;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Stream;
import scala.collection.immutable.Stream$;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;
import scala.runtime.RichInt$;

public final class Pyramid$
implements scala.Serializable {
    public static Pyramid$ MODULE$;

    static {
        new Pyramid$();
    }

    public <K, V extends CellGrid<Object>, M> Pyramid<K, V, M> fromLayerReader(String layerName, LayerReader<LayerId> layerReader, Option<Object> maxZoom, Option<Object> minZoom, AvroRecordCodec<K> evidence$8, Boundable<K> evidence$9, Encoder<K> evidence$10, Decoder<K> evidence$11, ClassTag<K> evidence$12, Component<K, SpatialKey> evidence$13, Function1<V, TilePrototypeMethods<V>> evidence$14, Function1<V, TileMergeMethods<V>> evidence$15, AvroRecordCodec<V> evidence$16, ClassTag<V> evidence$17, Encoder<M> evidence$18, Decoder<M> evidence$19, Component<M, Bounds<K>> evidence$20, Component<M, LayoutDefinition> evidence$21) {
        int n;
        int n2;
        Seq zooms = layerReader.attributeStore().availableZoomLevels(layerName);
        Option<Object> option = maxZoom;
        if (option instanceof Some) {
            Some some = (Some)option;
            int z2 = BoxesRunTime.unboxToInt((Object)some.value());
            if (z2 > BoxesRunTime.unboxToInt((Object)zooms.max((Ordering)Ordering.Int$.MODULE$))) {
                throw new IllegalArgumentException(new StringBuilder(61).append("Requested max zoom of ").append(z2).append(" is greater than max available zoom of ").append(zooms.max((Ordering)Ordering.Int$.MODULE$)).toString());
            }
            n2 = z2;
        } else if (None$.MODULE$.equals(option)) {
            n2 = BoxesRunTime.unboxToInt((Object)zooms.max((Ordering)Ordering.Int$.MODULE$));
        } else {
            throw new MatchError(option);
        }
        int maxZoomLevel = n2;
        Option<Object> option2 = maxZoom;
        if (option2 instanceof Some) {
            Some some = (Some)option2;
            int z3 = BoxesRunTime.unboxToInt((Object)some.value());
            if (z3 < BoxesRunTime.unboxToInt((Object)zooms.min((Ordering)Ordering.Int$.MODULE$))) {
                throw new IllegalArgumentException(new StringBuilder(61).append("Requested min zoom of ").append(z3).append(" is greater than min available zoom of ").append(zooms.min((Ordering)Ordering.Int$.MODULE$)).toString());
            }
            n = z3;
        } else if (None$.MODULE$.equals(option2)) {
            n = BoxesRunTime.unboxToInt((Object)zooms.min((Ordering)Ordering.Int$.MODULE$));
        } else {
            throw new MatchError(option2);
        }
        int minZoomLevel = n;
        IndexedSeq seq = (IndexedSeq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(maxZoomLevel), minZoomLevel).by(-1).map((Function1 & Serializable & scala.Serializable)z -> Pyramid$.$anonfun$fromLayerReader$1(layerReader, layerName, evidence$8, evidence$9, evidence$11, evidence$12, evidence$16, evidence$17, evidence$19, evidence$20, BoxesRunTime.unboxToInt((Object)z)), IndexedSeq$.MODULE$.canBuildFrom());
        return new Pyramid<K, V, M>(seq.toMap(Predef$.MODULE$.$conforms()), evidence$13, evidence$12, evidence$17, evidence$14, evidence$15, evidence$21, evidence$20);
    }

    public <K, V extends CellGrid<Object>, M> Option<Object> fromLayerReader$default$3() {
        return None$.MODULE$;
    }

    public <K, V extends CellGrid<Object>, M> Option<Object> fromLayerReader$default$4() {
        return None$.MODULE$;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public <K, V extends CellGrid<Object>, M> Pyramid<K, V, M> fromLayerRDD(RDD<Tuple2<K, V>> rdd, Option<Object> thisZoom, Option<Object> endZoom, ResampleMethod resampleMethod, Option<Partitioner> partitioner, Component<K, SpatialKey> evidence$22, ClassTag<K> evidence$23, ClassTag<V> evidence$24, Function1<V, TilePrototypeMethods<V>> evidence$25, Function1<V, TileMergeMethods<V>> evidence$26, Component<M, LayoutDefinition> evidence$27, Component<M, Bounds<K>> evidence$28) {
        Pyramid.Options opts = new Pyramid.Options(resampleMethod, partitioner);
        Bounds bounds = (Bounds)geotrellis.util.package$.MODULE$.withGetComponentMethods(((Metadata)rdd).metadata()).getComponent(evidence$28);
        if (!(bounds instanceof KeyBounds)) throw new IllegalArgumentException("Cannot construct a pyramid for an empty layer");
        KeyBounds keyBounds = (KeyBounds)bounds;
        GridBounds gridBounds = KeyBounds$.MODULE$.withSpatialComponentKeyBoundsMethods(keyBounds, evidence$22).toGridBounds();
        GridBounds gridBounds2 = gridBounds;
        double maxDim = scala.math.package$.MODULE$.max(gridBounds2.width$mcI$sp(), gridBounds2.height$mcI$sp());
        int levels = (int)scala.math.package$.MODULE$.ceil(scala.math.package$.MODULE$.log(maxDim) / scala.math.package$.MODULE$.log(2.0));
        Tuple2 tuple2 = new Tuple2(thisZoom, endZoom);
        if (tuple2 != null) {
            Option option = (Option)tuple2._1();
            Option option2 = (Option)tuple2._2();
            if (None$.MODULE$.equals(option) && None$.MODULE$.equals(option2)) {
                return new Pyramid<K, V, M>(this.levelStream(rdd, (LayoutScheme)new LocalLayoutScheme(), levels, 0, opts, evidence$22, evidence$23, evidence$24, evidence$26, evidence$25, evidence$27, evidence$28).toMap(Predef$.MODULE$.$conforms()), evidence$22, evidence$23, evidence$24, evidence$25, evidence$26, evidence$27, evidence$28);
            }
        }
        if (tuple2 != null) {
            Option option = (Option)tuple2._1();
            Option option3 = (Option)tuple2._2();
            if (option instanceof Some) {
                Some some = (Some)option;
                int start = BoxesRunTime.unboxToInt((Object)some.value());
                if (None$.MODULE$.equals(option3)) {
                    return new Pyramid<K, V, M>(this.levelStream(rdd, (LayoutScheme)new LocalLayoutScheme(), start, scala.math.package$.MODULE$.max(0, start - levels), opts, evidence$22, evidence$23, evidence$24, evidence$26, evidence$25, evidence$27, evidence$28).toMap(Predef$.MODULE$.$conforms()), evidence$22, evidence$23, evidence$24, evidence$25, evidence$26, evidence$27, evidence$28);
                }
            }
        }
        if (tuple2 != null) {
            Option option = (Option)tuple2._1();
            Option option4 = (Option)tuple2._2();
            if (None$.MODULE$.equals(option) && option4 instanceof Some) {
                Some some = (Some)option4;
                int end = BoxesRunTime.unboxToInt((Object)some.value());
                return new Pyramid<K, V, M>(this.levelStream(rdd, (LayoutScheme)new LocalLayoutScheme(), end + levels, end, opts, evidence$22, evidence$23, evidence$24, evidence$26, evidence$25, evidence$27, evidence$28).toMap(Predef$.MODULE$.$conforms()), evidence$22, evidence$23, evidence$24, evidence$25, evidence$26, evidence$27, evidence$28);
            }
        }
        if (tuple2 == null) throw new MatchError((Object)tuple2);
        Option option = (Option)tuple2._1();
        Option option5 = (Option)tuple2._2();
        if (!(option instanceof Some)) throw new MatchError((Object)tuple2);
        Some some = (Some)option;
        int start = BoxesRunTime.unboxToInt((Object)some.value());
        if (!(option5 instanceof Some)) throw new MatchError((Object)tuple2);
        Some some2 = (Some)option5;
        int end = BoxesRunTime.unboxToInt((Object)some2.value());
        return new Pyramid<K, V, M>(this.levelStream(rdd, (LayoutScheme)new LocalLayoutScheme(), start, end, opts, evidence$22, evidence$23, evidence$24, evidence$26, evidence$25, evidence$27, evidence$28).toMap(Predef$.MODULE$.$conforms()), evidence$22, evidence$23, evidence$24, evidence$25, evidence$26, evidence$27, evidence$28);
    }

    public <K, V extends CellGrid<Object>, M> Option<Object> fromLayerRDD$default$2() {
        return None$.MODULE$;
    }

    public <K, V extends CellGrid<Object>, M> Option<Object> fromLayerRDD$default$3() {
        return None$.MODULE$;
    }

    public <K, V extends CellGrid<Object>, M> ResampleMethod fromLayerRDD$default$4() {
        return Average$.MODULE$;
    }

    public <K, V extends CellGrid<Object>, M> Option<Partitioner> fromLayerRDD$default$5() {
        return None$.MODULE$;
    }

    public <K, V extends CellGrid<Object>, M> Tuple2<Object, RDD<Tuple2<K, V>>> up(RDD<Tuple2<K, V>> rdd, LayoutScheme layoutScheme, int zoom, Pyramid.Options options, Component<K, SpatialKey> evidence$29, ClassTag<K> evidence$30, ClassTag<V> evidence$31, Function1<V, TilePrototypeMethods<V>> evidence$32, Function1<V, TileMergeMethods<V>> evidence$33, Component<M, LayoutDefinition> evidence$34, Component<M, Bounds<K>> evidence$35) {
        EmptyBounds$ emptyBounds$;
        Pyramid.Options options2 = options;
        if (options2 == null) {
            throw new MatchError((Object)options2);
        }
        ResampleMethod resampleMethod = options2.resampleMethod();
        Option<Partitioner> partitioner = options2.partitioner();
        Tuple2 tuple2 = new Tuple2((Object)resampleMethod, partitioner);
        Tuple2 tuple22 = tuple2;
        ResampleMethod resampleMethod2 = (ResampleMethod)tuple22._1();
        Option partitioner2 = (Option)tuple22._2();
        Predef$.MODULE$.assert(!((SeqLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new PointResampleMethod[]{CubicConvolution$.MODULE$, CubicSpline$.MODULE$, Lanczos$.MODULE$}))).contains((Object)resampleMethod2), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(58).append(resampleMethod2).append(" resample method is not supported for pyramid construction").toString());
        LayoutDefinition sourceLayout = (LayoutDefinition)geotrellis.util.package$.MODULE$.withGetComponentMethods(((Metadata)rdd).metadata()).getComponent(evidence$34);
        Bounds sourceBounds = (Bounds)geotrellis.util.package$.MODULE$.withGetComponentMethods(((Metadata)rdd).metadata()).getComponent(evidence$35);
        LayoutLevel layoutLevel = layoutScheme.zoomOut(new LayoutLevel(zoom, sourceLayout));
        if (layoutLevel == null) {
            throw new MatchError((Object)layoutLevel);
        }
        int nextZoom = layoutLevel.zoom();
        LayoutDefinition nextLayout = layoutLevel.layout();
        Tuple2 tuple23 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)nextZoom), (Object)nextLayout);
        Tuple2 tuple24 = tuple23;
        int nextZoom2 = tuple24._1$mcI$sp();
        LayoutDefinition nextLayout2 = (LayoutDefinition)tuple24._2();
        Predef$.MODULE$.assert(sourceLayout.tileCols() % 2 == 0 && sourceLayout.tileRows() % 2 == 0, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(62).append("Pyramid operation requires tiles with even dimensions, got ").append(sourceLayout.tileCols()).append(" x ").append(sourceLayout.tileRows()).toString());
        Bounds bounds = sourceBounds;
        if (EmptyBounds$.MODULE$.equals(bounds)) {
            emptyBounds$ = EmptyBounds$.MODULE$;
        } else if (bounds instanceof KeyBounds) {
            KeyBounds keyBounds = (KeyBounds)bounds;
            Extent extent = sourceLayout.extent();
            RasterExtent sourceRe = RasterExtent$.MODULE$.apply(extent, sourceLayout.layoutCols(), sourceLayout.layoutRows());
            RasterExtent targetRe = RasterExtent$.MODULE$.apply(extent, nextLayout2.layoutCols(), nextLayout2.layoutRows());
            SpatialKey spatialKey = (SpatialKey)geotrellis.util.package$.MODULE$.withGetComponentMethods(keyBounds.minKey()).getComponent(evidence$29);
            if (spatialKey == null) {
                throw new MatchError((Object)spatialKey);
            }
            int sourceColMin = spatialKey.col();
            int sourceRowMin = spatialKey.row();
            Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(sourceColMin, sourceRowMin);
            Tuple2.mcII.sp sp3 = sp2;
            int sourceColMin2 = sp3._1$mcI$sp();
            int sourceRowMin2 = sp3._2$mcI$sp();
            SpatialKey spatialKey2 = (SpatialKey)geotrellis.util.package$.MODULE$.withGetComponentMethods(keyBounds.maxKey()).getComponent(evidence$29);
            if (spatialKey2 == null) {
                throw new MatchError((Object)spatialKey2);
            }
            int sourceColMax = spatialKey2.col();
            int sourceRowMax = spatialKey2.row();
            Tuple2.mcII.sp sp4 = new Tuple2.mcII.sp(sourceColMax, sourceRowMax);
            Tuple2.mcII.sp sp5 = sp4;
            int sourceColMax2 = sp5._1$mcI$sp();
            int sourceRowMax2 = sp5._2$mcI$sp();
            Tuple2 tuple25 = sourceRe.gridToMap$mcI$sp(sourceColMin2, sourceRowMin2);
            if (tuple25 == null) {
                throw new MatchError((Object)tuple25);
            }
            double x = tuple25._1$mcD$sp();
            double y = tuple25._2$mcD$sp();
            Tuple2.mcDD.sp sp6 = new Tuple2.mcDD.sp(x, y);
            Tuple2.mcDD.sp sp7 = sp6;
            double x2 = sp7._1$mcD$sp();
            double y2 = sp7._2$mcD$sp();
            Tuple2 tuple26 = targetRe.mapToGrid$mcI$sp(x2, y2);
            if (tuple26 == null) {
                throw new MatchError((Object)tuple26);
            }
            int colMin = tuple26._1$mcI$sp();
            int rowMin = tuple26._2$mcI$sp();
            Tuple2.mcII.sp sp8 = new Tuple2.mcII.sp(colMin, rowMin);
            Tuple2.mcII.sp sp9 = sp8;
            int colMin2 = sp9._1$mcI$sp();
            int rowMin2 = sp9._2$mcI$sp();
            Tuple2 tuple27 = sourceRe.gridToMap$mcI$sp(sourceColMax2, sourceRowMax2);
            if (tuple27 == null) {
                throw new MatchError((Object)tuple27);
            }
            double x3 = tuple27._1$mcD$sp();
            double y3 = tuple27._2$mcD$sp();
            Tuple2.mcDD.sp sp10 = new Tuple2.mcDD.sp(x3, y3);
            Tuple2.mcDD.sp sp11 = sp10;
            double x4 = sp11._1$mcD$sp();
            double y4 = sp11._2$mcD$sp();
            Tuple2 tuple28 = targetRe.mapToGrid$mcI$sp(x4, y4);
            if (tuple28 == null) {
                throw new MatchError((Object)tuple28);
            }
            int colMax = tuple28._1$mcI$sp();
            int rowMax = tuple28._2$mcI$sp();
            Tuple2.mcII.sp sp12 = new Tuple2.mcII.sp(colMax, rowMax);
            Tuple2.mcII.sp sp13 = sp12;
            int colMax2 = sp13._1$mcI$sp();
            int rowMax2 = sp13._2$mcI$sp();
            emptyBounds$ = new KeyBounds(geotrellis.util.package$.MODULE$.withSetComponentMethods(keyBounds.minKey()).setComponent((Object)new SpatialKey(colMin2, rowMin2), evidence$29), geotrellis.util.package$.MODULE$.withSetComponentMethods(keyBounds.maxKey()).setComponent((Object)new SpatialKey(colMax2, rowMax2), evidence$29));
        } else {
            throw new MatchError((Object)bounds);
        }
        EmptyBounds$ nextKeyBounds = emptyBounds$;
        Object nextMetadata = geotrellis.util.package$.MODULE$.withSetComponentMethods(geotrellis.util.package$.MODULE$.withSetComponentMethods(((Metadata)rdd).metadata()).setComponent((Object)nextLayout2, evidence$34)).setComponent((Object)nextKeyBounds, evidence$35);
        RDD transformedRdd = rdd.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Object key = tuple2._1();
            CellGrid tile = (CellGrid)tuple2._2();
            Extent extent = ((SpatialKey)geotrellis.util.package$.MODULE$.withGetComponentMethods(key).getComponent((GetComponent)evidence$29)).extent(sourceLayout);
            SpatialKey newSpatialKey = nextLayout2.mapTransform().apply(extent.center());
            CellGrid resampled = ((TilePrototypeMethods)evidence$32.apply((Object)tile)).prototype(sourceLayout.tileCols() / 2, sourceLayout.tileRows() / 2);
            ((TileMergeMethods)evidence$33.apply((Object)resampled)).merge(extent, extent, (Object)tile, resampleMethod2);
            Tuple2 tuple22 = new Tuple2(geotrellis.util.package$.MODULE$.withSetComponentMethods(key).setComponent((Object)newSpatialKey, (SetComponent)evidence$29), (Object)new Raster(resampled, extent));
            return tuple22;
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        RDD nextRdd = ((RDD)partitioner2.fold((Function0 & Serializable & scala.Serializable)() -> {
            RDD x$1 = transformedRdd;
            ClassTag x$2 = evidence$30;
            ClassTag x$3 = ClassTag$.MODULE$.apply(Raster.class);
            Null$ x$4 = RDD$.MODULE$.rddToPairRDDFunctions$default$4(x$1);
            return RDD$.MODULE$.rddToPairRDDFunctions(x$1, x$2, x$3, null).combineByKey((Function1 & Serializable & scala.Serializable)tile -> Pyramid$.createTiles$1(tile), (Function2 & Serializable & scala.Serializable)(tiles, tile) -> Pyramid$.mergeTiles1$1(tiles, tile), (Function2 & Serializable & scala.Serializable)(tiles1, tiles2) -> Pyramid$.mergeTiles2$1(tiles1, tiles2));
        }, (Function1 & Serializable & scala.Serializable)x$10 -> {
            RDD x$5 = transformedRdd;
            ClassTag x$6 = evidence$30;
            ClassTag x$7 = ClassTag$.MODULE$.apply(Raster.class);
            Null$ x$8 = RDD$.MODULE$.rddToPairRDDFunctions$default$4(x$5);
            PairRDDFunctions qual$1 = RDD$.MODULE$.rddToPairRDDFunctions(x$5, x$6, x$7, null);
            Function1 & Serializable & scala.Serializable x$9 = (Function1 & Serializable & scala.Serializable)tile -> Pyramid$.createTiles$1(tile);
            Function2 & Serializable & scala.Serializable x$102 = (Function2 & Serializable & scala.Serializable)(tiles, tile) -> Pyramid$.mergeTiles1$1(tiles, tile);
            Function2 & Serializable & scala.Serializable x$11 = (Function2 & Serializable & scala.Serializable)(tiles1, tiles2) -> Pyramid$.mergeTiles2$1(tiles1, tiles2);
            Partitioner x$12 = x$10;
            boolean x$13 = qual$1.combineByKey$default$5();
            Serializer x$14 = qual$1.combineByKey$default$6();
            return qual$1.combineByKey((Function1)x$9, (Function2)x$102, (Function2)x$11, x$12, x$13, x$14);
        })).mapPartitions((Function1 & Serializable & scala.Serializable)partition -> partition.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Seq seq;
            Object newKey;
            block3: {
                Tuple2 tuple2;
                block2: {
                    tuple2 = x0$2;
                    if (tuple2 == null) break block2;
                    newKey = tuple2._1();
                    seq = (Seq)tuple2._2();
                    Option option = evidence$30.unapply(newKey);
                    if (!option.isEmpty() && option.get() instanceof Object && seq != null) break block3;
                }
                throw new MatchError((Object)tuple2);
            }
            Seq seq2 = seq;
            Extent newExtent = ((SpatialKey)geotrellis.util.package$.MODULE$.withGetComponentMethods(newKey).getComponent((GetComponent)evidence$29)).extent(nextLayout2);
            CellGrid newTile = ((TilePrototypeMethods)evidence$32.apply((Object)((Raster)seq2.head()).tile())).prototype(nextLayout2.tileLayout().tileCols(), nextLayout2.tileLayout().tileRows());
            seq2.foreach((Function1 & Serializable & scala.Serializable)raster -> (CellGrid)((TileMergeMethods)evidence$33.apply((Object)newTile)).merge(newExtent, raster.extent(), (Object)raster.tile(), (ResampleMethod)NearestNeighbor$.MODULE$));
            Tuple2 tuple2 = new Tuple2(newKey, (Object)newTile);
            return tuple2;
        }), true, ClassTag$.MODULE$.apply(Tuple2.class));
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)nextZoom2)), new ContextRDD(nextRdd, nextMetadata));
    }

    public <K, V extends CellGrid<Object>, M> Tuple2<Object, RDD<Tuple2<K, V>>> up(RDD<Tuple2<K, V>> rdd, LayoutScheme layoutScheme, int zoom, Component<K, SpatialKey> evidence$36, ClassTag<K> evidence$37, ClassTag<V> evidence$38, Function1<V, TileMergeMethods<V>> evidence$39, Function1<V, TilePrototypeMethods<V>> evidence$40, Component<M, LayoutDefinition> evidence$41, Component<M, Bounds<K>> evidence$42) {
        return this.up(rdd, layoutScheme, zoom, Pyramid$Options$.MODULE$.DEFAULT(), evidence$36, evidence$37, evidence$38, evidence$40, evidence$39, evidence$41, evidence$42);
    }

    public <K, V extends CellGrid<Object>, M> Stream<Tuple2<Object, RDD<Tuple2<K, V>>>> levelStream(RDD<Tuple2<K, V>> rdd, LayoutScheme layoutScheme, int startZoom, int endZoom, Pyramid.Options options, Component<K, SpatialKey> evidence$43, ClassTag<K> evidence$44, ClassTag<V> evidence$45, Function1<V, TileMergeMethods<V>> evidence$46, Function1<V, TilePrototypeMethods<V>> evidence$47, Component<M, LayoutDefinition> evidence$48, Component<M, Bounds<K>> evidence$49) {
        Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)startZoom), rdd);
        return Stream$.MODULE$.consWrapper((Function0 & Serializable & scala.Serializable)() -> {
            Stream stream;
            if (startZoom > endZoom) {
                Tuple2 tuple2 = MODULE$.up(rdd, layoutScheme, startZoom, options, evidence$43, evidence$44, evidence$45, evidence$47, evidence$46, evidence$48, evidence$49);
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                int nextZoom = tuple2._1$mcI$sp();
                RDD nextRdd = (RDD)tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)nextZoom), (Object)nextRdd);
                Tuple2 tuple23 = tuple22;
                int nextZoom2 = tuple23._1$mcI$sp();
                RDD nextRdd2 = (RDD)tuple23._2();
                stream = MODULE$.levelStream(nextRdd2, layoutScheme, nextZoom2, endZoom, options, evidence$43, evidence$44, evidence$45, evidence$46, evidence$47, evidence$48, evidence$49);
            } else {
                stream = package$.MODULE$.Stream().empty();
            }
            return stream;
        }).$hash$colon$colon((Object)tuple2);
    }

    public <K, V extends CellGrid<Object>, M> Stream<Tuple2<Object, RDD<Tuple2<K, V>>>> levelStream(RDD<Tuple2<K, V>> rdd, LayoutScheme layoutScheme, int startZoom, int endZoom, Component<K, SpatialKey> evidence$50, ClassTag<K> evidence$51, ClassTag<V> evidence$52, Function1<V, TileMergeMethods<V>> evidence$53, Function1<V, TilePrototypeMethods<V>> evidence$54, Component<M, LayoutDefinition> evidence$55, Component<M, Bounds<K>> evidence$56) {
        return this.levelStream(rdd, layoutScheme, startZoom, endZoom, Pyramid$Options$.MODULE$.DEFAULT(), evidence$50, evidence$51, evidence$52, evidence$53, evidence$54, evidence$55, evidence$56);
    }

    public <K, V extends CellGrid<Object>, M> Stream<Tuple2<Object, RDD<Tuple2<K, V>>>> levelStream(RDD<Tuple2<K, V>> rdd, LayoutScheme layoutScheme, int startZoom, Pyramid.Options options, Component<K, SpatialKey> evidence$57, ClassTag<K> evidence$58, ClassTag<V> evidence$59, Function1<V, TileMergeMethods<V>> evidence$60, Function1<V, TilePrototypeMethods<V>> evidence$61, Component<M, LayoutDefinition> evidence$62, Component<M, Bounds<K>> evidence$63) {
        return this.levelStream(rdd, layoutScheme, startZoom, 0, options, evidence$57, evidence$58, evidence$59, evidence$60, evidence$61, evidence$62, evidence$63);
    }

    public <K, V extends CellGrid<Object>, M> Stream<Tuple2<Object, RDD<Tuple2<K, V>>>> levelStream(RDD<Tuple2<K, V>> rdd, LayoutScheme layoutScheme, int startZoom, Component<K, SpatialKey> evidence$64, ClassTag<K> evidence$65, ClassTag<V> evidence$66, Function1<V, TileMergeMethods<V>> evidence$67, Function1<V, TilePrototypeMethods<V>> evidence$68, Component<M, LayoutDefinition> evidence$69, Component<M, Bounds<K>> evidence$70) {
        return this.levelStream(rdd, layoutScheme, startZoom, Pyramid$Options$.MODULE$.DEFAULT(), evidence$64, evidence$65, evidence$66, evidence$67, evidence$68, evidence$69, evidence$70);
    }

    public <K, V extends CellGrid<Object>, M> RDD<Tuple2<K, V>> upLevels(RDD<Tuple2<K, V>> rdd, LayoutScheme layoutScheme, int startZoom, int endZoom, Pyramid.Options options, Function2<RDD<Tuple2<K, V>>, Object, BoxedUnit> f, Component<K, SpatialKey> evidence$71, ClassTag<K> evidence$72, ClassTag<V> evidence$73, Function1<V, TileMergeMethods<V>> evidence$74, Function1<V, TilePrototypeMethods<V>> evidence$75, Component<M, LayoutDefinition> evidence$76, Component<M, Bounds<K>> evidence$77) {
        Pyramid.Options options2 = options;
        if (options2 == null) {
            throw new MatchError((Object)options2);
        }
        ResampleMethod resampleMethod = options2.resampleMethod();
        Option<Partitioner> partitioner = options2.partitioner();
        Tuple2 tuple2 = new Tuple2((Object)resampleMethod, partitioner);
        Tuple2 tuple22 = tuple2;
        ResampleMethod resampleMethod2 = (ResampleMethod)tuple22._1();
        Option partitioner2 = (Option)tuple22._2();
        return (RDD)this.runLevel$1(rdd, startZoom, endZoom, f, layoutScheme, options, evidence$71, evidence$72, evidence$73, evidence$75, evidence$74, evidence$76, evidence$77)._1();
    }

    public <K, V extends CellGrid<Object>, M> RDD<Tuple2<K, V>> upLevels(RDD<Tuple2<K, V>> rdd, LayoutScheme layoutScheme, int startZoom, int endZoom, Function2<RDD<Tuple2<K, V>>, Object, BoxedUnit> f, Component<K, SpatialKey> evidence$78, ClassTag<K> evidence$79, ClassTag<V> evidence$80, Function1<V, TileMergeMethods<V>> evidence$81, Function1<V, TilePrototypeMethods<V>> evidence$82, Component<M, LayoutDefinition> evidence$83, Component<M, Bounds<K>> evidence$84) {
        return this.upLevels(rdd, layoutScheme, startZoom, endZoom, Pyramid$Options$.MODULE$.DEFAULT(), f, evidence$78, evidence$79, evidence$80, evidence$81, evidence$82, evidence$83, evidence$84);
    }

    public <K, V extends CellGrid<Object>, M> RDD<Tuple2<K, V>> upLevels(RDD<Tuple2<K, V>> rdd, LayoutScheme layoutScheme, int startZoom, Pyramid.Options options, Function2<RDD<Tuple2<K, V>>, Object, BoxedUnit> f, Component<K, SpatialKey> evidence$85, ClassTag<K> evidence$86, ClassTag<V> evidence$87, Function1<V, TileMergeMethods<V>> evidence$88, Function1<V, TilePrototypeMethods<V>> evidence$89, Component<M, LayoutDefinition> evidence$90, Component<M, Bounds<K>> evidence$91) {
        return this.upLevels(rdd, layoutScheme, startZoom, 0, options, f, evidence$85, evidence$86, evidence$87, evidence$88, evidence$89, evidence$90, evidence$91);
    }

    public <K, V extends CellGrid<Object>, M> RDD<Tuple2<K, V>> upLevels(RDD<Tuple2<K, V>> rdd, LayoutScheme layoutScheme, int startZoom, Function2<RDD<Tuple2<K, V>>, Object, BoxedUnit> f, Component<K, SpatialKey> evidence$92, ClassTag<K> evidence$93, ClassTag<V> evidence$94, Function1<V, TileMergeMethods<V>> evidence$95, Function1<V, TilePrototypeMethods<V>> evidence$96, Component<M, LayoutDefinition> evidence$97, Component<M, Bounds<K>> evidence$98) {
        return this.upLevels(rdd, layoutScheme, startZoom, Pyramid$Options$.MODULE$.DEFAULT(), f, evidence$92, evidence$93, evidence$94, evidence$95, evidence$96, evidence$97, evidence$98);
    }

    public <K, V extends CellGrid<Object>, M> Pyramid<K, V, M> apply(Map<Object, RDD<Tuple2<K, V>>> levels, Component<K, SpatialKey> evidence$1, ClassTag<K> evidence$2, ClassTag<V> evidence$3, Function1<V, TilePrototypeMethods<V>> evidence$4, Function1<V, TileMergeMethods<V>> evidence$5, Component<M, LayoutDefinition> evidence$6, Component<M, Bounds<K>> evidence$7) {
        return new Pyramid<K, V, M>(levels, evidence$1, evidence$2, evidence$3, evidence$4, evidence$5, evidence$6, evidence$7);
    }

    public <K, V extends CellGrid<Object>, M> Option<Map<Object, RDD<Tuple2<K, V>>>> unapply(Pyramid<K, V, M> x$0) {
        return x$0 == null ? None$.MODULE$ : new Some(x$0.levels());
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ Tuple2 $anonfun$fromLayerReader$1(LayerReader layerReader$1, String layerName$2, AvroRecordCodec evidence$8$1, Boundable evidence$9$1, Decoder evidence$11$1, ClassTag evidence$12$1, AvroRecordCodec evidence$16$1, ClassTag evidence$17$1, Decoder evidence$19$1, Component evidence$20$1, int z) {
        return new Tuple2((Object)BoxesRunTime.boxToInteger((int)z), layerReader$1.read(new LayerId(layerName$2, z), evidence$8$1, evidence$9$1, evidence$11$1, evidence$12$1, evidence$16$1, evidence$17$1, evidence$19$1, evidence$20$1));
    }

    private static final Seq createTiles$1(Raster tile) {
        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Raster[]{tile}));
    }

    private static final Seq mergeTiles1$1(Seq tiles, Raster tile) {
        return (Seq)tiles.$colon$plus((Object)tile, Seq$.MODULE$.canBuildFrom());
    }

    private static final Seq mergeTiles2$1(Seq tiles1, Seq tiles2) {
        return (Seq)tiles1.$plus$plus((GenTraversableOnce)tiles2, Seq$.MODULE$.canBuildFrom());
    }

    private final Tuple2 runLevel$1(RDD thisRdd, int thisZoom, int endZoom$2, Function2 f$1, LayoutScheme layoutScheme$2, Pyramid.Options options$2, Component evidence$71$1, ClassTag evidence$72$1, ClassTag evidence$73$1, Function1 evidence$75$1, Function1 evidence$74$1, Component evidence$76$1, Component evidence$77$1) {
        while (thisZoom > endZoom$2) {
            f$1.apply((Object)thisRdd, (Object)BoxesRunTime.boxToInteger((int)thisZoom));
            Tuple2 tuple2 = this.up(thisRdd, layoutScheme$2, thisZoom, options$2, evidence$71$1, evidence$72$1, evidence$73$1, evidence$75$1, evidence$74$1, evidence$76$1, evidence$77$1);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            int nextZoom = tuple2._1$mcI$sp();
            RDD nextRdd = (RDD)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)nextZoom), (Object)nextRdd);
            Tuple2 tuple23 = tuple22;
            int nextZoom2 = tuple23._1$mcI$sp();
            RDD nextRdd2 = (RDD)tuple23._2();
            thisZoom = nextZoom2;
            thisRdd = nextRdd2;
        }
        f$1.apply((Object)thisRdd, (Object)BoxesRunTime.boxToInteger((int)thisZoom));
        return new Tuple2((Object)thisRdd, (Object)BoxesRunTime.boxToInteger((int)thisZoom));
    }

    private Pyramid$() {
        MODULE$ = this;
    }
}

