/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.spark.regrid;

import geotrellis.layer.Bounds;
import geotrellis.layer.EmptyBounds$;
import geotrellis.layer.KeyBounds;
import geotrellis.layer.LayoutDefinition;
import geotrellis.layer.Metadata;
import geotrellis.layer.SpatialKey;
import geotrellis.raster.CellSize;
import geotrellis.raster.TileLayout;
import geotrellis.raster.crop.CropMethods;
import geotrellis.raster.stitch.Stitcher;
import geotrellis.spark.ContextRDD$;
import geotrellis.spark.regrid.Regrid;
import geotrellis.util.Component;
import geotrellis.util.GetComponent;
import geotrellis.util.SetComponent;
import geotrellis.vector.Extent;
import java.io.Serializable;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.TraversableLike;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

public final class Regrid$ {
    public static Regrid$ MODULE$;

    static {
        new Regrid$();
    }

    public <K, V, M> RDD<Tuple2<K, V>> apply(RDD<Tuple2<K, V>> layer, int tileCols, int tileRows, Component<K, SpatialKey> evidence$2, ClassTag<K> evidence$3, ClassTag<V> evidence$4, Stitcher<V> evidence$5, Function1<V, CropMethods<V>> evidence$6, Component<M, LayoutDefinition> evidence$7, Component<M, Bounds<K>> evidence$8) {
        RDD<Tuple2<K, V>> rDD;
        Object md = ((Metadata)layer).metadata();
        LayoutDefinition ld = (LayoutDefinition)geotrellis.util.package$.MODULE$.withGetComponentMethods(md).getComponent(evidence$7);
        if (ld.tileLayout().tileCols() == tileCols && ld.tileLayout().tileRows() == tileRows) {
            rDD = layer;
        } else {
            EmptyBounds$ emptyBounds$;
            JFunction1.mcID.sp & Serializable & scala.Serializable ceil = (JFunction1.mcID.sp & Serializable & scala.Serializable)x -> (int)package$.MODULE$.ceil(x);
            TileLayout tl = ld.tileLayout();
            Extent oldEx = ld.extent();
            CellSize cellSize = ld.cellSize();
            if (cellSize == null) {
                throw new MatchError((Object)cellSize);
            }
            double cellW = cellSize.width();
            double cellH = cellSize.height();
            Tuple2.mcDD.sp sp2 = new Tuple2.mcDD.sp(cellW, cellH);
            Tuple2.mcDD.sp sp3 = sp2;
            double cellW2 = sp3._1$mcD$sp();
            double cellH2 = sp3._2$mcD$sp();
            Tuple2.mcII.sp sp4 = new Tuple2.mcII.sp(tl.tileCols(), tl.tileRows());
            if (sp4 == null) {
                throw new MatchError((Object)sp4);
            }
            int oldW = sp4._1$mcI$sp();
            int oldH = sp4._2$mcI$sp();
            Tuple2.mcII.sp sp5 = new Tuple2.mcII.sp(oldW, oldH);
            Tuple2.mcII.sp sp6 = sp5;
            int oldW2 = sp6._1$mcI$sp();
            int oldH2 = sp6._2$mcI$sp();
            Tuple2.mcII.sp sp7 = new Tuple2.mcII.sp(tileCols, tileRows);
            if (sp7 == null) {
                throw new MatchError((Object)sp7);
            }
            int newW = sp7._1$mcI$sp();
            int newH = sp7._2$mcI$sp();
            Tuple2.mcII.sp sp8 = new Tuple2.mcII.sp(newW, newH);
            Tuple2.mcII.sp sp9 = sp8;
            int newW2 = sp9._1$mcI$sp();
            int newH2 = sp9._2$mcI$sp();
            TileLayout ntl = new TileLayout(ceil.apply$mcID$sp((double)(tl.layoutCols() * oldW2) / (double)newW2), ceil.apply$mcID$sp((double)(tl.layoutRows() * oldH2) / (double)newH2), tileCols, tileRows);
            LayoutDefinition nld = new LayoutDefinition(new Extent(oldEx.xmin(), oldEx.ymax() - cellH2 * (double)ntl.layoutRows() * (double)tileRows, oldEx.xmin() + cellW2 * (double)ntl.layoutCols() * (double)tileCols, oldEx.ymax()), ntl);
            Bounds bounds = (Bounds)geotrellis.util.package$.MODULE$.withGetComponentMethods(md).getComponent(evidence$8);
            if (bounds instanceof KeyBounds) {
                KeyBounds keyBounds = (KeyBounds)bounds;
                Object minKey = keyBounds.minKey();
                Object maxKey = keyBounds.maxKey();
                SpatialKey ulSK = (SpatialKey)geotrellis.util.package$.MODULE$.withGetComponentMethods(minKey).getComponent(evidence$2);
                SpatialKey lrSK = (SpatialKey)geotrellis.util.package$.MODULE$.withGetComponentMethods(maxKey).getComponent(evidence$2);
                Regrid.Interval<Long> pxXrange = new Regrid.Interval<Long>(BoxesRunTime.boxToLong((long)((long)ulSK._1() * (long)oldW2)), BoxesRunTime.boxToLong((long)((long)(lrSK._1() + 1) * (long)oldW2 - 1L)), (Ordering<Long>)Ordering.Long$.MODULE$);
                Regrid.Interval<Long> pxYrange = new Regrid.Interval<Long>(BoxesRunTime.boxToLong((long)((long)ulSK._2() * (long)oldH2)), BoxesRunTime.boxToLong((long)((long)(lrSK._2() + 1) * (long)oldH2 - 1L)), (Ordering<Long>)Ordering.Long$.MODULE$);
                SpatialKey newMinKey = new SpatialKey((int)(BoxesRunTime.unboxToLong((Object)pxXrange.start()) / (long)tileCols), (int)(BoxesRunTime.unboxToLong((Object)pxYrange.start()) / (long)tileRows));
                SpatialKey newMaxKey = new SpatialKey((int)(BoxesRunTime.unboxToLong((Object)pxXrange.end()) / (long)tileCols), (int)(BoxesRunTime.unboxToLong((Object)pxYrange.end()) / (long)tileRows));
                emptyBounds$ = new KeyBounds(geotrellis.util.package$.MODULE$.withSetComponentMethods(minKey).setComponent((Object)newMinKey, evidence$2), geotrellis.util.package$.MODULE$.withSetComponentMethods(maxKey).setComponent((Object)newMaxKey, evidence$2));
            } else if (EmptyBounds$.MODULE$.equals(bounds)) {
                emptyBounds$ = EmptyBounds$.MODULE$;
            } else {
                throw new MatchError((Object)bounds);
            }
            EmptyBounds$ bounds2 = emptyBounds$;
            Object newMd = geotrellis.util.package$.MODULE$.withSetComponentMethods(geotrellis.util.package$.MODULE$.withSetComponentMethods(md).setComponent((Object)nld, evidence$7)).setComponent((Object)bounds2, evidence$8);
            RDD x$1 = layer.flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2.mcII.sp sp2;
                Object oldTile;
                Object key;
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    key = tuple2._1();
                    oldTile = tuple2._2();
                    SpatialKey spatialKey = (SpatialKey)geotrellis.util.package$.MODULE$.withGetComponentMethods(key).getComponent((GetComponent)evidence$2);
                    if (spatialKey == null) {
                        throw new MatchError((Object)spatialKey);
                    }
                    int oldX = spatialKey.col();
                    int oldY = spatialKey.row();
                    sp2 = new Tuple2.mcII.sp(oldX, oldY);
                } else {
                    throw new MatchError((Object)tuple2);
                }
                Tuple2.mcII.sp sp3 = sp2;
                int oldX = sp3._1$mcI$sp();
                int oldY = sp3._2$mcI$sp();
                long oldXstart = (long)oldX * (long)oldW2;
                long oldYstart = (long)oldY * (long)oldH2;
                Regrid.Interval<Long> oldXrange = new Regrid.Interval<Long>(BoxesRunTime.boxToLong((long)oldXstart), BoxesRunTime.boxToLong((long)(oldXstart + (long)oldW2 - 1L)), (Ordering<Long>)Ordering.Long$.MODULE$);
                Regrid.Interval<Long> oldYrange = new Regrid.Interval<Long>(BoxesRunTime.boxToLong((long)oldYstart), BoxesRunTime.boxToLong((long)(oldYstart + (long)oldH2 - 1L)), (Ordering<Long>)Ordering.Long$.MODULE$);
                IndexedSeq indexedSeq = (IndexedSeq)((TraversableLike)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper((int)(oldXstart / (long)tileCols)), (int)((double)BoxesRunTime.unboxToLong((Object)oldXrange.end()) / (double)tileCols)).map((Function1 & Serializable & scala.Serializable)x -> Regrid$.$anonfun$apply$3(tileCols, BoxesRunTime.unboxToInt((Object)x)), IndexedSeq$.MODULE$.canBuildFrom())).flatMap((Function1 & Serializable & scala.Serializable)x$6 -> {
                    Tuple2 tuple2 = x$6;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    int x = tuple2._1$mcI$sp();
                    Regrid.Interval newXrange = (Regrid.Interval)tuple2._2();
                    IndexedSeq indexedSeq = (IndexedSeq)((TraversableLike)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper((int)(oldYstart / (long)tileRows)), (int)((double)BoxesRunTime.unboxToLong(oldYrange.end()) / (double)tileRows)).map((Function1 & Serializable & scala.Serializable)y -> Regrid$.$anonfun$apply$5(tileRows, BoxesRunTime.unboxToInt((Object)y)), IndexedSeq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$5 -> {
                        Tuple2 tuple2 = x$5;
                        if (tuple2 == null) {
                            throw new MatchError((Object)tuple2);
                        }
                        int y = tuple2._1$mcI$sp();
                        Regrid.Interval newYrange = (Regrid.Interval)tuple2._2();
                        Object newKey = geotrellis.util.package$.MODULE$.withSetComponentMethods(key).setComponent((Object)new SpatialKey(x, y), (SetComponent)evidence$2);
                        Regrid.Interval xSpan = oldXrange.intersect(newXrange);
                        Regrid.Interval ySpan = oldYrange.intersect(newYrange);
                        Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(newKey), (Object)new Tuple2(((CropMethods)evidence$6.apply(oldTile)).crop((int)(BoxesRunTime.unboxToLong(xSpan.start()) - oldXstart), (int)(BoxesRunTime.unboxToLong(ySpan.start()) - oldYstart), (int)(BoxesRunTime.unboxToLong(xSpan.end()) - oldXstart), (int)(BoxesRunTime.unboxToLong(ySpan.end()) - oldYstart)), (Object)new Tuple2.mcII.sp((int)(BoxesRunTime.unboxToLong(xSpan.start()) - BoxesRunTime.unboxToLong(newXrange.start())), (int)(BoxesRunTime.unboxToLong(ySpan.start()) - BoxesRunTime.unboxToLong(newYrange.start())))));
                        return tuple22;
                    }, IndexedSeq$.MODULE$.canBuildFrom());
                    return indexedSeq;
                }, IndexedSeq$.MODULE$.canBuildFrom());
                return indexedSeq;
            }, ClassTag$.MODULE$.apply(Tuple2.class));
            ClassTag<K> x$2 = evidence$3;
            ClassTag x$3 = ClassTag$.MODULE$.apply(Tuple2.class);
            Null$ x$4 = RDD$.MODULE$.rddToPairRDDFunctions$default$4(x$1);
            RDD x$5 = RDD$.MODULE$.rddToPairRDDFunctions(x$1, x$2, x$3, null).groupByKey();
            ClassTag<K> x$6 = evidence$3;
            ClassTag x$7 = ClassTag$.MODULE$.apply(Iterable.class);
            Null$ x$8 = RDD$.MODULE$.rddToPairRDDFunctions$default$4(x$5);
            RDD tiled = RDD$.MODULE$.rddToPairRDDFunctions(x$5, x$6, x$7, null).mapValues((Function1 & Serializable & scala.Serializable)tiles -> ((Stitcher)Predef$.MODULE$.implicitly((Object)evidence$5)).stitch(tiles, tileCols, tileRows));
            rDD = ContextRDD$.MODULE$.apply(tiled, newMd);
        }
        return rDD;
    }

    public <K, V, M> RDD<Tuple2<K, V>> apply(RDD<Tuple2<K, V>> layer, int tileSize, Component<K, SpatialKey> evidence$9, ClassTag<K> evidence$10, ClassTag<V> evidence$11, Stitcher<V> evidence$12, Function1<V, CropMethods<V>> evidence$13, Component<M, LayoutDefinition> evidence$14, Component<M, Bounds<K>> evidence$15) {
        return this.apply(layer, tileSize, tileSize, evidence$9, evidence$10, evidence$11, evidence$12, evidence$13, evidence$14, evidence$15);
    }

    public static final /* synthetic */ Tuple2 $anonfun$apply$3(int tileCols$1, int x) {
        long newXstart = (long)x * (long)tileCols$1;
        Regrid.Interval<Long> newXrange = new Regrid.Interval<Long>(BoxesRunTime.boxToLong((long)newXstart), BoxesRunTime.boxToLong((long)(newXstart + (long)tileCols$1 - 1L)), (Ordering<Long>)Ordering.Long$.MODULE$);
        return new Tuple2((Object)BoxesRunTime.boxToInteger((int)x), newXrange);
    }

    public static final /* synthetic */ Tuple2 $anonfun$apply$5(int tileRows$1, int y) {
        long newYstart = (long)y * (long)tileRows$1;
        Regrid.Interval<Long> newYrange = new Regrid.Interval<Long>(BoxesRunTime.boxToLong((long)newYstart), BoxesRunTime.boxToLong((long)(newYstart + (long)tileRows$1 - 1L)), (Ordering<Long>)Ordering.Long$.MODULE$);
        return new Tuple2((Object)BoxesRunTime.boxToInteger((int)y), newYrange);
    }

    private Regrid$() {
        MODULE$ = this;
    }
}

