/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.spark.reproject;

import geotrellis.layer.Boundable;
import geotrellis.layer.LayoutDefinition;
import geotrellis.layer.LayoutScheme;
import geotrellis.layer.SpatialKey;
import geotrellis.layer.TileLayerMetadata;
import geotrellis.proj4.CRS;
import geotrellis.raster.CellGrid;
import geotrellis.raster.CellSize;
import geotrellis.raster.buffer.BufferedTile;
import geotrellis.raster.crop.CropMethods;
import geotrellis.raster.merge.TileMergeMethods;
import geotrellis.raster.prototype.TilePrototypeMethods;
import geotrellis.raster.reproject.RasterRegionReproject;
import geotrellis.raster.stitch.Stitcher;
import geotrellis.spark.reproject.Reproject;
import geotrellis.spark.reproject.TileRDDReproject$;
import geotrellis.util.Component;
import geotrellis.vector.Extent;
import org.apache.spark.Partitioner;
import org.apache.spark.rdd.RDD;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Product;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Either;

@ScalaSignature(bytes="\u0006\u0001\u0011=q!\u0002\u0016,\u0011\u0003\u0011d!\u0002\u001b,\u0011\u0003)\u0004\"\u0002\u001f\u0002\t\u0003i\u0004\"\u0002 \u0002\t\u0003y\u0004B\u0002 \u0002\t\u0003\ti\r\u0003\u0004?\u0003\u0011\u0005!q\t\u0005\b\u0005c\u000bA\u0011\u0002BZ\r\u0019\u0011Y,\u0001#\u0003>\"Q!1Z\u0004\u0003\u0016\u0004%\tA!4\t\u0015\tUwA!E!\u0002\u0013\u0011y\r\u0003\u0006\u0003X\u001e\u0011)\u001a!C\u0001\u0005\u001bD!B!7\b\u0005#\u0005\u000b\u0011\u0002Bh\u0011)\u0011Yn\u0002BK\u0002\u0013\u0005!Q\u001c\u0005\u000b\u0005W<!\u0011#Q\u0001\n\t}\u0007B\u0003Bw\u000f\tU\r\u0011\"\u0001\u0003p\"Q!q_\u0004\u0003\u0012\u0003\u0006IA!=\t\rq:A\u0011\u0001B}\u0011\u001d\u0019\u0019a\u0002C\u0001\u0007\u000bAqaa\u0003\b\t\u0003\u0011i\rC\u0004\u0004\u000e\u001d!\taa\u0004\t\u000f\rUq\u0001\"\u0001\u0004\u0018!I11D\u0004\u0002\u0002\u0013\u00051Q\u0004\u0005\n\u0007O9\u0011\u0013!C\u0001\u0007SA\u0011ba\u0010\b#\u0003%\ta!\u000b\t\u0013\r\u0005s!%A\u0005\u0002\r\r\u0003\"CB$\u000fE\u0005I\u0011AB%\u0011%\u0019ieBA\u0001\n\u0003\u001ay\u0005C\u0005\u0004b\u001d\t\t\u0011\"\u0001\u0004d!I1QM\u0004\u0002\u0002\u0013\u00051q\r\u0005\n\u0007[:\u0011\u0011!C!\u0007_B\u0011b! \b\u0003\u0003%\taa \t\u0013\r%u!!A\u0005B\r-\u0005\"CBG\u000f\u0005\u0005I\u0011IBH\u0011%\u0019\tjBA\u0001\n\u0003\u001a\u0019jB\u0005\u0004@\u0006\t\t\u0011#\u0003\u0004B\u001aI!1X\u0001\u0002\u0002#%11\u0019\u0005\u0007y\r\"\ta!5\t\u0013\r55%!A\u0005F\r=\u0005\u0002\u0003 $\u0003\u0003%\tia5\t\u0013\ru7%!A\u0005\u0002\u000e}\u0007\"CBwG\u0005\u0005I\u0011BBx\u0011)\u001990\u0001ECB\u0013%1\u0011`\u0001\u0011)&dWM\u0015#E%\u0016\u0004(o\u001c6fGRT!\u0001L\u0017\u0002\u0013I,\u0007O]8kK\u000e$(B\u0001\u00180\u0003\u0015\u0019\b/\u0019:l\u0015\u0005\u0001\u0014AC4f_R\u0014X\r\u001c7jg\u000e\u0001\u0001CA\u001a\u0002\u001b\u0005Y#\u0001\u0005+jY\u0016\u0014F\t\u0012*faJ|'.Z2u'\t\ta\u0007\u0005\u00028u5\t\u0001HC\u0001:\u0003\u0015\u00198-\u00197b\u0013\tY\u0004H\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003I\nQ!\u00199qYf,2\u0001Q-d)5\t\u0015\u0011MA;\u0003s\nI)!+\u0002<Rq!)^A\u0006\u0003+\t)#a\u000b\u0002:\u0005=\u0003\u0003B\u001cD\u000b\"K!\u0001\u0012\u001d\u0003\rQ+\b\u000f\\33!\t9d)\u0003\u0002Hq\t\u0019\u0011J\u001c;\u0013\u0007%[EN\u0002\u0003K\u0003\u0001A%\u0001\u0004\u001fsK\u001aLg.Z7f]Rt\u0004c\u0001'U-6\tQJ\u0003\u0002O\u001f\u0006\u0019!\u000f\u001a3\u000b\u00059\u0002&BA)S\u0003\u0019\t\u0007/Y2iK*\t1+A\u0002pe\u001eL!!V'\u0003\u0007I#E\t\u0005\u00038\u0007^\u0013\u0007C\u0001-Z\u0019\u0001!QAW\u0002C\u0002m\u0013\u0011aS\t\u00039~\u0003\"aN/\n\u0005yC$a\u0002(pi\"Lgn\u001a\t\u0003o\u0001L!!\u0019\u001d\u0003\u0007\u0005s\u0017\u0010\u0005\u0002YG\u0012)Am\u0001b\u0001K\n\ta+\u0005\u0002]MB\u0019qM[#\u000e\u0003!T!![\u0018\u0002\rI\f7\u000f^3s\u0013\tY\u0007N\u0001\u0005DK2dwI]5e!\ri\u0007O]\u0007\u0002]*\u0011qnL\u0001\u0006Y\u0006LXM]\u0005\u0003c:\u0014\u0001\"T3uC\u0012\fG/\u0019\t\u0004[N<\u0016B\u0001;o\u0005E!\u0016\u000e\\3MCf,'/T3uC\u0012\fG/\u0019\u0005\bm\u000e\t\t\u0011q\u0001x\u0003))g/\u001b3f]\u000e,G%\r\t\u0005q\u0006\u0015qKD\u0002z\u0003\u0003q!A_@\u000f\u0005mtX\"\u0001?\u000b\u0005u\f\u0014A\u0002\u001fs_>$h(C\u00011\u0013\tyw&C\u0002\u0002\u00049\fq\u0001]1dW\u0006<W-\u0003\u0003\u0002\b\u0005%!\u0001E*qCRL\u0017\r\\\"p[B|g.\u001a8u\u0015\r\t\u0019A\u001c\u0005\n\u0003\u001b\u0019\u0011\u0011!a\u0002\u0003\u001f\t!\"\u001a<jI\u0016t7-\u001a\u00133!\u0011i\u0017\u0011C,\n\u0007\u0005MaNA\u0005C_VtG-\u00192mK\"I\u0011qC\u0002\u0002\u0002\u0003\u000f\u0011\u0011D\u0001\u000bKZLG-\u001a8dK\u0012\u001a\u0004#BA\u000e\u0003C9VBAA\u000f\u0015\r\ty\u0002O\u0001\be\u00164G.Z2u\u0013\u0011\t\u0019#!\b\u0003\u0011\rc\u0017m]:UC\u001eD\u0011\"a\n\u0004\u0003\u0003\u0005\u001d!!\u000b\u0002\u0015\u00154\u0018\u000eZ3oG\u0016$C\u0007E\u0003\u0002\u001c\u0005\u0005\"\rC\u0005\u0002.\r\t\t\u0011q\u0001\u00020\u0005QQM^5eK:\u001cW\rJ\u001b\u0011\u000b\u0005E\u0012Q\u00072\u000e\u0005\u0005M\"B\u0001\u0017i\u0013\u0011\t9$a\r\u0003+I\u000b7\u000f^3s%\u0016<\u0017n\u001c8SKB\u0014xN[3di\"I\u00111H\u0002\u0002\u0002\u0003\u000f\u0011QH\u0001\u000bKZLG-\u001a8dK\u00122\u0004CB\u001c\u0002@\t\f\u0019%C\u0002\u0002Ba\u0012\u0011BR;oGRLwN\\\u0019\u0011\u000b\u0005\u0015\u00131\n2\u000e\u0005\u0005\u001d#bAA%Q\u0006)Q.\u001a:hK&!\u0011QJA$\u0005A!\u0016\u000e\\3NKJ<W-T3uQ>$7\u000fC\u0005\u0002R\r\t\t\u0011q\u0001\u0002T\u0005QQM^5eK:\u001cW\rJ\u001c\u0011\r]\nyDYA+!\u0015\t9&!\u0018c\u001b\t\tIFC\u0002\u0002\\!\f\u0011\u0002\u001d:pi>$\u0018\u0010]3\n\t\u0005}\u0013\u0011\f\u0002\u0015)&dW\r\u0015:pi>$\u0018\u0010]3NKRDw\u000eZ:\t\u000f\u0005\r4\u00011\u0001\u0002f\u0005i!-\u001e4gKJ,G\rV5mKN\u0004B\u0001\u0014+\u0002hA)qgQ,\u0002jA)\u00111NA9E6\u0011\u0011Q\u000e\u0006\u0004\u0003_B\u0017A\u00022vM\u001a,'/\u0003\u0003\u0002t\u00055$\u0001\u0004\"vM\u001a,'/\u001a3US2,\u0007BBA<\u0007\u0001\u0007!/\u0001\u0005nKR\fG-\u0019;b\u0011\u001d\tYh\u0001a\u0001\u0003{\nq\u0001Z3ti\u000e\u00138\u000f\u0005\u0003\u0002\u0000\u0005\u0015UBAAA\u0015\r\t\u0019iL\u0001\u0006aJ|'\u000eN\u0005\u0005\u0003\u000f\u000b\tIA\u0002D%NCq!a#\u0004\u0001\u0004\ti)\u0001\u0007uCJ<W\r\u001e'bs>,H\u000f\u0005\u0005\u0002\u0010\u0006]\u0015QTAR\u001d\u0011\t\t*!&\u000f\u0007m\f\u0019*C\u0001:\u0013\r\t\u0019\u0001O\u0005\u0005\u00033\u000bYJ\u0001\u0004FSRDWM\u001d\u0006\u0004\u0003\u0007A\u0004cA7\u0002 &\u0019\u0011\u0011\u00158\u0003\u00191\u000b\u0017p\\;u'\u000eDW-\\3\u0011\u00075\f)+C\u0002\u0002(:\u0014\u0001\u0003T1z_V$H)\u001a4j]&$\u0018n\u001c8\t\u000f\u0005-6\u00011\u0001\u0002.\u00069q\u000e\u001d;j_:\u001c\b\u0003BAX\u0003ks1aMAY\u0013\r\t\u0019lK\u0001\n%\u0016\u0004(o\u001c6fGRLA!a.\u0002:\n9q\n\u001d;j_:\u001c(bAAZW!9\u0011QX\u0002A\u0002\u0005}\u0016a\u00039beRLG/[8oKJ\u0004RaNAa\u0003\u000bL1!a19\u0005\u0019y\u0005\u000f^5p]B!\u0011qYAe\u001b\u0005y\u0015bAAf\u001f\nY\u0001+\u0019:uSRLwN\\3s+\u0019\ty-a8\u0002dRa\u0011\u0011\u001bB\u001d\u0005\u007f\u0011\tEa\u0011\u0003FQ!\u00121[Au\u0003_\f)0a?\u0003\u0002\t\u001d!q\u0003B\u0015\u0005c\u0001RaN\"F\u0003+\u0014b!a6\u0002Z\u0006\u0015h!\u0002&\u0002\u0001\u0005U\u0007\u0003\u0002'U\u00037\u0004baN\"\u0002^\u0006\u0005\bc\u0001-\u0002`\u0012)!\f\u0002b\u00017B\u0019\u0001,a9\u0005\u000b\u0011$!\u0019A3\u0011\t5\u0004\u0018q\u001d\t\u0005[N\fi\u000eC\u0005\u0002l\u0012\t\t\u0011q\u0001\u0002n\u0006QQM^5eK:\u001cW\r\n\u001d\u0011\u000ba\f)!!8\t\u0013\u0005EH!!AA\u0004\u0005M\u0018AC3wS\u0012,gnY3%sA)Q.!\u0005\u0002^\"I\u0011q\u001f\u0003\u0002\u0002\u0003\u000f\u0011\u0011`\u0001\fKZLG-\u001a8dK\u0012\n\u0004\u0007\u0005\u0004\u0002\u001c\u0005\u0005\u0012Q\u001c\u0005\n\u0003{$\u0011\u0011!a\u0002\u0003\u007f\f1\"\u001a<jI\u0016t7-\u001a\u00132cA1\u00111DA\u0011\u0003CD\u0011Ba\u0001\u0005\u0003\u0003\u0005\u001dA!\u0002\u0002\u0017\u00154\u0018\u000eZ3oG\u0016$\u0013G\r\t\u0007\u0003c\t)$!9\t\u0013\t%A!!AA\u0004\t-\u0011aC3wS\u0012,gnY3%cM\u0002bA!\u0004\u0003\u0014\u0005\u0005XB\u0001B\b\u0015\r\u0011\t\u0002[\u0001\u0007gRLGo\u00195\n\t\tU!q\u0002\u0002\t'RLGo\u00195fe\"I!\u0011\u0004\u0003\u0002\u0002\u0003\u000f!1D\u0001\fKZLG-\u001a8dK\u0012\nD\u0007E\u00048\u0003\u007f\t\tO!\b\u0011\r\t}!QEAq\u001b\t\u0011\tCC\u0002\u0003$!\fAa\u0019:pa&!!q\u0005B\u0011\u0005-\u0019%o\u001c9NKRDw\u000eZ:\t\u0013\t-B!!AA\u0004\t5\u0012aC3wS\u0012,gnY3%cU\u0002raNA \u0003C\u0014y\u0003\u0005\u0004\u0002F\u0005-\u0013\u0011\u001d\u0005\n\u0005g!\u0011\u0011!a\u0002\u0005k\t1\"\u001a<jI\u0016t7-\u001a\u00132mA9q'a\u0010\u0002b\n]\u0002CBA,\u0003;\n\t\u000f\u0003\u0004O\t\u0001\u0007!1\b\n\u0007\u0005{\tI.!:\u0007\u000b)\u000b\u0001Aa\u000f\t\u000f\u0005mD\u00011\u0001\u0002~!9\u00111\u0012\u0003A\u0002\u00055\u0005bBAV\t\u0001\u0007\u0011Q\u0016\u0005\b\u0003{#\u0001\u0019AA`+\u0019\u0011IE!\u0017\u0003^Qq!1\nBP\u0005K\u00139K!+\u0003.\n=F\u0003\u0006B'\u0005G\u0012IGa\u001c\u0003v\tm$\u0011\u0011BD\u0005\u001f\u00139\nE\u00038\u0007\u0016\u0013yE\u0005\u0004\u0003R\tM#q\f\u0004\u0006\u0015\u0006\u0001!q\n\t\u0005\u0019R\u0013)\u0006\u0005\u00048\u0007\n]#1\f\t\u00041\neC!\u0002.\u0006\u0005\u0004Y\u0006c\u0001-\u0003^\u0011)A-\u0002b\u0001KB!Q\u000e\u001dB1!\u0011i7Oa\u0016\t\u0013\t\u0015T!!AA\u0004\t\u001d\u0014aC3wS\u0012,gnY3%c]\u0002R\u0001_A\u0003\u0005/B\u0011Ba\u001b\u0006\u0003\u0003\u0005\u001dA!\u001c\u0002\u0017\u00154\u0018\u000eZ3oG\u0016$\u0013\u0007\u000f\t\u0006[\u0006E!q\u000b\u0005\n\u0005c*\u0011\u0011!a\u0002\u0005g\n1\"\u001a<jI\u0016t7-\u001a\u00132sA1\u00111DA\u0011\u0005/B\u0011Ba\u001e\u0006\u0003\u0003\u0005\u001dA!\u001f\u0002\u0017\u00154\u0018\u000eZ3oG\u0016$#\u0007\r\t\u0007\u00037\t\tCa\u0017\t\u0013\tuT!!AA\u0004\t}\u0014aC3wS\u0012,gnY3%eE\u0002b!!\r\u00026\tm\u0003\"\u0003BB\u000b\u0005\u0005\t9\u0001BC\u0003-)g/\u001b3f]\u000e,GE\r\u001a\u0011\r\t5!1\u0003B.\u0011%\u0011I)BA\u0001\u0002\b\u0011Y)A\u0006fm&$WM\\2fII\u001a\u0004cB\u001c\u0002@\tm#Q\u0012\t\u0007\u0005?\u0011)Ca\u0017\t\u0013\tEU!!AA\u0004\tM\u0015aC3wS\u0012,gnY3%eQ\u0002raNA \u00057\u0012)\n\u0005\u0004\u0002F\u0005-#1\f\u0005\n\u00053+\u0011\u0011!a\u0002\u00057\u000b1\"\u001a<jI\u0016t7-\u001a\u00133kA9q'a\u0010\u0003\\\tu\u0005CBA,\u0003;\u0012Y\u0006\u0003\u0004O\u000b\u0001\u0007!\u0011\u0015\n\u0007\u0005G\u0013\u0019Fa\u0018\u0007\u000b)\u000b\u0001A!)\t\u000f\u0005mT\u00011\u0001\u0002~!9\u00111R\u0003A\u0002\u00055\u0005B\u0002BV\u000b\u0001\u0007Q)\u0001\u0006ck\u001a4WM]*ju\u0016Dq!a+\u0006\u0001\u0004\ti\u000bC\u0004\u0002>\u0016\u0001\r!a0\u000255\fGo\u00195SKB\u0014xN[3diJ\u000b7\u000f^3s\u000bb$XM\u001c;\u0015\u0015\tU6\u0011UBS\u0007S\u001bi\u000b\u0006\u0003\u00038\u000e]\u0005c\u0001B]\u000f5\t\u0011A\u0001\tSKB\u0014xN[3diN+X.\\1ssN1qA\u000eB`\u0005\u000b\u00042a\u000eBa\u0013\r\u0011\u0019\r\u000f\u0002\b!J|G-^2u!\r9$qY\u0005\u0004\u0005\u0013D$\u0001D*fe&\fG.\u001b>bE2,\u0017\u0001D:pkJ\u001cW\rU5yK2\u001cXC\u0001Bh!\r9$\u0011[\u0005\u0004\u0005'D$A\u0002#pk\ndW-A\u0007t_V\u00148-\u001a)jq\u0016d7\u000fI\u0001\u0007a&DX\r\\:\u0002\u000fAL\u00070\u001a7tA\u00051Q\r\u001f;f]R,\"Aa8\u0011\t\t\u0005(q]\u0007\u0003\u0005GT1A!:0\u0003\u00191Xm\u0019;pe&!!\u0011\u001eBr\u0005\u0019)\u0005\u0010^3oi\u00069Q\r\u001f;f]R\u0004\u0013\u0001C2fY2\u001c\u0016N_3\u0016\u0005\tE\bcA4\u0003t&\u0019!Q\u001f5\u0003\u0011\r+G\u000e\\*ju\u0016\f\u0011bY3mYNK'0\u001a\u0011\u0015\u0015\t]&1 B\u007f\u0005\u007f\u001c\t\u0001C\u0004\u0003LB\u0001\rAa4\t\u000f\t]\u0007\u00031\u0001\u0003P\"9!1\u001c\tA\u0002\t}\u0007b\u0002Bw!\u0001\u0007!\u0011_\u0001\bG>l'-\u001b8f)\u0011\u00119la\u0002\t\u000f\r%\u0011\u00031\u0001\u00038\u0006)q\u000e\u001e5fe\u0006Q\u0001/\u001b=fYJ\u000bG/[8\u0002%I,7oY1mK\u0012\u0004\u0016\u000e_3m%\u0006$\u0018n\u001c\u000b\u0005\u0005\u001f\u001c\t\u0002C\u0004\u0004\u0014M\u0001\rA!=\u0002\rQ\f'oZ3u\u0003I\u0011Xm]2bY\u0016$\u0007+\u001b=fY\u000e{WO\u001c;\u0015\t\t=7\u0011\u0004\u0005\b\u0007'!\u0002\u0019\u0001By\u0003\u0011\u0019w\u000e]=\u0015\u0015\t]6qDB\u0011\u0007G\u0019)\u0003C\u0005\u0003LV\u0001\n\u00111\u0001\u0003P\"I!q[\u000b\u0011\u0002\u0003\u0007!q\u001a\u0005\n\u00057,\u0002\u0013!a\u0001\u0005?D\u0011B!<\u0016!\u0003\u0005\rA!=\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u001111\u0006\u0016\u0005\u0005\u001f\u001cic\u000b\u0002\u00040A!1\u0011GB\u001e\u001b\t\u0019\u0019D\u0003\u0003\u00046\r]\u0012!C;oG\",7m[3e\u0015\r\u0019I\u0004O\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BB\u001f\u0007g\u0011\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII\nabY8qs\u0012\"WMZ1vYR$3'\u0006\u0002\u0004F)\"!q\\B\u0017\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIQ*\"aa\u0013+\t\tE8QF\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0016\u0005\rE\u0003\u0003BB*\u0007;j!a!\u0016\u000b\t\r]3\u0011L\u0001\u0005Y\u0006twM\u0003\u0002\u0004\\\u0005!!.\u0019<b\u0013\u0011\u0019yf!\u0016\u0003\rM#(/\u001b8h\u00031\u0001(o\u001c3vGR\f%/\u001b;z+\u0005)\u0015A\u00049s_\u0012,8\r^#mK6,g\u000e\u001e\u000b\u0004?\u000e%\u0004\u0002CB69\u0005\u0005\t\u0019A#\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\u0019\t\bE\u0003\u0004t\ret,\u0004\u0002\u0004v)\u00191q\u000f\u001d\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0004|\rU$\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$Ba!!\u0004\bB\u0019qga!\n\u0007\r\u0015\u0005HA\u0004C_>dW-\u00198\t\u0011\r-d$!AA\u0002}\u000b\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0002\u000b\u0006AAo\\*ue&tw\r\u0006\u0002\u0004R\u00051Q-];bYN$Ba!!\u0004\u0016\"A11N\u0011\u0002\u0002\u0003\u0007q\fC\u0004\u0004\u001a\u001a\u0001\u001daa'\u0002\u0005M\u001c\u0007\u0003BAd\u0007;K1aa(P\u00051\u0019\u0006/\u0019:l\u0007>tG/\u001a=u\u0011\u001d\u0019\u0019K\u0002a\u0001\u0003{\n1a\u001d:d\u0011\u001d\u00199K\u0002a\u0001\u0003{\n1\u0001Z:u\u0011\u001d\u0019YK\u0002a\u0001\u0003G\u000ba\u0001\\1z_V$\bbBBX\r\u0001\u00071\u0011W\u0001\nW\u0016L(i\\;oIN\u0004RaNAa\u0007g\u0003R!\\B[\u0007sK1aa.o\u0005%YU-\u001f\"pk:$7\u000fE\u0002n\u0007wK1a!0o\u0005)\u0019\u0006/\u0019;jC2\\U-_\u0001\u0011%\u0016\u0004(o\u001c6fGR\u001cV/\\7bef\u00042A!/$'\u0015\u00193Q\u0019Bc!9\u00199m!4\u0003P\n='q\u001cBy\u0005ok!a!3\u000b\u0007\r-\u0007(A\u0004sk:$\u0018.\\3\n\t\r=7\u0011\u001a\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:$DCABa))\u00119l!6\u0004X\u000ee71\u001c\u0005\b\u0005\u00174\u0003\u0019\u0001Bh\u0011\u001d\u00119N\na\u0001\u0005\u001fDqAa7'\u0001\u0004\u0011y\u000eC\u0004\u0003n\u001a\u0002\rA!=\u0002\u000fUt\u0017\r\u001d9msR!1\u0011]Bu!\u00159\u0014\u0011YBr!-94Q\u001dBh\u0005\u001f\u0014yN!=\n\u0007\r\u001d\bH\u0001\u0004UkBdW\r\u000e\u0005\n\u0007W<\u0013\u0011!a\u0001\u0005o\u000b1\u0001\u001f\u00131\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\rE\b\u0003BB*\u0007gLAa!>\u0004V\t1qJ\u00196fGR\fa\u0001\\8hO\u0016\u0014XCAB~!\u0011\u0019i\u0010b\u0001\u000e\u0005\r}(b\u0001C\u0001%\u0006)An\\45g&!AQAB\u0000\u0005\u0019aunZ4fe\"\u001a\u0011\u0006\"\u0003\u0011\u0007]\"Y!C\u0002\u0005\u000ea\u0012\u0011\u0002\u001e:b]NLWM\u001c;")
public final class TileRDDReproject {
    public static <K, V extends CellGrid<Object>> Tuple2<Object, RDD<Tuple2<K, V>>> apply(RDD<Tuple2<K, V>> rDD, CRS cRS, Either<LayoutScheme, LayoutDefinition> either, int n, Reproject.Options options, Option<Partitioner> option, Component<K, SpatialKey> component, Boundable<K> boundable, ClassTag<K> classTag, ClassTag<V> classTag2, RasterRegionReproject<V> rasterRegionReproject, Stitcher<V> stitcher, Function1<V, CropMethods<V>> function1, Function1<V, TileMergeMethods<V>> function12, Function1<V, TilePrototypeMethods<V>> function13) {
        return TileRDDReproject$.MODULE$.apply(rDD, cRS, either, n, options, option, component, boundable, classTag, classTag2, rasterRegionReproject, stitcher, function1, function12, function13);
    }

    public static <K, V extends CellGrid<Object>> Tuple2<Object, RDD<Tuple2<K, V>>> apply(RDD<Tuple2<K, V>> rDD, CRS cRS, Either<LayoutScheme, LayoutDefinition> either, Reproject.Options options, Option<Partitioner> option, Component<K, SpatialKey> component, Boundable<K> boundable, ClassTag<K> classTag, ClassTag<V> classTag2, RasterRegionReproject<V> rasterRegionReproject, Stitcher<V> stitcher, Function1<V, CropMethods<V>> function1, Function1<V, TileMergeMethods<V>> function12, Function1<V, TilePrototypeMethods<V>> function13) {
        return TileRDDReproject$.MODULE$.apply(rDD, cRS, either, options, option, component, boundable, classTag, classTag2, rasterRegionReproject, stitcher, function1, function12, function13);
    }

    public static <K, V extends CellGrid<Object>> Tuple2<Object, RDD<Tuple2<K, V>>> apply(RDD<Tuple2<K, BufferedTile<V>>> rDD, TileLayerMetadata<K> tileLayerMetadata, CRS cRS, Either<LayoutScheme, LayoutDefinition> either, Reproject.Options options, Option<Partitioner> option, Component<K, SpatialKey> component, Boundable<K> boundable, ClassTag<K> classTag, ClassTag<V> classTag2, RasterRegionReproject<V> rasterRegionReproject, Function1<V, TileMergeMethods<V>> function1, Function1<V, TilePrototypeMethods<V>> function12) {
        return TileRDDReproject$.MODULE$.apply(rDD, tileLayerMetadata, cRS, either, options, option, component, boundable, classTag, classTag2, rasterRegionReproject, function1, function12);
    }

    public static class ReprojectSummary
    implements Product,
    Serializable {
        private final double sourcePixels;
        private final double pixels;
        private final Extent extent;
        private final CellSize cellSize;

        public double sourcePixels() {
            return this.sourcePixels;
        }

        public double pixels() {
            return this.pixels;
        }

        public Extent extent() {
            return this.extent;
        }

        public CellSize cellSize() {
            return this.cellSize;
        }

        public ReprojectSummary combine(ReprojectSummary other) {
            return this.cellSize().resolution() <= other.cellSize().resolution() ? new ReprojectSummary(this.sourcePixels() + other.sourcePixels(), this.pixels() + other.rescaledPixelCount(this.cellSize()), this.extent().combine(other.extent()), this.cellSize()) : new ReprojectSummary(this.sourcePixels() + other.sourcePixels(), this.rescaledPixelCount(other.cellSize()) + other.pixels(), this.extent().combine(other.extent()), other.cellSize());
        }

        public double pixelRatio() {
            return this.pixels() / this.sourcePixels();
        }

        public double rescaledPixelRatio(CellSize target) {
            return this.rescaledPixelCount(target) / this.sourcePixels();
        }

        public double rescaledPixelCount(CellSize target) {
            CellSize cellSize = this.cellSize();
            if (cellSize == null) {
                throw new MatchError((Object)cellSize);
            }
            double w0 = cellSize.width();
            double h0 = cellSize.height();
            Tuple2.mcDD.sp sp2 = new Tuple2.mcDD.sp(w0, h0);
            Tuple2.mcDD.sp sp3 = sp2;
            double w02 = sp3._1$mcD$sp();
            double h02 = sp3._2$mcD$sp();
            CellSize cellSize2 = target;
            if (cellSize2 == null) {
                throw new MatchError((Object)cellSize2);
            }
            double w1 = cellSize2.width();
            double h1 = cellSize2.height();
            Tuple2.mcDD.sp sp4 = new Tuple2.mcDD.sp(w1, h1);
            Tuple2.mcDD.sp sp5 = sp4;
            double w12 = sp5._1$mcD$sp();
            double h12 = sp5._2$mcD$sp();
            return this.pixels() * (w02 * h02) / (w12 * h12);
        }

        public ReprojectSummary copy(double sourcePixels, double pixels, Extent extent, CellSize cellSize) {
            return new ReprojectSummary(sourcePixels, pixels, extent, cellSize);
        }

        public double copy$default$1() {
            return this.sourcePixels();
        }

        public double copy$default$2() {
            return this.pixels();
        }

        public Extent copy$default$3() {
            return this.extent();
        }

        public CellSize copy$default$4() {
            return this.cellSize();
        }

        public String productPrefix() {
            return "ReprojectSummary";
        }

        public int productArity() {
            return 4;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = BoxesRunTime.boxToDouble((double)this.sourcePixels());
                    break;
                }
                case 1: {
                    object = BoxesRunTime.boxToDouble((double)this.pixels());
                    break;
                }
                case 2: {
                    object = this.extent();
                    break;
                }
                case 3: {
                    object = this.cellSize();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof ReprojectSummary;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.sourcePixels()));
            n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.pixels()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.extent()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.cellSize()));
            return Statics.finalizeHash((int)n, (int)4);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof ReprojectSummary)) return false;
            boolean bl = true;
            if (!bl) return false;
            ReprojectSummary reprojectSummary = (ReprojectSummary)x$1;
            if (this.sourcePixels() != reprojectSummary.sourcePixels()) return false;
            if (this.pixels() != reprojectSummary.pixels()) return false;
            Extent extent = this.extent();
            Extent extent2 = reprojectSummary.extent();
            if (extent == null) {
                if (extent2 != null) {
                    return false;
                }
            } else if (!extent.equals(extent2)) return false;
            CellSize cellSize = this.cellSize();
            CellSize cellSize2 = reprojectSummary.cellSize();
            if (cellSize == null) {
                if (cellSize2 != null) {
                    return false;
                }
            } else if (!cellSize.equals(cellSize2)) return false;
            if (!reprojectSummary.canEqual(this)) return false;
            return true;
        }

        public ReprojectSummary(double sourcePixels, double pixels, Extent extent, CellSize cellSize) {
            this.sourcePixels = sourcePixels;
            this.pixels = pixels;
            this.extent = extent;
            this.cellSize = cellSize;
            Product.$init$((Product)this);
        }
    }
}

