/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.spark.store;

import geotrellis.raster.GridBounds;
import geotrellis.raster.io.geotiff.GeoTiffSegmentLayoutTransform;
import geotrellis.raster.io.geotiff.GeoTiffSegmentLayoutTransform$;
import geotrellis.raster.io.geotiff.reader.GeoTiffInfo;
import geotrellis.spark.store.RasterReader;
import java.io.Serializable;
import java.net.URI;
import org.apache.spark.SparkContext;
import org.apache.spark.rdd.RDD;
import org.locationtech.jts.geom.Geometry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015e\u0001\u0003\u0005\n!\u0003\r\t!D\b\t\u000be\u0001A\u0011A\u000e\t\u000b}\u0001a\u0011\u0001\u0011\t\u000bu\u0002a\u0011\u0001 \t\u000b5\u0003A\u0011\u0001(\t\u000bU\u0003A\u0011\u0002,\t\u000bu\u0004A\u0011\u0001@\t\u0015\u00055\u0004\u0001#b!\n\u0013\tyGA\tHK>$\u0016N\u001a4J]\u001a|'+Z1eKJT!AC\u0006\u0002\u000bM$xN]3\u000b\u00051i\u0011!B:qCJ\\'\"\u0001\b\u0002\u0015\u001d,w\u000e\u001e:fY2L7oE\u0002\u0001!Y\u0001\"!\u0005\u000b\u000e\u0003IQ\u0011aE\u0001\u0006g\u000e\fG.Y\u0005\u0003+I\u0011a!\u00118z%\u00164\u0007CA\t\u0018\u0013\tA\"C\u0001\u0007TKJL\u0017\r\\5{C\ndW-\u0001\u0004%S:LG\u000fJ\u0002\u0001)\u0005a\u0002CA\t\u001e\u0013\tq\"C\u0001\u0003V]&$\u0018AD4f_RKgMZ%oM>\u0014F\t\u0012\u000b\u0003C]\u00022A\t\u0016-\u001b\u0005\u0019#B\u0001\u0013&\u0003\r\u0011H\r\u001a\u0006\u0003\u0019\u0019R!a\n\u0015\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005I\u0013aA8sO&\u00111f\t\u0002\u0004%\u0012#\u0005CA\u00175\u001d\tq#\u0007\u0005\u00020%5\t\u0001G\u0003\u000225\u00051AH]8pizJ!a\r\n\u0002\rA\u0013X\rZ3g\u0013\t)dG\u0001\u0004TiJLgn\u001a\u0006\u0003gIAQ\u0001\u000f\u0002A\u0004e\n!a]2\u0011\u0005iZT\"A\u0013\n\u0005q*#\u0001D*qCJ\\7i\u001c8uKb$\u0018AD4fi\u001e+w\u000eV5gM&sgm\u001c\u000b\u0003\u007f-\u0003\"\u0001Q%\u000e\u0003\u0005S!AQ\"\u0002\rI,\u0017\rZ3s\u0015\t!U)A\u0004hK>$\u0018N\u001a4\u000b\u0005\u0019;\u0015AA5p\u0015\tAU\"\u0001\u0004sCN$XM]\u0005\u0003\u0015\u0006\u00131bR3p)&4g-\u00138g_\")Aj\u0001a\u0001Y\u0005\u0019QO]5\u00023\u001d,GoU3h[\u0016tG\u000fT1z_V$HK]1og\u001a|'/\u001c\u000b\u0003\u001fN\u0003\"\u0001U)\u000e\u0003\rK!AU\"\u0003;\u001d+w\u000eV5gMN+w-\\3oi2\u000b\u0017p\\;u)J\fgn\u001d4pe6DQ\u0001\u0016\u0003A\u0002}\n1bZ3p)&4g-\u00138g_\u0006\u0011r/\u001b8e_^\u001c()\u001f)beRLG/[8o)\u00159&\r\u001a4l!\r\t\u0002LW\u0005\u00033J\u0011Q!\u0011:sCf\u00042!\u0005-\\!\raVlX\u0007\u0002\u000f&\u0011al\u0012\u0002\u000b\u000fJLGMQ8v]\u0012\u001c\bCA\ta\u0013\t\t'CA\u0002J]RDQaY\u0003A\u0002}\nA!\u001b8g_\")Q-\u0002a\u0001?\u00069Q.\u0019=TSj,\u0007\"B4\u0006\u0001\u0004A\u0017A\u00049beRLG/[8o\u0005f$Xm\u001d\t\u0003#%L!A\u001b\n\u0003\t1{gn\u001a\u0005\u0006Y\u0016\u0001\r!\\\u0001\tO\u0016|W.\u001a;ssB\u0019\u0011C\u001c9\n\u0005=\u0014\"AB(qi&|g\u000e\u0005\u0002ru:\u0011!o\u001e\b\u0003gVt!a\f;\n\u00039I!A^\u0007\u0002\rY,7\r^8s\u0013\tA\u00180A\u0004qC\u000e\\\u0017mZ3\u000b\u0005Yl\u0011BA>}\u0005!9Um\\7fiJL(B\u0001=z\u0003-\u0011X-\u00193XS:$wn^:\u0016\u0013}\f9$a\u0010\u0002\u0010\u0005\rBCDA\u0001\u0003\u0007\nI&a\u0019\u0002f\u0005\u001d\u00141\u000e\u000b\u0007\u0003\u0007\t9#!\u000b\u0011\t\tR\u0013Q\u0001\t\b#\u0005\u001d\u00111BA\u0011\u0013\r\tIA\u0005\u0002\u0007)V\u0004H.\u001a\u001a\u0011\t\u00055\u0011q\u0002\u0007\u0001\t\u001d\t\tB\u0002b\u0001\u0003'\u0011\u0011aS\t\u0005\u0003+\tY\u0002E\u0002\u0012\u0003/I1!!\u0007\u0013\u0005\u001dqu\u000e\u001e5j]\u001e\u00042!EA\u000f\u0013\r\tyB\u0005\u0002\u0004\u0003:L\b\u0003BA\u0007\u0003G!q!!\n\u0007\u0005\u0004\t\u0019BA\u0001W\u0011\u0015Ad\u0001q\u0001:\u0011\u001d\tYC\u0002a\u0002\u0003[\t!A\u001d:\u0011\u0011\u0005=\u0012\u0011GA\u001b\u0003wi\u0011!C\u0005\u0004\u0003gI!\u0001\u0004*bgR,'OU3bI\u0016\u0014\b\u0003BA\u0007\u0003o!q!!\u000f\u0007\u0005\u0004\t\u0019BA\u0001P!\u001d\t\u0012qAA\u001f\u0003C\u0001B!!\u0004\u0002@\u00119\u0011\u0011\t\u0004C\u0002\u0005M!!A%\t\u000f\u0005\u0015c\u00011\u0001\u0002H\u0005)a-\u001b7fgB!!EKA%!\u0011\tY%!\u0016\u000e\u0005\u00055#\u0002BA(\u0003#\n1A\\3u\u0015\t\t\u0019&\u0001\u0003kCZ\f\u0017\u0002BA,\u0003\u001b\u00121!\u0016*J\u0011\u001d\tYF\u0002a\u0001\u0003;\n\u0001\"\u001e:j)>\\U-\u001f\t\n#\u0005}\u0013\u0011JA\u001f\u0003\u0017I1!!\u0019\u0013\u0005%1UO\\2uS>t'\u0007C\u0003f\r\u0001\u0007q\fC\u0003h\r\u0001\u0007\u0001\u000eC\u0004\u0002j\u0019\u0001\r!!\u000e\u0002'I\f7\u000f^3s%\u0016\fG-\u001a:PaRLwN\\:\t\u000b14\u0001\u0019A7\u0002\r1|wmZ3s+\t\t\t\b\u0005\u0003\u0002t\u0005eTBAA;\u0015\r\t9\bK\u0001\u0006Y><Gg]\u0005\u0005\u0003w\n)H\u0001\u0004M_\u001e<WM\u001d\u0015\u0004\u000f\u0005}\u0004cA\t\u0002\u0002&\u0019\u00111\u0011\n\u0003\u0013Q\u0014\u0018M\\:jK:$\b")
public interface GeoTiffInfoReader
extends scala.Serializable {
    public static /* synthetic */ Logger geotrellis$spark$store$GeoTiffInfoReader$$logger$(GeoTiffInfoReader $this) {
        return $this.geotrellis$spark$store$GeoTiffInfoReader$$logger();
    }

    default public Logger geotrellis$spark$store$GeoTiffInfoReader$$logger() {
        return LoggerFactory.getLogger(GeoTiffInfoReader.class);
    }

    public RDD<String> geoTiffInfoRDD(SparkContext var1);

    public GeoTiffInfo getGeoTiffInfo(String var1);

    public static /* synthetic */ GeoTiffSegmentLayoutTransform getSegmentLayoutTransform$(GeoTiffInfoReader $this, GeoTiffInfo geoTiffInfo) {
        return $this.getSegmentLayoutTransform(geoTiffInfo);
    }

    default public GeoTiffSegmentLayoutTransform getSegmentLayoutTransform(GeoTiffInfo geoTiffInfo) {
        return GeoTiffSegmentLayoutTransform$.MODULE$.apply(geoTiffInfo.segmentLayout(), geoTiffInfo.bandCount());
    }

    private GridBounds<Object>[][] windowsByPartition(GeoTiffInfo info, int maxSize, long partitionBytes, Option<Geometry> geometry) {
        GridBounds[] gridBoundsArray;
        Option<Geometry> option = geometry;
        if (option instanceof Some) {
            Some some = (Some)option;
            Geometry geometry2 = (Geometry)some.value();
            gridBoundsArray = info.segmentLayout().listWindows(maxSize, info.extent(), geometry2);
        } else if (None$.MODULE$.equals(option)) {
            gridBoundsArray = info.segmentLayout().listWindows(maxSize);
        } else {
            throw new MatchError(option);
        }
        GridBounds[] windows = gridBoundsArray;
        return info.segmentLayout().partitionWindowsBySegments((Seq)Predef$.MODULE$.wrapRefArray((Object[])windows), partitionBytes / (long)package$.MODULE$.max(info.cellType().bytes(), 1));
    }

    public static /* synthetic */ RDD readWindows$(GeoTiffInfoReader $this, RDD files, Function2 uriToKey, int maxSize, long partitionBytes, Object rasterReaderOptions, Option geometry, SparkContext sc, RasterReader rr) {
        return $this.readWindows((RDD<URI>)files, uriToKey, maxSize, partitionBytes, rasterReaderOptions, (Option<Geometry>)geometry, sc, rr);
    }

    default public <O, I, K, V> RDD<Tuple2<K, V>> readWindows(RDD<URI> files, Function2<URI, I, K> uriToKey, int maxSize, long partitionBytes, O rasterReaderOptions, Option<Geometry> geometry, SparkContext sc, RasterReader<O, Tuple2<I, V>> rr) {
        RDD rDD;
        RDD windows = files.flatMap((Function1 & Serializable & scala.Serializable)uri -> (TraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.windowsByPartition(this.getGeoTiffInfo(uri.toString()), maxSize, partitionBytes, geometry))).map((Function1 & Serializable & scala.Serializable)windows -> new Tuple2(uri, windows), Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit())), ClassTag$.MODULE$.apply(Tuple2.class));
        windows.persist();
        int windowCount = (int)windows.count();
        if (windowCount > windows.partitions().length) {
            if (this.geotrellis$spark$store$GeoTiffInfoReader$$logger().isInfoEnabled()) {
                this.geotrellis$spark$store$GeoTiffInfoReader$$logger().info(new StringBuilder(29).append("Repartition into ").append(windowCount).append(" partitions.").toString());
            }
            int x$1 = windowCount;
            Ordering x$2 = windows.repartition$default$2(x$1);
            rDD = windows.repartition(x$1, x$2);
        } else {
            rDD = windows;
        }
        RDD repartition = rDD;
        RDD result = repartition.flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            URI uri = (URI)tuple2._1();
            GridBounds[] windows = (GridBounds[])tuple2._2();
            GeoTiffInfo info = this.getGeoTiffInfo(uri.toString());
            Iterator iterator = rr.readWindows(windows, info, rasterReaderOptions).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                Tuple2 tuple2 = x0$2;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Object k = tuple2._1();
                Object v = tuple2._2();
                Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(uriToKey.apply((Object)uri, k)), v);
                return tuple22;
            });
            return iterator;
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        windows.unpersist(windows.unpersist$default$1());
        return result;
    }

    public static void $init$(GeoTiffInfoReader $this) {
    }
}

