/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.spark.store.cog;

import geotrellis.layer.Bounds;
import geotrellis.layer.KeyBounds;
import geotrellis.layer.LayoutDefinition;
import geotrellis.layer.LayoutScheme;
import geotrellis.layer.MapKeyTransform;
import geotrellis.layer.Metadata;
import geotrellis.layer.SpatialKey;
import geotrellis.layer.TileLayerMetadata;
import geotrellis.layer.TileLayerMetadata$;
import geotrellis.layer.ZoomedLayoutScheme;
import geotrellis.layer.ZoomedLayoutScheme$;
import geotrellis.proj4.CRS;
import geotrellis.raster.CellGrid;
import geotrellis.raster.DataType;
import geotrellis.raster.GridBounds;
import geotrellis.raster.GridBounds$;
import geotrellis.raster.TileLayout;
import geotrellis.raster.crop.CropMethods;
import geotrellis.raster.crop.TileCropMethods;
import geotrellis.raster.io.geotiff.GeoTiff;
import geotrellis.raster.io.geotiff.GeoTiffBuilder;
import geotrellis.raster.io.geotiff.GeoTiffBuilder$;
import geotrellis.raster.io.geotiff.GeoTiffData;
import geotrellis.raster.io.geotiff.GeoTiffOptions;
import geotrellis.raster.io.geotiff.GeoTiffOptions$;
import geotrellis.raster.io.geotiff.StorageMethod;
import geotrellis.raster.io.geotiff.Tags;
import geotrellis.raster.io.geotiff.Tiled;
import geotrellis.raster.io.geotiff.compression.Compression;
import geotrellis.raster.io.geotiff.writer.GeoTiffWriter;
import geotrellis.raster.merge.TileMergeMethods;
import geotrellis.raster.prototype.TilePrototypeMethods;
import geotrellis.raster.resample.ResampleMethod;
import geotrellis.spark.ContextRDD$;
import geotrellis.spark.pyramid.Pyramid;
import geotrellis.spark.pyramid.Pyramid$;
import geotrellis.spark.pyramid.Pyramid$Options$;
import geotrellis.spark.store.cog.COGLayer;
import geotrellis.spark.store.cog.COGLayerWriter;
import geotrellis.spark.store.cog.COGLayerWriter$Options$;
import geotrellis.spark.util.KryoWrapper;
import geotrellis.spark.util.KryoWrapper$;
import geotrellis.store.cog.COGLayerMetadata;
import geotrellis.store.cog.COGLayerMetadata$;
import geotrellis.store.cog.ZoomRange;
import geotrellis.store.cog.ZoomRange$;
import geotrellis.store.hadoop.SerializableConfiguration;
import geotrellis.store.hadoop.util.HdfsUtils$;
import geotrellis.store.index.KeyIndex;
import geotrellis.util.Component;
import geotrellis.util.GetComponent;
import geotrellis.util.SetComponent;
import geotrellis.vector.Extent;
import io.circe.Encoder;
import java.io.DataOutputStream;
import java.io.Serializable;
import java.net.URI;
import org.apache.hadoop.fs.Path;
import org.apache.spark.HashPartitioner;
import org.apache.spark.Partitioner;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Vector;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;

public final class COGLayer$
implements scala.Serializable {
    public static COGLayer$ MODULE$;

    static {
        new COGLayer$();
    }

    private boolean isPowerOfTwo(int x) {
        return x != 0 && (x & x - 1) == 0;
    }

    public <K, V extends CellGrid<Object>> COGLayer<K, V> fromLayerRDD(RDD<Tuple2<K, V>> rdd, int baseZoom, Option<Object> minZoom, COGLayerWriter.Options options, Component<K, SpatialKey> evidence$1, Ordering<K> evidence$2, Encoder<K> evidence$3, ClassTag<K> evidence$4, ClassTag<V> evidence$5, Function1<V, TileMergeMethods<V>> evidence$6, Function1<V, TilePrototypeMethods<V>> evidence$7, Function1<V, TileCropMethods<V>> evidence$8, GeoTiffBuilder<V> evidence$9) {
        if (!BoxesRunTime.equals((Object)minZoom.getOrElse((Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> Double.NaN), (Object)BoxesRunTime.boxToDouble((double)baseZoom))) {
            if (((TileLayerMetadata)((Metadata)rdd).metadata()).layout().tileCols() != ((TileLayerMetadata)((Metadata)rdd).metadata()).layout().tileRows()) {
                throw scala.sys.package$.MODULE$.error("Cannot create Pyramided COG layer for non-square tiles.");
            }
            if (!this.isPowerOfTwo(((TileLayerMetadata)((Metadata)rdd).metadata()).layout().tileCols())) {
                throw scala.sys.package$.MODULE$.error("Cannot create Pyramided COG layer for tile sizes that are not power-of-two.");
            }
        }
        return this.buildCOGLayer(rdd, baseZoom, (Function2 & Serializable & scala.Serializable)(layoutScheme, keyBounds) -> COGLayer$.constructMetadata$1(layoutScheme, keyBounds, rdd, baseZoom, minZoom, options, evidence$1), options, evidence$1, evidence$2, evidence$3, evidence$4, evidence$5, evidence$6, evidence$7, evidence$8, evidence$9);
    }

    public <K, V extends CellGrid<Object>> COGLayer<K, V> fromLayerRDD(RDD<Tuple2<K, V>> rdd, int baseZoom, Vector<ZoomRange> zoomRanges, COGLayerWriter.Options options, Component<K, SpatialKey> evidence$10, Ordering<K> evidence$11, Encoder<K> evidence$12, ClassTag<K> evidence$13, ClassTag<V> evidence$14, Function1<V, TileMergeMethods<V>> evidence$15, Function1<V, TilePrototypeMethods<V>> evidence$16, Function1<V, TileCropMethods<V>> evidence$17, GeoTiffBuilder<V> evidence$18) {
        if (zoomRanges.exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)COGLayer$.$anonfun$fromLayerRDD$4(baseZoom, x$1)))) {
            if (((TileLayerMetadata)((Metadata)rdd).metadata()).layout().tileCols() != ((TileLayerMetadata)((Metadata)rdd).metadata()).layout().tileRows()) {
                throw scala.sys.package$.MODULE$.error("Cannot create Pyramided COG layer for non-square tiles.");
            }
            if (!this.isPowerOfTwo(((TileLayerMetadata)((Metadata)rdd).metadata()).layout().tileCols())) {
                throw scala.sys.package$.MODULE$.error("Cannot create Pyramided COG layer for tile sizes that are not power-of-two.");
            }
        }
        return this.buildCOGLayer(rdd, baseZoom, (Function2 & Serializable & scala.Serializable)(layoutScheme, keyBounds) -> COGLayer$.constructMetadata$2(layoutScheme, keyBounds, rdd, baseZoom, zoomRanges, evidence$10), options, evidence$10, evidence$11, evidence$12, evidence$13, evidence$14, evidence$15, evidence$16, evidence$17, evidence$18);
    }

    public <K, V extends CellGrid<Object>> Option<Object> fromLayerRDD$default$3() {
        return None$.MODULE$;
    }

    public <K, V extends CellGrid<Object>> COGLayerWriter.Options fromLayerRDD$default$4() {
        return COGLayerWriter$Options$.MODULE$.DEFAULT();
    }

    private <K, V extends CellGrid<Object>> COGLayer<K, V> buildCOGLayer(RDD<Tuple2<K, V>> rdd, int baseZoom, Function2<ZoomedLayoutScheme, KeyBounds<K>, COGLayerMetadata<K>> constructMetadata, COGLayerWriter.Options options, Component<K, SpatialKey> evidence$19, Ordering<K> evidence$20, Encoder<K> evidence$21, ClassTag<K> evidence$22, ClassTag<V> evidence$23, Function1<V, TileMergeMethods<V>> evidence$24, Function1<V, TilePrototypeMethods<V>> evidence$25, Function1<V, TileCropMethods<V>> evidence$26, GeoTiffBuilder<V> evidence$27) {
        KeyBounds keyBounds;
        ZoomedLayoutScheme layoutScheme = ZoomedLayoutScheme$.MODULE$.apply(((TileLayerMetadata)((Metadata)rdd).metadata()).crs(), ((TileLayerMetadata)((Metadata)rdd).metadata()).layout().tileCols(), ZoomedLayoutScheme$.MODULE$.apply$default$3());
        LayoutDefinition layoutDefinition = ((TileLayerMetadata)((Metadata)rdd).metadata()).layout();
        LayoutDefinition layoutDefinition2 = layoutScheme.levelForZoom(baseZoom).layout();
        if (layoutDefinition == null ? layoutDefinition2 != null : !layoutDefinition.equals(layoutDefinition2)) {
            throw scala.sys.package$.MODULE$.error(new StringBuilder(62).append("Tile Layout of layer and ZoomedLayoutScheme do not match. ").append(((TileLayerMetadata)((Metadata)rdd).metadata()).layout()).append(" != ").append(layoutScheme.levelForZoom(baseZoom).layout()).toString());
        }
        Bounds bounds = ((TileLayerMetadata)((Metadata)rdd).metadata()).bounds();
        if (!(bounds instanceof KeyBounds)) {
            throw scala.sys.package$.MODULE$.error("Cannot create COGLayer with empty Bounds");
        }
        KeyBounds keyBounds2 = keyBounds = (KeyBounds)bounds;
        KeyBounds keyBounds3 = keyBounds2;
        COGLayerMetadata cogLayerMetadata = (COGLayerMetadata)constructMetadata.apply((Object)layoutScheme, (Object)keyBounds3);
        Compression compression = options.compression();
        ResampleMethod resampleMethod = options.resampleMethod();
        Pyramid.Options pyramidOptions = new Pyramid.Options(resampleMethod, Pyramid$Options$.MODULE$.apply$default$2());
        Map layers = ((TraversableOnce)((TraversableOnce)cogLayerMetadata.zoomRanges().sorted(scala.package$.MODULE$.Ordering().apply(ZoomRange$.MODULE$.ordering()).reverse())).foldLeft((Object)Nil$.MODULE$, (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            .colon.colon colon2;
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 != null) {
                List acc = (List)tuple2._1();
                ZoomRange range = (ZoomRange)tuple2._2();
                if (acc.isEmpty()) {
                    colon2 = new .colon.colon((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)range), MODULE$.generateGeoTiffRDD(rdd, range, layoutScheme, cogLayerMetadata.cellType(), compression, resampleMethod, evidence$19, evidence$20, evidence$21, evidence$22, evidence$23, evidence$24, evidence$25, evidence$26, evidence$27)), (List)Nil$.MODULE$);
                } else {
                    RDD previousLayer = RDD$.MODULE$.rddToPairRDDFunctions((RDD)((Tuple2)acc.head())._2(), evidence$22, ClassTag$.MODULE$.apply(GeoTiff.class), evidence$20).mapValues((Function1 & Serializable & scala.Serializable)tiff -> tiff.overviews().nonEmpty() ? ((GeoTiff)tiff.overviews().last()).tile() : tiff.tile());
                    TileLayerMetadata tmd = cogLayerMetadata.tileLayerMetadata(range.maxZoom() + 1);
                    RDD upsampledPreviousLayer = (RDD)Pyramid$.MODULE$.up(ContextRDD$.MODULE$.apply(previousLayer, tmd), (LayoutScheme)layoutScheme, range.maxZoom() + 1, pyramidOptions, evidence$19, evidence$22, evidence$23, evidence$25, evidence$24, TileLayerMetadata$.MODULE$.layoutComponent(evidence$19), TileLayerMetadata$.MODULE$.boundsComponent(evidence$19))._2();
                    RDD rzz = MODULE$.generateGeoTiffRDD(upsampledPreviousLayer, range, layoutScheme, cogLayerMetadata.cellType(), compression, resampleMethod, evidence$19, evidence$20, evidence$21, evidence$22, evidence$23, evidence$24, evidence$25, evidence$26, evidence$27);
                    Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)range), rzz);
                    colon2 = acc.$colon$colon((Object)tuple22);
                }
            } else {
                throw new MatchError((Object)tuple2);
            }
            .colon.colon colon3 = colon2;
            return colon3;
        })).toMap(Predef$.MODULE$.$conforms());
        return new COGLayer(layers, cogLayerMetadata);
    }

    private <K, V extends CellGrid<Object>> RDD<Tuple2<K, GeoTiff<V>>> generateGeoTiffRDD(RDD<Tuple2<K, V>> rdd, ZoomRange zoomRange, ZoomedLayoutScheme layoutScheme, DataType cellType, Compression compression, ResampleMethod resampleMethod, Component<K, SpatialKey> evidence$28, Ordering<K> evidence$29, Encoder<K> evidence$30, ClassTag<K> evidence$31, ClassTag<V> evidence$32, Function1<V, TileMergeMethods<V>> evidence$33, Function1<V, TilePrototypeMethods<V>> evidence$34, Function1<V, TileCropMethods<V>> evidence$35, GeoTiffBuilder<V> evidence$36) {
        KryoWrapper<Object> kwEncoder = KryoWrapper$.MODULE$.apply(Predef$.MODULE$.implicitly(evidence$30), ClassTag$.MODULE$.apply(Encoder.class));
        CRS crs = layoutScheme.crs();
        LayoutDefinition minZoomLayout = layoutScheme.levelForZoom(zoomRange.minZoom()).layout();
        LayoutDefinition maxZoomLayout = layoutScheme.levelForZoom(zoomRange.maxZoom()).layout();
        GeoTiffOptions options = new GeoTiffOptions((StorageMethod)new Tiled(maxZoomLayout.tileCols(), maxZoomLayout.tileRows()), compression, GeoTiffOptions$.MODULE$.apply$default$3(), GeoTiffOptions$.MODULE$.apply$default$4(), GeoTiffOptions$.MODULE$.apply$default$5(), GeoTiffOptions$.MODULE$.apply$default$6(), GeoTiffOptions$.MODULE$.apply$default$7());
        RDD qual$1 = RDD$.MODULE$.rddToPairRDDFunctions(rdd.mapPartitions((Function1 & Serializable & scala.Serializable)partition -> partition.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Object key = tuple2._1();
            CellGrid tile = (CellGrid)tuple2._2();
            Extent extent = ((SpatialKey)geotrellis.util.package$.MODULE$.withGetComponentMethods(key).getComponent((GetComponent)evidence$28)).extent(maxZoomLayout);
            SpatialKey minZoomSpatialKey = minZoomLayout.mapTransform().apply(extent.center());
            Tuple2 tuple22 = new Tuple2(geotrellis.util.package$.MODULE$.withSetComponentMethods(key).setComponent((Object)minZoomSpatialKey, (SetComponent)evidence$28), (Object)new Tuple2(key, (Object)tile));
            return tuple22;
        }), rdd.mapPartitions$default$2(), ClassTag$.MODULE$.apply(Tuple2.class)), evidence$31, ClassTag$.MODULE$.apply(Tuple2.class), evidence$29).groupByKey((Partitioner)new HashPartitioner(rdd.partitions().length));
        Function1 & Serializable & scala.Serializable x$4 = (Function1 & Serializable & scala.Serializable)partition -> {
            Encoder keyEncoder = (Encoder)kwEncoder.value();
            return partition.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                Tuple2 tuple2 = x0$2;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Object key = tuple2._1();
                Iterable tiles = (Iterable)tuple2._2();
                Extent cogExtent = ((SpatialKey)geotrellis.util.package$.MODULE$.withGetComponentMethods(key).getComponent((GetComponent)evidence$28)).extent(minZoomLayout);
                double h = maxZoomLayout.cellheight() / (double)2;
                double w = maxZoomLayout.cellwidth() / (double)2;
                Extent centerToCenter = new Extent(cogExtent.xmin() + w, cogExtent.ymin() + h, cogExtent.xmax() - w, cogExtent.ymax() - h);
                GridBounds cogTileBounds = maxZoomLayout.mapTransform().extentToBounds(centerToCenter);
                TileLayout cogLayout = maxZoomLayout.layoutForBounds(cogTileBounds).tileLayout();
                Iterable segments = (Iterable)tiles.map((Function1 & Serializable & scala.Serializable)x0$3 -> {
                    Tuple2.mcII.sp sp2;
                    CellGrid value;
                    Tuple2 tuple2 = x0$3;
                    if (tuple2 != null) {
                        Object key = tuple2._1();
                        value = (CellGrid)tuple2._2();
                        SpatialKey spatialKey = (SpatialKey)geotrellis.util.package$.MODULE$.withGetComponentMethods(key).getComponent((GetComponent)evidence$28);
                        if (spatialKey == null) {
                            throw new MatchError((Object)spatialKey);
                        }
                        int col = spatialKey.col();
                        int row = spatialKey.row();
                        sp2 = new Tuple2.mcII.sp(col, row);
                    } else {
                        throw new MatchError((Object)tuple2);
                    }
                    Tuple2.mcII.sp sp3 = sp2;
                    int col = sp3._1$mcI$sp();
                    int row = sp3._2$mcI$sp();
                    Tuple2 tuple22 = new Tuple2((Object)new SpatialKey(col - cogTileBounds.colMin$mcI$sp(), row - cogTileBounds.rowMin$mcI$sp()), (Object)value);
                    return tuple22;
                }, Iterable$.MODULE$.canBuildFrom());
                CellGrid cogTile = GeoTiffBuilder$.MODULE$.apply(evidence$36).makeTile(segments.iterator(), cogLayout, cellType, (StorageMethod)new Tiled(cogLayout.tileCols(), cogLayout.tileRows()), compression);
                GeoTiff qual$2 = GeoTiffBuilder$.MODULE$.apply(evidence$36).makeGeoTiff(cogTile, cogExtent, crs, new Tags((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"GT_KEY"), (Object)keyEncoder.apply(key).noSpaces())})), (List)Nil$.MODULE$), options);
                ResampleMethod x$1 = resampleMethod;
                List x$2 = qual$2.withOverviews$default$2();
                int x$3 = qual$2.withOverviews$default$3();
                GeoTiff cogTiff = qual$2.withOverviews(x$1, x$2, x$3);
                Tuple2 tuple22 = new Tuple2(key, (Object)cogTiff);
                return tuple22;
            });
        };
        boolean x$5 = qual$1.mapPartitions$default$2();
        return qual$1.mapPartitions((Function1)x$4, x$5, ClassTag$.MODULE$.apply(Tuple2.class));
    }

    public <K, V extends CellGrid<Object>> void write(RDD<Tuple2<K, GeoTiff<V>>> cogs, KeyIndex<K> keyIndex, URI uri, Component<K, SpatialKey> evidence$37, ClassTag<K> evidence$38, ClassTag<V> evidence$39) {
        SerializableConfiguration conf = new SerializableConfiguration(cogs.sparkContext().hadoopConfiguration());
        cogs.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            COGLayer$.$anonfun$write$1(uri, keyIndex, conf, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public <V extends CellGrid<Object>> GeoTiff<V> mergeCOGs(GeoTiff<V> previous, GeoTiff<V> update, Function1<V, CropMethods<V>> evidence$40, Function1<V, TileMergeMethods<V>> evidence$41, GeoTiffBuilder<V> evidence$42) {
        GeoTiffBuilder geoTiffBuilder = (GeoTiffBuilder)Predef$.MODULE$.implicitly(evidence$42);
        StorageMethod storageMethod = previous.options().storageMethod();
        if (!(storageMethod instanceof Tiled)) {
            throw new MatchError((Object)storageMethod);
        }
        Tiled tiled = (Tiled)storageMethod;
        int segmentCols = tiled.blockCols();
        int segmentRows = tiled.blockRows();
        Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(segmentCols, segmentRows);
        Tuple2.mcII.sp sp3 = sp2;
        int segmentCols2 = sp3._1$mcI$sp();
        int segmentRows2 = sp3._2$mcI$sp();
        int pixelCols = BoxesRunTime.unboxToInt((Object)previous.tile().cols());
        int pixelRows = BoxesRunTime.unboxToInt((Object)previous.tile().rows());
        int x$1 = (int)package$.MODULE$.ceil((double)pixelRows / (double)segmentRows2);
        int x$2 = (int)package$.MODULE$.ceil((double)pixelCols / (double)segmentCols2);
        int x$3 = segmentCols2;
        int x$4 = segmentRows2;
        TileLayout layout = new TileLayout(x$2, x$1, x$3, x$4);
        Seq tiles = (Seq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), layout.layoutRows()).flatMap((Function1 & Serializable & scala.Serializable)layoutRow -> COGLayer$.$anonfun$mergeCOGs$1(layout, segmentCols2, segmentRows2, evidence$40, previous, update, evidence$41, BoxesRunTime.unboxToInt((Object)layoutRow)), IndexedSeq$.MODULE$.canBuildFrom());
        MapKeyTransform mapKeyTransform = new LayoutDefinition(previous.extent(), layout).mapTransform();
        return geoTiffBuilder.fromSegments(tiles.toMap(Predef$.MODULE$.$conforms()), (Function2 & Serializable & scala.Serializable)(col, row) -> mapKeyTransform.keyToExtent(BoxesRunTime.unboxToInt((Object)col), BoxesRunTime.unboxToInt((Object)row)), previous.crs(), previous.options(), previous.tags());
    }

    public <K, T extends CellGrid<Object>> COGLayer<K, T> apply(Map<ZoomRange, RDD<Tuple2<K, GeoTiff<T>>>> layers, COGLayerMetadata<K> metadata) {
        return new COGLayer<K, T>(layers, metadata);
    }

    public <K, T extends CellGrid<Object>> Option<Tuple2<Map<ZoomRange, RDD<Tuple2<K, GeoTiff<T>>>>, COGLayerMetadata<K>>> unapply(COGLayer<K, T> x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple2(x$0.layers(), x$0.metadata()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private static final COGLayerMetadata constructMetadata$1(ZoomedLayoutScheme layoutScheme, KeyBounds keyBounds, RDD rdd$1, int baseZoom$1, Option minZoom$1, COGLayerWriter.Options options$1, Component evidence$1$1) {
        return COGLayerMetadata$.MODULE$.apply(((TileLayerMetadata)((Metadata)rdd$1).metadata()).cellType(), ((TileLayerMetadata)((Metadata)rdd$1).metadata()).extent(), ((TileLayerMetadata)((Metadata)rdd$1).metadata()).crs(), keyBounds, layoutScheme, baseZoom$1, BoxesRunTime.unboxToInt((Object)minZoom$1.getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0)), options$1.maxTileSize(), evidence$1$1);
    }

    public static final /* synthetic */ boolean $anonfun$fromLayerRDD$4(int baseZoom$2, ZoomRange x$1) {
        return x$1.maxZoom() != baseZoom$2;
    }

    private static final COGLayerMetadata constructMetadata$2(ZoomedLayoutScheme layoutScheme, KeyBounds keyBounds, RDD rdd$2, int baseZoom$2, Vector zoomRanges$1, Component evidence$10$1) {
        return COGLayerMetadata$.MODULE$.apply(((TileLayerMetadata)((Metadata)rdd$2).metadata()).cellType(), ((TileLayerMetadata)((Metadata)rdd$2).metadata()).extent(), ((TileLayerMetadata)((Metadata)rdd$2).metadata()).crs(), keyBounds, baseZoom$2, layoutScheme, zoomRanges$1, evidence$10$1);
    }

    public static final /* synthetic */ void $anonfun$write$2(GeoTiff tiff$1, DataOutputStream x$4) {
        new GeoTiffWriter((GeoTiffData)tiff$1, x$4).write(true);
    }

    public static final /* synthetic */ void $anonfun$write$1(URI uri$1, KeyIndex keyIndex$1, SerializableConfiguration conf$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Object key = tuple2._1();
        GeoTiff tiff = (GeoTiff)tuple2._2();
        Predef$.MODULE$.println((Object)new StringBuilder(8).append(key).append(": ").append(uri$1.toString()).append("/").append(keyIndex$1.toIndex(key)).append(".tiff").toString());
        HdfsUtils$.MODULE$.write(new Path(new StringBuilder(6).append(uri$1.toString()).append("/").append(keyIndex$1.toIndex(key)).append(".tiff").toString()), conf$1.value(), (Function1 & Serializable & scala.Serializable)x$4 -> {
            COGLayer$.$anonfun$write$2(tiff, x$4);
            return BoxedUnit.UNIT;
        });
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ Tuple2 $anonfun$mergeCOGs$2(int segmentCols$1, int layoutRow$1, int segmentRows$1, int layoutCol) {
        GridBounds segmentBounds = GridBounds$.MODULE$.apply(layoutCol * segmentCols$1, layoutRow$1 * segmentRows$1, (layoutCol + 1) * segmentCols$1 - 1, (layoutRow$1 + 1) * segmentRows$1 - 1);
        return new Tuple2((Object)BoxesRunTime.boxToInteger((int)layoutCol), (Object)segmentBounds);
    }

    public static final /* synthetic */ IndexedSeq $anonfun$mergeCOGs$1(TileLayout layout$1, int segmentCols$1, int segmentRows$1, Function1 evidence$40$1, GeoTiff previous$1, GeoTiff update$1, Function1 evidence$41$1, int layoutRow) {
        return (IndexedSeq)((TraversableLike)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), layout$1.layoutCols()).map((Function1 & Serializable & scala.Serializable)layoutCol -> COGLayer$.$anonfun$mergeCOGs$2(segmentCols$1, layoutRow, segmentRows$1, BoxesRunTime.unboxToInt((Object)layoutCol)), IndexedSeq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$6 -> {
            Tuple2 tuple2 = x$6;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            int layoutCol = tuple2._1$mcI$sp();
            GridBounds segmentBounds = (GridBounds)tuple2._2();
            SpatialKey key = new SpatialKey(layoutCol, layoutRow);
            CellGrid left = (CellGrid)((CropMethods)evidence$40$1.apply((Object)previous$1.tile())).crop(segmentBounds);
            CellGrid right = (CellGrid)((CropMethods)evidence$40$1.apply((Object)update$1.tile())).crop(segmentBounds);
            Tuple2 tuple22 = new Tuple2((Object)key, ((TileMergeMethods)evidence$41$1.apply((Object)left)).merge((Object)right));
            return tuple22;
        }, IndexedSeq$.MODULE$.canBuildFrom());
    }

    private COGLayer$() {
        MODULE$ = this;
    }
}

