/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.spark.store.file;

import geotrellis.layer.Boundable;
import geotrellis.layer.KeyBounds;
import geotrellis.layer.KeyBounds$;
import geotrellis.spark.util.KryoWrapper;
import geotrellis.spark.util.KryoWrapper$;
import geotrellis.store.avro.AvroEncoder$;
import geotrellis.store.avro.AvroRecordCodec;
import geotrellis.store.avro.codecs.KeyValueRecordCodec;
import geotrellis.store.avro.codecs.KeyValueRecordCodec$;
import geotrellis.store.index.IndexRanges$;
import geotrellis.store.index.MergeQueue$;
import geotrellis.store.util.BlockingThreadPool$;
import geotrellis.store.util.IOUtils$;
import geotrellis.util.Filesystem$;
import java.io.File;
import java.io.Serializable;
import org.apache.avro.Schema;
import org.apache.spark.SparkContext;
import org.apache.spark.rdd.RDD;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Vector;
import scala.concurrent.ExecutionContext;
import scala.math.BigInt;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

public final class FileRDDReader$ {
    public static FileRDDReader$ MODULE$;

    static {
        new FileRDDReader$();
    }

    public <K, V> RDD<Tuple2<K, V>> read(Function1<BigInt, String> keyPath, Seq<KeyBounds<K>> queryKeyBounds, Function1<KeyBounds<K>, Seq<Tuple2<BigInt, BigInt>>> decomposeBounds, boolean filterIndexOnly, Option<Schema> writerSchema, Option<Object> numPartitions, Function0<ExecutionContext> executionContext, AvroRecordCodec<K> evidence$1, Boundable<K> evidence$2, AvroRecordCodec<V> evidence$3, SparkContext sc) {
        if (queryKeyBounds.isEmpty()) {
            return sc.emptyRDD(ClassTag$.MODULE$.apply(Tuple2.class));
        }
        Seq ranges = queryKeyBounds.length() > 1 ? MergeQueue$.MODULE$.apply((TraversableOnce)queryKeyBounds.flatMap(decomposeBounds, Seq$.MODULE$.canBuildFrom())) : (Seq)queryKeyBounds.flatMap(decomposeBounds, Seq$.MODULE$.canBuildFrom());
        Seq bins = IndexRanges$.MODULE$.bin(ranges, BoxesRunTime.unboxToInt((Object)numPartitions.getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> sc.defaultParallelism())));
        Boundable boundable = (Boundable)Predef$.MODULE$.implicitly(evidence$2);
        Function1 & Serializable & scala.Serializable includeKey = (Function1 & Serializable & scala.Serializable)key -> BoxesRunTime.boxToBoolean((boolean)KeyBounds$.MODULE$.includeKey(queryKeyBounds, key, boundable));
        KeyValueRecordCodec _recordCodec = KeyValueRecordCodec$.MODULE$.apply(evidence$1, evidence$3);
        KryoWrapper<Option<Schema>> kwWriterSchema = KryoWrapper$.MODULE$.apply(writerSchema, ClassTag$.MODULE$.apply(Option.class));
        RDD qual$1 = sc.parallelize(bins, bins.size(), ClassTag$.MODULE$.apply(Seq.class));
        Function1 & Serializable & scala.Serializable x$1 = (Function1 & Serializable & scala.Serializable)partition -> {
            ExecutionContext ec = (ExecutionContext)executionContext.apply();
            return partition.flatMap((Function1 & Serializable & scala.Serializable)seq -> IOUtils$.MODULE$.parJoin(seq.toIterator(), (Function1 & Serializable & scala.Serializable)index -> {
                Vector vector;
                String path = (String)keyPath.apply(index);
                if (new File(path).exists()) {
                    byte[] bytes = Filesystem$.MODULE$.slurp(path, Filesystem$.MODULE$.slurp$default$2());
                    Vector recs = (Vector)AvroEncoder$.MODULE$.fromBinary((Schema)((Option)kwWriterSchema.value()).getOrElse((Function0 & Serializable & scala.Serializable)() -> _recordCodec.schema()), bytes, (AvroRecordCodec)_recordCodec);
                    vector = filterIndexOnly ? recs : (Vector)recs.filter((Function1 & Serializable & scala.Serializable)row -> BoxesRunTime.boxToBoolean((boolean)FileRDDReader$.$anonfun$read$7(includeKey, row)));
                } else {
                    vector = package$.MODULE$.Vector().empty();
                }
                return vector;
            }, ec));
        };
        boolean x$2 = qual$1.mapPartitions$default$2();
        return qual$1.mapPartitions((Function1)x$1, x$2, ClassTag$.MODULE$.apply(Tuple2.class));
    }

    public <K, V> Option<Schema> read$default$5() {
        return None$.MODULE$;
    }

    public <K, V> Option<Object> read$default$6() {
        return None$.MODULE$;
    }

    public <K, V> ExecutionContext read$default$7() {
        return BlockingThreadPool$.MODULE$.executionContext();
    }

    public static final /* synthetic */ boolean $anonfun$read$7(Function1 includeKey$1, Tuple2 row) {
        return BoxesRunTime.unboxToBoolean((Object)includeKey$1.apply(row._1()));
    }

    private FileRDDReader$() {
        MODULE$ = this;
    }
}

