/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.spark.store.hadoop;

import geotrellis.layer.Boundable;
import geotrellis.layer.Bounds;
import geotrellis.layer.EmptyBounds$;
import geotrellis.layer.KeyBounds;
import geotrellis.layer.KeyBounds$;
import geotrellis.spark.ContextRDD;
import geotrellis.spark.store.FilteringLayerReader;
import geotrellis.spark.store.hadoop.HadoopLayerReader$;
import geotrellis.spark.store.hadoop.HadoopRDDReader$;
import geotrellis.store.AttributeStore;
import geotrellis.store.LayerAttributes;
import geotrellis.store.LayerId;
import geotrellis.store.LayerQuery;
import geotrellis.store.avro.AvroRecordCodec;
import geotrellis.store.hadoop.HadoopAttributeStore;
import geotrellis.store.hadoop.HadoopLayerHeader;
import geotrellis.store.hadoop.HadoopLayerHeader$;
import geotrellis.store.index.KeyIndex;
import geotrellis.store.package;
import geotrellis.util.Component;
import geotrellis.util.package$;
import io.circe.Decoder;
import java.io.Serializable;
import org.apache.avro.Schema;
import org.apache.hadoop.fs.Path;
import org.apache.spark.SparkContext;
import org.apache.spark.rdd.RDD;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.GenTraversable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u00055e\u0001B\u0007\u000f\u0001]A\u0001\"\t\u0001\u0003\u0006\u0004%\tA\t\u0005\tM\u0001\u0011\t\u0011)A\u0005G!Aq\u0005\u0001B\u0001B\u0003-\u0001\u0006C\u00032\u0001\u0011\u0005!\u0007C\u00049\u0001\t\u0007I\u0011A\u001d\t\r\u0001\u0003\u0001\u0015!\u0003;\u0011\u0015\t\u0005\u0001\"\u0001C\u000f\u001d\t\u0019F\u0004E\u0001\u0003+2a!\u0004\b\t\u0002\u0005]\u0003BB\u0019\n\t\u0003\ty\u0006C\u0004\u0002b%!\t!a\u0019\t\u000f\u0005\u0005\u0014\u0002\"\u0001\u0002v\t\t\u0002*\u00193p_Bd\u0015-_3s%\u0016\fG-\u001a:\u000b\u0005=\u0001\u0012A\u00025bI>|\u0007O\u0003\u0002\u0012%\u0005)1\u000f^8sK*\u00111\u0003F\u0001\u0006gB\f'o\u001b\u0006\u0002+\u0005Qq-Z8ue\u0016dG.[:\u0004\u0001M\u0011\u0001\u0001\u0007\t\u00043iaR\"\u0001\t\n\u0005m\u0001\"\u0001\u0006$jYR,'/\u001b8h\u0019\u0006LXM\u001d*fC\u0012,'\u000f\u0005\u0002\u001e?5\taD\u0003\u0002\u0012)%\u0011\u0001E\b\u0002\b\u0019\u0006LXM]%e\u00039\tG\u000f\u001e:jEV$Xm\u0015;pe\u0016,\u0012a\t\t\u0003;\u0011J!!\n\u0010\u0003\u001d\u0005#HO]5ckR,7\u000b^8sK\u0006y\u0011\r\u001e;sS\n,H/Z*u_J,\u0007%\u0001\u0002tGB\u0011\u0011fL\u0007\u0002U)\u00111c\u000b\u0006\u0003Y5\na!\u00199bG\",'\"\u0001\u0018\u0002\u0007=\u0014x-\u0003\u00021U\ta1\u000b]1sW\u000e{g\u000e^3yi\u00061A(\u001b8jiz\"\"aM\u001c\u0015\u0005Q2\u0004CA\u001b\u0001\u001b\u0005q\u0001\"B\u0014\u0005\u0001\bA\u0003\"B\u0011\u0005\u0001\u0004\u0019\u0013\u0001\u00063fM\u0006,H\u000e\u001e(v[B\u000b'\u000f^5uS>t7/F\u0001;!\tYd(D\u0001=\u0015\u0005i\u0014!B:dC2\f\u0017BA =\u0005\rIe\u000e^\u0001\u0016I\u00164\u0017-\u001e7u\u001dVl\u0007+\u0019:uSRLwN\\:!\u0003\u0011\u0011X-\u00193\u0016\t\r\u001bVL\u001a\u000b\n\t\u0006]\u00121HA#\u0003\u0013\"R\"\u00125qk~\fy!!\u0006\u0002\u001c\u0005\u0005\"c\u0001$I?\u001a!q\t\u0001\u0001F\u00051a$/\u001a4j]\u0016lWM\u001c;?!\rIEJT\u0007\u0002\u0015*\u00111JK\u0001\u0004e\u0012$\u0017BA'K\u0005\r\u0011F\t\u0012\t\u0005w=\u000bF,\u0003\u0002Qy\t1A+\u001e9mKJ\u0002\"AU*\r\u0001\u0011)Ak\u0002b\u0001+\n\t1*\u0005\u0002W3B\u00111hV\u0005\u00031r\u0012qAT8uQ&tw\r\u0005\u0002<5&\u00111\f\u0010\u0002\u0004\u0003:L\bC\u0001*^\t\u0015qvA1\u0001V\u0005\u00051\u0006c\u00011dK6\t\u0011M\u0003\u0002c)\u0005)A.Y=fe&\u0011A-\u0019\u0002\t\u001b\u0016$\u0018\rZ1uCB\u0011!K\u001a\u0003\u0006O\u001e\u0011\r!\u0016\u0002\u0002\u001b\"9\u0011nBA\u0001\u0002\bQ\u0017AC3wS\u0012,gnY3%cA\u00191N\\)\u000e\u00031T!!\u001c\u0010\u0002\t\u00054(o\\\u0005\u0003_2\u0014q\"\u0011<s_J+7m\u001c:e\u0007>$Wm\u0019\u0005\bc\u001e\t\t\u0011q\u0001s\u0003))g/\u001b3f]\u000e,GE\r\t\u0004AN\f\u0016B\u0001;b\u0005%\u0011u.\u001e8eC\ndW\rC\u0004w\u000f\u0005\u0005\t9A<\u0002\u0015\u00154\u0018\u000eZ3oG\u0016$3\u0007E\u0002y{Fk\u0011!\u001f\u0006\u0003un\fQaY5sG\u0016T\u0011\u0001`\u0001\u0003S>L!A`=\u0003\u000f\u0011+7m\u001c3fe\"I\u0011\u0011A\u0004\u0002\u0002\u0003\u000f\u00111A\u0001\u000bKZLG-\u001a8dK\u0012\"\u0004#BA\u0003\u0003\u0017\tVBAA\u0004\u0015\r\tI\u0001P\u0001\be\u00164G.Z2u\u0013\u0011\ti!a\u0002\u0003\u0011\rc\u0017m]:UC\u001eD\u0011\"!\u0005\b\u0003\u0003\u0005\u001d!a\u0005\u0002\u0015\u00154\u0018\u000eZ3oG\u0016$S\u0007E\u0002l]rC\u0011\"a\u0006\b\u0003\u0003\u0005\u001d!!\u0007\u0002\u0015\u00154\u0018\u000eZ3oG\u0016$c\u0007E\u0003\u0002\u0006\u0005-A\fC\u0005\u0002\u001e\u001d\t\t\u0011q\u0001\u0002 \u0005QQM^5eK:\u001cW\rJ\u001c\u0011\u0007alX\rC\u0005\u0002$\u001d\t\t\u0011q\u0001\u0002&\u0005QQM^5eK:\u001cW\r\n\u001d\u0011\u000f\u0005\u001d\u0012QF3\u000225\u0011\u0011\u0011\u0006\u0006\u0004\u0003W!\u0012\u0001B;uS2LA!a\f\u0002*\tI1i\\7q_:,g\u000e\u001e\t\u0005A\u0006M\u0012+C\u0002\u00026\u0005\u0014aAQ8v]\u0012\u001c\bBBA\u001d\u000f\u0001\u0007A$\u0001\u0002jI\"9\u0011QH\u0004A\u0002\u0005}\u0012!\u0003;jY\u0016\fV/\u001a:z!\u0015i\u0012\u0011I)f\u0013\r\t\u0019E\b\u0002\u000b\u0019\u0006LXM])vKJL\bBBA$\u000f\u0001\u0007!(A\u0007ok6\u0004\u0016M\u001d;ji&|gn\u001d\u0005\b\u0003\u0017:\u0001\u0019AA'\u0003=Ig\u000eZ3y\r&dG/\u001a:P]2L\bcA\u001e\u0002P%\u0019\u0011\u0011\u000b\u001f\u0003\u000f\t{w\u000e\\3b]\u0006\t\u0002*\u00193p_Bd\u0015-_3s%\u0016\fG-\u001a:\u0011\u0005UJ1cA\u0005\u0002ZA\u00191(a\u0017\n\u0007\u0005uCH\u0001\u0004B]f\u0014VM\u001a\u000b\u0003\u0003+\nQ!\u00199qYf$B!!\u001a\u0002jQ\u0019A'a\u001a\t\u000b\u001dZ\u00019\u0001\u0015\t\r\u0005Z\u0001\u0019AA6!\u0011\ti'!\u001d\u000e\u0005\u0005=$BA\b\u001f\u0013\u0011\t\u0019(a\u001c\u0003)!\u000bGm\\8q\u0003R$(/\u001b2vi\u0016\u001cFo\u001c:f)\u0011\t9(a\u001f\u0015\u0007Q\nI\bC\u0003(\u0019\u0001\u000f\u0001\u0006C\u0004\u0002~1\u0001\r!a \u0002\u0011I|w\u000e\u001e)bi\"\u0004B!!!\u0002\n6\u0011\u00111\u0011\u0006\u0005\u0003\u000b\u000b9)\u0001\u0002gg*\u0011qbK\u0005\u0005\u0003\u0017\u000b\u0019I\u0001\u0003QCRD\u0007")
public class HadoopLayerReader
extends FilteringLayerReader<LayerId> {
    private final AttributeStore attributeStore;
    private final SparkContext sc;
    private final int defaultNumPartitions;

    public static HadoopLayerReader apply(Path path, SparkContext sparkContext) {
        return HadoopLayerReader$.MODULE$.apply(path, sparkContext);
    }

    public static HadoopLayerReader apply(HadoopAttributeStore hadoopAttributeStore, SparkContext sparkContext) {
        return HadoopLayerReader$.MODULE$.apply(hadoopAttributeStore, sparkContext);
    }

    @Override
    public AttributeStore attributeStore() {
        return this.attributeStore;
    }

    @Override
    public int defaultNumPartitions() {
        return this.defaultNumPartitions;
    }

    @Override
    public <K, V, M> RDD<Tuple2<K, V>> read(LayerId id, LayerQuery<K, M> tileQuery, int numPartitions, boolean indexFilterOnly, AvroRecordCodec<K> evidence$1, Boundable<K> evidence$2, Decoder<K> evidence$3, ClassTag<K> evidence$4, AvroRecordCodec<V> evidence$5, ClassTag<V> evidence$6, Decoder<M> evidence$7, Component<M, Bounds<K>> evidence$8) {
        RDD<Tuple2<K, V>> rDD;
        if (!this.attributeStore().layerExists(id)) {
            throw new package.LayerNotFoundError(id);
        }
        LayerAttributes layerAttributes = this.liftedTree1$1(id, evidence$7, evidence$4);
        if (layerAttributes == null) {
            throw new MatchError((Object)layerAttributes);
        }
        HadoopLayerHeader header = (HadoopLayerHeader)layerAttributes.header();
        Object metadata = layerAttributes.metadata();
        KeyIndex keyIndex = layerAttributes.keyIndex();
        Schema writerSchema = layerAttributes.schema();
        Tuple4 tuple4 = new Tuple4((Object)header, metadata, (Object)keyIndex, (Object)writerSchema);
        Tuple4 tuple42 = tuple4;
        HadoopLayerHeader header2 = (HadoopLayerHeader)tuple42._1();
        Object metadata2 = tuple42._2();
        KeyIndex keyIndex2 = (KeyIndex)tuple42._3();
        Schema writerSchema2 = (Schema)tuple42._4();
        Path layerPath = new Path(header2.path());
        KeyBounds keyBounds = ((Bounds)package$.MODULE$.withGetComponentMethods(metadata2).getComponent(evidence$8)).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
            throw new package.LayerEmptyBoundsError(id);
        });
        Seq queryKeyBounds = tileQuery.apply(metadata2);
        Object layerMetadata = package$.MODULE$.withSetComponentMethods(metadata2).setComponent(queryKeyBounds.foldLeft((Object)EmptyBounds$.MODULE$, (Function2 & Serializable & scala.Serializable)(x$2, x$3) -> x$2.combine((Bounds)x$3, evidence$2)), evidence$8);
        Seq seq = queryKeyBounds;
        GenTraversable genTraversable = Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KeyBounds[]{keyBounds}));
        if (!(seq != null ? !seq.equals(genTraversable) : genTraversable != null)) {
            rDD = HadoopRDDReader$.MODULE$.readFully(layerPath, (Option<Schema>)new Some((Object)writerSchema2), evidence$1, evidence$2, evidence$5, this.sc);
        } else {
            Function1 & Serializable & scala.Serializable decompose = (Function1 & Serializable & scala.Serializable)bounds -> keyIndex2.indexRanges(KeyBounds$.MODULE$.keyBoundsToTuple(bounds));
            rDD = HadoopRDDReader$.MODULE$.readFiltered(layerPath, queryKeyBounds, decompose, indexFilterOnly, (Option<Schema>)new Some((Object)writerSchema2), evidence$1, evidence$2, evidence$5, this.sc);
        }
        RDD<Tuple2<K, V>> rdd = rDD;
        return new ContextRDD<K, V, Object>(rdd, layerMetadata);
    }

    private final LayerAttributes liftedTree1$1(LayerId id$1, Decoder evidence$7$1, ClassTag evidence$4$1) {
        LayerAttributes layerAttributes;
        try {
            layerAttributes = this.attributeStore().readLayerAttributes(id$1, HadoopLayerHeader$.MODULE$.fileLayerHeaderDecoder(), evidence$7$1, evidence$4$1);
        }
        catch (package.AttributeNotFoundError e) {
            throw new package.LayerReadError(id$1).initCause((Throwable)e);
        }
        return layerAttributes;
    }

    public HadoopLayerReader(AttributeStore attributeStore, SparkContext sc) {
        this.attributeStore = attributeStore;
        this.sc = sc;
        this.defaultNumPartitions = sc.defaultParallelism();
    }
}

