/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.spark.store.hadoop.formats;

import geotrellis.layer.TemporalProjectedExtent;
import geotrellis.layer.TemporalProjectedExtent$;
import geotrellis.proj4.CRS;
import geotrellis.raster.ProjectedRaster;
import geotrellis.raster.Raster;
import geotrellis.raster.Tile;
import geotrellis.raster.io.geotiff.SinglebandGeoTiff;
import geotrellis.raster.io.geotiff.SinglebandGeoTiff$;
import geotrellis.spark.store.hadoop.formats.GeoTiffInputFormat$;
import geotrellis.spark.store.hadoop.formats.TemporalGeoTiffInputFormat$;
import geotrellis.store.hadoop.formats.BinaryFileInputFormat;
import geotrellis.vector.Extent;
import java.io.Serializable;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import scala.Function0;
import scala.MatchError;
import scala.Option;
import scala.Tuple2;
import scala.Tuple3;
import scala.reflect.ScalaSignature;
import scala.sys.package$;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015u!\u0002\u000b\u0016\u0011\u0003\u0001c!\u0002\u0012\u0016\u0011\u0003\u0019\u0003\"\u0002\u0016\u0002\t\u0003Y\u0003b\u0002\u0017\u0002\u0005\u0004%)!\f\u0005\u0007a\u0005\u0001\u000bQ\u0002\u0018\t\u000fE\n!\u0019!C\u0003e!1a'\u0001Q\u0001\u000eMBqaN\u0001C\u0002\u0013\u0015\u0001\b\u0003\u0004<\u0003\u0001\u0006i!\u000f\u0005\by\u0005\u0011\r\u0011\"\u0002>\u0011\u0019\t\u0015\u0001)A\u0007}!)!)\u0001C\u0001\u0007\")!)\u0001C\u0001C\")!.\u0001C\u0001W\")!.\u0001C\u0001_\")!/\u0001C\u0001g\")A0\u0001C\u0001{\u001a)!%\u0006\u0001\u0002$!1!&\u0005C\u0001\u00037Bq!a\u0018\u0012\t\u0003\t\t'\u0001\u000eUK6\u0004xN]1m\u000f\u0016|G+\u001b4g\u0013:\u0004X\u000f\u001e$pe6\fGO\u0003\u0002\u0017/\u00059am\u001c:nCR\u001c(B\u0001\r\u001a\u0003\u0019A\u0017\rZ8pa*\u0011!dG\u0001\u0006gR|'/\u001a\u0006\u00039u\tQa\u001d9be.T\u0011AH\u0001\u000bO\u0016|GO]3mY&\u001c8\u0001\u0001\t\u0003C\u0005i\u0011!\u0006\u0002\u001b)\u0016l\u0007o\u001c:bY\u001e+w\u000eV5gM&s\u0007/\u001e;G_Jl\u0017\r^\n\u0003\u0003\u0011\u0002\"!\n\u0015\u000e\u0003\u0019R\u0011aJ\u0001\u0006g\u000e\fG.Y\u0005\u0003S\u0019\u0012a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001!\u0003A9Ui\u0014+J\r\u001a{F+S'F?R\u000bu)F\u0001/\u001f\u0005y\u0013%\u0001\u0017\u0002#\u001d+u\nV%G\r~#\u0016*T#`)\u0006;\u0005%\u0001\rH\u000b>#\u0016J\u0012$`)&kUi\u0018+B\u000f~#UIR!V\u0019R+\u0012aM\b\u0002i\u0005\nQ'\u0001\tU\u0013\u001a3E+Q$`\t\u0006#V\tV%N\u000b\u0006Ir)R(U\u0013\u001a3u\fV%N\u000b~#\u0016iR0E\u000b\u001a\u000bU\u000b\u0014+!\u0003M9Ui\u0014+J\r\u001a{F+S'F?\u001a{%+T!U+\u0005It\"\u0001\u001e\"\u0003]\nAcR#P)&3ei\u0018+J\u001b\u0016{fi\u0014*N\u0003R\u0003\u0013aG$F\u001fRKeIR0U\u00136+uLR(S\u001b\u0006#v\fR#G\u0003VcE+F\u0001?\u001f\u0005y\u0014%\u0001!\u0002'eL\u00180\u001f\u001eN\u001bj\"G\r\t%Iu5l'h]:\u00029\u001d+u\nV%G\r~#\u0016*T#`\r>\u0013V*\u0011+`\t\u00163\u0015)\u0016'UA\u0005Q1/\u001a;US6,G+Y4\u0015\u0007\u0011;E\u000b\u0005\u0002&\u000b&\u0011aI\n\u0002\u0005+:LG\u000fC\u0003I\u0017\u0001\u0007\u0011*A\u0002k_\n\u0004\"A\u0013*\u000e\u0003-S!\u0001T'\u0002\u00135\f\u0007O]3ek\u000e,'B\u0001\rO\u0015\ty\u0005+\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002#\u0006\u0019qN]4\n\u0005M[%A\u0003&pE\u000e{g\u000e^3yi\")Qk\u0003a\u0001-\u00069A/[7f)\u0006<\u0007CA,_\u001d\tAF\f\u0005\u0002ZM5\t!L\u0003\u0002\\?\u00051AH]8pizJ!!\u0018\u0014\u0002\rA\u0013X\rZ3g\u0013\ty\u0006M\u0001\u0004TiJLgn\u001a\u0006\u0003;\u001a\"2\u0001\u00122j\u0011\u0015\u0019G\u00021\u0001e\u0003\u0011\u0019wN\u001c4\u0011\u0005\u0015<W\"\u00014\u000b\u0005\rl\u0015B\u00015g\u00055\u0019uN\u001c4jOV\u0014\u0018\r^5p]\")Q\u000b\u0004a\u0001-\u0006i1/\u001a;US6,gi\u001c:nCR$2\u0001\u00127n\u0011\u0015AU\u00021\u0001J\u0011\u0015qW\u00021\u0001W\u0003)!\u0018.\\3G_Jl\u0017\r\u001e\u000b\u0004\tB\f\b\"B2\u000f\u0001\u0004!\u0007\"\u00028\u000f\u0001\u00041\u0016AC4fiRKW.\u001a+bOR\u0011Ao\u001f\t\u0003kjl\u0011A\u001e\u0006\u0003ob\fA\u0001\\1oO*\t\u00110\u0001\u0003kCZ\f\u0017BA0w\u0011\u0015Au\u00021\u0001J\u0003A9W\r\u001e+j[\u00164uN]7biR,'\u000fF\u0002\u007f\u0003\u001b\u00012a`A\u0005\u001b\t\t\tA\u0003\u0003\u0002\u0004\u0005\u0015\u0011A\u00024pe6\fGOC\u0002\u0002\ba\fA\u0001^5nK&!\u00111BA\u0001\u0005E!\u0015\r^3US6,gi\u001c:nCR$XM\u001d\u0005\u0006\u0011B\u0001\r!\u0013\u0015\b\u0003\u0005E\u0011qCA\u000e!\r)\u00131C\u0005\u0004\u0003+1#A\u00033faJ,7-\u0019;fI\u0006\u0012\u0011\u0011D\u0001G)\u0016l\u0007o\u001c:bY\u001e+w\u000eV5gM&s\u0007/\u001e;G_Jl\u0017\r\u001e\u0011jg\u0002\"W\r\u001d:fG\u0006$X\r\u001a\u0017!kN,\u0007\u0005S1e_>\u0004x)Z8US\u001a4'\u000b\u0012#!S:\u001cH/Z1eC\t\ti\"A\u00032]Ar\u0003\u0007K\u0004\u0002\u0003#\t9\"a\u0007)\u000f\u0001\t\t\"a\u0006\u0002\u001cM)\u0011#!\n\u0002NAA\u0011qEA\u0019\u0003k\t\t%\u0004\u0002\u0002*)!\u00111FA\u0017\u0003\u0015Ig\u000e];u\u0015\r\tycS\u0001\u0004Y&\u0014\u0017\u0002BA\u001a\u0003S\u0011qBR5mK&s\u0007/\u001e;G_Jl\u0017\r\u001e\t\u0005\u0003o\ti$\u0004\u0002\u0002:)\u0019\u00111H\u000f\u0002\u000b1\f\u00170\u001a:\n\t\u0005}\u0012\u0011\b\u0002\u0018)\u0016l\u0007o\u001c:bYB\u0013xN[3di\u0016$W\t\u001f;f]R\u0004B!a\u0011\u0002J5\u0011\u0011Q\t\u0006\u0004\u0003\u000fj\u0012A\u0002:bgR,'/\u0003\u0003\u0002L\u0005\u0015#\u0001\u0002+jY\u0016\u0004\u0002\"a\u0014\u0002X\u0005U\u0012\u0011I\u0007\u0003\u0003#R1AFA*\u0015\rA\u0012Q\u000b\u0006\u00035uIA!!\u0017\u0002R\t)\")\u001b8bef4\u0015\u000e\\3J]B,HOR8s[\u0006$HCAA/!\t\t\u0013#\u0001\u0003sK\u0006$GCBA2\u0003S\nI\bE\u0004&\u0003K\n)$!\u0011\n\u0007\u0005\u001ddE\u0001\u0004UkBdWM\r\u0005\b\u0003W\u001a\u0002\u0019AA7\u0003\u0015\u0011\u0017\u0010^3t!\u0015)\u0013qNA:\u0013\r\t\tH\n\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0004K\u0005U\u0014bAA<M\t!!)\u001f;f\u0011\u001d\tYh\u0005a\u0001\u0003{\nqaY8oi\u0016DH\u000fE\u0002K\u0003\u007fJ1!!!L\u0005I!\u0016m]6BiR,W\u000e\u001d;D_:$X\r\u001f;)\u000fE\t\t\"a\u0006\u0002\u001c\u0001")
public class TemporalGeoTiffInputFormat
extends FileInputFormat<TemporalProjectedExtent, Tile>
implements BinaryFileInputFormat<TemporalProjectedExtent, Tile> {
    public static DateTimeFormatter getTimeFormatter(JobContext jobContext) {
        return TemporalGeoTiffInputFormat$.MODULE$.getTimeFormatter(jobContext);
    }

    public static String getTimeTag(JobContext jobContext) {
        return TemporalGeoTiffInputFormat$.MODULE$.getTimeTag(jobContext);
    }

    public static void setTimeFormat(Configuration configuration, String string) {
        TemporalGeoTiffInputFormat$.MODULE$.setTimeFormat(configuration, string);
    }

    public static void setTimeFormat(JobContext jobContext, String string) {
        TemporalGeoTiffInputFormat$.MODULE$.setTimeFormat(jobContext, string);
    }

    public static void setTimeTag(Configuration configuration, String string) {
        TemporalGeoTiffInputFormat$.MODULE$.setTimeTag(configuration, string);
    }

    public static void setTimeTag(JobContext jobContext, String string) {
        TemporalGeoTiffInputFormat$.MODULE$.setTimeTag(jobContext, string);
    }

    public static String GEOTIFF_TIME_FORMAT_DEFAULT() {
        return TemporalGeoTiffInputFormat$.MODULE$.GEOTIFF_TIME_FORMAT_DEFAULT();
    }

    public static String GEOTIFF_TIME_FORMAT() {
        return TemporalGeoTiffInputFormat$.MODULE$.GEOTIFF_TIME_FORMAT();
    }

    public static String GEOTIFF_TIME_TAG_DEFAULT() {
        return TemporalGeoTiffInputFormat$.MODULE$.GEOTIFF_TIME_TAG_DEFAULT();
    }

    public static String GEOTIFF_TIME_TAG() {
        return TemporalGeoTiffInputFormat$.MODULE$.GEOTIFF_TIME_TAG();
    }

    public boolean isSplitable(JobContext context, Path fileName) {
        return BinaryFileInputFormat.isSplitable$((BinaryFileInputFormat)this, (JobContext)context, (Path)fileName);
    }

    public RecordReader<TemporalProjectedExtent, Tile> createRecordReader(InputSplit split, TaskAttemptContext context) {
        return BinaryFileInputFormat.createRecordReader$((BinaryFileInputFormat)this, (InputSplit)split, (TaskAttemptContext)context);
    }

    public Tuple2<TemporalProjectedExtent, Tile> read(byte[] bytes, TaskAttemptContext context) {
        CRS crs;
        Raster raster;
        ZonedDateTime dateTime;
        Option<CRS> inputCrs;
        block3: {
            ProjectedRaster projectedRaster;
            block2: {
                SinglebandGeoTiff geoTiff = SinglebandGeoTiff$.MODULE$.apply(bytes);
                String timeTag = TemporalGeoTiffInputFormat$.MODULE$.getTimeTag((JobContext)context);
                DateTimeFormatter dateFormatter = TemporalGeoTiffInputFormat$.MODULE$.getTimeFormatter((JobContext)context);
                inputCrs = GeoTiffInputFormat$.MODULE$.getCrs((JobContext)context);
                String dateTimeString = (String)geoTiff.tags().headTags().getOrElse((Object)timeTag, (Function0 & Serializable & scala.Serializable)() -> package$.MODULE$.error(new StringBuilder(38).append("There is no tag ").append(timeTag).append(" in the GeoTiff header").toString()));
                dateTime = ZonedDateTime.from(dateFormatter.parse(dateTimeString));
                projectedRaster = geoTiff.projectedRaster();
                if (projectedRaster == null) break block2;
                raster = projectedRaster.raster();
                crs = projectedRaster.crs();
                if (raster != null) break block3;
            }
            throw new MatchError((Object)projectedRaster);
        }
        Tile tile = (Tile)raster.tile();
        Extent extent = raster.extent();
        Tuple3 tuple3 = new Tuple3((Object)tile, (Object)extent, (Object)crs);
        Tuple3 tuple32 = tuple3;
        Tile tile2 = (Tile)tuple32._1();
        Extent extent2 = (Extent)tuple32._2();
        CRS crs2 = (CRS)tuple32._3();
        return new Tuple2((Object)TemporalProjectedExtent$.MODULE$.apply(extent2, (CRS)inputCrs.getOrElse((Function0 & Serializable & scala.Serializable)() -> crs2), dateTime), (Object)tile2);
    }

    public TemporalGeoTiffInputFormat() {
        BinaryFileInputFormat.$init$((BinaryFileInputFormat)this);
    }
}

