/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.spark.store.hadoop.formats;

import geotrellis.layer.TemporalProjectedExtent;
import geotrellis.layer.TemporalProjectedExtent$;
import geotrellis.proj4.CRS;
import geotrellis.raster.MultibandTile;
import geotrellis.raster.ProjectedRaster;
import geotrellis.raster.Raster;
import geotrellis.raster.io.geotiff.MultibandGeoTiff;
import geotrellis.raster.io.geotiff.MultibandGeoTiff$;
import geotrellis.spark.store.hadoop.formats.GeoTiffInputFormat$;
import geotrellis.spark.store.hadoop.formats.TemporalGeoTiffInputFormat$;
import geotrellis.store.hadoop.formats.BinaryFileInputFormat;
import geotrellis.vector.Extent;
import java.io.Serializable;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import scala.Function0;
import scala.MatchError;
import scala.Option;
import scala.Tuple2;
import scala.Tuple3;
import scala.reflect.ScalaSignature;
import scala.sys.package$;

@ScalaSignature(bytes="\u0006\u0001Q3Aa\u0001\u0003\u0001\u001f!)!\u0007\u0001C\u0001g!)a\u0007\u0001C\u0001o\t\u0019C+Z7q_J\fG.T;mi&\u0014\u0017M\u001c3HK>$\u0016N\u001a4J]B,HOR8s[\u0006$(BA\u0003\u0007\u0003\u001d1wN]7biNT!a\u0002\u0005\u0002\r!\fGm\\8q\u0015\tI!\"A\u0003ti>\u0014XM\u0003\u0002\f\u0019\u0005)1\u000f]1sW*\tQ\"\u0001\u0006hK>$(/\u001a7mSN\u001c\u0001aE\u0002\u0001!-\u0002B!E\u000f K5\t!C\u0003\u0002\u0014)\u0005)\u0011N\u001c9vi*\u0011QCF\u0001\u0004Y&\u0014'BA\f\u0019\u0003%i\u0017\r\u001d:fIV\u001cWM\u0003\u0002\b3)\u0011!dG\u0001\u0007CB\f7\r[3\u000b\u0003q\t1a\u001c:h\u0013\tq\"CA\bGS2,\u0017J\u001c9vi\u001a{'/\\1u!\t\u00013%D\u0001\"\u0015\t\u0011C\"A\u0003mCf,'/\u0003\u0002%C\t9B+Z7q_J\fG\u000e\u0015:pU\u0016\u001cG/\u001a3FqR,g\u000e\u001e\t\u0003M%j\u0011a\n\u0006\u0003Q1\taA]1ti\u0016\u0014\u0018B\u0001\u0016(\u00055iU\u000f\u001c;jE\u0006tG\rV5mKB!A\u0006M\u0010&\u001b\u0005i#BA\u0003/\u0015\t9qF\u0003\u0002\n\u0019%\u0011\u0011'\f\u0002\u0016\u0005&t\u0017M]=GS2,\u0017J\u001c9vi\u001a{'/\\1u\u0003\u0019a\u0014N\\5u}Q\tA\u0007\u0005\u00026\u00015\tA!\u0001\u0003sK\u0006$Gc\u0001\u001d?\rB!\u0011\bP\u0010&\u001b\u0005Q$\"A\u001e\u0002\u000bM\u001c\u0017\r\\1\n\u0005uR$A\u0002+va2,'\u0007C\u0003@\u0005\u0001\u0007\u0001)A\u0003csR,7\u000fE\u0002:\u0003\u000eK!A\u0011\u001e\u0003\u000b\u0005\u0013(/Y=\u0011\u0005e\"\u0015BA#;\u0005\u0011\u0011\u0015\u0010^3\t\u000b\u001d\u0013\u0001\u0019\u0001%\u0002\u000f\r|g\u000e^3yiB\u0011\u0011JS\u0007\u0002-%\u00111J\u0006\u0002\u0013)\u0006\u001c8.\u0011;uK6\u0004HoQ8oi\u0016DH\u000f\u000b\u0003\u0001\u001bB\u0013\u0006CA\u001dO\u0013\ty%H\u0001\u0006eKB\u0014XmY1uK\u0012\f\u0013!U\u0001P)\u0016l\u0007o\u001c:bY6+H\u000e^5cC:$w)Z8US\u001a4\u0017J\u001c9vi\u001a{'/\\1uA%\u001c\b\u0005Z3qe\u0016\u001c\u0017\r^3eY\u0001*8/\u001a\u0011IC\u0012|w\u000e]$f_RKgM\u001a*E\t\u0002Jgn\u001d;fC\u0012\f\u0013aU\u0001\u0006c9\u0002d\u0006\r")
public class TemporalMultibandGeoTiffInputFormat
extends FileInputFormat<TemporalProjectedExtent, MultibandTile>
implements BinaryFileInputFormat<TemporalProjectedExtent, MultibandTile> {
    public boolean isSplitable(JobContext context, Path fileName) {
        return BinaryFileInputFormat.isSplitable$((BinaryFileInputFormat)this, (JobContext)context, (Path)fileName);
    }

    public RecordReader<TemporalProjectedExtent, MultibandTile> createRecordReader(InputSplit split, TaskAttemptContext context) {
        return BinaryFileInputFormat.createRecordReader$((BinaryFileInputFormat)this, (InputSplit)split, (TaskAttemptContext)context);
    }

    public Tuple2<TemporalProjectedExtent, MultibandTile> read(byte[] bytes, TaskAttemptContext context) {
        CRS crs;
        Raster raster;
        ZonedDateTime dateTime;
        Option<CRS> inputCrs;
        block3: {
            ProjectedRaster projectedRaster;
            block2: {
                MultibandGeoTiff geoTiff = MultibandGeoTiff$.MODULE$.apply(bytes);
                String timeTag = TemporalGeoTiffInputFormat$.MODULE$.getTimeTag((JobContext)context);
                DateTimeFormatter dateFormatter = TemporalGeoTiffInputFormat$.MODULE$.getTimeFormatter((JobContext)context);
                inputCrs = GeoTiffInputFormat$.MODULE$.getCrs((JobContext)context);
                String dateTimeString = (String)geoTiff.tags().headTags().getOrElse((Object)timeTag, (Function0 & Serializable & scala.Serializable)() -> package$.MODULE$.error(new StringBuilder(38).append("There is no tag ").append(timeTag).append(" in the GeoTiff header").toString()));
                dateTime = ZonedDateTime.from(dateFormatter.parse(dateTimeString));
                projectedRaster = geoTiff.projectedRaster();
                if (projectedRaster == null) break block2;
                raster = projectedRaster.raster();
                crs = projectedRaster.crs();
                if (raster != null) break block3;
            }
            throw new MatchError((Object)projectedRaster);
        }
        MultibandTile tile = (MultibandTile)raster.tile();
        Extent extent = raster.extent();
        Tuple3 tuple3 = new Tuple3((Object)tile, (Object)extent, (Object)crs);
        Tuple3 tuple32 = tuple3;
        MultibandTile tile2 = (MultibandTile)tuple32._1();
        Extent extent2 = (Extent)tuple32._2();
        CRS crs2 = (CRS)tuple32._3();
        return new Tuple2((Object)TemporalProjectedExtent$.MODULE$.apply(extent2, (CRS)inputCrs.getOrElse((Function0 & Serializable & scala.Serializable)() -> crs2), dateTime), (Object)tile2);
    }

    public TemporalMultibandGeoTiffInputFormat() {
        BinaryFileInputFormat.$init$((BinaryFileInputFormat)this);
    }
}

