/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.spark.store.http.util;

import geotrellis.spark.store.http.util.HttpRangeReader$;
import geotrellis.util.RangeReader;
import java.io.Serializable;
import java.net.URI;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Try$;
import scalaj.http.Http$;
import scalaj.http.HttpRequest;
import scalaj.http.HttpResponse;

@ScalaSignature(bytes="\u0006\u0001\u0005ma\u0001B\n\u0015\u0001}A\u0001b\u000b\u0001\u0003\u0002\u0003\u0006I\u0001\f\u0005\ti\u0001\u0011\t\u0011)A\u0005k!)\u0001\b\u0001C\u0001s!9a\b\u0001b\u0001\n\u0003y\u0004BB$\u0001A\u0003%\u0001\tC\u0004I\u0001\t\u0007I\u0011A%\t\r5\u0003\u0001\u0015!\u0003K\u0011\u0015q\u0005\u0001\"\u0001P\u0011!i\u0006\u0001#b!\n\u0013qv!B6\u0015\u0011\u0003ag!B\n\u0015\u0011\u0003i\u0007\"\u0002\u001d\f\t\u0003q\u0007\"B8\f\t\u0003\u0001\b\"B8\f\t\u0003q\bBB8\f\t\u0003\tI\u0001C\u0004\u0002\u000e-!\t!a\u0004\t\u000f\u000551\u0002\"\u0001\u0002\u0014!9\u0011QB\u0006\u0005\u0002\u0005]!a\u0004%uiB\u0014\u0016M\\4f%\u0016\fG-\u001a:\u000b\u0005U1\u0012\u0001B;uS2T!a\u0006\r\u0002\t!$H\u000f\u001d\u0006\u00033i\tQa\u001d;pe\u0016T!a\u0007\u000f\u0002\u000bM\u0004\u0018M]6\u000b\u0003u\t!bZ3piJ,G\u000e\\5t\u0007\u0001\u00192\u0001\u0001\u0011'!\t\tC%D\u0001#\u0015\u0005\u0019\u0013!B:dC2\f\u0017BA\u0013#\u0005\u0019\te.\u001f*fMB\u0011q%K\u0007\u0002Q)\u0011Q\u0003H\u0005\u0003U!\u00121BU1oO\u0016\u0014V-\u00193fe\u0006\u0019QO\u001d7\u0011\u00055\u0012T\"\u0001\u0018\u000b\u0005=\u0002\u0014a\u00018fi*\t\u0011'\u0001\u0003kCZ\f\u0017BA\u001a/\u0005\r)&\u000bT\u0001\u000fkN,\u0007*Z1e%\u0016\fX/Z:u!\t\tc'\u0003\u00028E\t9!i\\8mK\u0006t\u0017A\u0002\u001fj]&$h\bF\u0002;yu\u0002\"a\u000f\u0001\u000e\u0003QAQaK\u0002A\u00021BQ\u0001N\u0002A\u0002U\nqA]3rk\u0016\u001cH/F\u0001A!\t\tU)D\u0001C\u0015\t92IC\u0001E\u0003\u0019\u00198-\u00197bU&\u0011aI\u0011\u0002\f\u0011R$\bOU3rk\u0016\u001cH/\u0001\u0005sKF,Xm\u001d;!\u0003-!x\u000e^1m\u0019\u0016tw\r\u001e5\u0016\u0003)\u0003\"!I&\n\u00051\u0013#\u0001\u0002'p]\u001e\fA\u0002^8uC2dUM\\4uQ\u0002\n\u0001C]3bI\u000ec\u0017\u000e\u001d9fIJ\u000bgnZ3\u0015\u0007A3\u0006\fE\u0002\"#NK!A\u0015\u0012\u0003\u000b\u0005\u0013(/Y=\u0011\u0005\u0005\"\u0016BA+#\u0005\u0011\u0011\u0015\u0010^3\t\u000b]C\u0001\u0019\u0001&\u0002\u000bM$\u0018M\u001d;\t\u000beC\u0001\u0019\u0001.\u0002\r1,gn\u001a;i!\t\t3,\u0003\u0002]E\t\u0019\u0011J\u001c;\u0002\r1|wmZ3s+\u0005y\u0006C\u00011f\u001b\u0005\t'B\u00012d\u0003\u0015awn\u001a\u001bt\u0015\u0005!\u0017aA8sO&\u0011a-\u0019\u0002\u0007\u0019><w-\u001a:)\u0005%A\u0007CA\u0011j\u0013\tQ'EA\u0005ue\u0006t7/[3oi\u0006y\u0001\n\u001e;q%\u0006tw-\u001a*fC\u0012,'\u000f\u0005\u0002<\u0017M\u00111\u0002\t\u000b\u0002Y\u0006)\u0011\r\u001d9msR\u0011!(\u001d\u0005\u0006e6\u0001\ra]\u0001\bC\u0012$'/Z:t!\t!8P\u0004\u0002vsB\u0011aOI\u0007\u0002o*\u0011\u0001PH\u0001\u0007yI|w\u000e\u001e \n\u0005i\u0014\u0013A\u0002)sK\u0012,g-\u0003\u0002}{\n11\u000b\u001e:j]\u001eT!A\u001f\u0012\u0015\u0005iz\bbBA\u0001\u001d\u0001\u0007\u00111A\u0001\u0004kJL\u0007cA\u0017\u0002\u0006%\u0019\u0011q\u0001\u0018\u0003\u0007U\u0013\u0016\nF\u0002;\u0003\u0017AQaK\bA\u00021\n!c^5uQ>,H\u000fS3bIJ+\u0017/^3tiR\u0019!(!\u0005\t\u000b-\u0002\u0002\u0019\u0001\u0017\u0015\u0007i\n)\u0002C\u0003s#\u0001\u00071\u000fF\u0002;\u00033Aq!!\u0001\u0013\u0001\u0004\t\u0019\u0001")
public class HttpRangeReader
implements RangeReader {
    private transient Logger logger;
    private final HttpRequest request;
    private final long totalLength;
    private volatile transient boolean bitmap$trans$0;

    public static HttpRangeReader withoutHeadRequest(URI uRI) {
        return HttpRangeReader$.MODULE$.withoutHeadRequest(uRI);
    }

    public static HttpRangeReader withoutHeadRequest(String string) {
        return HttpRangeReader$.MODULE$.withoutHeadRequest(string);
    }

    public static HttpRangeReader withoutHeadRequest(URL uRL) {
        return HttpRangeReader$.MODULE$.withoutHeadRequest(uRL);
    }

    public static HttpRangeReader apply(URL uRL) {
        return HttpRangeReader$.MODULE$.apply(uRL);
    }

    public static HttpRangeReader apply(URI uRI) {
        return HttpRangeReader$.MODULE$.apply(uRI);
    }

    public static HttpRangeReader apply(String string) {
        return HttpRangeReader$.MODULE$.apply(string);
    }

    public byte[] readRange(long start, int length) {
        return RangeReader.readRange$((RangeReader)this, (long)start, (int)length);
    }

    public byte[] readAll() {
        return RangeReader.readAll$((RangeReader)this);
    }

    private Logger logger$lzycompute() {
        HttpRangeReader httpRangeReader = this;
        synchronized (httpRangeReader) {
            if (!this.bitmap$trans$0) {
                this.logger = LoggerFactory.getLogger(HttpRangeReader.class);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    private Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    public HttpRequest request() {
        return this.request;
    }

    public long totalLength() {
        return this.totalLength;
    }

    public byte[] readClippedRange(long start, int length) {
        HttpResponse res;
        block0: {
            res = this.request().method("GET").header("Range", new StringBuilder(7).append("bytes=").append(start).append("-").append(start + (long)length).toString()).asBytes();
            Predef$.MODULE$.require(res.code() != 416, (Function0 & Serializable & scala.Serializable)() -> "Server unable to generate the byte range between ${start} and ${start + length}");
            if (res.code() == 206) break block0;
            this.logger().info("Server responded to range request with HTTP code other than PARTIAL_RESPONSE (206)");
        }
        return (byte[])res.body();
    }

    public HttpRangeReader(URL url, boolean useHeadRequest) {
        long l;
        RangeReader.$init$((RangeReader)this);
        this.request = Http$.MODULE$.apply(url.toString());
        HttpResponse headers = useHeadRequest ? this.request().method("HEAD").asString() : this.request().method("GET").execute((Function1 & Serializable & scala.Serializable)is -> "");
        Option option = headers.header("Content-Length").flatMap((Function1 & Serializable & scala.Serializable)cl -> Try$.MODULE$.apply((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(cl)).toLong()).toOption());
        if (option instanceof Some) {
            long num;
            Some some = (Some)option;
            l = num = BoxesRunTime.unboxToLong((Object)some.value());
        } else if (None$.MODULE$.equals(option)) {
            l = -1L;
        } else {
            throw new MatchError((Object)option);
        }
        long contentLength = l;
        headers.throwError();
        Option option2 = headers.header("Accept-Ranges");
        Some some = new Some((Object)"bytes");
        Predef$.MODULE$.require(!(option2 != null ? !option2.equals(some) : some != null), (Function0 & Serializable & scala.Serializable)() -> "Server doesn't support ranged byte reads");
        Predef$.MODULE$.require(contentLength > 0L, (Function0 & Serializable & scala.Serializable)() -> "Server didn't provide (required) \"Content-Length\" headers, unable to do range-based read");
        this.totalLength = contentLength;
    }
}

