/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.spark.store.slippy;

import geotrellis.layer.SpatialKey;
import geotrellis.layer.SpatialKey$;
import geotrellis.spark.store.slippy.SlippyTileReader;
import geotrellis.spark.store.slippy.SlippyTileReader$;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import org.apache.commons.io.IOUtils;
import org.apache.spark.HashPartitioner;
import org.apache.spark.Partitioner;
import org.apache.spark.SparkContext;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\u0005%a\u0001B\u0005\u000b\u0001MA\u0001B\u000b\u0001\u0003\u0002\u0003\u0006Ia\u000b\u0005\tm\u0001\u0011\t\u0011)A\u0005o!)a\t\u0001C\u0001\u000f\")A\n\u0001C\u0001\u001b\")q\u000b\u0001C\u00011\")1\r\u0001C\u0005I\")q\r\u0001C\u0001Q\")q\r\u0001C\u0001[\n!\u0002\n\u001e;q'2L\u0007\u000f]=US2,'+Z1eKJT!a\u0003\u0007\u0002\rMd\u0017\u000e\u001d9z\u0015\tia\"A\u0003ti>\u0014XM\u0003\u0002\u0010!\u0005)1\u000f]1sW*\t\u0011#\u0001\u0006hK>$(/\u001a7mSN\u001c\u0001!\u0006\u0002\u0015CM\u0019\u0001!F\u000e\u0011\u0005YIR\"A\f\u000b\u0003a\tQa]2bY\u0006L!AG\f\u0003\r\u0005s\u0017PU3g!\raRdH\u0007\u0002\u0015%\u0011aD\u0003\u0002\u0011'2L\u0007\u000f]=US2,'+Z1eKJ\u0004\"\u0001I\u0011\r\u0001\u0011)!\u0005\u0001b\u0001G\t\tA+\u0005\u0002%OA\u0011a#J\u0005\u0003M]\u0011qAT8uQ&tw\r\u0005\u0002\u0017Q%\u0011\u0011f\u0006\u0002\u0004\u0003:L\u0018\u0001\u00049bi\"$V-\u001c9mCR,\u0007C\u0001\u00174\u001d\ti\u0013\u0007\u0005\u0002//5\tqF\u0003\u00021%\u00051AH]8pizJ!AM\f\u0002\rA\u0013X\rZ3g\u0013\t!TG\u0001\u0004TiJLgn\u001a\u0006\u0003e]\t\u0011B\u001a:p[\nKH/Z:\u0011\u000bYA$\bQ\u0010\n\u0005e:\"!\u0003$v]\u000e$\u0018n\u001c83!\tYd(D\u0001=\u0015\ti\u0004#A\u0003mCf,'/\u0003\u0002@y\tQ1\u000b]1uS\u0006d7*Z=\u0011\u0007Y\t5)\u0003\u0002C/\t)\u0011I\u001d:bsB\u0011a\u0003R\u0005\u0003\u000b^\u0011AAQ=uK\u00061A(\u001b8jiz\"\"\u0001S&\u0015\u0005%S\u0005c\u0001\u000f\u0001?!)ag\u0001a\u0001o!)!f\u0001a\u0001W\u00051q-\u001a;V%2#Ba\u000b(T+\")q\n\u0002a\u0001!\u0006\t!\u0010\u0005\u0002\u0017#&\u0011!k\u0006\u0002\u0004\u0013:$\b\"\u0002+\u0005\u0001\u0004\u0001\u0016!\u0001=\t\u000bY#\u0001\u0019\u0001)\u0002\u0003e\fqaZ3u+Jc5\u000f\u0006\u0002ZEB\u0019!lX\u0016\u000f\u0005mkfB\u0001\u0018]\u0013\u0005A\u0012B\u00010\u0018\u0003\u001d\u0001\u0018mY6bO\u0016L!\u0001Y1\u0003\u0007M+\u0017O\u0003\u0002_/!)q*\u0002a\u0001!\u0006aq-\u001a;CsR,\u0017I\u001d:bsR\u0011\u0001)\u001a\u0005\u0006M\u001a\u0001\raK\u0001\u0004kJd\u0017\u0001\u0002:fC\u0012$2aH5l\u0011\u0015Qw\u00011\u0001Q\u0003\u0011Qxn\\7\t\u000b1<\u0001\u0019\u0001\u001e\u0002\u0007-,\u0017\u0010F\u0002o\u0003\u000f!\"a\\?\u0011\u0007AD(0D\u0001r\u0015\t\u00118/A\u0002sI\u0012T!a\u0004;\u000b\u0005U4\u0018AB1qC\u000eDWMC\u0001x\u0003\ry'oZ\u0005\u0003sF\u00141A\u0015#E!\u001112PO\u0010\n\u0005q<\"A\u0002+va2,'\u0007C\u0003\u007f\u0011\u0001\u000fq0\u0001\u0002tGB!\u0011\u0011AA\u0002\u001b\u0005\u0019\u0018bAA\u0003g\na1\u000b]1sW\u000e{g\u000e^3yi\")!\u000e\u0003a\u0001!\u0002")
public class HttpSlippyTileReader<T>
implements SlippyTileReader<T> {
    private final String pathTemplate;
    private final Function2<SpatialKey, byte[], T> fromBytes;

    @Override
    public T read(int zoom, int x, int y) {
        return (T)SlippyTileReader.read$(this, zoom, x, y);
    }

    public String getURL(int z, int x, int y) {
        return this.pathTemplate.replace("{z}", ((Object)BoxesRunTime.boxToInteger((int)z)).toString()).replace("{x}", ((Object)BoxesRunTime.boxToInteger((int)x)).toString()).replace("{y}", ((Object)BoxesRunTime.boxToInteger((int)y)).toString());
    }

    public Seq<String> getURLs(int z) {
        return (Seq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), (int)package$.MODULE$.pow(2.0, (double)z)).flatMap((Function1 & Serializable & scala.Serializable)x -> HttpSlippyTileReader.$anonfun$getURLs$1(this, z, BoxesRunTime.unboxToInt((Object)x)), IndexedSeq$.MODULE$.canBuildFrom());
    }

    private byte[] getByteArray(String url) {
        byte[] byArray;
        try (InputStream inStream = new URL(url).openStream();){
            byArray = IOUtils.toByteArray((InputStream)inStream);
        }
        return byArray;
    }

    @Override
    public T read(int zoom, SpatialKey key) {
        String url = this.getURL(zoom, key.col(), key.row());
        byte[] byArray = this.getByteArray(url);
        Option option = Array$.MODULE$.unapplySeq((Object)byArray);
        if (!option.isEmpty() && option.get() != null && ((SeqLike)option.get()).lengthCompare(0) == 0) {
            throw new FileNotFoundException(String.valueOf(url));
        }
        Option option2 = Array$.MODULE$.unapplySeq((Object)byArray);
        if (option2.isEmpty() || option2.get() == null || ((SeqLike)option2.get()).lengthCompare(1) != 0) {
            throw new MatchError((Object)byArray);
        }
        byte tile = BoxesRunTime.unboxToByte((Object)((SeqLike)option2.get()).apply(0));
        Object object = this.fromBytes.apply((Object)key, (Object)new byte[]{tile});
        return (T)object;
    }

    @Override
    public RDD<Tuple2<SpatialKey, T>> read(int zoom, SparkContext sc) {
        Seq urls = (Seq)this.getURLs(zoom).flatMap((Function1 & Serializable & scala.Serializable)url -> {
            Iterable iterable;
            String string = url;
            Option option = SlippyTileReader$.MODULE$.TilePath().unapplySeq((CharSequence)string);
            if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(2) == 0) {
                String x = (String)((LinearSeqOptimized)option.get()).apply(0);
                String y = (String)((LinearSeqOptimized)option.get()).apply(1);
                iterable = Option$.MODULE$.option2Iterable((Option)new Some((Object)new Tuple2((Object)new SpatialKey(new StringOps(Predef$.MODULE$.augmentString(x)).toInt(), new StringOps(Predef$.MODULE$.augmentString(y)).toInt()), url)));
            } else {
                iterable = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
            }
            return iterable;
        }, Seq$.MODULE$.canBuildFrom());
        int numPartitions = package$.MODULE$.min(urls.size(), package$.MODULE$.max(urls.size() / 10, 50));
        return RDD$.MODULE$.rddToPairRDDFunctions(sc.parallelize(urls.toSeq(), sc.parallelize$default$2(), ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.apply(SpatialKey.class), ClassTag$.MODULE$.apply(String.class), SpatialKey$.MODULE$.ordering()).partitionBy((Partitioner)new HashPartitioner(numPartitions)).mapPartitions((Function1 & Serializable & scala.Serializable)partition -> partition.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Object object;
            SpatialKey key;
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                key = (SpatialKey)tuple2._1();
                String url = (String)tuple2._2();
                byte[] byArray = this.getByteArray(url);
                Option option = Array$.MODULE$.unapplySeq((Object)byArray);
                if (!option.isEmpty() && option.get() != null && ((SeqLike)option.get()).lengthCompare(1) == 0) {
                    byte tile = BoxesRunTime.unboxToByte((Object)((SeqLike)option.get()).apply(0));
                    object = $this.fromBytes.apply((Object)key, (Object)new byte[]{tile});
                } else {
                    object = $this.fromBytes.apply((Object)key, Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.Byte()));
                }
            } else {
                throw new MatchError((Object)tuple2);
            }
            Object tile = object;
            Tuple2 tuple22 = new Tuple2((Object)key, tile);
            return tuple22;
        }), true, ClassTag$.MODULE$.apply(Tuple2.class));
    }

    public static final /* synthetic */ IndexedSeq $anonfun$getURLs$1(HttpSlippyTileReader $this, int z$1, int x) {
        return (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), (int)package$.MODULE$.pow(2.0, (double)z$1)).map((Function1 & Serializable & scala.Serializable)y -> $this.getURL(z$1, x, BoxesRunTime.unboxToInt((Object)y)), IndexedSeq$.MODULE$.canBuildFrom());
    }

    public HttpSlippyTileReader(String pathTemplate, Function2<SpatialKey, byte[], T> fromBytes) {
        this.pathTemplate = pathTemplate;
        this.fromBytes = fromBytes;
        SlippyTileReader.$init$(this);
    }
}

