/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.spark.viewshed;

import geotrellis.layer.Bounds;
import geotrellis.layer.KeyBounds;
import geotrellis.layer.MapKeyTransform;
import geotrellis.layer.Metadata;
import geotrellis.layer.SpatialKey;
import geotrellis.layer.TileLayerMetadata;
import geotrellis.raster.DataType;
import geotrellis.raster.IntConstantNoDataCellType$;
import geotrellis.raster.MutableArrayTile;
import geotrellis.raster.RasterExtent;
import geotrellis.raster.RasterExtent$;
import geotrellis.raster.Tile;
import geotrellis.raster.viewshed.R2Viewshed;
import geotrellis.raster.viewshed.R2Viewshed$;
import geotrellis.spark.ContextRDD$;
import geotrellis.spark.EmptyBoundsError;
import geotrellis.spark.EmptyBoundsError$;
import geotrellis.spark.costdistance.IterativeCostDistance$;
import geotrellis.spark.viewshed.IterativeViewshed;
import geotrellis.spark.viewshed.Viewpoint;
import geotrellis.vector.Extent;
import geotrellis.vector.Point$;
import java.io.Serializable;
import org.apache.log4j.Logger;
import org.apache.spark.SparkContext;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.rdd.RDD;
import org.apache.spark.storage.StorageLevel$;
import org.apache.spark.util.AccumulatorV2;
import org.locationtech.jts.geom.Coordinate;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple6;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class IterativeViewshed$ {
    public static IterativeViewshed$ MODULE$;
    private final Logger logger;

    static {
        new IterativeViewshed$();
    }

    public Seq<Viewpoint> coordinatesToPoints(Seq<Coordinate> points) {
        return (Seq)points.map((Function1 & Serializable & scala.Serializable)p -> new Viewpoint(p.getX(), p.getY(), p.getZ(), 0.0, -1.0, Double.NEGATIVE_INFINITY), Seq$.MODULE$.canBuildFrom());
    }

    private Logger logger() {
        return this.logger;
    }

    private <K, V> IterativeViewshed.PointInfo pointInfo(RDD<Tuple2<K, V>> rdd, Tuple2<Viewpoint, Object> pi, Function1<K, SpatialKey> evidence$1, Function1<V, Tile> evidence$2) {
        Tuple2<Viewpoint, Object> tuple2 = pi;
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        Viewpoint p = (Viewpoint)tuple2._1();
        int index = tuple2._2$mcI$sp();
        Tuple2 tuple22 = new Tuple2((Object)p, (Object)BoxesRunTime.boxToInteger((int)index));
        Tuple2 tuple23 = tuple22;
        Viewpoint p2 = (Viewpoint)tuple23._1();
        int index2 = tuple23._2$mcI$sp();
        TileLayerMetadata md = (TileLayerMetadata)((Metadata)rdd).metadata();
        int cols = md.layout().tileCols();
        int rows = md.layout().tileRows();
        SpatialKey key = md.layout().mapTransform().apply(Point$.MODULE$.apply(p2.x(), p2.y()));
        Extent extent = md.mapTransform().apply(key);
        RasterExtent re = RasterExtent$.MODULE$.apply(extent, cols, rows);
        int col = re.mapXToGrid$mcI$sp(p2.x());
        int row = re.mapYToGrid$mcI$sp(p2.y());
        double viewHeight = p2.viewHeight();
        return new IterativeViewshed.PointInfo(index2, key, col, row, viewHeight, p2.angle(), p2.fieldOfView(), p2.altitude());
    }

    public <K, V> RDD<Tuple2<K, Tile>> apply(RDD<Tuple2<K, V>> elevation, Seq<Viewpoint> ps, double maxDistance, boolean curvature, R2Viewshed.AggregationOperator operator, double epsilon, boolean scatter, Function1<K, SpatialKey> evidence$3, ClassTag<K> evidence$4, Function1<V, Tile> evidence$5) {
        KeyBounds keyBounds;
        SparkContext sparkContext = elevation.sparkContext();
        TileLayerMetadata md = (TileLayerMetadata)((Metadata)elevation).metadata();
        MapKeyTransform mt = md.mapTransform();
        double resolution = IterativeCostDistance$.MODULE$.computeResolution(elevation, evidence$3, evidence$5);
        this.logger().debug((Object)new StringBuilder(34).append("Computed resolution: ").append(resolution).append(" meters/pixel").toString());
        Bounds bounds = md.bounds();
        if (!(bounds instanceof KeyBounds)) {
            throw new EmptyBoundsError(EmptyBoundsError$.MODULE$.$lessinit$greater$default$1());
        }
        KeyBounds keyBounds2 = keyBounds = (KeyBounds)bounds;
        KeyBounds bounds2 = keyBounds2;
        SpatialKey minKey = (SpatialKey)evidence$3.apply(bounds2.minKey());
        int minKeyCol = minKey.col();
        int minKeyRow = minKey.row();
        SpatialKey maxKey = (SpatialKey)evidence$3.apply(bounds2.maxKey());
        int maxKeyCol = maxKey.col();
        int maxKeyRow = maxKey.row();
        IterativeViewshed.RayCatcher rays = new IterativeViewshed.RayCatcher();
        sparkContext.register((AccumulatorV2)rays);
        Function1 & Serializable & scala.Serializable fn = (Function1 & Serializable & scala.Serializable)pi -> MODULE$.pointInfo(elevation, (Tuple2<Viewpoint, Object>)pi, evidence$3, evidence$5);
        Seq info = (Seq)((TraversableLike)ps.zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1)fn, Seq$.MODULE$.canBuildFrom());
        Map _pointsByKey = info.groupBy((Function1 & Serializable & scala.Serializable)x$5 -> x$5.key()).toMap(Predef$.MODULE$.$conforms());
        Broadcast pointsByKey = sparkContext.broadcast((Object)_pointsByKey, ClassTag$.MODULE$.apply(Map.class));
        IterativeViewshed.PointInfo[] _pointsByIndex = (IterativeViewshed.PointInfo[])info.toArray(ClassTag$.MODULE$.apply(IterativeViewshed.PointInfo.class));
        Broadcast pointsByIndex = sparkContext.broadcast((Object)_pointsByIndex, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(IterativeViewshed.PointInfo.class)));
        Map _heightsByIndex = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])elevation.flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Seq seq;
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            Object k = tuple2._1();
            Object v = tuple2._2();
            SpatialKey key = (SpatialKey)Predef$.MODULE$.implicitly(evidence$3.apply(k));
            Tile tile = (Tile)Predef$.MODULE$.implicitly(evidence$5.apply(v));
            Option option = ((MapLike)pointsByKey.value()).get((Object)key);
            if (option instanceof Some) {
                Some some = (Some)option;
                Seq list = (Seq)some.value();
                seq = (Seq)list.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                    IterativeViewshed.PointInfo pointInfo = x0$2;
                    if (pointInfo == null) {
                        throw new MatchError((Object)pointInfo);
                    }
                    int index = pointInfo.index();
                    int col = pointInfo.col();
                    int row = pointInfo.row();
                    double viewHeight0 = pointInfo.viewHeight();
                    double viewHeight = viewHeight0 >= 0.0 ? tile.getDouble(col, row) + viewHeight0 : -viewHeight0;
                    Tuple2.mcID.sp sp2 = new Tuple2.mcID.sp(index, viewHeight);
                    return sp2;
                }, Seq$.MODULE$.canBuildFrom());
                return seq;
            } else {
                if (!None$.MODULE$.equals(option)) throw new MatchError((Object)option);
                seq = (Seq)Seq$.MODULE$.empty();
            }
            return seq;
        }, ClassTag$.MODULE$.apply(Tuple2.class)).collect())).toMap(Predef$.MODULE$.$conforms());
        Broadcast heightsByIndex = sparkContext.broadcast((Object)_heightsByIndex, ClassTag$.MODULE$.apply(Map.class));
        RDD sheds = elevation.map((Function1 & Serializable & scala.Serializable)x0$3 -> {
            Tuple2 tuple2 = x0$3;
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            Object k = tuple2._1();
            Object v = tuple2._2();
            SpatialKey key = (SpatialKey)Predef$.MODULE$.implicitly(evidence$3.apply(k));
            Tile tile = (Tile)Predef$.MODULE$.implicitly(evidence$5.apply(v));
            MutableArrayTile shed = R2Viewshed$.MODULE$.generateEmptyViewshedTile(BoxesRunTime.unboxToInt((Object)tile.cols()), BoxesRunTime.unboxToInt((Object)tile.rows()), R2Viewshed$.MODULE$.generateEmptyViewshedTile$default$3());
            Option option = ((MapLike)pointsByKey.value()).get((Object)key);
            if (option instanceof Some) {
                Some some = (Some)option;
                Seq list = (Seq)some.value();
                list.foreach((Function1 & Serializable & scala.Serializable)x0$4 -> {
                    IterativeViewshed.PointInfo pointInfo = x0$4;
                    if (pointInfo == null) {
                        throw new MatchError((Object)pointInfo);
                    }
                    int index = pointInfo.index();
                    int col = pointInfo.col();
                    int row = pointInfo.row();
                    double ang = pointInfo.angle();
                    double fov = pointInfo.fov();
                    double alt = pointInfo.alt();
                    double viewHeight = BoxesRunTime.unboxToDouble((Object)((MapLike)heightsByIndex.value()).getOrElse((Object)BoxesRunTime.boxToInteger((int)index), (Function0 & Serializable & scala.Serializable)() -> {
                        throw new Exception();
                    }));
                    Tile x$1 = tile;
                    MutableArrayTile x$2 = shed;
                    int x$3 = col;
                    int x$4 = row;
                    double x$5 = viewHeight;
                    R2Viewshed.FromInside$ x$6 = R2Viewshed.FromInside$.MODULE$;
                    Object x$7 = null;
                    Function1 & Serializable & scala.Serializable x$8 = (Function1 & Serializable & scala.Serializable)bundle -> {
                        IterativeViewshed$.rayCatcherFn$1(key, index, bundle, rays, minKeyCol, maxKeyCol, minKeyRow, maxKeyRow);
                        return BoxedUnit.UNIT;
                    };
                    double x$9 = resolution;
                    double x$10 = maxDistance;
                    boolean x$11 = curvature;
                    double x$12 = alt;
                    R2Viewshed.AggregationOperator x$13 = operator;
                    double x$14 = ang;
                    double x$15 = fov;
                    double x$16 = epsilon;
                    boolean x$17 = scatter;
                    Tile tile = R2Viewshed$.MODULE$.compute(x$1, x$2, x$3, x$4, x$5, (R2Viewshed.From)x$6, null, (Function1)x$8, x$9, x$10, x$11, x$13, x$12, x$14, x$15, x$16, x$17);
                    return tile;
                });
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return new Tuple3(k, v, (Object)shed);
            } else {
                if (!None$.MODULE$.equals(option)) throw new MatchError((Object)option);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return new Tuple3(k, v, (Object)shed);
        }, ClassTag$.MODULE$.apply(Tuple3.class)).persist(StorageLevel$.MODULE$.MEMORY_AND_DISK_SER());
        sheds.count();
        do {
            Map _changes = ((Map)rays.value().map((Function1 & Serializable & scala.Serializable)x0$5 -> {
                Tuple2 tuple2 = x0$5;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                SpatialKey k = (SpatialKey)tuple2._1();
                List list = (List)tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)k, list.map((Function1 & Serializable & scala.Serializable)x0$6 -> {
                    IterativeViewshed.Message message = x0$6;
                    if (message == null) {
                        throw new MatchError((Object)message);
                    }
                    int index = message.index();
                    R2Viewshed.From from = message.from();
                    ArrayBuffer<R2Viewshed.Ray> rs = message.rays();
                    Tuple3 tuple3 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)index), (Object)from, rs);
                    return tuple3;
                }, List$.MODULE$.canBuildFrom()));
                return tuple22;
            }, Map$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            Broadcast changes = sparkContext.broadcast((Object)_changes, ClassTag$.MODULE$.apply(Map.class));
            rays.reset();
            this.logger().debug((Object)new StringBuilder(18).append("\u2265 ").append(((TraversableOnce)changes.value()).size()).append(" tiles in motion").toString());
            RDD oldSheds = sheds;
            sheds = oldSheds.map((Function1 & Serializable & scala.Serializable)x0$7 -> {
                Some some;
                Seq localChanges;
                Tuple3 tuple3 = x0$7;
                if (tuple3 == null) throw new MatchError((Object)tuple3);
                Object k = tuple3._1();
                Object v = tuple3._2();
                MutableArrayTile shed = (MutableArrayTile)tuple3._3();
                SpatialKey key = (SpatialKey)Predef$.MODULE$.implicitly(evidence$3.apply(k));
                Tile elevationTile = (Tile)Predef$.MODULE$.implicitly(evidence$5.apply(v));
                int cols = BoxesRunTime.unboxToInt((Object)elevationTile.cols());
                int rows = BoxesRunTime.unboxToInt((Object)elevationTile.rows());
                Option option = ((MapLike)changes.value()).get((Object)key);
                if (option instanceof Some && (localChanges = (Seq)(some = (Some)option).value()) != null) {
                    Seq seq = localChanges;
                    Tuple2[] indexed = (Tuple2[])((TraversableOnce)seq.groupBy((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToInteger((int)IterativeViewshed$.$anonfun$apply$14(x$6))).map((Function1 & Serializable & scala.Serializable)x0$8 -> {
                        Tuple2 tuple2 = x0$8;
                        if (tuple2 == null) {
                            throw new MatchError((Object)tuple2);
                        }
                        int index = tuple2._1$mcI$sp();
                        Seq list = (Seq)tuple2._2();
                        Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)index), list.map((Function1 & Serializable & scala.Serializable)x0$9 -> {
                            Tuple3 tuple3 = x0$9;
                            if (tuple3 == null) {
                                throw new MatchError((Object)tuple3);
                            }
                            R2Viewshed.From from = (R2Viewshed.From)tuple3._2();
                            ArrayBuffer rs = (ArrayBuffer)tuple3._3();
                            Tuple2 tuple2 = new Tuple2((Object)from, (Object)rs);
                            return tuple2;
                        }, Seq$.MODULE$.canBuildFrom()));
                        return tuple22;
                    }, Map$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Tuple2.class));
                    for (int j = 0; j < indexed.length; ++j) {
                        Tuple2 tuple2 = indexed[j];
                        if (tuple2 == null) throw new MatchError((Object)tuple2);
                        int index = tuple2._1$mcI$sp();
                        Seq list = (Seq)tuple2._2();
                        Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)index), (Object)list);
                        Tuple2 tuple23 = tuple22;
                        int index2 = tuple23._1$mcI$sp();
                        Seq list2 = (Seq)tuple23._2();
                        IterativeViewshed.PointInfo pointInfo = ((IterativeViewshed.PointInfo[])pointsByIndex.value())[index2];
                        if (pointInfo == null) throw new MatchError((Object)pointInfo);
                        SpatialKey pointKey = pointInfo.key();
                        int col = pointInfo.col();
                        int row = pointInfo.row();
                        double angle = pointInfo.angle();
                        double fov = pointInfo.fov();
                        double alt = pointInfo.alt();
                        Tuple6 tuple6 = new Tuple6((Object)pointKey, (Object)BoxesRunTime.boxToInteger((int)col), (Object)BoxesRunTime.boxToInteger((int)row), (Object)BoxesRunTime.boxToDouble((double)angle), (Object)BoxesRunTime.boxToDouble((double)fov), (Object)BoxesRunTime.boxToDouble((double)alt));
                        Tuple6 tuple62 = tuple6;
                        SpatialKey pointKey2 = (SpatialKey)tuple62._1();
                        int col2 = BoxesRunTime.unboxToInt((Object)tuple62._2());
                        int row2 = BoxesRunTime.unboxToInt((Object)tuple62._3());
                        double angle2 = BoxesRunTime.unboxToDouble((Object)tuple62._4());
                        double fov2 = BoxesRunTime.unboxToDouble((Object)tuple62._5());
                        double alt2 = BoxesRunTime.unboxToDouble((Object)tuple62._6());
                        int startCol = (pointKey2.col() - key.col()) * cols + col2;
                        int startRow = (pointKey2.row() - key.row()) * rows + row2;
                        double viewHeight = BoxesRunTime.unboxToDouble((Object)((MapLike)heightsByIndex.value()).getOrElse((Object)BoxesRunTime.boxToInteger((int)index2), (Function0 & Serializable & scala.Serializable)() -> {
                            throw new Exception();
                        }));
                        Tuple2[] packets = (Tuple2[])list2.groupBy((Function1 & Serializable & scala.Serializable)x$9 -> (R2Viewshed.From)x$9._1()).mapValues((Function1 & Serializable & scala.Serializable)x0$10 -> {
                            Seq seq = x0$10;
                            ArrayBuffer arrayBuffer = (ArrayBuffer)((TraversableOnce)seq.map((Function1 & Serializable & scala.Serializable)x0$11 -> {
                                ArrayBuffer rs;
                                Tuple2 tuple2 = x0$11;
                                if (tuple2 == null) {
                                    throw new MatchError((Object)tuple2);
                                }
                                ArrayBuffer arrayBuffer = rs = (ArrayBuffer)tuple2._2();
                                return arrayBuffer;
                            }, Seq$.MODULE$.canBuildFrom())).foldLeft((Object)ArrayBuffer$.MODULE$.empty(), (Function2 & Serializable & scala.Serializable)(x$10, x$11) -> (ArrayBuffer)x$10.$plus$plus((GenTraversableOnce)x$11));
                            return arrayBuffer;
                        }).mapValues((Function1 & Serializable & scala.Serializable)rs -> (R2Viewshed.Ray[])((TraversableOnce)rs.sortBy((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToDouble((double)x$12.theta()), (Ordering)Ordering.Double$.MODULE$)).toArray(ClassTag$.MODULE$.apply(R2Viewshed.Ray.class))).toArray(ClassTag$.MODULE$.apply(Tuple2.class));
                        for (int i = 0; i < packets.length; ++i) {
                            Tuple2 tuple24 = packets[i];
                            if (tuple24 == null) throw new MatchError((Object)tuple24);
                            R2Viewshed.From from = (R2Viewshed.From)tuple24._1();
                            R2Viewshed.Ray[] rays = (R2Viewshed.Ray[])tuple24._2();
                            Tuple2 tuple25 = new Tuple2((Object)from, (Object)rays);
                            Tuple2 tuple26 = tuple25;
                            R2Viewshed.From from2 = (R2Viewshed.From)tuple26._1();
                            R2Viewshed.Ray[] rays2 = (R2Viewshed.Ray[])tuple26._2();
                            R2Viewshed.Ray[] sortedRays = (R2Viewshed.Ray[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])rays2)).toArray(ClassTag$.MODULE$.apply(R2Viewshed.Ray.class));
                            Object object = rays2.length > 0 ? R2Viewshed$.MODULE$.compute(elevationTile, shed, startCol, startRow, viewHeight, from2, sortedRays, (Function1 & Serializable & scala.Serializable)bundle -> {
                                IterativeViewshed$.rayCatcherFn$1(key, index2, bundle, rays, minKeyCol, maxKeyCol, minKeyRow, maxKeyRow);
                                return BoxedUnit.UNIT;
                            }, resolution, maxDistance, curvature, operator, alt2, angle2, fov2, epsilon, scatter) : BoxedUnit.UNIT;
                        }
                    }
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return new Tuple3(k, v, (Object)shed);
                } else {
                    if (!None$.MODULE$.equals(option)) throw new MatchError((Object)option);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
                return new Tuple3(k, v, (Object)shed);
            }, ClassTag$.MODULE$.apply(Tuple3.class)).persist(StorageLevel$.MODULE$.MEMORY_AND_DISK_SER());
            sheds.count();
            oldSheds.unpersist(oldSheds.unpersist$default$1());
        } while (rays.value().nonEmpty());
        TileLayerMetadata metadata = new TileLayerMetadata((DataType)IntConstantNoDataCellType$.MODULE$, md.layout(), md.extent(), md.crs(), md.bounds());
        RDD rdd = sheds.map((Function1 & Serializable & scala.Serializable)x0$12 -> {
            Tuple3 tuple3 = x0$12;
            if (tuple3 == null) {
                throw new MatchError((Object)tuple3);
            }
            Object k = tuple3._1();
            MutableArrayTile viewshed = (MutableArrayTile)tuple3._3();
            Tuple2 tuple2 = new Tuple2(k, (Object)viewshed);
            return tuple2;
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        return ContextRDD$.MODULE$.apply(rdd, metadata);
    }

    public <K, V> boolean apply$default$4() {
        return true;
    }

    public <K, V> R2Viewshed.AggregationOperator apply$default$5() {
        return R2Viewshed.Or$.MODULE$;
    }

    public <K, V> double apply$default$6() {
        return 0.3183098861837907;
    }

    public <K, V> boolean apply$default$7() {
        return true;
    }

    private static final boolean validKey$1(SpatialKey key, int minKeyCol$1, int maxKeyCol$1, int minKeyRow$1, int maxKeyRow$1) {
        return minKeyCol$1 <= key.col() && key.col() <= maxKeyCol$1 && minKeyRow$1 <= key.row() && key.row() <= maxKeyRow$1;
    }

    public static final /* synthetic */ void $anonfun$apply$1(Map bundle$1, int index$1, IterativeViewshed.RayCatcher rays$1, int minKeyCol$1, int maxKeyCol$1, int minKeyRow$1, int maxKeyRow$1, Tuple2 x0$1) {
        BoxedUnit boxedUnit;
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            Product dir = (Product)tuple2._1();
            SpatialKey key = (SpatialKey)tuple2._2();
            if (IterativeViewshed$.validKey$1(key, minKeyCol$1, maxKeyCol$1, minKeyRow$1, maxKeyRow$1)) {
                ArrayBuffer rs = (ArrayBuffer)bundle$1.getOrElse((Object)dir, (Function0 & Serializable & scala.Serializable)() -> {
                    throw new Exception();
                });
                if (rs.length() > 0) {
                    IterativeViewshed.Message message = new IterativeViewshed.Message(key, index$1, (R2Viewshed.From)dir, (ArrayBuffer<R2Viewshed.Ray>)rs);
                    rays$1.add(message);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        BoxedUnit boxedUnit2 = boxedUnit;
    }

    private static final void rayCatcherFn$1(SpatialKey key, int index, Map bundle, IterativeViewshed.RayCatcher rays$1, int minKeyCol$1, int maxKeyCol$1, int minKeyRow$1, int maxKeyRow$1) {
        SpatialKey toTheNorth = new SpatialKey(key.col() + 0, key.row() + 1);
        SpatialKey toTheEast = new SpatialKey(key.col() + 1, key.row() + 0);
        SpatialKey toTheSouth = new SpatialKey(key.col() + 0, key.row() - 1);
        SpatialKey toTheWest = new SpatialKey(key.col() - 1, key.row() + 0);
        ((IterableLike)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)R2Viewshed.FromSouth$.MODULE$), (Object)toTheNorth), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)R2Viewshed.FromWest$.MODULE$), (Object)toTheEast), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)R2Viewshed.FromNorth$.MODULE$), (Object)toTheSouth), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)R2Viewshed.FromEast$.MODULE$), (Object)toTheWest)}))).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            IterativeViewshed$.$anonfun$apply$1(bundle, index, rays$1, minKeyCol$1, maxKeyCol$1, minKeyRow$1, maxKeyRow$1, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ int $anonfun$apply$14(Tuple3 x$6) {
        return BoxesRunTime.unboxToInt((Object)x$6._1());
    }

    private IterativeViewshed$() {
        MODULE$ = this;
        this.logger = Logger.getLogger(this.getClass());
    }
}

