/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.spark;

import geotrellis.layer.Boundable;
import geotrellis.layer.Bounds;
import geotrellis.layer.KeyBounds;
import geotrellis.layer.KeyBounds$;
import geotrellis.layer.LayoutDefinition;
import geotrellis.layer.LayoutLevel;
import geotrellis.layer.LayoutScheme;
import geotrellis.layer.SpatialKey;
import geotrellis.layer.TileLayerMetadata;
import geotrellis.layer.ZoomedLayoutScheme;
import geotrellis.proj4.CRS;
import geotrellis.raster.CellGrid;
import geotrellis.raster.CellSize;
import geotrellis.raster.CellSize$;
import geotrellis.raster.DataType;
import geotrellis.spark.tiling.TilerKeyMethods;
import geotrellis.util.Component;
import geotrellis.util.GetComponent;
import geotrellis.util.package$;
import geotrellis.vector.Extent;
import geotrellis.vector.ProjectedExtent;
import java.io.Serializable;
import org.apache.spark.rdd.RDD;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.Tuple5;
import scala.collection.GenTraversableOnce;
import scala.collection.Seq;
import scala.collection.immutable.Set;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class CollectTileLayerMetadata$ {
    public static CollectTileLayerMetadata$ MODULE$;

    static {
        new CollectTileLayerMetadata$();
    }

    private <K, V extends CellGrid<Object>, K2> Tuple4<Extent, DataType, CellSize, KeyBounds<K2>> collectMetadata(RDD<Tuple2<K, V>> rdd, Function1<K, TilerKeyMethods<K, K2>> evidence$1, Component<K2, SpatialKey> evidence$2, Boundable<K2> evidence$3) {
        return (Tuple4)rdd.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Object key = tuple2._1();
            CellGrid grid = (CellGrid)tuple2._2();
            Extent extent = ((TilerKeyMethods)evidence$1.apply(key)).extent();
            Object boundsKey = ((TilerKeyMethods)evidence$1.apply(key)).translate(new SpatialKey(0, 0));
            Tuple4 tuple4 = new Tuple4((Object)extent, (Object)grid.cellType(), (Object)CellSize$.MODULE$.apply(extent, BoxesRunTime.unboxToInt((Object)grid.cols()), BoxesRunTime.unboxToInt((Object)grid.rows())), (Object)new KeyBounds(boundsKey, boundsKey));
            return tuple4;
        }, ClassTag$.MODULE$.apply(Tuple4.class)).reduce((Function2 & Serializable & scala.Serializable)(tuple1, tuple2) -> {
            Tuple4 tuple4 = tuple1;
            if (tuple4 == null) {
                throw new MatchError((Object)tuple4);
            }
            Extent extent1 = (Extent)tuple4._1();
            DataType cellType1 = (DataType)tuple4._2();
            CellSize cellSize1 = (CellSize)tuple4._3();
            KeyBounds bounds1 = (KeyBounds)tuple4._4();
            Tuple4 tuple42 = new Tuple4((Object)extent1, (Object)cellType1, (Object)cellSize1, (Object)bounds1);
            Tuple4 tuple43 = tuple42;
            Extent extent12 = (Extent)tuple43._1();
            DataType cellType12 = (DataType)tuple43._2();
            CellSize cellSize12 = (CellSize)tuple43._3();
            KeyBounds bounds12 = (KeyBounds)tuple43._4();
            Tuple4 tuple44 = tuple2;
            if (tuple44 == null) {
                throw new MatchError((Object)tuple44);
            }
            Extent extent2 = (Extent)tuple44._1();
            DataType cellType2 = (DataType)tuple44._2();
            CellSize cellSize2 = (CellSize)tuple44._3();
            KeyBounds bounds2 = (KeyBounds)tuple44._4();
            Tuple4 tuple45 = new Tuple4((Object)extent2, (Object)cellType2, (Object)cellSize2, (Object)bounds2);
            Tuple4 tuple46 = tuple45;
            Extent extent22 = (Extent)tuple46._1();
            DataType cellType22 = (DataType)tuple46._2();
            CellSize cellSize22 = (CellSize)tuple46._3();
            KeyBounds bounds22 = (KeyBounds)tuple46._4();
            return new Tuple4((Object)extent12.combine(extent22), (Object)cellType12.union(cellType22), (Object)(cellSize12.resolution() < cellSize22.resolution() ? cellSize12 : cellSize22), (Object)bounds12.combine((Bounds)bounds22, evidence$3));
        });
    }

    private <K, V extends CellGrid<Object>, K2> Tuple5<Extent, DataType, CellSize, KeyBounds<K2>, CRS> collectMetadataWithCRS(RDD<Tuple2<K, V>> rdd, GetComponent<K, ProjectedExtent> evidence$4, Function1<K, TilerKeyMethods<K, K2>> evidence$5, Component<K2, SpatialKey> evidence$6, Boundable<K2> evidence$7) {
        Tuple5 tuple5 = (Tuple5)rdd.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2;
            CellGrid grid;
            Object key;
            Tuple2 tuple22 = x0$1;
            if (tuple22 != null) {
                key = tuple22._1();
                grid = (CellGrid)tuple22._2();
                ProjectedExtent projectedExtent = (ProjectedExtent)package$.MODULE$.withGetComponentMethods(key).getComponent(evidence$4);
                if (projectedExtent == null) {
                    throw new MatchError((Object)projectedExtent);
                }
                Extent extent = projectedExtent.extent();
                CRS crs = projectedExtent.crs();
                tuple2 = new Tuple2((Object)extent, (Object)crs);
            } else {
                throw new MatchError((Object)tuple22);
            }
            Tuple2 tuple23 = tuple2;
            Extent extent = (Extent)tuple23._1();
            CRS crs = (CRS)tuple23._2();
            Object boundsKey = ((TilerKeyMethods)evidence$5.apply(key)).translate(new SpatialKey(0, 0));
            Tuple5 tuple5 = new Tuple5((Object)extent, (Object)grid.cellType(), (Object)CellSize$.MODULE$.apply(extent, BoxesRunTime.unboxToInt((Object)grid.cols()), BoxesRunTime.unboxToInt((Object)grid.rows())), (Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new CRS[]{crs})), (Object)new KeyBounds(boundsKey, boundsKey));
            return tuple5;
        }, ClassTag$.MODULE$.apply(Tuple5.class)).reduce((Function2 & Serializable & scala.Serializable)(tuple1, tuple2) -> {
            Tuple5 tuple5 = tuple1;
            if (tuple5 == null) {
                throw new MatchError((Object)tuple5);
            }
            Extent extent1 = (Extent)tuple5._1();
            DataType cellType1 = (DataType)tuple5._2();
            CellSize cellSize1 = (CellSize)tuple5._3();
            Set crs1 = (Set)tuple5._4();
            KeyBounds bounds1 = (KeyBounds)tuple5._5();
            Tuple5 tuple52 = new Tuple5((Object)extent1, (Object)cellType1, (Object)cellSize1, (Object)crs1, (Object)bounds1);
            Tuple5 tuple53 = tuple52;
            Extent extent12 = (Extent)tuple53._1();
            DataType cellType12 = (DataType)tuple53._2();
            CellSize cellSize12 = (CellSize)tuple53._3();
            Set crs12 = (Set)tuple53._4();
            KeyBounds bounds12 = (KeyBounds)tuple53._5();
            Tuple5 tuple54 = tuple2;
            if (tuple54 == null) {
                throw new MatchError((Object)tuple54);
            }
            Extent extent2 = (Extent)tuple54._1();
            DataType cellType2 = (DataType)tuple54._2();
            CellSize cellSize2 = (CellSize)tuple54._3();
            Set crs2 = (Set)tuple54._4();
            KeyBounds bounds2 = (KeyBounds)tuple54._5();
            Tuple5 tuple55 = new Tuple5((Object)extent2, (Object)cellType2, (Object)cellSize2, (Object)crs2, (Object)bounds2);
            Tuple5 tuple56 = tuple55;
            Extent extent22 = (Extent)tuple56._1();
            DataType cellType22 = (DataType)tuple56._2();
            CellSize cellSize22 = (CellSize)tuple56._3();
            Set crs22 = (Set)tuple56._4();
            KeyBounds bounds22 = (KeyBounds)tuple56._5();
            return new Tuple5((Object)extent12.combine(extent22), (Object)cellType12.union(cellType22), (Object)(cellSize12.resolution() < cellSize22.resolution() ? cellSize12 : cellSize22), (Object)crs12.$plus$plus((GenTraversableOnce)crs22), (Object)bounds12.combine((Bounds)bounds22, evidence$7));
        });
        if (tuple5 == null) {
            throw new MatchError((Object)tuple5);
        }
        Extent extent = (Extent)tuple5._1();
        DataType cellType = (DataType)tuple5._2();
        CellSize cellSize = (CellSize)tuple5._3();
        Set crsSet = (Set)tuple5._4();
        KeyBounds bounds = (KeyBounds)tuple5._5();
        Tuple5 tuple52 = new Tuple5((Object)extent, (Object)cellType, (Object)cellSize, (Object)crsSet, (Object)bounds);
        Tuple5 tuple53 = tuple52;
        Extent extent2 = (Extent)tuple53._1();
        DataType cellType2 = (DataType)tuple53._2();
        CellSize cellSize2 = (CellSize)tuple53._3();
        Set crsSet2 = (Set)tuple53._4();
        KeyBounds bounds2 = (KeyBounds)tuple53._5();
        Predef$.MODULE$.require(crsSet2.size() == 1, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(25).append("Multiple CRS tags found: ").append(crsSet2).toString());
        return new Tuple5((Object)extent2, (Object)cellType2, (Object)cellSize2, (Object)bounds2, crsSet2.head());
    }

    public <K, V extends CellGrid<Object>, K2> TileLayerMetadata<K2> fromRDD(RDD<Tuple2<K, V>> rdd, CRS crs, LayoutDefinition layout, Function1<K, TilerKeyMethods<K, K2>> evidence$8, Component<K2, SpatialKey> evidence$9, Boundable<K2> evidence$10) {
        Tuple4<Extent, DataType, CellSize, KeyBounds<K2>> tuple4 = this.collectMetadata(rdd, evidence$8, evidence$9, evidence$10);
        if (tuple4 == null) {
            throw new MatchError(tuple4);
        }
        Extent extent = (Extent)tuple4._1();
        DataType cellType = (DataType)tuple4._2();
        KeyBounds bounds = (KeyBounds)tuple4._4();
        Tuple3 tuple3 = new Tuple3((Object)extent, (Object)cellType, (Object)bounds);
        Tuple3 tuple32 = tuple3;
        Extent extent2 = (Extent)tuple32._1();
        DataType cellType2 = (DataType)tuple32._2();
        KeyBounds bounds2 = (KeyBounds)tuple32._3();
        KeyBounds kb = bounds2.setSpatialBounds(KeyBounds$.MODULE$.apply(layout.mapTransform().apply(extent2)), evidence$9);
        return new TileLayerMetadata(cellType2, layout, extent2, crs, (Bounds)kb);
    }

    public <K, V extends CellGrid<Object>, K2> Tuple2<Object, TileLayerMetadata<K2>> fromRDD(RDD<Tuple2<K, V>> rdd, CRS crs, LayoutScheme scheme, Function1<K, TilerKeyMethods<K, K2>> evidence$11, Component<K2, SpatialKey> evidence$12, Boundable<K2> evidence$13) {
        Tuple4<Extent, DataType, CellSize, KeyBounds<K2>> tuple4 = this.collectMetadata(rdd, evidence$11, evidence$12, evidence$13);
        if (tuple4 == null) {
            throw new MatchError(tuple4);
        }
        Extent extent = (Extent)tuple4._1();
        DataType cellType = (DataType)tuple4._2();
        CellSize cellSize = (CellSize)tuple4._3();
        KeyBounds bounds = (KeyBounds)tuple4._4();
        Tuple4 tuple42 = new Tuple4((Object)extent, (Object)cellType, (Object)cellSize, (Object)bounds);
        Tuple4 tuple43 = tuple42;
        Extent extent2 = (Extent)tuple43._1();
        DataType cellType2 = (DataType)tuple43._2();
        CellSize cellSize2 = (CellSize)tuple43._3();
        KeyBounds bounds2 = (KeyBounds)tuple43._4();
        LayoutLevel layoutLevel = scheme.levelFor(extent2, cellSize2);
        if (layoutLevel == null) {
            throw new MatchError((Object)layoutLevel);
        }
        int zoom = layoutLevel.zoom();
        LayoutDefinition layout = layoutLevel.layout();
        Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)zoom), (Object)layout);
        Tuple2 tuple22 = tuple2;
        int zoom2 = tuple22._1$mcI$sp();
        LayoutDefinition layout2 = (LayoutDefinition)tuple22._2();
        KeyBounds kb = bounds2.setSpatialBounds(KeyBounds$.MODULE$.apply(layout2.mapTransform().apply(extent2)), evidence$12);
        return new Tuple2((Object)BoxesRunTime.boxToInteger((int)zoom2), (Object)new TileLayerMetadata(cellType2, layout2, extent2, crs, (Bounds)kb));
    }

    public <K, V extends CellGrid<Object>, K2> Tuple2<Object, TileLayerMetadata<K2>> fromRDD(RDD<Tuple2<K, V>> rdd, CRS crs, ZoomedLayoutScheme scheme, Function1<K, TilerKeyMethods<K, K2>> evidence$14, Component<K2, SpatialKey> evidence$15, Boundable<K2> evidence$16) {
        return this._fromRDD(rdd, crs, scheme, (Option<Object>)None$.MODULE$, evidence$14, evidence$15, evidence$16);
    }

    public <K, V extends CellGrid<Object>, K2> Tuple2<Object, TileLayerMetadata<K2>> fromRDD(RDD<Tuple2<K, V>> rdd, CRS crs, ZoomedLayoutScheme scheme, int maxZoom, Function1<K, TilerKeyMethods<K, K2>> evidence$17, Component<K2, SpatialKey> evidence$18, Boundable<K2> evidence$19) {
        return this._fromRDD(rdd, crs, scheme, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)maxZoom)), evidence$17, evidence$18, evidence$19);
    }

    private <K, V extends CellGrid<Object>, K2> Tuple2<Object, TileLayerMetadata<K2>> _fromRDD(RDD<Tuple2<K, V>> rdd, CRS crs, ZoomedLayoutScheme scheme, Option<Object> maxZoom, Function1<K, TilerKeyMethods<K, K2>> evidence$20, Component<K2, SpatialKey> evidence$21, Boundable<K2> evidence$22) {
        Tuple4<Extent, DataType, CellSize, KeyBounds<K2>> tuple4 = this.collectMetadata(rdd, evidence$20, evidence$21, evidence$22);
        if (tuple4 == null) {
            throw new MatchError(tuple4);
        }
        Extent extent = (Extent)tuple4._1();
        DataType cellType = (DataType)tuple4._2();
        CellSize cellSize = (CellSize)tuple4._3();
        KeyBounds bounds = (KeyBounds)tuple4._4();
        Tuple4 tuple42 = new Tuple4((Object)extent, (Object)cellType, (Object)cellSize, (Object)bounds);
        Tuple4 tuple43 = tuple42;
        Extent extent2 = (Extent)tuple43._1();
        DataType cellType2 = (DataType)tuple43._2();
        CellSize cellSize2 = (CellSize)tuple43._3();
        KeyBounds bounds2 = (KeyBounds)tuple43._4();
        Option<Object> option = maxZoom;
        LayoutLevel layoutLevel = option instanceof Some ? scheme.levelForZoom(BoxesRunTime.unboxToInt((Object)maxZoom.get())) : scheme.levelFor(extent2, cellSize2);
        LayoutLevel layoutLevel2 = layoutLevel;
        if (layoutLevel2 == null) {
            throw new MatchError((Object)layoutLevel2);
        }
        int zoom = layoutLevel2.zoom();
        LayoutDefinition layout = layoutLevel2.layout();
        Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)zoom), (Object)layout);
        Tuple2 tuple22 = tuple2;
        int zoom2 = tuple22._1$mcI$sp();
        LayoutDefinition layout2 = (LayoutDefinition)tuple22._2();
        KeyBounds kb = bounds2.setSpatialBounds(KeyBounds$.MODULE$.apply(layout2.mapTransform().apply(extent2)), evidence$21);
        return new Tuple2((Object)BoxesRunTime.boxToInteger((int)zoom2), (Object)new TileLayerMetadata(cellType2, layout2, extent2, crs, (Bounds)kb));
    }

    public <K, V extends CellGrid<Object>, K2> Tuple2<Object, TileLayerMetadata<K2>> fromRDD(RDD<Tuple2<K, V>> rdd, LayoutScheme scheme, GetComponent<K, ProjectedExtent> evidence$23, Function1<K, TilerKeyMethods<K, K2>> evidence$24, Component<K2, SpatialKey> evidence$25, Boundable<K2> evidence$26) {
        Tuple5<Extent, DataType, CellSize, KeyBounds<K2>, CRS> tuple5 = this.collectMetadataWithCRS(rdd, evidence$23, evidence$24, evidence$25, evidence$26);
        if (tuple5 == null) {
            throw new MatchError(tuple5);
        }
        Extent extent = (Extent)tuple5._1();
        DataType cellType = (DataType)tuple5._2();
        CellSize cellSize = (CellSize)tuple5._3();
        KeyBounds bounds = (KeyBounds)tuple5._4();
        CRS crs = (CRS)tuple5._5();
        Tuple5 tuple52 = new Tuple5((Object)extent, (Object)cellType, (Object)cellSize, (Object)bounds, (Object)crs);
        Tuple5 tuple53 = tuple52;
        Extent extent2 = (Extent)tuple53._1();
        DataType cellType2 = (DataType)tuple53._2();
        CellSize cellSize2 = (CellSize)tuple53._3();
        KeyBounds bounds2 = (KeyBounds)tuple53._4();
        CRS crs2 = (CRS)tuple53._5();
        LayoutLevel layoutLevel = scheme.levelFor(extent2, cellSize2);
        if (layoutLevel == null) {
            throw new MatchError((Object)layoutLevel);
        }
        int zoom = layoutLevel.zoom();
        LayoutDefinition layout = layoutLevel.layout();
        Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)zoom), (Object)layout);
        Tuple2 tuple22 = tuple2;
        int zoom2 = tuple22._1$mcI$sp();
        LayoutDefinition layout2 = (LayoutDefinition)tuple22._2();
        KeyBounds kb = bounds2.setSpatialBounds(KeyBounds$.MODULE$.apply(layout2.mapTransform().apply(extent2)), evidence$25);
        return new Tuple2((Object)BoxesRunTime.boxToInteger((int)zoom2), (Object)new TileLayerMetadata(cellType2, layout2, extent2, crs2, (Bounds)kb));
    }

    public <K, V extends CellGrid<Object>, K2> Tuple2<Object, TileLayerMetadata<K2>> fromRDD(RDD<Tuple2<K, V>> rdd, ZoomedLayoutScheme scheme, GetComponent<K, ProjectedExtent> evidence$27, Function1<K, TilerKeyMethods<K, K2>> evidence$28, Component<K2, SpatialKey> evidence$29, Boundable<K2> evidence$30) {
        return this._fromRDD(rdd, scheme, (Option<Object>)None$.MODULE$, evidence$27, evidence$28, evidence$29, evidence$30);
    }

    public <K, V extends CellGrid<Object>, K2> Tuple2<Object, TileLayerMetadata<K2>> fromRDD(RDD<Tuple2<K, V>> rdd, ZoomedLayoutScheme scheme, int maxZoom, GetComponent<K, ProjectedExtent> evidence$31, Function1<K, TilerKeyMethods<K, K2>> evidence$32, Component<K2, SpatialKey> evidence$33, Boundable<K2> evidence$34) {
        return this._fromRDD(rdd, scheme, (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)maxZoom)), evidence$31, evidence$32, evidence$33, evidence$34);
    }

    private <K, V extends CellGrid<Object>, K2> Tuple2<Object, TileLayerMetadata<K2>> _fromRDD(RDD<Tuple2<K, V>> rdd, ZoomedLayoutScheme scheme, Option<Object> maxZoom, GetComponent<K, ProjectedExtent> evidence$35, Function1<K, TilerKeyMethods<K, K2>> evidence$36, Component<K2, SpatialKey> evidence$37, Boundable<K2> evidence$38) {
        Tuple5<Extent, DataType, CellSize, KeyBounds<K2>, CRS> tuple5 = this.collectMetadataWithCRS(rdd, evidence$35, evidence$36, evidence$37, evidence$38);
        if (tuple5 == null) {
            throw new MatchError(tuple5);
        }
        Extent extent = (Extent)tuple5._1();
        DataType cellType = (DataType)tuple5._2();
        CellSize cellSize = (CellSize)tuple5._3();
        KeyBounds bounds = (KeyBounds)tuple5._4();
        CRS crs = (CRS)tuple5._5();
        Tuple5 tuple52 = new Tuple5((Object)extent, (Object)cellType, (Object)cellSize, (Object)bounds, (Object)crs);
        Tuple5 tuple53 = tuple52;
        Extent extent2 = (Extent)tuple53._1();
        DataType cellType2 = (DataType)tuple53._2();
        CellSize cellSize2 = (CellSize)tuple53._3();
        KeyBounds bounds2 = (KeyBounds)tuple53._4();
        CRS crs2 = (CRS)tuple53._5();
        Option<Object> option = maxZoom;
        LayoutLevel layoutLevel = option instanceof Some ? scheme.levelForZoom(BoxesRunTime.unboxToInt((Object)maxZoom.get())) : scheme.levelFor(extent2, cellSize2);
        LayoutLevel layoutLevel2 = layoutLevel;
        if (layoutLevel2 == null) {
            throw new MatchError((Object)layoutLevel2);
        }
        int zoom = layoutLevel2.zoom();
        LayoutDefinition layout = layoutLevel2.layout();
        Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)zoom), (Object)layout);
        Tuple2 tuple22 = tuple2;
        int zoom2 = tuple22._1$mcI$sp();
        LayoutDefinition layout2 = (LayoutDefinition)tuple22._2();
        KeyBounds kb = bounds2.setSpatialBounds(KeyBounds$.MODULE$.apply(layout2.mapTransform().apply(extent2)), evidence$37);
        return new Tuple2((Object)BoxesRunTime.boxToInteger((int)zoom2), (Object)new TileLayerMetadata(cellType2, layout2, extent2, crs2, (Bounds)kb));
    }

    public <K, V extends CellGrid<Object>, K2> TileLayerMetadata<K2> fromRDD(RDD<Tuple2<K, V>> rdd, LayoutDefinition layoutDefinition, GetComponent<K, ProjectedExtent> evidence$39, Function1<K, TilerKeyMethods<K, K2>> evidence$40, Component<K2, SpatialKey> evidence$41, Boundable<K2> evidence$42) {
        Tuple5<Extent, DataType, CellSize, KeyBounds<K2>, CRS> tuple5 = this.collectMetadataWithCRS(rdd, evidence$39, evidence$40, evidence$41, evidence$42);
        if (tuple5 == null) {
            throw new MatchError(tuple5);
        }
        Extent extent = (Extent)tuple5._1();
        DataType cellType = (DataType)tuple5._2();
        CellSize cellSize = (CellSize)tuple5._3();
        KeyBounds bounds = (KeyBounds)tuple5._4();
        CRS crs = (CRS)tuple5._5();
        Tuple5 tuple52 = new Tuple5((Object)extent, (Object)cellType, (Object)cellSize, (Object)bounds, (Object)crs);
        Tuple5 tuple53 = tuple52;
        Extent extent2 = (Extent)tuple53._1();
        DataType cellType2 = (DataType)tuple53._2();
        CellSize cellSize2 = (CellSize)tuple53._3();
        KeyBounds bounds2 = (KeyBounds)tuple53._4();
        CRS crs2 = (CRS)tuple53._5();
        KeyBounds kb = bounds2.setSpatialBounds(KeyBounds$.MODULE$.apply(layoutDefinition.mapTransform().apply(extent2)), evidence$41);
        return new TileLayerMetadata(cellType2, layoutDefinition, extent2, crs2, (Bounds)kb);
    }

    private CollectTileLayerMetadata$() {
        MODULE$ = this;
    }
}

