/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.spark;

import geotrellis.layer.Boundable;
import geotrellis.layer.Boundable$;
import geotrellis.layer.Implicits;
import geotrellis.layer.KeyExtractor;
import geotrellis.layer.KeyExtractor$;
import geotrellis.layer.LayoutDefinition;
import geotrellis.layer.LayoutTileSource;
import geotrellis.layer.SpaceTimeKey;
import geotrellis.layer.SpaceTimeKey$;
import geotrellis.layer.SpatialKey;
import geotrellis.layer.TileLayerMetadata;
import geotrellis.raster.ArrayTile$;
import geotrellis.raster.DataType;
import geotrellis.raster.MultibandTile;
import geotrellis.raster.MultibandTile$;
import geotrellis.raster.RasterMetadata;
import geotrellis.raster.RasterRegion;
import geotrellis.raster.RasterSource;
import geotrellis.raster.ReadingSource;
import geotrellis.raster.Tile;
import geotrellis.raster.io.geotiff.OverviewStrategy;
import geotrellis.raster.io.geotiff.OverviewStrategy$;
import geotrellis.raster.package$;
import geotrellis.raster.resample.NearestNeighbor$;
import geotrellis.raster.resample.ResampleMethod;
import geotrellis.spark.ContextRDD$;
import geotrellis.spark.RasterSummary;
import geotrellis.spark.RasterSummary$;
import geotrellis.spark.partition.SpatialPartitioner$;
import geotrellis.util.Component;
import geotrellis.vector.Extent;
import java.io.Serializable;
import org.apache.spark.Partitioner;
import org.apache.spark.SparkContext;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.locationtech.jts.geom.Geometry;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Traversable;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Range;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.mutable.ArrayBuilder;
import scala.collection.mutable.ArrayBuilder$;
import scala.collection.mutable.ArrayOps;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.Null$;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction2;

public final class RasterSourceRDD$ {
    public static RasterSourceRDD$ MODULE$;
    private final long DEFAULT_PARTITION_BYTES;

    static {
        new RasterSourceRDD$();
    }

    public final long DEFAULT_PARTITION_BYTES() {
        return this.DEFAULT_PARTITION_BYTES;
    }

    public RDD<Tuple2<SpatialKey, MultibandTile>> read(Seq<ReadingSource> readingSources, LayoutDefinition layout, SparkContext sc) {
        return this.read(readingSources, layout, this.DEFAULT_PARTITION_BYTES(), sc);
    }

    public RDD<Tuple2<SpaceTimeKey, MultibandTile>> read(Seq<ReadingSource> readingSources, LayoutDefinition layout, KeyExtractor<SpaceTimeKey> keyExtractor, SparkContext sc) {
        return this.read(readingSources, layout, keyExtractor, this.DEFAULT_PARTITION_BYTES(), sc);
    }

    public RDD<Tuple2<SpatialKey, MultibandTile>> read(Seq<ReadingSource> readingSources, LayoutDefinition layout, long partitionBytes, SparkContext sc) {
        return this.readPartitionBytes(readingSources, layout, KeyExtractor$.MODULE$.spatialKeyExtractor(), partitionBytes, geotrellis.util.package$.MODULE$.identityComponent(), ClassTag$.MODULE$.apply(SpatialKey.class), Boundable$.MODULE$.unitBoundable(), sc);
    }

    public RDD<Tuple2<SpaceTimeKey, MultibandTile>> read(Seq<ReadingSource> readingSources, LayoutDefinition layout, KeyExtractor<SpaceTimeKey> keyExtractor, long partitionBytes, SparkContext sc) {
        return this.readPartitionBytes(readingSources, layout, keyExtractor, partitionBytes, SpaceTimeKey$.MODULE$.spatialComponent(), ClassTag$.MODULE$.apply(SpaceTimeKey.class), Boundable$.MODULE$.zonedDateTimeBoundable(), sc);
    }

    public <K, M> RDD<Tuple2<K, MultibandTile>> readPartitionBytes(Seq<ReadingSource> readingSources, LayoutDefinition layout, KeyExtractor<K> keyExtractor, long partitionBytes, Component<K, SpatialKey> evidence$1, ClassTag<K> evidence$2, Boundable<M> evidence$3, SparkContext sc) {
        RDD repartitioned;
        RDD rDD;
        RasterSummary<M> summary = RasterSummary$.MODULE$.fromSeq((Seq<RasterSource>)((Seq)readingSources.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.source(), Seq$.MODULE$.canBuildFrom())), (Function1 & Serializable & scala.Serializable)rs -> keyExtractor.getMetadata(rs), evidence$3);
        DataType cellType = summary.cellType();
        int tileSize = layout.tileCols() * layout.tileRows() * cellType.bytes();
        TileLayerMetadata<K> layerMetadata = summary.toTileLayerMetadata(layout, (Function2 & Serializable & scala.Serializable)(metadata, spatialKey) -> keyExtractor.getKey(metadata, spatialKey), evidence$1);
        int maxIndex = BoxesRunTime.unboxToInt((Object)((TraversableOnce)readingSources.map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToInteger((int)RasterSourceRDD$.$anonfun$readPartitionBytes$4(x$2)), Seq$.MODULE$.canBuildFrom())).max((Ordering)Ordering.Int$.MODULE$));
        Range.Inclusive targetIndexes = RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), maxIndex);
        RDD sourcesRDD = sc.parallelize(readingSources, readingSources.size(), ClassTag$.MODULE$.apply(ReadingSource.class)).flatMap((Function1 & Serializable & scala.Serializable)rs -> {
            Object m = keyExtractor.getMetadata((RasterMetadata)rs.source());
            Function1 & Serializable & scala.Serializable tileKeyTransform = (Function1 & Serializable & scala.Serializable)sk -> keyExtractor.getKey(m, sk);
            Implicits.TileToLayoutOps qual$1 = geotrellis.layer.package$.MODULE$.TileToLayoutOps(rs.source());
            LayoutDefinition x$1 = layout;
            Function1 & Serializable & scala.Serializable x$2 = tileKeyTransform;
            ResampleMethod x$32 = qual$1.tileToLayout$default$3();
            OverviewStrategy x$42 = qual$1.tileToLayout$default$4();
            LayoutTileSource layoutSource = qual$1.tileToLayout(x$1, (Function1)x$2, x$32, x$42, evidence$1);
            Set keys = layoutSource.keys();
            return (TraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(MODULE$.partition((Traversable)keys, partitionBytes, (Function1)(Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToLong((long)tileSize), (ClassTag)evidence$2))).flatMap((Function1 & Serializable & scala.Serializable)x$4 -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.genericArrayOps(x$4).flatMap((Function1 & Serializable & scala.Serializable)key -> (Map)rs.sourceToTargetBand().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                int sourceBand = tuple2._1$mcI$sp();
                int targetBand = tuple2._2$mcI$sp();
                Tuple2 tuple22 = new Tuple2(key, (Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)targetBand), (Object)layoutSource.read(key, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{sourceBand})))));
                return tuple22;
            }, Map$.MODULE$.canBuildFrom()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).toTraversable(), Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        sourcesRDD.persist();
        int count = (int)sourcesRDD.count();
        if (count > new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sourcesRDD.partitions())).size()) {
            int x$5 = count;
            Ordering x$6 = sourcesRDD.repartition$default$2(x$5);
            rDD = sourcesRDD.repartition(x$5, x$6);
        } else {
            rDD = sourcesRDD;
        }
        RDD x$7 = repartitioned = rDD;
        ClassTag x$8 = evidence$2;
        ClassTag x$9 = ClassTag$.MODULE$.apply(Tuple2.class);
        Null$ x$10 = RDD$.MODULE$.rddToPairRDDFunctions$default$4(x$7);
        RDD groupedSourcesRDD = RDD$.MODULE$.rddToPairRDDFunctions(x$7, x$8, x$9, null).groupByKey();
        RDD result = groupedSourcesRDD.mapPartitions(arg_0 -> RasterSourceRDD$.$anonfun$readPartitionBytes$11((Seq)targetIndexes, cellType, layout, arg_0), true, ClassTag$.MODULE$.apply(Tuple2.class));
        sourcesRDD.unpersist(sourcesRDD.unpersist$default$1());
        return ContextRDD$.MODULE$.apply(result, layerMetadata);
    }

    public RDD<Tuple2<SpatialKey, MultibandTile>> read(RDD<ReadingSource> readingSourcesRDD, LayoutDefinition layout, Option<Partitioner> partitioner, SparkContext sc) {
        return this.read(readingSourcesRDD, layout, KeyExtractor$.MODULE$.spatialKeyExtractor(), partitioner, geotrellis.util.package$.MODULE$.identityComponent(), ClassTag$.MODULE$.apply(SpatialKey.class), Boundable$.MODULE$.unitBoundable(), sc);
    }

    public <K, M> RDD<Tuple2<K, MultibandTile>> read(RDD<ReadingSource> readingSourcesRDD, LayoutDefinition layout, KeyExtractor<K> keyExtractor, Option<Partitioner> partitioner, Component<K, SpatialKey> evidence$4, ClassTag<K> evidence$5, Boundable<M> evidence$6, SparkContext sc) {
        RDD rasterSourcesRDD = readingSourcesRDD.map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.source(), ClassTag$.MODULE$.apply(RasterSource.class));
        RasterSummary<M> summary = RasterSummary$.MODULE$.fromRDD((RDD<RasterSource>)rasterSourcesRDD, (Function1 & Serializable & scala.Serializable)rs -> keyExtractor.getMetadata(rs), evidence$6);
        DataType cellType = summary.cellType();
        TileLayerMetadata<K> layerMetadata = summary.toTileLayerMetadata(layout, (Function2 & Serializable & scala.Serializable)(metadata, spatialKey) -> keyExtractor.getKey(metadata, spatialKey), evidence$4);
        int maxIndex = BoxesRunTime.unboxToInt((Object)readingSourcesRDD.map((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToInteger((int)RasterSourceRDD$.$anonfun$read$4(x$7)), ClassTag$.MODULE$.Int()).reduce((Function2)(JFunction2.mcIII.sp & Serializable & scala.Serializable)(x$8, x$9) -> RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(x$8), x$9)));
        Range.Inclusive targetIndexes = RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), maxIndex);
        RDD keyedRDD = readingSourcesRDD.mapPartitions((Function1 & Serializable & scala.Serializable)partition -> partition.flatMap((Function1 & Serializable & scala.Serializable)rs -> {
            Object m = keyExtractor.getMetadata((RasterMetadata)rs.source());
            Function1 & Serializable & scala.Serializable tileKeyTransform = (Function1 & Serializable & scala.Serializable)sk -> keyExtractor.getKey(m, sk);
            Implicits.TileToLayoutOps qual$1 = geotrellis.layer.package$.MODULE$.TileToLayoutOps(rs.source());
            LayoutDefinition x$1 = layout;
            Function1 & Serializable & scala.Serializable x$2 = tileKeyTransform;
            ResampleMethod x$3 = qual$1.tileToLayout$default$3();
            OverviewStrategy x$4 = qual$1.tileToLayout$default$4();
            LayoutTileSource layoutSource = qual$1.tileToLayout(x$1, (Function1)x$2, x$3, x$4, evidence$4);
            return (GenTraversableOnce)layoutSource.keys().flatMap((Function1 & Serializable & scala.Serializable)key -> (Map)rs.sourceToTargetBand().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                int sourceBand = tuple2._1$mcI$sp();
                int targetBand = tuple2._2$mcI$sp();
                Tuple2 tuple22 = new Tuple2(key, (Object)new Tuple2((Object)BoxesRunTime.boxToInteger((int)targetBand), (Object)layoutSource.read(key, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{sourceBand})))));
                return tuple22;
            }, Map$.MODULE$.canBuildFrom()), Set$.MODULE$.canBuildFrom());
        }), readingSourcesRDD.mapPartitions$default$2(), ClassTag$.MODULE$.apply(Tuple2.class));
        int partitionCount = scala.math.package$.MODULE$.max(keyedRDD.getNumPartitions(), summary.estimatePartitionsNumber());
        RDD x$5 = keyedRDD;
        ClassTag<K> x$62 = evidence$5;
        ClassTag x$72 = ClassTag$.MODULE$.apply(Tuple2.class);
        Null$ x$82 = RDD$.MODULE$.rddToPairRDDFunctions$default$4(x$5);
        RDD groupedRDD = RDD$.MODULE$.rddToPairRDDFunctions(x$5, x$62, x$72, null).groupByKey((Partitioner)partitioner.getOrElse((Function0 & Serializable & scala.Serializable)() -> SpatialPartitioner$.MODULE$.apply(partitionCount, evidence$4)));
        RDD result = groupedRDD.mapPartitions(arg_0 -> RasterSourceRDD$.$anonfun$read$12((Seq)targetIndexes, cellType, layout, arg_0), true, ClassTag$.MODULE$.apply(Tuple2.class));
        return ContextRDD$.MODULE$.apply(result, layerMetadata);
    }

    public Option<Partitioner> read$default$3() {
        return None$.MODULE$;
    }

    public RDD<Tuple2<SpatialKey, MultibandTile>> tiledLayerRDD(RDD<RasterSource> sources, LayoutDefinition layout, SparkContext sc) {
        return this.tiledLayerRDD(sources, layout, (KeyExtractor)KeyExtractor$.MODULE$.spatialKeyExtractor(), (ResampleMethod)NearestNeighbor$.MODULE$, (Option)None$.MODULE$, (Option<Partitioner>)None$.MODULE$, (Component)geotrellis.util.package$.MODULE$.identityComponent(), (Boundable)SpatialKey.Boundable$.MODULE$, (ClassTag)ClassTag$.MODULE$.apply(SpatialKey.class), (Boundable)Boundable$.MODULE$.unitBoundable(), sc);
    }

    public RDD<Tuple2<SpatialKey, MultibandTile>> tiledLayerRDD(RDD<RasterSource> sources, LayoutDefinition layout, ResampleMethod resampleMethod, SparkContext sc) {
        return this.tiledLayerRDD(sources, layout, (KeyExtractor)KeyExtractor$.MODULE$.spatialKeyExtractor(), resampleMethod, (Option)None$.MODULE$, (Option<Partitioner>)None$.MODULE$, (Component)geotrellis.util.package$.MODULE$.identityComponent(), (Boundable)SpatialKey.Boundable$.MODULE$, (ClassTag)ClassTag$.MODULE$.apply(SpatialKey.class), (Boundable)Boundable$.MODULE$.unitBoundable(), sc);
    }

    public <K, M> RDD<Tuple2<K, MultibandTile>> tiledLayerRDD(RDD<RasterSource> sources, LayoutDefinition layout, KeyExtractor<K> keyExtractor, ResampleMethod resampleMethod, Option<RasterSummary<M>> rasterSummary, Option<Partitioner> partitioner, Component<K, SpatialKey> evidence$7, Boundable<K> evidence$8, ClassTag<K> evidence$9, Boundable<M> evidence$10, SparkContext sc) {
        RasterSummary summary = (RasterSummary)rasterSummary.getOrElse((Function0 & Serializable & scala.Serializable)() -> RasterSummary$.MODULE$.fromRDD(sources, (Function1 & Serializable & scala.Serializable)rs -> keyExtractor.getMetadata(rs), evidence$10));
        TileLayerMetadata<K> layerMetadata = summary.toTileLayerMetadata(layout, (Function2 & Serializable & scala.Serializable)(metadata, spatialKey) -> keyExtractor.getKey(metadata, spatialKey), evidence$7);
        RDD tiledLayoutSourceRDD = sources.map((Function1 & Serializable & scala.Serializable)rs -> {
            Object m = keyExtractor.getMetadata((RasterMetadata)rs);
            Function1 & Serializable & scala.Serializable tileKeyTransform = (Function1 & Serializable & scala.Serializable)sk -> keyExtractor.getKey(m, sk);
            Implicits.TileToLayoutOps qual$1 = geotrellis.layer.package$.MODULE$.TileToLayoutOps(rs);
            LayoutDefinition x$1 = layout;
            Function1 & Serializable & scala.Serializable x$2 = tileKeyTransform;
            ResampleMethod x$3 = qual$1.tileToLayout$default$3();
            OverviewStrategy x$4 = qual$1.tileToLayout$default$4();
            return qual$1.tileToLayout(x$1, (Function1)x$2, x$3, x$4, evidence$7);
        }, ClassTag$.MODULE$.apply(LayoutTileSource.class));
        RDD rasterRegionRDD = tiledLayoutSourceRDD.flatMap((Function1 & Serializable & scala.Serializable)x$11 -> x$11.keyedRasterRegions(), ClassTag$.MODULE$.apply(Tuple2.class));
        int partitionCount = scala.math.package$.MODULE$.max(rasterRegionRDD.getNumPartitions(), summary.estimatePartitionsNumber());
        RDD x$5 = rasterRegionRDD;
        ClassTag<K> x$6 = evidence$9;
        ClassTag x$7 = ClassTag$.MODULE$.apply(RasterRegion.class);
        Null$ x$8 = RDD$.MODULE$.rddToPairRDDFunctions$default$4(x$5);
        RDD x$9 = RDD$.MODULE$.rddToPairRDDFunctions(x$5, x$6, x$7, null).groupByKey((Partitioner)partitioner.getOrElse((Function0 & Serializable & scala.Serializable)() -> SpatialPartitioner$.MODULE$.apply(partitionCount, evidence$7)));
        ClassTag<K> x$10 = evidence$9;
        ClassTag x$112 = ClassTag$.MODULE$.apply(Iterable.class);
        Null$ x$12 = RDD$.MODULE$.rddToPairRDDFunctions$default$4(x$9);
        RDD tiledRDD = RDD$.MODULE$.rddToPairRDDFunctions(x$9, x$10, x$112, null).mapValues((Function1 & Serializable & scala.Serializable)iter -> MultibandTile$.MODULE$.apply((Traversable)iter.flatMap((Function1 & Serializable & scala.Serializable)x$12 -> (Seq)Option$.MODULE$.option2Iterable(x$12.raster()).toSeq().flatMap((Function1 & Serializable & scala.Serializable)x$13 -> ((MultibandTile)x$13.tile()).bands(), Seq$.MODULE$.canBuildFrom()), Iterable$.MODULE$.canBuildFrom())));
        return ContextRDD$.MODULE$.apply(tiledRDD, layerMetadata);
    }

    public <K, M> ResampleMethod tiledLayerRDD$default$4() {
        return NearestNeighbor$.MODULE$;
    }

    public <K, M> None$ tiledLayerRDD$default$5() {
        return None$.MODULE$;
    }

    public <K, M> Option<Partitioner> tiledLayerRDD$default$6() {
        return None$.MODULE$;
    }

    public RDD<Tuple2<SpatialKey, MultibandTile>> spatial(Seq<RasterSource> sources, LayoutDefinition layout, OverviewStrategy strategy, long partitionBytes, SparkContext sc) {
        return this.apply(sources, layout, (KeyExtractor)KeyExtractor$.MODULE$.spatialKeyExtractor(), partitionBytes, strategy, (Component)geotrellis.util.package$.MODULE$.identityComponent(), (Boundable)SpatialKey.Boundable$.MODULE$, (ClassTag)ClassTag$.MODULE$.apply(SpatialKey.class), (Boundable)Boundable$.MODULE$.unitBoundable(), sc);
    }

    public RDD<Tuple2<SpatialKey, MultibandTile>> spatial(RasterSource source, LayoutDefinition layout, SparkContext sc) {
        return this.spatial((Seq<RasterSource>)((Seq)new .colon.colon((Object)source, (List)Nil$.MODULE$)), layout, this.spatial$default$3(), this.spatial$default$4(), sc);
    }

    public OverviewStrategy spatial$default$3() {
        return OverviewStrategy$.MODULE$.DEFAULT();
    }

    public long spatial$default$4() {
        return this.DEFAULT_PARTITION_BYTES();
    }

    public RDD<Tuple2<SpaceTimeKey, MultibandTile>> temporal(Seq<RasterSource> sources, LayoutDefinition layout, KeyExtractor<SpaceTimeKey> keyExtractor, OverviewStrategy strategy, long partitionBytes, SparkContext sc) {
        return this.apply(sources, layout, (KeyExtractor)keyExtractor, partitionBytes, strategy, (Component)SpaceTimeKey$.MODULE$.spatialComponent(), (Boundable)SpaceTimeKey.Boundable$.MODULE$, (ClassTag)ClassTag$.MODULE$.apply(SpaceTimeKey.class), (Boundable)Boundable$.MODULE$.zonedDateTimeBoundable(), sc);
    }

    public RDD<Tuple2<SpaceTimeKey, MultibandTile>> temporal(RasterSource source, LayoutDefinition layout, KeyExtractor<SpaceTimeKey> keyExtractor, SparkContext sc) {
        return this.temporal((Seq<RasterSource>)((Seq)new .colon.colon((Object)source, (List)Nil$.MODULE$)), layout, keyExtractor, this.temporal$default$4(), this.temporal$default$5(), sc);
    }

    public OverviewStrategy temporal$default$4() {
        return OverviewStrategy$.MODULE$.DEFAULT();
    }

    public long temporal$default$5() {
        return this.DEFAULT_PARTITION_BYTES();
    }

    public <K, M> RDD<Tuple2<K, MultibandTile>> apply(Seq<RasterSource> sources, LayoutDefinition layout, KeyExtractor<K> keyExtractor, long partitionBytes, OverviewStrategy strategy, Component<K, SpatialKey> evidence$11, Boundable<K> evidence$12, ClassTag<K> evidence$13, Boundable<M> evidence$14, SparkContext sc) {
        RDD rDD;
        RasterSummary<M> summary = RasterSummary$.MODULE$.fromSeq(sources, (Function1 & Serializable & scala.Serializable)rs -> keyExtractor.getMetadata(rs), evidence$14);
        Extent extent = summary.extent();
        DataType cellType = summary.cellType();
        int tileSize = layout.tileCols() * layout.tileRows() * cellType.bytes();
        TileLayerMetadata<K> layerMetadata = summary.toTileLayerMetadata(layout, (Function2 & Serializable & scala.Serializable)(metadata, spatialKey) -> keyExtractor.getKey(metadata, spatialKey), evidence$11);
        RDD sourcesRDD = sc.parallelize(sources, sc.parallelize$default$2(), ClassTag$.MODULE$.apply(RasterSource.class)).flatMap((Function1 & Serializable & scala.Serializable)source -> {
            Traversable traversable;
            Option option = extent.intersection(source.extent());
            if (option instanceof Some) {
                Some some = (Some)option;
                Extent intersection = (Extent)some.value();
                traversable = layout.mapTransform().keysForGeometry((Geometry)intersection.toPolygon());
            } else if (None$.MODULE$.equals(option)) {
                traversable = (Traversable)Nil$.MODULE$;
            } else {
                throw new MatchError((Object)option);
            }
            Traversable keys = traversable;
            return (TraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(MODULE$.partition(keys, partitionBytes, (Function1 & Serializable & scala.Serializable)x$14 -> BoxesRunTime.boxToLong((long)tileSize), ClassTag$.MODULE$.apply(SpatialKey.class)))).map((Function1 & Serializable & scala.Serializable)res -> new Tuple2(source, res), Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        sourcesRDD.persist();
        int count = (int)sourcesRDD.count();
        if (count > new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sourcesRDD.partitions())).size()) {
            int x$1 = count;
            Ordering x$2 = sourcesRDD.repartition$default$2(x$1);
            rDD = sourcesRDD.repartition(x$1, x$2);
        } else {
            rDD = sourcesRDD;
        }
        RDD repartitioned = rDD;
        RDD result = repartitioned.flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            RasterSource source = (RasterSource)tuple2._1();
            SpatialKey[] keys = (SpatialKey[])tuple2._2();
            Object m = keyExtractor.getMetadata((RasterMetadata)source);
            Function1 & Serializable & scala.Serializable tileKeyTransform = (Function1 & Serializable & scala.Serializable)sk -> keyExtractor.getKey(m, sk);
            LayoutTileSource tileSource = geotrellis.layer.package$.MODULE$.TileToLayoutOps(source).tileToLayout(layout, (Function1)tileKeyTransform, (ResampleMethod)NearestNeighbor$.MODULE$, strategy, evidence$11);
            Iterator iterator = tileSource.readAll(Predef$.MODULE$.genericArrayOps(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])keys)).map((Function1)tileKeyTransform, Array$.MODULE$.canBuildFrom(evidence$13))).iterator());
            return iterator;
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        sourcesRDD.unpersist(sourcesRDD.unpersist$default$1());
        return ContextRDD$.MODULE$.apply(result, layerMetadata);
    }

    public <K, M> long apply$default$4() {
        return this.DEFAULT_PARTITION_BYTES();
    }

    public <K, M> OverviewStrategy apply$default$5() {
        return OverviewStrategy$.MODULE$.DEFAULT();
    }

    private <T> Object[] partition(Traversable<T> chunks, long maxPartitionSize, Function1<T, Object> chunkSize, ClassTag<T> evidence$15) {
        Object[] objectArray;
        if (chunks.isEmpty()) {
            objectArray = (Object[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(evidence$15.runtimeClass())));
        } else {
            ArrayBuilder partition = ArrayBuilder$.MODULE$.make(evidence$15);
            partition.sizeHintBounded(128, chunks);
            LongRef partitionSize = LongRef.create((long)0L);
            LongRef partitionCount = LongRef.create((long)0L);
            ArrayBuilder partitions = ArrayBuilder$.MODULE$.make(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(evidence$15.runtimeClass())));
            chunks.foreach((Function1 & Serializable & scala.Serializable)chunk -> {
                RasterSourceRDD$.$anonfun$partition$1(partitionCount, partitionSize, chunkSize, maxPartitionSize, partition, partitions, chunk);
                return BoxedUnit.UNIT;
            });
            RasterSourceRDD$.finalizePartition$1(partition, partitions, partitionSize, partitionCount);
            objectArray = (Object[])partitions.result();
        }
        return objectArray;
    }

    private <T> Function1<T, Object> partition$default$3(Traversable<T> chunks, long maxPartitionSize) {
        return (Function1 & Serializable & scala.Serializable)c -> BoxesRunTime.boxToLong((long)RasterSourceRDD$.$anonfun$partition$default$3$1(c));
    }

    private static final Tile getNoDataTile$1(DataType cellType$1, LayoutDefinition layout$1) {
        return package$.MODULE$.withTileHydrologyMethods((Tile)ArrayTile$.MODULE$.alloc(cellType$1, layout$1.tileCols(), layout$1.tileRows())).fill(-2.147483648E9).interpretAs(cellType$1);
    }

    public static final /* synthetic */ int $anonfun$readPartitionBytes$4(ReadingSource x$2) {
        return BoxesRunTime.unboxToInt((Object)x$2.sourceToTargetBand().values().max((Ordering)Ordering.Int$.MODULE$));
    }

    public static final /* synthetic */ Tile $anonfun$readPartitionBytes$14(Map mappedBands$1, Tile noDataTile$1, int index) {
        Tile tile;
        Option option = (Option)mappedBands$1.getOrElse((Object)BoxesRunTime.boxToInteger((int)index), (Function0 & Serializable & scala.Serializable)() -> None$.MODULE$);
        if (option instanceof Some) {
            Some some = (Some)option;
            MultibandTile multibandTile = (MultibandTile)some.value();
            tile = multibandTile.band(0);
        } else if (None$.MODULE$.equals(option)) {
            tile = noDataTile$1;
        } else {
            throw new MatchError((Object)option);
        }
        return tile;
    }

    public static final /* synthetic */ Iterator $anonfun$readPartitionBytes$11(Seq targetIndexes$1, DataType cellType$1, LayoutDefinition layout$1, Iterator partition) {
        Tile noDataTile = RasterSourceRDD$.getNoDataTile$1(cellType$1, layout$1);
        return partition.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Object key = tuple2._1();
            Iterable iter = (Iterable)tuple2._2();
            Map mappedBands = ((TraversableOnce)iter.toSeq().sortBy((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToInteger((int)x$5._1$mcI$sp()), (Ordering)Ordering.Int$.MODULE$)).toMap(Predef$.MODULE$.$conforms());
            Seq tiles = (Seq)targetIndexes$1.map((Function1 & Serializable & scala.Serializable)index -> RasterSourceRDD$.$anonfun$readPartitionBytes$14(mappedBands, noDataTile, BoxesRunTime.unboxToInt((Object)index)), Seq$.MODULE$.canBuildFrom());
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(key), (Object)MultibandTile$.MODULE$.apply((Traversable)tiles));
            return tuple22;
        });
    }

    private static final Tile getNoDataTile$2(DataType cellType$2, LayoutDefinition layout$2) {
        return package$.MODULE$.withTileHydrologyMethods((Tile)ArrayTile$.MODULE$.alloc(cellType$2, layout$2.tileCols(), layout$2.tileRows())).fill(-2.147483648E9).interpretAs(cellType$2);
    }

    public static final /* synthetic */ int $anonfun$read$4(ReadingSource x$7) {
        return BoxesRunTime.unboxToInt((Object)x$7.sourceToTargetBand().values().max((Ordering)Ordering.Int$.MODULE$));
    }

    public static final /* synthetic */ Tile $anonfun$read$15(Map mappedBands$2, Tile noDataTile$2, int index) {
        Tile tile;
        Option option = (Option)mappedBands$2.getOrElse((Object)BoxesRunTime.boxToInteger((int)index), (Function0 & Serializable & scala.Serializable)() -> None$.MODULE$);
        if (option instanceof Some) {
            Some some = (Some)option;
            MultibandTile multibandTile = (MultibandTile)some.value();
            tile = multibandTile.band(0);
        } else if (None$.MODULE$.equals(option)) {
            tile = noDataTile$2;
        } else {
            throw new MatchError((Object)option);
        }
        return tile;
    }

    public static final /* synthetic */ Iterator $anonfun$read$12(Seq targetIndexes$2, DataType cellType$2, LayoutDefinition layout$2, Iterator partition) {
        Tile noDataTile = RasterSourceRDD$.getNoDataTile$2(cellType$2, layout$2);
        return partition.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Object key = tuple2._1();
            Iterable iter = (Iterable)tuple2._2();
            Map mappedBands = ((TraversableOnce)iter.toSeq().sortBy((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToInteger((int)x$10._1$mcI$sp()), (Ordering)Ordering.Int$.MODULE$)).toMap(Predef$.MODULE$.$conforms());
            Seq tiles = (Seq)targetIndexes$2.map((Function1 & Serializable & scala.Serializable)index -> RasterSourceRDD$.$anonfun$read$15(mappedBands, noDataTile, BoxesRunTime.unboxToInt((Object)index)), Seq$.MODULE$.canBuildFrom());
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(key), (Object)MultibandTile$.MODULE$.apply((Traversable)tiles));
            return tuple22;
        });
    }

    private static final void finalizePartition$1(ArrayBuilder partition$1, ArrayBuilder partitions$1, LongRef partitionSize$1, LongRef partitionCount$3) {
        Object res = partition$1.result();
        Object object = Predef$.MODULE$.genericArrayOps(res).nonEmpty() ? partitions$1.$plus$eq(res) : BoxedUnit.UNIT;
        partition$1.clear();
        partitionSize$1.elem = 0L;
        partitionCount$3.elem = 0L;
    }

    private static final void addToPartition$1(Object chunk, ArrayBuilder partition$1, LongRef partitionSize$1, Function1 chunkSize$1, LongRef partitionCount$3) {
        partition$1.$plus$eq(chunk);
        partitionSize$1.elem += BoxesRunTime.unboxToLong((Object)chunkSize$1.apply(chunk));
        ++partitionCount$3.elem;
    }

    public static final /* synthetic */ void $anonfun$partition$1(LongRef partitionCount$3, LongRef partitionSize$1, Function1 chunkSize$1, long maxPartitionSize$1, ArrayBuilder partition$1, ArrayBuilder partitions$1, Object chunk) {
        if (partitionCount$3.elem == 0L || partitionSize$1.elem + BoxesRunTime.unboxToLong((Object)chunkSize$1.apply(chunk)) < maxPartitionSize$1) {
            RasterSourceRDD$.addToPartition$1(chunk, partition$1, partitionSize$1, chunkSize$1, partitionCount$3);
        } else {
            RasterSourceRDD$.finalizePartition$1(partition$1, partitions$1, partitionSize$1, partitionCount$3);
            RasterSourceRDD$.addToPartition$1(chunk, partition$1, partitionSize$1, chunkSize$1, partitionCount$3);
        }
    }

    public static final /* synthetic */ long $anonfun$partition$default$3$1(Object c) {
        return 1L;
    }

    private RasterSourceRDD$() {
        MODULE$ = this;
        this.DEFAULT_PARTITION_BYTES = 0x8000000L;
    }
}

