/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.spark.buffer;

import geotrellis.layer.SpatialKey;
import geotrellis.layer.buffer.BufferTiles;
import geotrellis.raster.CellGrid;
import geotrellis.raster.GridBounds;
import geotrellis.raster.GridBounds$;
import geotrellis.raster.buffer.BufferSizes;
import geotrellis.raster.buffer.BufferedTile;
import geotrellis.raster.buffer.Direction;
import geotrellis.raster.crop.Crop;
import geotrellis.raster.crop.CropMethods;
import geotrellis.raster.stitch.Stitcher;
import geotrellis.util.Component;
import geotrellis.util.GetComponent;
import geotrellis.util.SetComponent;
import geotrellis.util.package$;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import org.apache.log4j.Logger;
import org.apache.spark.Partitioner;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;
import scala.runtime.java8.JFunction0;

public final class BufferTilesRDD$
implements BufferTiles {
    public static BufferTilesRDD$ MODULE$;
    private final Logger logger;

    static {
        new BufferTilesRDD$();
    }

    public <K, V extends CellGrid<Object>> Seq<Tuple2<K, Tuple2<Direction, V>>> collectWithTileNeighbors(K key, V tile, Function1<SpatialKey, Object> includeKey, Function1<SpatialKey, BufferSizes> getBufferSizes, Component<K, SpatialKey> evidence$1, Function1<V, CropMethods<V>> evidence$2) {
        return BufferTiles.collectWithTileNeighbors$((BufferTiles)this, key, tile, includeKey, getBufferSizes, evidence$1, evidence$2);
    }

    public <K, V extends CellGrid<Object>> Seq<Tuple2<K, BufferedTile<V>>> bufferWithNeighbors(Seq<Tuple2<K, Seq<Tuple2<Direction, V>>>> seq, Component<K, SpatialKey> evidence$3, Stitcher<V> evidence$4) {
        return BufferTiles.bufferWithNeighbors$((BufferTiles)this, seq, evidence$3, evidence$4);
    }

    public <K, V extends CellGrid<Object>> Seq<Tuple2<K, BufferedTile<V>>> apply(Seq<Tuple2<K, V>> seq, int bufferSize, Component<K, SpatialKey> evidence$5, Stitcher<V> evidence$6, Function1<V, CropMethods<V>> evidence$7) {
        return BufferTiles.apply$((BufferTiles)this, seq, (int)bufferSize, evidence$5, evidence$6, evidence$7);
    }

    public <K, V extends CellGrid<Object>> Seq<Tuple2<K, BufferedTile<V>>> apply(Seq<Tuple2<K, V>> seq, Function1<K, BufferSizes> getBufferSizes, Component<K, SpatialKey> evidence$8, Stitcher<V> evidence$9, Function1<V, CropMethods<V>> evidence$10) {
        return BufferTiles.apply$((BufferTiles)this, seq, getBufferSizes, evidence$8, evidence$9, evidence$10);
    }

    public <K, V extends CellGrid<Object>> Seq<Tuple2<K, BufferedTile<V>>> apply(Seq<Tuple2<K, V>> seq, Seq<Tuple2<K, BufferSizes>> bufferSizesPerKey, Component<K, SpatialKey> evidence$11, Stitcher<V> evidence$12, Function1<V, CropMethods<V>> evidence$13) {
        return BufferTiles.apply$((BufferTiles)this, seq, bufferSizesPerKey, evidence$11, evidence$12, evidence$13);
    }

    public <K, V extends CellGrid<Object>> Seq<Tuple2<K, BufferedTile<V>>> apply(Seq<Tuple2<K, V>> seq, int bufferSize, GridBounds<Object> layerBounds, Component<K, SpatialKey> evidence$14, Stitcher<V> evidence$15, Function1<V, CropMethods<V>> evidence$16) {
        return BufferTiles.apply$((BufferTiles)this, seq, (int)bufferSize, layerBounds, evidence$14, evidence$15, evidence$16);
    }

    public void geotrellis$layer$buffer$BufferTiles$_setter_$logger_$eq(Logger x$1) {
    }

    public Logger logger() {
        return this.logger;
    }

    public <K, V extends CellGrid<Object>> RDD<Tuple2<K, BufferedTile<V>>> bufferWithNeighbors(RDD<Tuple2<K, Iterable<Tuple2<Direction, V>>>> rdd, Component<K, SpatialKey> evidence$1, ClassTag<K> evidence$2, Stitcher<V> evidence$3, ClassTag<V> evidence$4) {
        RDD<Tuple2<K, Iterable<Tuple2<Direction, V>>>> x$1 = rdd;
        ClassTag<K> x$2 = evidence$2;
        ClassTag x$3 = ClassTag$.MODULE$.apply(Iterable.class);
        Null$ x$4 = RDD$.MODULE$.rddToPairRDDFunctions$default$4(x$1);
        RDD r = RDD$.MODULE$.rddToPairRDDFunctions(x$1, x$2, x$3, null).flatMapValues((Function1 & Serializable & scala.Serializable)neighbors -> Option$.MODULE$.option2Iterable(neighbors.find((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)BufferTilesRDD$.$anonfun$bufferWithNeighbors$2(x$1))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            CellGrid centerTile = (CellGrid)tuple2._2();
            BufferSizes bufferSizes = (BufferSizes)neighbors.foldLeft((Object)new BufferSizes(0, 0, 0, 0), (Function2 & Serializable & scala.Serializable)(acc, tup) -> {
                BufferSizes bufferSizes;
                Tuple2 tuple2 = tup;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Direction direction = (Direction)tuple2._1();
                CellGrid slice = (CellGrid)tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)direction, (Object)slice);
                Tuple2 tuple23 = tuple22;
                Direction direction2 = (Direction)tuple23._1();
                CellGrid slice2 = (CellGrid)tuple23._2();
                Direction direction3 = direction2;
                if (Direction.Left$.MODULE$.equals(direction3)) {
                    bufferSizes = acc.copy(BoxesRunTime.unboxToInt((Object)slice2.cols()), acc.copy$default$2(), acc.copy$default$3(), acc.copy$default$4());
                } else if (Direction.Right$.MODULE$.equals(direction3)) {
                    int x$5 = BoxesRunTime.unboxToInt((Object)slice2.cols());
                    int x$6 = acc.copy$default$1();
                    int x$7 = acc.copy$default$3();
                    int x$8 = acc.copy$default$4();
                    bufferSizes = acc.copy(x$6, x$5, x$7, x$8);
                } else if (Direction.Top$.MODULE$.equals(direction3)) {
                    int x$9 = BoxesRunTime.unboxToInt((Object)slice2.rows());
                    int x$10 = acc.copy$default$1();
                    int x$11 = acc.copy$default$2();
                    int x$12 = acc.copy$default$3();
                    bufferSizes = acc.copy(x$10, x$11, x$12, x$9);
                } else if (Direction.Bottom$.MODULE$.equals(direction3)) {
                    int x$13 = BoxesRunTime.unboxToInt((Object)slice2.rows());
                    int x$14 = acc.copy$default$1();
                    int x$15 = acc.copy$default$2();
                    int x$16 = acc.copy$default$4();
                    bufferSizes = acc.copy(x$14, x$15, x$13, x$16);
                } else if (Direction.BottomRight$.MODULE$.equals(direction3)) {
                    int x$17 = BoxesRunTime.unboxToInt((Object)slice2.rows());
                    int x$18 = BoxesRunTime.unboxToInt((Object)slice2.cols());
                    int x$19 = acc.copy$default$1();
                    int x$20 = acc.copy$default$4();
                    bufferSizes = acc.copy(x$19, x$18, x$17, x$20);
                } else if (Direction.BottomLeft$.MODULE$.equals(direction3)) {
                    int x$21 = BoxesRunTime.unboxToInt((Object)slice2.rows());
                    int x$22 = BoxesRunTime.unboxToInt((Object)slice2.cols());
                    int x$23 = acc.copy$default$2();
                    int x$24 = acc.copy$default$4();
                    bufferSizes = acc.copy(x$22, x$23, x$21, x$24);
                } else if (Direction.TopRight$.MODULE$.equals(direction3)) {
                    int x$25 = BoxesRunTime.unboxToInt((Object)slice2.rows());
                    int x$26 = BoxesRunTime.unboxToInt((Object)slice2.cols());
                    int x$27 = acc.copy$default$1();
                    int x$28 = acc.copy$default$3();
                    bufferSizes = acc.copy(x$27, x$26, x$28, x$25);
                } else if (Direction.TopLeft$.MODULE$.equals(direction3)) {
                    int x$29 = BoxesRunTime.unboxToInt((Object)slice2.rows());
                    int x$30 = BoxesRunTime.unboxToInt((Object)slice2.cols());
                    int x$31 = acc.copy$default$2();
                    int x$32 = acc.copy$default$3();
                    bufferSizes = acc.copy(x$30, x$31, x$32, x$29);
                } else {
                    bufferSizes = acc;
                }
                return bufferSizes;
            });
            Iterable pieces = (Iterable)neighbors.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                Tuple2.mcII.sp sp2;
                CellGrid slice;
                Tuple2 tuple2 = x0$2;
                if (tuple2 != null) {
                    Tuple2.mcII.sp sp3;
                    Direction direction = (Direction)tuple2._1();
                    slice = (CellGrid)tuple2._2();
                    Direction direction2 = direction;
                    if (Direction.Center$.MODULE$.equals(direction2)) {
                        sp3 = new Tuple2.mcII.sp(bufferSizes.left(), bufferSizes.top());
                    } else if (Direction.Left$.MODULE$.equals(direction2)) {
                        sp3 = new Tuple2.mcII.sp(0, bufferSizes.top());
                    } else if (Direction.Right$.MODULE$.equals(direction2)) {
                        sp3 = new Tuple2.mcII.sp(bufferSizes.left() + BoxesRunTime.unboxToInt((Object)centerTile.cols()), bufferSizes.top());
                    } else if (Direction.Top$.MODULE$.equals(direction2)) {
                        sp3 = new Tuple2.mcII.sp(bufferSizes.left(), 0);
                    } else if (Direction.Bottom$.MODULE$.equals(direction2)) {
                        sp3 = new Tuple2.mcII.sp(bufferSizes.left(), bufferSizes.top() + BoxesRunTime.unboxToInt((Object)centerTile.rows()));
                    } else if (Direction.TopLeft$.MODULE$.equals(direction2)) {
                        sp3 = new Tuple2.mcII.sp(0, 0);
                    } else if (Direction.TopRight$.MODULE$.equals(direction2)) {
                        sp3 = new Tuple2.mcII.sp(bufferSizes.left() + BoxesRunTime.unboxToInt((Object)centerTile.cols()), 0);
                    } else if (Direction.BottomLeft$.MODULE$.equals(direction2)) {
                        sp3 = new Tuple2.mcII.sp(0, bufferSizes.top() + BoxesRunTime.unboxToInt((Object)centerTile.rows()));
                    } else if (Direction.BottomRight$.MODULE$.equals(direction2)) {
                        sp3 = new Tuple2.mcII.sp(bufferSizes.left() + BoxesRunTime.unboxToInt((Object)centerTile.cols()), bufferSizes.top() + BoxesRunTime.unboxToInt((Object)centerTile.rows()));
                    } else {
                        throw new MatchError((Object)direction2);
                    }
                    Tuple2.mcII.sp sp4 = sp3;
                    if (sp4 == null) {
                        throw new MatchError((Object)sp4);
                    }
                    int updateColMin = sp4._1$mcI$sp();
                    int updateRowMin = sp4._2$mcI$sp();
                    sp2 = new Tuple2.mcII.sp(updateColMin, updateRowMin);
                } else {
                    throw new MatchError((Object)tuple2);
                }
                Tuple2.mcII.sp sp5 = sp2;
                int updateColMin = sp5._1$mcI$sp();
                int updateRowMin = sp5._2$mcI$sp();
                Tuple2 tuple22 = new Tuple2((Object)slice, (Object)new Tuple2.mcII.sp(updateColMin, updateRowMin));
                return tuple22;
            }, Iterable$.MODULE$.canBuildFrom());
            int cols = BoxesRunTime.unboxToInt((Object)centerTile.cols()) + bufferSizes.left() + bufferSizes.right();
            int rows = BoxesRunTime.unboxToInt((Object)centerTile.rows()) + bufferSizes.top() + bufferSizes.bottom();
            CellGrid stitched = (CellGrid)((Stitcher)Predef$.MODULE$.implicitly((Object)evidence$3)).stitch(pieces, cols, rows);
            BufferedTile bufferedTile = new BufferedTile((Object)stitched, GridBounds$.MODULE$.apply(bufferSizes.left(), bufferSizes.top(), cols - bufferSizes.right() - 1, rows - bufferSizes.bottom() - 1));
            return bufferedTile;
        })));
        return r;
    }

    public <K, V extends CellGrid<Object>> RDD<Tuple2<K, BufferedTile<V>>> apply(RDD<Tuple2<K, V>> rdd, int bufferSize, Component<K, SpatialKey> evidence$5, ClassTag<K> evidence$6, Stitcher<V> evidence$7, ClassTag<V> evidence$8, Function1<V, CropMethods<V>> evidence$9) {
        return this.apply(rdd, (Function1 & Serializable & scala.Serializable)x$4 -> new BufferSizes(bufferSize, bufferSize, bufferSize, bufferSize), (Option<Partitioner>)None$.MODULE$, evidence$5, evidence$6, evidence$7, evidence$9);
    }

    public <K, V extends CellGrid<Object>> RDD<Tuple2<K, BufferedTile<V>>> apply(RDD<Tuple2<K, V>> rdd, int bufferSize, Option<Partitioner> partitioner, Component<K, SpatialKey> evidence$10, ClassTag<K> evidence$11, Stitcher<V> evidence$12, ClassTag<V> evidence$13, Function1<V, CropMethods<V>> evidence$14) {
        return this.apply(rdd, (Function1 & Serializable & scala.Serializable)x$5 -> new BufferSizes(bufferSize, bufferSize, bufferSize, bufferSize), partitioner, evidence$10, evidence$11, evidence$12, evidence$14);
    }

    public <K, V extends CellGrid<Object>> RDD<Tuple2<K, BufferedTile<V>>> apply(RDD<Tuple2<K, V>> rdd, int bufferSize, GridBounds<Object> layerBounds, Component<K, SpatialKey> evidence$15, ClassTag<K> evidence$16, Stitcher<V> evidence$17, ClassTag<V> evidence$18, Function1<V, CropMethods<V>> evidence$19) {
        return this.apply(rdd, bufferSize, layerBounds, (Option<Partitioner>)None$.MODULE$, evidence$15, evidence$16, evidence$17, evidence$18, evidence$19);
    }

    public <K, V extends CellGrid<Object>> RDD<Tuple2<K, BufferedTile<V>>> apply(RDD<Tuple2<K, V>> rdd, int bufferSize, GridBounds<Object> layerBounds, Option<Partitioner> partitioner, Component<K, SpatialKey> evidence$20, ClassTag<K> evidence$21, Stitcher<V> evidence$22, ClassTag<V> evidence$23, Function1<V, CropMethods<V>> evidence$24) {
        return this.apply(rdd, (Function1 & Serializable & scala.Serializable)key -> BoxesRunTime.boxToBoolean((boolean)BufferTilesRDD$.$anonfun$apply$3(evidence$20, layerBounds, key)), (Function1 & Serializable & scala.Serializable)x$6 -> new BufferSizes(bufferSize, bufferSize, bufferSize, bufferSize), partitioner, evidence$20, evidence$21, evidence$22, evidence$24);
    }

    public <K, V extends CellGrid<Object>> RDD<Tuple2<K, BufferedTile<V>>> apply(RDD<Tuple2<K, V>> layer, Function1<K, BufferSizes> getBufferSizes, Component<K, SpatialKey> evidence$25, ClassTag<K> evidence$26, Stitcher<V> evidence$27, Function1<V, CropMethods<V>> evidence$28) {
        return this.apply(layer, getBufferSizes, (Option<Partitioner>)None$.MODULE$, evidence$25, evidence$26, evidence$27, evidence$28);
    }

    public <K, V extends CellGrid<Object>> RDD<Tuple2<K, BufferedTile<V>>> apply(RDD<Tuple2<K, V>> layer, Function1<K, BufferSizes> getBufferSizes, Option<Partitioner> partitioner, Component<K, SpatialKey> evidence$29, ClassTag<K> evidence$30, Stitcher<V> evidence$31, Function1<V, CropMethods<V>> evidence$32) {
        return this.apply(layer, (Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)BufferTilesRDD$.$anonfun$apply$5(x$7)), getBufferSizes, partitioner, evidence$29, evidence$30, evidence$31, evidence$32);
    }

    public <K, V extends CellGrid<Object>> RDD<Tuple2<K, BufferedTile<V>>> apply(RDD<Tuple2<K, V>> layer, Function1<K, Object> includeKey, Function1<K, BufferSizes> getBufferSizes, Component<K, SpatialKey> evidence$33, ClassTag<K> evidence$34, Stitcher<V> evidence$35, Function1<V, CropMethods<V>> evidence$36) {
        return this.apply(layer, includeKey, getBufferSizes, (Option<Partitioner>)None$.MODULE$, evidence$33, evidence$34, evidence$35, evidence$36);
    }

    /*
     * Unable to fully structure code
     */
    public <K, V extends CellGrid<Object>> RDD<Tuple2<K, BufferedTile<V>>> apply(RDD<Tuple2<K, V>> layer, Function1<K, Object> includeKey, Function1<K, BufferSizes> getBufferSizes, Option<Partitioner> partitioner, Component<K, SpatialKey> evidence$37, ClassTag<K> evidence$38, Stitcher<V> evidence$39, Function1<V, CropMethods<V>> evidence$40) {
        block7: {
            block8: {
                block6: {
                    leftDirs = (Seq)new .colon.colon((Object)Direction.TopLeft$.MODULE$, (List)new .colon.colon((Object)Direction.Left$.MODULE$, (List)new .colon.colon((Object)Direction.BottomLeft$.MODULE$, (List)Nil$.MODULE$)));
                    hmidDirs = (Seq)new .colon.colon((Object)Direction.Top$.MODULE$, (List)new .colon.colon((Object)Direction.Center$.MODULE$, (List)new .colon.colon((Object)Direction.Bottom$.MODULE$, (List)Nil$.MODULE$)));
                    rightDirs = (Seq)new .colon.colon((Object)Direction.TopRight$.MODULE$, (List)new .colon.colon((Object)Direction.Right$.MODULE$, (List)new .colon.colon((Object)Direction.BottomRight$.MODULE$, (List)Nil$.MODULE$)));
                    topDirs = (Seq)new .colon.colon((Object)Direction.TopLeft$.MODULE$, (List)new .colon.colon((Object)Direction.Top$.MODULE$, (List)new .colon.colon((Object)Direction.TopRight$.MODULE$, (List)Nil$.MODULE$)));
                    vmidDirs = (Seq)new .colon.colon((Object)Direction.Left$.MODULE$, (List)new .colon.colon((Object)Direction.Center$.MODULE$, (List)new .colon.colon((Object)Direction.Right$.MODULE$, (List)Nil$.MODULE$)));
                    botDirs = (Seq)new .colon.colon((Object)Direction.BottomLeft$.MODULE$, (List)new .colon.colon((Object)Direction.Bottom$.MODULE$, (List)new .colon.colon((Object)Direction.BottomRight$.MODULE$, (List)Nil$.MODULE$)));
                    var18_15 = new Tuple2((Object)layer.partitioner(), partitioner);
                    if (var18_15 == null || !((var19_16 = (Option)var18_15._2()) instanceof Some)) break block6;
                    var10_17 = partitioner;
                    break block7;
                }
                if (var18_15 == null) break block8;
                var20_18 = (Option)var18_15._1();
                var21_19 = (Option)var18_15._2();
                if (!(var20_18 instanceof Some) || !None$.MODULE$.equals(var21_19)) break block8;
                var10_17 = layer.partitioner();
                break block7;
            }
            if (var18_15 == null) ** GOTO lbl-1000
            var22_20 = (Option)var18_15._1();
            var23_21 = (Option)var18_15._2();
            if (None$.MODULE$.equals(var22_20) && None$.MODULE$.equals(var23_21)) {
                var10_17 = None$.MODULE$;
            } else lbl-1000:
            // 2 sources

            {
                throw new MatchError((Object)var18_15);
            }
        }
        targetPartitioner = var10_17;
        sliced = layer.flatMap((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$apply$6(geotrellis.util.Component scala.Function1 scala.collection.Seq scala.collection.Seq scala.collection.Seq scala.collection.Seq scala.collection.Seq scala.collection.Seq scala.Function1 scala.Function1 scala.Tuple2 ), (Lscala/Tuple2;)Lscala/collection/Seq;)(evidence$37, getBufferSizes, (Seq)leftDirs, (Seq)hmidDirs, (Seq)rightDirs, (Seq)topDirs, (Seq)vmidDirs, (Seq)botDirs, evidence$40, includeKey), ClassTag$.MODULE$.apply(Tuple2.class));
        var26_24 = targetPartitioner;
        if (var26_24 instanceof Some) {
            var27_25 = (Some)var26_24;
            p = (Partitioner)var27_25.value();
            x$1 = sliced;
            x$2 = evidence$38;
            x$3 = ClassTag$.MODULE$.apply(Tuple3.class);
            x$4 = RDD$.MODULE$.rddToPairRDDFunctions$default$4(x$1);
            var9_31 = RDD$.MODULE$.rddToPairRDDFunctions(x$1, x$2, x$3, null).groupByKey(p);
        } else if (None$.MODULE$.equals(var26_24)) {
            x$5 = sliced;
            x$6 = evidence$38;
            x$7 = ClassTag$.MODULE$.apply(Tuple3.class);
            x$8 = RDD$.MODULE$.rddToPairRDDFunctions$default$4(x$5);
            var9_31 = RDD$.MODULE$.rddToPairRDDFunctions(x$5, x$6, x$7, null).groupByKey();
        } else {
            throw new MatchError((Object)var26_24);
        }
        x$9 = grouped = var9_31;
        x$10 = evidence$38;
        x$11 = ClassTag$.MODULE$.apply(Iterable.class);
        x$12 = RDD$.MODULE$.rddToPairRDDFunctions$default$4(x$9);
        return RDD$.MODULE$.rddToPairRDDFunctions(x$9, x$10, x$11, null).flatMapValues((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$apply$9(scala.collection.Seq scala.collection.Seq scala.collection.Seq scala.collection.Seq scala.collection.Seq scala.collection.Seq geotrellis.raster.stitch.Stitcher scala.collection.Iterable ), (Lscala/collection/Iterable;)Lscala/collection/TraversableOnce;)((Seq)leftDirs, (Seq)hmidDirs, (Seq)rightDirs, (Seq)topDirs, (Seq)vmidDirs, (Seq)botDirs, evidence$39));
    }

    public static final /* synthetic */ boolean $anonfun$bufferWithNeighbors$2(Tuple2 x$1) {
        Object object = x$1._1();
        Direction.Center$ center$ = Direction.Center$.MODULE$;
        return !(object != null ? !object.equals(center$) : center$ != null);
    }

    public static final /* synthetic */ boolean $anonfun$apply$3(Component evidence$20$1, GridBounds layerBounds$1, Object key) {
        SpatialKey k = (SpatialKey)package$.MODULE$.withGetComponentMethods(key).getComponent((GetComponent)evidence$20$1);
        return layerBounds$1.contains$mcI$sp(k.col(), k.row());
    }

    public static final /* synthetic */ boolean $anonfun$apply$5(Object x$7) {
        return true;
    }

    private static final Tuple2 genSection$1(Direction neighbor, Object key$1, int x$16, int y$1, Component evidence$37$1, Function1 getBufferSizes$1, Seq leftDirs$1, Seq hmidDirs$1, Seq rightDirs$1, int cols$1, Seq topDirs$1, Seq vmidDirs$1, Seq botDirs$1, int rows$1, Function1 evidence$40$1, CellGrid tile$1) {
        boolean bl;
        boolean bl2;
        Tuple2.mcII.sp sp2;
        boolean bl3;
        boolean bl4;
        boolean bl5;
        Tuple2.mcII.sp sp3;
        boolean bl6;
        Tuple2 tuple2 = Direction.DirectionOp$.MODULE$.offsetOf(neighbor);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int xOfs = tuple2._1$mcI$sp();
        int yOfs = tuple2._2$mcI$sp();
        Tuple2.mcII.sp sp4 = new Tuple2.mcII.sp(xOfs, yOfs);
        Tuple2.mcII.sp sp5 = sp4;
        int xOfs2 = sp5._1$mcI$sp();
        int yOfs2 = sp5._2$mcI$sp();
        Object targetKey = package$.MODULE$.withSetComponentMethods(key$1).setComponent((Object)new SpatialKey(x$16 + xOfs2, y$1 + yOfs2), (SetComponent)evidence$37$1);
        Product targetDir = Direction.DirectionOp$.MODULE$.opp(neighbor);
        BufferSizes bs = (BufferSizes)getBufferSizes$1.apply(targetKey);
        Tuple3 tuple3 = new Tuple3((Object)BoxesRunTime.boxToBoolean((boolean)leftDirs$1.contains((Object)neighbor)), (Object)BoxesRunTime.boxToBoolean((boolean)hmidDirs$1.contains((Object)neighbor)), (Object)BoxesRunTime.boxToBoolean((boolean)rightDirs$1.contains((Object)neighbor)));
        if (tuple3 != null && (bl6 = BoxesRunTime.unboxToBoolean((Object)tuple3._1()))) {
            sp3 = new Tuple2.mcII.sp(0, bs.right() - 1);
        } else if (tuple3 != null && (bl5 = BoxesRunTime.unboxToBoolean((Object)tuple3._2()))) {
            sp3 = new Tuple2.mcII.sp(0, cols$1 - 1);
        } else if (tuple3 != null && (bl4 = BoxesRunTime.unboxToBoolean((Object)tuple3._3()))) {
            sp3 = new Tuple2.mcII.sp(cols$1 - bs.left(), cols$1 - 1);
        } else {
            throw new IllegalStateException("Unreachable state");
        }
        Tuple2.mcII.sp sp6 = sp3;
        if (sp6 == null) {
            throw new MatchError((Object)sp6);
        }
        int l = sp6._1$mcI$sp();
        int r = sp6._2$mcI$sp();
        Tuple2.mcII.sp sp7 = new Tuple2.mcII.sp(l, r);
        Tuple2.mcII.sp sp8 = sp7;
        int l2 = sp8._1$mcI$sp();
        int r2 = sp8._2$mcI$sp();
        Tuple3 tuple32 = new Tuple3((Object)BoxesRunTime.boxToBoolean((boolean)topDirs$1.contains((Object)neighbor)), (Object)BoxesRunTime.boxToBoolean((boolean)vmidDirs$1.contains((Object)neighbor)), (Object)BoxesRunTime.boxToBoolean((boolean)botDirs$1.contains((Object)neighbor)));
        if (tuple32 != null && (bl3 = BoxesRunTime.unboxToBoolean((Object)tuple32._1()))) {
            sp2 = new Tuple2.mcII.sp(0, bs.bottom() - 1);
        } else if (tuple32 != null && (bl2 = BoxesRunTime.unboxToBoolean((Object)tuple32._2()))) {
            sp2 = new Tuple2.mcII.sp(0, rows$1 - 1);
        } else if (tuple32 != null && (bl = BoxesRunTime.unboxToBoolean((Object)tuple32._3()))) {
            sp2 = new Tuple2.mcII.sp(rows$1 - bs.top(), rows$1 - 1);
        } else {
            throw new IllegalStateException("Unreachable state");
        }
        Tuple2.mcII.sp sp9 = sp2;
        if (sp9 == null) {
            throw new MatchError((Object)sp9);
        }
        int t = sp9._1$mcI$sp();
        int b = sp9._2$mcI$sp();
        Tuple2.mcII.sp sp10 = new Tuple2.mcII.sp(t, b);
        Tuple2.mcII.sp sp11 = sp10;
        int t2 = sp11._1$mcI$sp();
        int b2 = sp11._2$mcI$sp();
        MODULE$.logger().debug((Object)new StringBuilder(47).append("Generating buffer for ").append(targetKey).append(" -> ").append(targetDir).append(" from ").append(key$1).append(" over span [").append(new Tuple2.mcII.sp(l2, t2)).append(", ").append(new Tuple2.mcII.sp(r2, b2)).append("]").toString());
        boolean x$1 = true;
        boolean x$2 = Crop.Options$.MODULE$.apply$default$1();
        CellGrid slice = (CellGrid)((CropMethods)evidence$40$1.apply((Object)tile$1)).crop(l2, t2, r2, b2, new Crop.Options(x$2, x$1));
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(targetKey), (Object)new Tuple3(targetKey, (Object)targetDir, (Object)slice));
    }

    public static final /* synthetic */ Seq $anonfun$apply$6(Component evidence$37$1, Function1 getBufferSizes$1, Seq leftDirs$1, Seq hmidDirs$1, Seq rightDirs$1, Seq topDirs$1, Seq vmidDirs$1, Seq botDirs$1, Function1 evidence$40$1, Function1 includeKey$1, Tuple2 x0$1) {
        Tuple2.mcII.sp sp2;
        CellGrid tile;
        Object key;
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            key = tuple2._1();
            tile = (CellGrid)tuple2._2();
            SpatialKey spatialKey = (SpatialKey)package$.MODULE$.withGetComponentMethods(key).getComponent((GetComponent)evidence$37$1);
            if (spatialKey == null) {
                throw new MatchError((Object)spatialKey);
            }
            int x = spatialKey.col();
            int y = spatialKey.row();
            sp2 = new Tuple2.mcII.sp(x, y);
        } else {
            throw new MatchError((Object)tuple2);
        }
        Tuple2.mcII.sp sp3 = sp2;
        int x = sp3._1$mcI$sp();
        int y = sp3._2$mcI$sp();
        int cols = BoxesRunTime.unboxToInt((Object)tile.cols());
        int rows = BoxesRunTime.unboxToInt((Object)tile.rows());
        Seq seq = BoxesRunTime.unboxToBoolean((Object)includeKey$1.apply(key)) ? (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Product[]{Direction.Center$.MODULE$, Direction.Left$.MODULE$, Direction.Right$.MODULE$, Direction.Bottom$.MODULE$, Direction.Top$.MODULE$, Direction.TopLeft$.MODULE$, Direction.TopRight$.MODULE$, Direction.BottomLeft$.MODULE$, Direction.BottomRight$.MODULE$}))).map((Function1 & Serializable & scala.Serializable)neighbor -> BufferTilesRDD$.genSection$1(neighbor, key, x, y, evidence$37$1, getBufferSizes$1, leftDirs$1, hmidDirs$1, rightDirs$1, cols, topDirs$1, vmidDirs$1, botDirs$1, rows, evidence$40$1, tile), Seq$.MODULE$.canBuildFrom()) : (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Product[]{Direction.Left$.MODULE$, Direction.Right$.MODULE$, Direction.Bottom$.MODULE$, Direction.Top$.MODULE$, Direction.TopLeft$.MODULE$, Direction.TopRight$.MODULE$, Direction.BottomLeft$.MODULE$, Direction.BottomRight$.MODULE$}))).map((Function1 & Serializable & scala.Serializable)neighbor -> BufferTilesRDD$.genSection$1(neighbor, key, x, y, evidence$37$1, getBufferSizes$1, leftDirs$1, hmidDirs$1, rightDirs$1, cols, topDirs$1, vmidDirs$1, botDirs$1, rows, evidence$40$1, tile), Seq$.MODULE$.canBuildFrom());
        return seq;
    }

    public static final /* synthetic */ int $anonfun$apply$13(CellGrid x$13) {
        return BoxesRunTime.unboxToInt((Object)x$13.cols());
    }

    public static final /* synthetic */ int $anonfun$apply$12(Map pieces$1, Product x) {
        return BoxesRunTime.unboxToInt((Object)pieces$1.get((Object)x).map((Function1 & Serializable & scala.Serializable)x$13 -> BoxesRunTime.boxToInteger((int)BufferTilesRDD$.$anonfun$apply$13(x$13))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0));
    }

    public static final /* synthetic */ int $anonfun$apply$11(Map pieces$1, Seq x$12) {
        return BoxesRunTime.unboxToInt((Object)((TraversableOnce)x$12.map((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToInteger((int)BufferTilesRDD$.$anonfun$apply$12(pieces$1, x)), Seq$.MODULE$.canBuildFrom())).max((Ordering)Ordering.Int$.MODULE$));
    }

    public static final /* synthetic */ Seq $anonfun$apply$15(Seq acc, int x) {
        return (Seq)acc.$colon$plus((Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)acc.last()) + x)), Seq$.MODULE$.canBuildFrom());
    }

    public static final /* synthetic */ int $anonfun$apply$18(CellGrid x$15) {
        return BoxesRunTime.unboxToInt((Object)x$15.rows());
    }

    public static final /* synthetic */ int $anonfun$apply$17(Map pieces$1, Product x) {
        return BoxesRunTime.unboxToInt((Object)pieces$1.get((Object)x).map((Function1 & Serializable & scala.Serializable)x$15 -> BoxesRunTime.boxToInteger((int)BufferTilesRDD$.$anonfun$apply$18(x$15))).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0));
    }

    public static final /* synthetic */ int $anonfun$apply$16(Map pieces$1, Seq x$14) {
        return BoxesRunTime.unboxToInt((Object)((TraversableOnce)x$14.map((Function1 & Serializable & scala.Serializable)x -> BoxesRunTime.boxToInteger((int)BufferTilesRDD$.$anonfun$apply$17(pieces$1, x)), Seq$.MODULE$.canBuildFrom())).max((Ordering)Ordering.Int$.MODULE$));
    }

    public static final /* synthetic */ Seq $anonfun$apply$20(Seq acc, int x) {
        return (Seq)acc.$colon$plus((Object)BoxesRunTime.boxToInteger((int)(BoxesRunTime.unboxToInt((Object)acc.last()) + x)), Seq$.MODULE$.canBuildFrom());
    }

    private static final Tuple2 loc$1(Direction dir, Seq lefts$1, Seq tops$1) {
        Tuple2.mcII.sp sp2;
        Direction direction = dir;
        if (Direction.TopLeft$.MODULE$.equals(direction)) {
            sp2 = new Tuple2.mcII.sp(BoxesRunTime.unboxToInt((Object)lefts$1.apply(0)), BoxesRunTime.unboxToInt((Object)tops$1.apply(0)));
        } else if (Direction.Top$.MODULE$.equals(direction)) {
            sp2 = new Tuple2.mcII.sp(BoxesRunTime.unboxToInt((Object)lefts$1.apply(1)), BoxesRunTime.unboxToInt((Object)tops$1.apply(0)));
        } else if (Direction.TopRight$.MODULE$.equals(direction)) {
            sp2 = new Tuple2.mcII.sp(BoxesRunTime.unboxToInt((Object)lefts$1.apply(2)), BoxesRunTime.unboxToInt((Object)tops$1.apply(0)));
        } else if (Direction.Left$.MODULE$.equals(direction)) {
            sp2 = new Tuple2.mcII.sp(BoxesRunTime.unboxToInt((Object)lefts$1.apply(0)), BoxesRunTime.unboxToInt((Object)tops$1.apply(1)));
        } else if (Direction.Center$.MODULE$.equals(direction)) {
            sp2 = new Tuple2.mcII.sp(BoxesRunTime.unboxToInt((Object)lefts$1.apply(1)), BoxesRunTime.unboxToInt((Object)tops$1.apply(1)));
        } else if (Direction.Right$.MODULE$.equals(direction)) {
            sp2 = new Tuple2.mcII.sp(BoxesRunTime.unboxToInt((Object)lefts$1.apply(2)), BoxesRunTime.unboxToInt((Object)tops$1.apply(1)));
        } else if (Direction.BottomLeft$.MODULE$.equals(direction)) {
            sp2 = new Tuple2.mcII.sp(BoxesRunTime.unboxToInt((Object)lefts$1.apply(0)), BoxesRunTime.unboxToInt((Object)tops$1.apply(2)));
        } else if (Direction.Bottom$.MODULE$.equals(direction)) {
            sp2 = new Tuple2.mcII.sp(BoxesRunTime.unboxToInt((Object)lefts$1.apply(1)), BoxesRunTime.unboxToInt((Object)tops$1.apply(2)));
        } else if (Direction.BottomRight$.MODULE$.equals(direction)) {
            sp2 = new Tuple2.mcII.sp(BoxesRunTime.unboxToInt((Object)lefts$1.apply(2)), BoxesRunTime.unboxToInt((Object)tops$1.apply(2)));
        } else {
            throw new MatchError((Object)direction);
        }
        return sp2;
    }

    public static final /* synthetic */ TraversableOnce $anonfun$apply$9(Seq leftDirs$1, Seq hmidDirs$1, Seq rightDirs$1, Seq topDirs$1, Seq vmidDirs$1, Seq botDirs$1, Stitcher evidence$39$1, Iterable iter) {
        Iterable iterable;
        Map pieces = ((TraversableOnce)iter.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Tuple3 tuple3 = x0$2;
            if (tuple3 == null) {
                throw new MatchError((Object)tuple3);
            }
            Direction dir = (Direction)tuple3._2();
            CellGrid tile = (CellGrid)tuple3._3();
            Tuple2 tuple2 = new Tuple2((Object)dir, (Object)tile);
            return tuple2;
        }, Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        if (pieces.contains((Object)Direction.Center$.MODULE$)) {
            Seq lefts = (Seq)((TraversableOnce)((TraversableLike)new .colon.colon((Object)leftDirs$1, (List)new .colon.colon((Object)hmidDirs$1, (List)new .colon.colon((Object)rightDirs$1, (List)Nil$.MODULE$)))).map((Function1 & Serializable & scala.Serializable)x$12 -> BoxesRunTime.boxToInteger((int)BufferTilesRDD$.$anonfun$apply$11(pieces, x$12)), Seq$.MODULE$.canBuildFrom())).foldLeft((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})), (Function2 & Serializable & scala.Serializable)(acc, x) -> BufferTilesRDD$.$anonfun$apply$15(acc, BoxesRunTime.unboxToInt((Object)x)));
            Seq tops = (Seq)((TraversableOnce)((TraversableLike)new .colon.colon((Object)topDirs$1, (List)new .colon.colon((Object)vmidDirs$1, (List)new .colon.colon((Object)botDirs$1, (List)Nil$.MODULE$)))).map((Function1 & Serializable & scala.Serializable)x$14 -> BoxesRunTime.boxToInteger((int)BufferTilesRDD$.$anonfun$apply$16(pieces, x$14)), Seq$.MODULE$.canBuildFrom())).foldLeft((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0})), (Function2 & Serializable & scala.Serializable)(acc, x) -> BufferTilesRDD$.$anonfun$apply$20(acc, BoxesRunTime.unboxToInt((Object)x)));
            int totalWidth = BoxesRunTime.unboxToInt((Object)lefts.last());
            int totalHeight = BoxesRunTime.unboxToInt((Object)tops.last());
            Seq toStitch = (Seq)pieces.toSeq().map((Function1 & Serializable & scala.Serializable)x0$3 -> {
                Tuple2 tuple2 = x0$3;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Direction dir = (Direction)tuple2._1();
                CellGrid tile = (CellGrid)tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)tile, (Object)BufferTilesRDD$.loc$1(dir, lefts, tops));
                return tuple22;
            }, Seq$.MODULE$.canBuildFrom());
            Stitcher stitcher = (Stitcher)Predef$.MODULE$.implicitly((Object)evidence$39$1);
            CellGrid stitched = (CellGrid)stitcher.stitch((Iterable)toStitch, totalWidth, totalHeight);
            iterable = Option$.MODULE$.option2Iterable((Option)new Some((Object)new BufferedTile((Object)stitched, GridBounds$.MODULE$.apply(BoxesRunTime.unboxToInt((Object)lefts.apply(1)), BoxesRunTime.unboxToInt((Object)tops.apply(1)), BoxesRunTime.unboxToInt((Object)lefts.apply(2)) - 1, BoxesRunTime.unboxToInt((Object)tops.apply(2)) - 1))));
        } else {
            iterable = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
        }
        return iterable;
    }

    private BufferTilesRDD$() {
        MODULE$ = this;
        BufferTiles.$init$((BufferTiles)this);
        this.logger = Logger.getLogger(this.getClass());
    }
}

