/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.spark.mask;

import geotrellis.layer.LayoutDefinition;
import geotrellis.layer.MapKeyTransform;
import geotrellis.layer.Metadata;
import geotrellis.layer.SpatialKey;
import geotrellis.layer.mask.Mask;
import geotrellis.raster.mask.TileMaskMethods;
import geotrellis.spark.ContextRDD$;
import geotrellis.util.Component;
import geotrellis.util.GetComponent;
import geotrellis.util.package$;
import geotrellis.vector.Extent;
import geotrellis.vector.Extent$;
import java.io.Serializable;
import org.apache.spark.rdd.RDD;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Polygon;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Traversable;
import scala.collection.Traversable$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;

public final class MaskRDD$
implements Mask {
    public static MaskRDD$ MODULE$;

    static {
        new MaskRDD$();
    }

    public Option<Geometry> eliminateNotQualified(Option<Geometry> geom) {
        return Mask.eliminateNotQualified$((Mask)this, geom);
    }

    public <K, V, M> Seq<Tuple2<K, V>> apply(Seq<Tuple2<K, V>> seq, Traversable<Polygon> geoms, Mask.Options options, Component<K, SpatialKey> evidence$3, Function1<V, TileMaskMethods<V>> evidence$4, GetComponent<M, LayoutDefinition> evidence$5) {
        return Mask.apply$((Mask)this, seq, geoms, (Mask.Options)options, evidence$3, evidence$4, evidence$5);
    }

    public <K, V, M> Seq<Tuple2<K, V>> apply(Seq<Tuple2<K, V>> seq, Traversable<MultiPolygon> geoms, Mask.Options options, Component<K, SpatialKey> evidence$6, Function1<V, TileMaskMethods<V>> evidence$7, GetComponent<M, LayoutDefinition> evidence$8, Predef.DummyImplicit d) {
        return Mask.apply$((Mask)this, seq, geoms, (Mask.Options)options, evidence$6, evidence$7, evidence$8, (Predef.DummyImplicit)d);
    }

    public <K, V, M> Seq<Tuple2<K, V>> apply(Seq<Tuple2<K, V>> seq, Extent ext, Mask.Options options, Component<K, SpatialKey> evidence$9, Function1<V, TileMaskMethods<V>> evidence$10, GetComponent<M, LayoutDefinition> evidence$11) {
        return Mask.apply$((Mask)this, seq, (Extent)ext, (Mask.Options)options, evidence$9, evidence$10, evidence$11);
    }

    public <K, V, M> Seq<Tuple2<K, V>> apply(Seq<Tuple2<K, V>> seq, Extent ext, Component<K, SpatialKey> evidence$12, Function1<V, TileMaskMethods<V>> evidence$13, GetComponent<M, LayoutDefinition> evidence$14) {
        return Mask.apply$((Mask)this, seq, (Extent)ext, evidence$12, evidence$13, evidence$14);
    }

    private <K, V, M> RDD<Tuple2<K, V>> _mask(RDD<Tuple2<K, V>> rdd, Function2<Extent, V, Option<V>> masker, Component<K, SpatialKey> evidence$1, ClassTag<K> evidence$2, GetComponent<M, LayoutDefinition> evidence$3) {
        MapKeyTransform mapTransform = ((LayoutDefinition)package$.MODULE$.withGetComponentMethods(((Metadata)rdd).metadata()).getComponent(evidence$3)).mapTransform();
        RDD masked = rdd.mapPartitions((Function1 & Serializable & scala.Serializable)partition -> partition.flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Object k = tuple2._1();
            Object tile = tuple2._2();
            SpatialKey key = (SpatialKey)package$.MODULE$.withGetComponentMethods(k).getComponent((GetComponent)evidence$1);
            Extent tileExtent = mapTransform.apply(key);
            Iterable iterable = Option$.MODULE$.option2Iterable(((Option)masker.apply((Object)tileExtent, tile)).map((Function1 & Serializable & scala.Serializable)result -> new Tuple2(k, result)));
            return iterable;
        }), true, ClassTag$.MODULE$.apply(Tuple2.class));
        return ContextRDD$.MODULE$.apply(masked, ((Metadata)rdd).metadata());
    }

    public <K, V, M> RDD<Tuple2<K, V>> apply(RDD<Tuple2<K, V>> rdd, Traversable<Polygon> geoms, Mask.Options options, Component<K, SpatialKey> evidence$4, ClassTag<K> evidence$5, Function1<V, TileMaskMethods<V>> evidence$6, GetComponent<M, LayoutDefinition> evidence$7) {
        return this._mask(rdd, (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Extent tileExtent = (Extent)tuple2._1();
            Object tile = tuple2._2();
            Traversable tileGeoms = (Traversable)geoms.flatMap((Function1 & Serializable & scala.Serializable)g -> {
                Option intersections = geotrellis.vector.package$.MODULE$.withExtraGeometryMethods((Geometry)g).intersectionSafe((Geometry)Extent$.MODULE$.toPolygon(tileExtent)).toGeometry();
                return Option$.MODULE$.option2Iterable(MODULE$.eliminateNotQualified((Option<Geometry>)intersections));
            }, Traversable$.MODULE$.canBuildFrom());
            Some some = tileGeoms.isEmpty() && options.filterEmptyTiles() ? None$.MODULE$ : new Some(((TileMaskMethods)evidence$6.apply(tile)).mask(tileExtent, tileGeoms, options.rasterizerOptions()));
            return some;
        }, evidence$4, evidence$5, evidence$7);
    }

    public <K, V, M> RDD<Tuple2<K, V>> apply(RDD<Tuple2<K, V>> rdd, Traversable<MultiPolygon> geoms, Mask.Options options, Component<K, SpatialKey> evidence$8, ClassTag<K> evidence$9, Function1<V, TileMaskMethods<V>> evidence$10, GetComponent<M, LayoutDefinition> evidence$11, Predef.DummyImplicit d) {
        return this._mask(rdd, (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Extent tileExtent = (Extent)tuple2._1();
            Object tile = tuple2._2();
            Traversable tileGeoms = (Traversable)geoms.flatMap((Function1 & Serializable & scala.Serializable)g -> {
                Option intersections = geotrellis.vector.package$.MODULE$.withExtraGeometryMethods((Geometry)g).intersectionSafe((Geometry)Extent$.MODULE$.toPolygon(tileExtent)).toGeometry();
                return Option$.MODULE$.option2Iterable(MODULE$.eliminateNotQualified((Option<Geometry>)intersections));
            }, Traversable$.MODULE$.canBuildFrom());
            Some some = tileGeoms.isEmpty() && options.filterEmptyTiles() ? None$.MODULE$ : new Some(((TileMaskMethods)evidence$10.apply(tile)).mask(tileExtent, tileGeoms, options.rasterizerOptions()));
            return some;
        }, evidence$8, evidence$9, evidence$11);
    }

    public <K, V, M> RDD<Tuple2<K, V>> apply(RDD<Tuple2<K, V>> rdd, Extent ext, Mask.Options options, Component<K, SpatialKey> evidence$12, ClassTag<K> evidence$13, Function1<V, TileMaskMethods<V>> evidence$14, GetComponent<M, LayoutDefinition> evidence$15) {
        return this._mask(rdd, (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            Some some;
            Extent intersected;
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Extent tileExtent = (Extent)tuple2._1();
            Object tile = tuple2._2();
            Option tileExts = ext.intersection(tileExtent);
            Option option = tileExts;
            Object object = option instanceof Some && (intersected = (Extent)(some = (Some)option).value()).area() != 0.0 ? new Some(((TileMaskMethods)evidence$14.apply(tile)).mask(tileExtent, (Geometry)intersected.toPolygon(), options.rasterizerOptions())) : (options.filterEmptyTiles() ? None$.MODULE$ : new Some(((TileMaskMethods)evidence$14.apply(tile)).mask(tileExtent, (Geometry)Extent$.MODULE$.toPolygon(new Extent(0.0, 0.0, 0.0, 0.0)), options.rasterizerOptions())));
            None$ none$ = object;
            return none$;
        }, evidence$12, evidence$13, evidence$15);
    }

    public <K, V, M> RDD<Tuple2<K, V>> apply(RDD<Tuple2<K, V>> rdd, Extent ext, Component<K, SpatialKey> evidence$16, ClassTag<K> evidence$17, Function1<V, TileMaskMethods<V>> evidence$18, GetComponent<M, LayoutDefinition> evidence$19) {
        Mask.Options options = Mask.Options$.MODULE$.DEFAULT();
        return this._mask(rdd, (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> {
            Some some;
            Extent intersected;
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Extent tileExtent = (Extent)tuple2._1();
            Object tile = tuple2._2();
            Option tileExts = ext.intersection(tileExtent);
            Option option = tileExts;
            Object object = option instanceof Some && (intersected = (Extent)(some = (Some)option).value()).area() != 0.0 ? new Some(((TileMaskMethods)evidence$18.apply(tile)).mask(tileExtent, (Geometry)intersected.toPolygon(), options.rasterizerOptions())) : (options.filterEmptyTiles() ? None$.MODULE$ : new Some(((TileMaskMethods)evidence$18.apply(tile)).mask(tileExtent, (Geometry)Extent$.MODULE$.toPolygon(new Extent(0.0, 0.0, 0.0, 0.0)), options.rasterizerOptions())));
            None$ none$ = object;
            return none$;
        }, evidence$16, evidence$17, evidence$19);
    }

    private MaskRDD$() {
        MODULE$ = this;
        Mask.$init$((Mask)this);
    }
}

