/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.spark.rasterize;

import geotrellis.layer.LayoutDefinition;
import geotrellis.layer.SpatialKey;
import geotrellis.layer.SpatialKey$;
import geotrellis.raster.ArrayTile;
import geotrellis.raster.ArrayTile$;
import geotrellis.raster.BitCellType$;
import geotrellis.raster.ByteCellType$;
import geotrellis.raster.ByteConstantNoDataCellType$;
import geotrellis.raster.DataType;
import geotrellis.raster.DoubleCellType$;
import geotrellis.raster.FloatCellType$;
import geotrellis.raster.IntCellType$;
import geotrellis.raster.MutableArrayTile;
import geotrellis.raster.RasterExtent;
import geotrellis.raster.RasterExtent$;
import geotrellis.raster.ShortCellType$;
import geotrellis.raster.Tile;
import geotrellis.raster.UByteCellType$;
import geotrellis.raster.UShortCellType$;
import geotrellis.raster.package$;
import geotrellis.raster.rasterize.CellValue;
import geotrellis.raster.rasterize.Rasterizer;
import geotrellis.spark.ContextRDD$;
import geotrellis.vector.Feature;
import java.io.Serializable;
import org.apache.spark.HashPartitioner;
import org.apache.spark.Partitioner;
import org.apache.spark.rdd.PairRDDFunctions;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.serializer.Serializer;
import org.locationtech.jts.geom.Geometry;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Tuple2;
import scala.collection.Traversable;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction2;

public final class RasterizeRDD$ {
    public static RasterizeRDD$ MODULE$;

    static {
        new RasterizeRDD$();
    }

    public <G extends Geometry> RDD<Tuple2<SpatialKey, Tile>> fromGeometry(RDD<G> geoms, double value, DataType cellType, LayoutDefinition layout, Rasterizer.Options options, Option<Partitioner> partitioner) {
        RDD features = geoms.map((Function1 & Serializable & scala.Serializable)g -> new Feature(g, (Object)BoxesRunTime.boxToDouble((double)value)), ClassTag$.MODULE$.apply(Feature.class));
        return this.fromFeature(features, cellType, layout, options, partitioner);
    }

    public <G extends Geometry> Rasterizer.Options fromGeometry$default$5() {
        return Rasterizer.Options$.MODULE$.DEFAULT();
    }

    public <G extends Geometry> Option<Partitioner> fromGeometry$default$6() {
        return None$.MODULE$;
    }

    public <G extends Geometry> RDD<Tuple2<SpatialKey, Tile>> fromKeyedGeometry(RDD<Tuple2<SpatialKey, G>> geoms, double value, DataType cellType, LayoutDefinition layout, Rasterizer.Options options, Option<Partitioner> partitioner) {
        RDD features = geoms.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            SpatialKey key = (SpatialKey)tuple2._1();
            Geometry g = (Geometry)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)key, (Object)new Tuple2((Object)new Feature(g, (Object)BoxesRunTime.boxToDouble((double)value)), (Object)key));
            return tuple22;
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        return this._fromKeyedFeature(features, cellType, layout, options, partitioner);
    }

    public <G extends Geometry> Rasterizer.Options fromKeyedGeometry$default$5() {
        return Rasterizer.Options$.MODULE$.DEFAULT();
    }

    public <G extends Geometry> Option<Partitioner> fromKeyedGeometry$default$6() {
        return None$.MODULE$;
    }

    public <G extends Geometry> RDD<Tuple2<SpatialKey, Tile>> fromFeature(RDD<Feature<G, Object>> features, DataType cellType, LayoutDefinition layout, Rasterizer.Options options, Option<Partitioner> partitioner) {
        RDD keyed = features.flatMap((Function1 & Serializable & scala.Serializable)feature -> layout.mapTransform().keysForGeometry(feature.geom()).iterator().map((Function1 & Serializable & scala.Serializable)key -> new Tuple2(key, (Object)new Tuple2(feature, key))), ClassTag$.MODULE$.apply(Tuple2.class));
        return this._fromKeyedFeature(keyed, cellType, layout, options, partitioner);
    }

    public <G extends Geometry> Rasterizer.Options fromFeature$default$4() {
        return Rasterizer.Options$.MODULE$.DEFAULT();
    }

    public <G extends Geometry> Option<Partitioner> fromFeature$default$5() {
        return None$.MODULE$;
    }

    public <G extends Geometry> RDD<Tuple2<SpatialKey, Tile>> fromKeyedFeature(RDD<Tuple2<SpatialKey, Feature<G, Object>>> features, DataType cellType, LayoutDefinition layout, Rasterizer.Options options, Option<Partitioner> partitioner) {
        RDD keyed = features.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            SpatialKey key = (SpatialKey)tuple2._1();
            Feature feature = (Feature)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)key, (Object)new Tuple2((Object)feature, (Object)key));
            return tuple22;
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        return this._fromKeyedFeature(keyed, cellType, layout, options, partitioner);
    }

    public <G extends Geometry> Rasterizer.Options fromKeyedFeature$default$4() {
        return Rasterizer.Options$.MODULE$.DEFAULT();
    }

    public <G extends Geometry> Option<Partitioner> fromKeyedFeature$default$5() {
        return None$.MODULE$;
    }

    private <G extends Geometry> RDD<Tuple2<SpatialKey, Tile>> _fromKeyedFeature(RDD<Tuple2<SpatialKey, Tuple2<Feature<G, Object>, SpatialKey>>> keyedFeatures, DataType cellType, LayoutDefinition layout, Rasterizer.Options options, Option<Partitioner> partitioner) {
        Function1 & Serializable & scala.Serializable createTile = (Function1 & Serializable & scala.Serializable)tup -> {
            Tuple2 tuple2 = tup;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Feature feature = (Feature)tuple2._1();
            SpatialKey key = (SpatialKey)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)feature, (Object)key);
            Tuple2 tuple23 = tuple22;
            Feature feature2 = (Feature)tuple23._1();
            SpatialKey key2 = (SpatialKey)tuple23._2();
            MutableArrayTile tile = ArrayTile$.MODULE$.empty(cellType, layout.tileCols(), layout.tileRows());
            RasterExtent re = RasterExtent$.MODULE$.apply(layout.mapTransform().apply(key2), layout.tileCols(), layout.tileRows());
            package$.MODULE$.withGeometryRasterizeMethods(feature2.geom()).foreach(re, options, (Function2)(JFunction2.mcVII.sp & Serializable & scala.Serializable)(x, y) -> tile.setDouble(x, y, BoxesRunTime.unboxToDouble((Object)feature2.data())));
            return tile;
        };
        Function2 & Serializable & scala.Serializable updateTile = (Function2 & Serializable & scala.Serializable)(tile, tup) -> {
            Tuple2 tuple2 = tup;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Feature feature = (Feature)tuple2._1();
            SpatialKey key = (SpatialKey)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)feature, (Object)key);
            Tuple2 tuple23 = tuple22;
            Feature feature2 = (Feature)tuple23._1();
            SpatialKey key2 = (SpatialKey)tuple23._2();
            RasterExtent re = RasterExtent$.MODULE$.apply(layout.mapTransform().apply(key2), layout.tileCols(), layout.tileRows());
            package$.MODULE$.withGeometryRasterizeMethods(feature2.geom()).foreach(re, options, (Function2)(JFunction2.mcVII.sp & Serializable & scala.Serializable)(x$3, x$4) -> tile.setDouble(x$3, x$4, BoxesRunTime.unboxToDouble((Object)feature2.data())));
            return tile;
        };
        Function2 & Serializable & scala.Serializable mergeTiles = (Function2 & Serializable & scala.Serializable)(left, right) -> ((Tile)package$.MODULE$.withSinglebandMergeMethods((Tile)left).merge(right)).mutable();
        PairRDDFunctions qual$1 = RDD$.MODULE$.rddToPairRDDFunctions(keyedFeatures, ClassTag$.MODULE$.apply(SpatialKey.class), ClassTag$.MODULE$.apply(Tuple2.class), SpatialKey$.MODULE$.ordering());
        Function1 & Serializable & scala.Serializable x$1 = createTile;
        Function2 & Serializable & scala.Serializable x$2 = updateTile;
        Function2 & Serializable & scala.Serializable x$3 = mergeTiles;
        Partitioner x$4 = (Partitioner)partitioner.getOrElse((Function0 & Serializable & scala.Serializable)() -> new HashPartitioner(keyedFeatures.getNumPartitions()));
        boolean x$5 = qual$1.combineByKeyWithClassTag$default$5();
        Serializer x$6 = qual$1.combineByKeyWithClassTag$default$6();
        RDD tiles = qual$1.combineByKeyWithClassTag((Function1)x$1, (Function2)x$2, (Function2)x$3, x$4, x$5, x$6, ClassTag$.MODULE$.apply(MutableArrayTile.class));
        return ContextRDD$.MODULE$.apply(tiles, layout);
    }

    private <G extends Geometry> Rasterizer.Options _fromKeyedFeature$default$4() {
        return Rasterizer.Options$.MODULE$.DEFAULT();
    }

    private <G extends Geometry> Option<Partitioner> _fromKeyedFeature$default$5() {
        return None$.MODULE$;
    }

    public <G extends Geometry> RDD<Tuple2<SpatialKey, Tile>> fromFeatureWithZIndex(RDD<Feature<G, CellValue>> features, DataType cellType, LayoutDefinition layout, Rasterizer.Options options, Option<Partitioner> partitioner, DataType zIndexCellType) {
        RDD keyed = features.flatMap((Function1 & Serializable & scala.Serializable)feature -> layout.mapTransform().keysForGeometry(feature.geom()).iterator().map((Function1 & Serializable & scala.Serializable)key -> new Tuple2(key, (Object)new Tuple2(feature, key))), ClassTag$.MODULE$.apply(Tuple2.class));
        return this._fromKeyedFeatureWithZIndex(keyed, cellType, layout, options, partitioner, zIndexCellType);
    }

    public <G extends Geometry> Rasterizer.Options fromFeatureWithZIndex$default$4() {
        return Rasterizer.Options$.MODULE$.DEFAULT();
    }

    public <G extends Geometry> Option<Partitioner> fromFeatureWithZIndex$default$5() {
        return None$.MODULE$;
    }

    public <G extends Geometry> DataType fromFeatureWithZIndex$default$6() {
        return ByteConstantNoDataCellType$.MODULE$;
    }

    public <G extends Geometry> RDD<Tuple2<SpatialKey, Tile>> fromKeyedFeatureWithZIndex(RDD<Tuple2<SpatialKey, Feature<G, CellValue>>> features, DataType cellType, LayoutDefinition layout, Rasterizer.Options options, Option<Partitioner> partitioner, DataType zIndexCellType) {
        RDD keyed = features.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            SpatialKey key = (SpatialKey)tuple2._1();
            Feature feature = (Feature)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)key, (Object)new Tuple2((Object)feature, (Object)key));
            return tuple22;
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        return this._fromKeyedFeatureWithZIndex(keyed, cellType, layout, options, partitioner, this._fromKeyedFeatureWithZIndex$default$6());
    }

    public <G extends Geometry> Rasterizer.Options fromKeyedFeatureWithZIndex$default$4() {
        return Rasterizer.Options$.MODULE$.DEFAULT();
    }

    public <G extends Geometry> Option<Partitioner> fromKeyedFeatureWithZIndex$default$5() {
        return None$.MODULE$;
    }

    public <G extends Geometry> DataType fromKeyedFeatureWithZIndex$default$6() {
        return ByteConstantNoDataCellType$.MODULE$;
    }

    private <G extends Geometry> RDD<Tuple2<SpatialKey, Tile>> _fromKeyedFeatureWithZIndex(RDD<Tuple2<SpatialKey, Tuple2<Feature<G, CellValue>, SpatialKey>>> keyedFeatures, DataType cellType, LayoutDefinition layout, Rasterizer.Options options, Option<Partitioner> partitioner, DataType zIndexCellType) {
        Function1 & Serializable & scala.Serializable createTile = (Function1 & Serializable & scala.Serializable)tup -> {
            Tuple2 tuple2 = tup;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Feature feature = (Feature)tuple2._1();
            SpatialKey key = (SpatialKey)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)feature, (Object)key);
            Tuple2 tuple23 = tuple22;
            Feature feature2 = (Feature)tuple23._1();
            SpatialKey key2 = (SpatialKey)tuple23._2();
            MutableArrayTile tile = ArrayTile$.MODULE$.empty(cellType, layout.tileCols(), layout.tileRows());
            MutableArrayTile ztile = ArrayTile$.MODULE$.empty(zIndexCellType, layout.tileCols(), layout.tileRows());
            RasterExtent re = RasterExtent$.MODULE$.apply(layout.mapTransform().apply(key2), layout.tileCols(), layout.tileRows());
            package$.MODULE$.withGeometryRasterizeMethods(feature2.geom()).foreach(re, options, (Function2)(JFunction2.mcVII.sp & Serializable & scala.Serializable)(x, y) -> {
                double priority = ((CellValue)((Feature)tup._1()).data()).zindex();
                tile.setDouble(x, y, ((CellValue)feature2.data()).value());
                ztile.setDouble(x, y, priority);
            });
            return new Tuple2((Object)tile, (Object)ztile);
        };
        Function2 & Serializable & scala.Serializable updateTile = (Function2 & Serializable & scala.Serializable)(pair, tup) -> {
            Tuple2 tuple2 = tup;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Feature feature = (Feature)tuple2._1();
            SpatialKey key = (SpatialKey)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)feature, (Object)key);
            Tuple2 tuple23 = tuple22;
            Feature feature2 = (Feature)tuple23._1();
            SpatialKey key2 = (SpatialKey)tuple23._2();
            RasterExtent re = RasterExtent$.MODULE$.apply(layout.mapTransform().apply(key2), layout.tileCols(), layout.tileRows());
            Tuple2 tuple24 = pair;
            if (tuple24 == null) {
                throw new MatchError((Object)tuple24);
            }
            MutableArrayTile tile = (MutableArrayTile)tuple24._1();
            MutableArrayTile ztile = (MutableArrayTile)tuple24._2();
            Tuple2 tuple25 = new Tuple2((Object)tile, (Object)ztile);
            Tuple2 tuple26 = tuple25;
            MutableArrayTile tile2 = (MutableArrayTile)tuple26._1();
            MutableArrayTile ztile2 = (MutableArrayTile)tuple26._2();
            double priority = ((CellValue)((Feature)tup._1()).data()).zindex();
            package$.MODULE$.withGeometryRasterizeMethods(feature2.geom()).foreach(re, options, (Function2)(JFunction2.mcVII.sp & Serializable & scala.Serializable)(x, y) -> {
                block0: {
                    if (!Double.isNaN(((ArrayTile)pair._1()).getDouble(x, y)) && !((double)((ArrayTile)pair._2()).get(x, y) < priority)) break block0;
                    tile2.setDouble(x, y, ((CellValue)feature2.data()).value());
                    ztile2.setDouble(x, y, priority);
                }
            });
            return new Tuple2((Object)tile2, (Object)ztile2);
        };
        Function2 & Serializable & scala.Serializable mergeTiles = (Function2 & Serializable & scala.Serializable)(pair1, pair2) -> {
            Tuple2 tuple2 = pair1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            MutableArrayTile left = (MutableArrayTile)tuple2._1();
            MutableArrayTile leftPriority = (MutableArrayTile)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)left, (Object)leftPriority);
            Tuple2 tuple23 = tuple22;
            MutableArrayTile left2 = (MutableArrayTile)tuple23._1();
            MutableArrayTile leftPriority2 = (MutableArrayTile)tuple23._2();
            Tuple2 tuple24 = pair2;
            if (tuple24 == null) {
                throw new MatchError((Object)tuple24);
            }
            MutableArrayTile right = (MutableArrayTile)tuple24._1();
            MutableArrayTile rightPriority = (MutableArrayTile)tuple24._2();
            Tuple2 tuple25 = new Tuple2((Object)right, (Object)rightPriority);
            Tuple2 tuple26 = tuple25;
            MutableArrayTile right2 = (MutableArrayTile)tuple26._1();
            MutableArrayTile rightPriority2 = (MutableArrayTile)tuple26._2();
            MODULE$.mergePriority(left2, leftPriority2, right2, rightPriority2);
            return new Tuple2((Object)left2, (Object)leftPriority2);
        };
        PairRDDFunctions qual$1 = RDD$.MODULE$.rddToPairRDDFunctions(keyedFeatures, ClassTag$.MODULE$.apply(SpatialKey.class), ClassTag$.MODULE$.apply(Tuple2.class), SpatialKey$.MODULE$.ordering());
        Function1 & Serializable & scala.Serializable x$1 = createTile;
        Function2 & Serializable & scala.Serializable x$2 = updateTile;
        Function2 & Serializable & scala.Serializable x$3 = mergeTiles;
        Partitioner x$4 = (Partitioner)partitioner.getOrElse((Function0 & Serializable & scala.Serializable)() -> new HashPartitioner(keyedFeatures.getNumPartitions()));
        boolean x$5 = qual$1.combineByKeyWithClassTag$default$5();
        Serializer x$6 = qual$1.combineByKeyWithClassTag$default$6();
        RDD tiles = RDD$.MODULE$.rddToPairRDDFunctions(qual$1.combineByKeyWithClassTag((Function1)x$1, (Function2)x$2, (Function2)x$3, x$4, x$5, x$6, ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.apply(SpatialKey.class), ClassTag$.MODULE$.apply(Tuple2.class), SpatialKey$.MODULE$.ordering()).mapValues((Function1 & Serializable & scala.Serializable)tup -> (MutableArrayTile)tup._1());
        return ContextRDD$.MODULE$.apply(tiles, layout);
    }

    private <G extends Geometry> Rasterizer.Options _fromKeyedFeatureWithZIndex$default$4() {
        return Rasterizer.Options$.MODULE$.DEFAULT();
    }

    private <G extends Geometry> Option<Partitioner> _fromKeyedFeatureWithZIndex$default$5() {
        return None$.MODULE$;
    }

    private <G extends Geometry> DataType _fromKeyedFeatureWithZIndex$default$6() {
        return ByteConstantNoDataCellType$.MODULE$;
    }

    public Tuple2<MutableArrayTile, MutableArrayTile> mergePriority(MutableArrayTile leftTile, MutableArrayTile leftPriority, MutableArrayTile rightTile, MutableArrayTile rightPriority) {
        package$.MODULE$.TraversableTileExtensions((Traversable)new .colon.colon((Object)leftTile, (List)new .colon.colon((Object)rightTile, (List)new .colon.colon((Object)leftPriority, (List)new .colon.colon((Object)rightPriority, (List)Nil$.MODULE$))))).assertEqualDimensions();
        DataType dataType = leftTile.cellType();
        if (BitCellType$.MODULE$.equals(dataType)) {
            for (int index$macro$2 = 0; index$macro$2 < BoxesRunTime.unboxToInt((Object)leftTile.rows()); ++index$macro$2) {
                for (int index$macro$1 = 0; index$macro$1 < BoxesRunTime.unboxToInt((Object)leftTile.cols()); ++index$macro$1) {
                    int leftv = leftTile.get(index$macro$1, index$macro$2);
                    int rightv = rightTile.get(index$macro$1, index$macro$2);
                    int rightp = rightPriority.get(index$macro$1, index$macro$2);
                    if (leftv != 0 || rightv != 1) continue;
                    leftTile.set(index$macro$1, index$macro$2, rightv);
                    leftPriority.set(index$macro$1, index$macro$2, rightp);
                }
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            boolean bl = ByteCellType$.MODULE$.equals(dataType) ? true : (UByteCellType$.MODULE$.equals(dataType) ? true : (ShortCellType$.MODULE$.equals(dataType) ? true : (UShortCellType$.MODULE$.equals(dataType) ? true : IntCellType$.MODULE$.equals(dataType))));
            if (bl) {
                for (int index$macro$4 = 0; index$macro$4 < BoxesRunTime.unboxToInt((Object)leftTile.rows()); ++index$macro$4) {
                    for (int index$macro$3 = 0; index$macro$3 < BoxesRunTime.unboxToInt((Object)leftTile.cols()); ++index$macro$3) {
                        int leftv = leftTile.get(index$macro$3, index$macro$4);
                        int leftp = leftPriority.get(index$macro$3, index$macro$4);
                        int rightv = rightTile.get(index$macro$3, index$macro$4);
                        int rightp = rightPriority.get(index$macro$3, index$macro$4);
                        if ((leftv != 0 || rightv == 0) && (leftv == 0 || rightv == 0 || leftp >= rightp)) continue;
                        leftTile.set(index$macro$3, index$macro$4, rightTile.get(index$macro$3, index$macro$4));
                        leftPriority.set(index$macro$3, index$macro$4, rightp);
                    }
                }
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                boolean bl2 = FloatCellType$.MODULE$.equals(dataType) ? true : DoubleCellType$.MODULE$.equals(dataType);
                if (bl2) {
                    for (int index$macro$6 = 0; index$macro$6 < BoxesRunTime.unboxToInt((Object)leftTile.rows()); ++index$macro$6) {
                        for (int index$macro$5 = 0; index$macro$5 < BoxesRunTime.unboxToInt((Object)leftTile.cols()); ++index$macro$5) {
                            double leftv = leftTile.getDouble(index$macro$5, index$macro$6);
                            int leftp = leftPriority.get(index$macro$5, index$macro$6);
                            double rightv = rightTile.getDouble(index$macro$5, index$macro$6);
                            int rightp = rightPriority.get(index$macro$5, index$macro$6);
                            if ((leftv != 0.0 || rightv == 0.0) && (leftv == 0.0 || rightv == 0.0 || leftp >= rightp)) continue;
                            leftTile.setDouble(index$macro$5, index$macro$6, rightv);
                            leftPriority.set(index$macro$5, index$macro$6, rightp);
                        }
                    }
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if (dataType.isFloatingPoint()) {
                    for (int index$macro$8 = 0; index$macro$8 < BoxesRunTime.unboxToInt((Object)leftTile.rows()); ++index$macro$8) {
                        for (int index$macro$7 = 0; index$macro$7 < BoxesRunTime.unboxToInt((Object)leftTile.cols()); ++index$macro$7) {
                            double leftv = leftTile.getDouble(index$macro$7, index$macro$8);
                            boolean leftnd = Double.isNaN(leftTile.getDouble(index$macro$7, index$macro$8));
                            int leftp = leftPriority.get(index$macro$7, index$macro$8);
                            double rightv = rightTile.getDouble(index$macro$7, index$macro$8);
                            boolean rightnd = Double.isNaN(rightTile.getDouble(index$macro$7, index$macro$8));
                            int rightp = rightPriority.get(index$macro$7, index$macro$8);
                            if ((!leftnd || rightnd) && (leftnd || rightnd || leftp >= rightp)) continue;
                            leftTile.setDouble(index$macro$7, index$macro$8, rightv);
                            leftPriority.set(index$macro$7, index$macro$8, rightp);
                        }
                    }
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    for (int index$macro$10 = 0; index$macro$10 < BoxesRunTime.unboxToInt((Object)leftTile.rows()); ++index$macro$10) {
                        for (int index$macro$9 = 0; index$macro$9 < BoxesRunTime.unboxToInt((Object)leftTile.cols()); ++index$macro$9) {
                            int leftv = leftTile.get(index$macro$9, index$macro$10);
                            boolean leftnd = leftTile.get(index$macro$9, index$macro$10) == Integer.MIN_VALUE;
                            int leftp = leftPriority.get(index$macro$9, index$macro$10);
                            int rightv = rightTile.get(index$macro$9, index$macro$10);
                            boolean rightnd = rightTile.get(index$macro$9, index$macro$10) == Integer.MIN_VALUE;
                            int rightp = rightPriority.get(index$macro$9, index$macro$10);
                            if ((!leftnd || rightnd) && (leftnd || rightnd || leftp >= rightp)) continue;
                            leftTile.set(index$macro$9, index$macro$10, rightv);
                            leftPriority.set(index$macro$9, index$macro$10, rightp);
                        }
                    }
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
            }
        }
        return new Tuple2((Object)leftTile, (Object)leftPriority);
    }

    private RasterizeRDD$() {
        MODULE$ = this;
    }
}

