/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.spark.reproject;

import geotrellis.layer.Boundable;
import geotrellis.layer.FloatingLayoutScheme;
import geotrellis.layer.KeyBounds;
import geotrellis.layer.KeyBounds$;
import geotrellis.layer.LayoutDefinition;
import geotrellis.layer.LayoutLevel;
import geotrellis.layer.LayoutScheme;
import geotrellis.layer.MapKeyTransform;
import geotrellis.layer.Metadata;
import geotrellis.layer.SpatialKey;
import geotrellis.layer.TileLayerMetadata;
import geotrellis.proj4.CRS;
import geotrellis.proj4.Proj4Transform$;
import geotrellis.proj4.Transform$;
import geotrellis.raster.CellGrid;
import geotrellis.raster.CellSize;
import geotrellis.raster.GridBounds;
import geotrellis.raster.GridBounds$;
import geotrellis.raster.GridExtent;
import geotrellis.raster.Raster;
import geotrellis.raster.RasterExtent;
import geotrellis.raster.RasterExtent$;
import geotrellis.raster.TileLayout;
import geotrellis.raster.buffer.BufferSizes;
import geotrellis.raster.buffer.BufferedTile;
import geotrellis.raster.crop.CropMethods;
import geotrellis.raster.merge.TileMergeMethods;
import geotrellis.raster.prototype.TilePrototypeMethods;
import geotrellis.raster.reproject.RasterRegionReproject;
import geotrellis.raster.reproject.Reproject;
import geotrellis.raster.reproject.ReprojectRasterExtent$;
import geotrellis.raster.stitch.Stitcher;
import geotrellis.spark.ContextRDD;
import geotrellis.spark.ContextRDD$;
import geotrellis.spark.buffer.BufferTilesRDD$;
import geotrellis.spark.package$;
import geotrellis.spark.reproject.Reproject;
import geotrellis.spark.reproject.TileRDDReproject;
import geotrellis.util.Component;
import geotrellis.util.GetComponent;
import geotrellis.util.SetComponent;
import geotrellis.vector.Extent;
import geotrellis.vector.ProjectedExtent;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import org.apache.spark.Partitioner;
import org.apache.spark.SparkContext;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Polygon;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.Iterator$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.Set$;
import scala.collection.immutable.Vector;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.Null$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;
import spire.math.Integral;
import spire.math.Integral$;

public final class TileRDDReproject$ {
    public static TileRDDReproject$ MODULE$;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    static {
        new TileRDDReproject$();
    }

    private Logger logger$lzycompute() {
        TileRDDReproject$ tileRDDReproject$ = this;
        synchronized (tileRDDReproject$) {
            if (!this.bitmap$trans$0) {
                this.logger = LoggerFactory.getLogger((String)"geotrellis.spark.reproject.TileRDDReproject");
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    private Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    /*
     * Unable to fully structure code
     */
    public <K, V extends CellGrid<Object>> Tuple2<Object, RDD<Tuple2<K, V>>> apply(RDD<Tuple2<K, BufferedTile<V>>> bufferedTiles, TileLayerMetadata<K> metadata, CRS destCrs, Either<LayoutScheme, LayoutDefinition> targetLayout, Reproject.Options options, Option<Partitioner> partitioner, Component<K, SpatialKey> evidence$1, Boundable<K> evidence$2, ClassTag<K> evidence$3, ClassTag<V> evidence$4, RasterRegionReproject<V> evidence$5, Function1<V, TileMergeMethods<V>> evidence$6, Function1<V, TilePrototypeMethods<V>> evidence$7) {
        block25: {
            block24: {
                crs = metadata.crs();
                layout = metadata.layout();
                tileLayout = layout.tileLayout();
                sc = bufferedTiles.context();
                sourceDataGridExtent = metadata.layout().createAlignedGridExtent$mcJ$sp(metadata.extent());
                passthroughGridExtent = ReprojectRasterExtent$.MODULE$.apply(sourceDataGridExtent, metadata.crs(), destCrs, (Integral)Integral$.MODULE$.LongIsIntegral());
                targetDataExtent = passthroughGridExtent.extent();
                targetPartitioner = partitioner.orElse((Function0)(Function0 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$apply$1(org.apache.spark.rdd.RDD ), ()Lscala/Option;)(bufferedTiles));
                reprojectSummary = this.matchReprojectRasterExtent(metadata.crs(), destCrs, metadata.layout(), (Option<KeyBounds<SpatialKey>>)metadata.bounds().toOption().map((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$apply$2(geotrellis.util.Component geotrellis.layer.KeyBounds ), (Lgeotrellis/layer/KeyBounds;)Lgeotrellis/layer/KeyBounds;)(evidence$1)), sc);
                if (this.logger().isDebugEnabled()) {
                    this.logger().debug(String.valueOf(reprojectSummary));
                }
                var30_23 = false;
                var31_24 = null;
                var32_25 = targetLayout;
                if (!(var32_25 instanceof Right)) break block24;
                var33_26 = (Right)var32_25;
                layoutDefinition = (LayoutDefinition)var33_26.value();
                var16_28 = new LayoutLevel(0, layoutDefinition);
                break block25;
            }
            if (!(var32_25 instanceof Left)) ** GOTO lbl-1000
            var30_23 = true;
            var31_24 = (Left)var32_25;
            layoutScheme = (LayoutScheme)var31_24.value();
            if (layoutScheme instanceof FloatingLayoutScheme) {
                var36_30 = (FloatingLayoutScheme)layoutScheme;
                if (options.matchLayerExtent()) {
                    tre = ReprojectRasterExtent$.MODULE$.apply((GridExtent)layout, crs, destCrs, options.rasterReprojectOptions(), (Integral)Integral$.MODULE$.LongIsIntegral());
                    v0 = var36_30.levelFor(tre.extent(), tre.cellSize());
                } else {
                    var38_32 = options.rasterReprojectOptions().parentGridExtent();
                    if (var38_32 instanceof Some) {
                        var39_33 = (Some)var38_32;
                        ge = (GridExtent)var39_33.value();
                        var17_35 = var36_30.levelFor(targetDataExtent, ge.cellSize());
                    } else if (None$.MODULE$.equals(var38_32)) {
                        var41_36 = options.rasterReprojectOptions().targetCellSize();
                        if (var41_36 instanceof Some) {
                            var42_37 = (Some)var41_36;
                            ct = (CellSize)var42_37.value();
                            var18_39 = var36_30.levelFor(targetDataExtent, ct);
                        } else if (None$.MODULE$.equals(var41_36)) {
                            var18_39 = var36_30.levelFor(targetDataExtent, passthroughGridExtent.cellSize());
                        } else {
                            throw new MatchError((Object)var41_36);
                        }
                        var17_35 = var18_39;
                    } else {
                        throw new MatchError((Object)var38_32);
                    }
                    v0 = var17_35;
                }
                var16_28 = v0;
            } else if (var30_23) {
                layoutScheme = (LayoutScheme)var31_24.value();
                if (options.matchLayerExtent()) {
                    x$1 = None$.MODULE$;
                    x$2 = None$.MODULE$;
                    x$3 = None$.MODULE$;
                    x$4 = options.rasterReprojectOptions().copy$default$1();
                    x$5 = options.rasterReprojectOptions().copy$default$2();
                    tre = ReprojectRasterExtent$.MODULE$.apply(sourceDataGridExtent, crs, destCrs, options.rasterReprojectOptions().copy(x$4, x$5, (Option)x$1, (Option)x$3, (Option)x$2), (Integral)Integral$.MODULE$.LongIsIntegral());
                    v1 = layoutScheme.levelFor(tre.extent(), tre.cellSize());
                } else {
                    tre = ReprojectRasterExtent$.MODULE$.apply(sourceDataGridExtent, crs, destCrs, options.rasterReprojectOptions(), (Integral)Integral$.MODULE$.LongIsIntegral());
                    if (options.rasterReprojectOptions().targetCellSize().isDefined() || options.rasterReprojectOptions().parentGridExtent().isDefined()) {
                        v1 = layoutScheme.levelFor(tre.extent(), tre.cellSize());
                    } else {
                        cellSize = reprojectSummary.cellSize();
                        v1 = layoutScheme.levelFor(tre.extent(), cellSize);
                    }
                }
                var16_28 = v1;
            } else {
                throw new MatchError(var32_25);
            }
        }
        var29_49 = var16_28;
        if (var29_49 == null) {
            throw new MatchError((Object)var29_49);
        }
        targetZoom = var29_49.zoom();
        targetLayerLayout = var29_49.layout();
        var15_52 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)targetZoom), (Object)targetLayerLayout);
        var28_53 = var15_52;
        targetZoom = var28_53._1$mcI$sp();
        targetLayerLayout = (LayoutDefinition)var28_53._2();
        x$6 = new Some((Object)targetLayerLayout);
        x$7 = None$.MODULE$;
        x$8 = None$.MODULE$;
        x$9 = options.rasterReprojectOptions().copy$default$1();
        x$10 = options.rasterReprojectOptions().copy$default$2();
        rasterReprojectOptions = options.rasterReprojectOptions().copy(x$9, x$10, (Option)x$6, (Option)x$8, (Option)x$7);
        x$11 = destCrs;
        x$12 = targetLayerLayout;
        x$13 = targetDataExtent;
        x$14 = metadata.bounds().setSpatialBounds(KeyBounds$.MODULE$.apply(targetLayerLayout.mapTransform().extentToBounds(targetDataExtent)), evidence$1);
        x$15 = metadata.copy$default$1();
        newMetadata = metadata.copy(x$15, x$12, x$13, x$11, x$14);
        newLayout = newMetadata.layout();
        maptrans = newLayout.mapTransform();
        rrp = (RasterRegionReproject)Predef$.MODULE$.implicitly(evidence$5);
        stagedTiles = bufferedTiles.mapPartitions((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$apply$3(geotrellis.util.Component geotrellis.layer.LayoutDefinition geotrellis.proj4.CRS geotrellis.proj4.CRS geotrellis.layer.MapKeyTransform geotrellis.layer.LayoutDefinition scala.collection.Iterator ), (Lscala/collection/Iterator;)Lscala/collection/Iterator;)(evidence$1, (LayoutDefinition)layout, (CRS)crs, (CRS)destCrs, (MapKeyTransform)maptrans, (LayoutDefinition)newLayout), bufferedTiles.mapPartitions$default$2(), ClassTag$.MODULE$.apply(Tuple2.class));
        var76_72 = targetPartitioner;
        if (var76_72 instanceof Some) {
            var77_73 = (Some)var76_72;
            part = (Partitioner)var77_73.value();
            x$16 = stagedTiles;
            x$17 = evidence$3;
            x$18 = ClassTag$.MODULE$.apply(Tuple3.class);
            x$19 = RDD$.MODULE$.rddToPairRDDFunctions$default$4(x$16);
            qual$1 = RDD$.MODULE$.rddToPairRDDFunctions(x$16, x$17, x$18, null);
            x$20 = (Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$apply$6(geotrellis.raster.reproject.RasterRegionReproject geotrellis.proj4.CRS geotrellis.proj4.CRS geotrellis.raster.reproject.Reproject$Options scala.Tuple3 ), (Lscala/Tuple3;)Lgeotrellis/raster/CellGrid;)((RasterRegionReproject)rrp, (CRS)crs, (CRS)destCrs, (Reproject.Options)rasterReprojectOptions);
            x$21 = (Function2 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$apply$7(geotrellis.raster.reproject.RasterRegionReproject geotrellis.proj4.CRS geotrellis.proj4.CRS geotrellis.raster.reproject.Reproject$Options geotrellis.raster.CellGrid scala.Tuple3 ), (Lgeotrellis/raster/CellGrid;Lscala/Tuple3;)Lgeotrellis/raster/CellGrid;)((RasterRegionReproject)rrp, (CRS)crs, (CRS)destCrs, (Reproject.Options)rasterReprojectOptions);
            x$22 = (Function2 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$apply$8(scala.Function1 geotrellis.raster.CellGrid geotrellis.raster.CellGrid ), (Lgeotrellis/raster/CellGrid;Lgeotrellis/raster/CellGrid;)Lgeotrellis/raster/CellGrid;)(evidence$6);
            x$23 = part;
            x$24 = qual$1.combineByKey$default$5();
            x$25 = qual$1.combineByKey$default$6();
            var14_86 = qual$1.combineByKey((Function1)x$20, (Function2)x$21, (Function2)x$22, x$23, x$24, x$25);
        } else if (None$.MODULE$.equals(var76_72)) {
            x$26 = stagedTiles;
            x$27 = evidence$3;
            x$28 = ClassTag$.MODULE$.apply(Tuple3.class);
            x$29 = RDD$.MODULE$.rddToPairRDDFunctions$default$4(x$26);
            var14_86 = RDD$.MODULE$.rddToPairRDDFunctions(x$26, x$27, x$28, null).combineByKey((Function1)(Function1 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$apply$9(geotrellis.raster.reproject.RasterRegionReproject geotrellis.proj4.CRS geotrellis.proj4.CRS geotrellis.raster.reproject.Reproject$Options scala.Tuple3 ), (Lscala/Tuple3;)Lgeotrellis/raster/CellGrid;)((RasterRegionReproject)rrp, (CRS)crs, (CRS)destCrs, (Reproject.Options)rasterReprojectOptions), (Function2)(Function2 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$apply$10(geotrellis.raster.reproject.RasterRegionReproject geotrellis.proj4.CRS geotrellis.proj4.CRS geotrellis.raster.reproject.Reproject$Options geotrellis.raster.CellGrid scala.Tuple3 ), (Lgeotrellis/raster/CellGrid;Lscala/Tuple3;)Lgeotrellis/raster/CellGrid;)((RasterRegionReproject)rrp, (CRS)crs, (CRS)destCrs, (Reproject.Options)rasterReprojectOptions), (Function2)(Function2 & Serializable & scala.Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$apply$11(scala.Function1 geotrellis.raster.CellGrid geotrellis.raster.CellGrid ), (Lgeotrellis/raster/CellGrid;Lgeotrellis/raster/CellGrid;)Lgeotrellis/raster/CellGrid;)(evidence$6));
        } else {
            throw new MatchError((Object)var76_72);
        }
        tiled = var14_86;
        return new Tuple2((Object)BoxesRunTime.boxToInteger((int)targetZoom), ContextRDD$.MODULE$.apply(tiled, newMetadata));
    }

    public <K, V extends CellGrid<Object>> Tuple2<Object, RDD<Tuple2<K, V>>> apply(RDD<Tuple2<K, V>> rdd, CRS destCrs, Either<LayoutScheme, LayoutDefinition> targetLayout, Reproject.Options options, Option<Partitioner> partitioner, Component<K, SpatialKey> evidence$8, Boundable<K> evidence$9, ClassTag<K> evidence$10, ClassTag<V> evidence$11, RasterRegionReproject<V> evidence$12, Stitcher<V> evidence$13, Function1<V, CropMethods<V>> evidence$14, Function1<V, TileMergeMethods<V>> evidence$15, Function1<V, TilePrototypeMethods<V>> evidence$16) {
        Tuple2<Object, RDD<Tuple2<K, V>>> tuple2;
        CRS cRS = ((TileLayerMetadata)((Metadata)rdd).metadata()).crs();
        CRS cRS2 = destCrs;
        if (!(cRS != null ? !cRS.equals(cRS2) : cRS2 != null)) {
            Tuple2.mcIZ.sp sp2;
            LayoutDefinition layout = ((TileLayerMetadata)((Metadata)rdd).metadata()).layout();
            Either<LayoutScheme, LayoutDefinition> either = targetLayout;
            if (either instanceof Left) {
                LayoutDefinition newLayout;
                Left left = (Left)either;
                LayoutScheme layoutScheme = (LayoutScheme)left.value();
                LayoutLevel layoutLevel = layoutScheme.levelFor(layout.extent(), layout.cellSize());
                if (layoutLevel == null) {
                    throw new MatchError((Object)layoutLevel);
                }
                int zoom = layoutLevel.zoom();
                LayoutDefinition newLayout2 = layoutLevel.layout();
                Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)zoom), (Object)newLayout2);
                Tuple2 tuple23 = tuple22;
                int zoom2 = tuple23._1$mcI$sp();
                LayoutDefinition layoutDefinition = newLayout = (LayoutDefinition)tuple23._2();
                LayoutDefinition layoutDefinition2 = layout;
                sp2 = new Tuple2.mcIZ.sp(zoom2, !(layoutDefinition != null ? !layoutDefinition.equals(layoutDefinition2) : layoutDefinition2 != null));
            } else if (either instanceof Right) {
                LayoutDefinition layoutDefinition;
                Right right = (Right)either;
                LayoutDefinition layoutDefinition3 = layoutDefinition = (LayoutDefinition)right.value();
                LayoutDefinition layoutDefinition4 = layout;
                sp2 = new Tuple2.mcIZ.sp(0, !(layoutDefinition3 != null ? !layoutDefinition3.equals(layoutDefinition4) : layoutDefinition4 != null));
            } else {
                throw new MatchError(either);
            }
            Tuple2.mcIZ.sp sp3 = sp2;
            if (sp3 == null) {
                throw new MatchError((Object)sp3);
            }
            int zoom = sp3._1$mcI$sp();
            boolean bail = sp3._2$mcZ$sp();
            Tuple2.mcIZ.sp sp4 = new Tuple2.mcIZ.sp(zoom, bail);
            Tuple2.mcIZ.sp sp5 = sp4;
            int zoom3 = sp5._1$mcI$sp();
            boolean bail2 = sp5._2$mcZ$sp();
            tuple2 = bail2 ? new Tuple2<Object, RDD<Tuple2<K, V>>>((Object)BoxesRunTime.boxToInteger((int)zoom3), rdd) : this.apply(rdd, destCrs, targetLayout, 0, options, partitioner, evidence$8, evidence$9, evidence$10, evidence$11, evidence$12, evidence$13, evidence$14, evidence$15, evidence$16);
        } else {
            LazyRef transform$lzy = new LazyRef();
            CRS crs = ((TileLayerMetadata)((Metadata)rdd).metadata()).crs();
            LayoutDefinition layout = ((TileLayerMetadata)((Metadata)rdd).metadata()).layout();
            TileLayout tileLayout = ((TileLayerMetadata)((Metadata)rdd).metadata()).layout().tileLayout();
            RDD<Tuple2<K, BufferedTile<V>>> bufferedTiles = BufferTilesRDD$.MODULE$.apply(rdd, (Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)TileRDDReproject$.$anonfun$apply$12(rdd, evidence$9, x$6)), (Function1 & Serializable & scala.Serializable)key -> {
                RasterExtent dstRE;
                Extent e;
                Extent extent = ((SpatialKey)geotrellis.util.package$.MODULE$.withGetComponentMethods(key).getComponent((GetComponent)evidence$8)).extent(layout);
                RasterExtent srcRE = RasterExtent$.MODULE$.apply(extent, tileLayout.tileCols(), tileLayout.tileRows());
                GridBounds gb = srcRE.gridBoundsFor$mcI$sp(e = geotrellis.vector.package$.MODULE$.ReprojectExtent((dstRE = ReprojectRasterExtent$.MODULE$.apply(srcRE, TileRDDReproject$.transform$1(transform$lzy, crs, destCrs))).extent()).reproject(destCrs, crs), false);
                int x$1 = 1 + (gb.colMin$mcI$sp() < 0 ? -gb.colMin$mcI$sp() : 0);
                int x$2 = 1 + (gb.colMax$mcI$sp() >= srcRE.cols() ? gb.colMax$mcI$sp() - (srcRE.cols() - 1) : 0);
                int x$3 = 1 + (gb.rowMin$mcI$sp() < 0 ? -gb.rowMin$mcI$sp() : 0);
                int x$4 = 1 + (gb.rowMax$mcI$sp() >= srcRE.rows() ? gb.rowMax$mcI$sp() - (srcRE.rows() - 1) : 0);
                return new BufferSizes(x$1, x$2, x$4, x$3);
            }, evidence$8, evidence$10, evidence$13, evidence$14);
            tuple2 = this.apply(bufferedTiles, (TileLayerMetadata)((Metadata)rdd).metadata(), destCrs, targetLayout, options, partitioner, evidence$8, evidence$9, evidence$10, evidence$11, evidence$12, evidence$15, evidence$16);
        }
        return tuple2;
    }

    public <K, V extends CellGrid<Object>> Tuple2<Object, RDD<Tuple2<K, V>>> apply(RDD<Tuple2<K, V>> rdd, CRS destCrs, Either<LayoutScheme, LayoutDefinition> targetLayout, int bufferSize, Reproject.Options options, Option<Partitioner> partitioner, Component<K, SpatialKey> evidence$17, Boundable<K> evidence$18, ClassTag<K> evidence$19, ClassTag<V> evidence$20, RasterRegionReproject<V> evidence$21, Stitcher<V> evidence$22, Function1<V, CropMethods<V>> evidence$23, Function1<V, TileMergeMethods<V>> evidence$24, Function1<V, TilePrototypeMethods<V>> evidence$25) {
        Tuple2<Object, RDD<Tuple2<K, V>>> tuple2;
        if (bufferSize == 0) {
            ContextRDD fakeBuffers = package$.MODULE$.WithContextWrapper(rdd).withContext((Function1 & Serializable & scala.Serializable)x$7 -> {
                RDD x$1 = x$7;
                ClassTag x$2 = evidence$19;
                ClassTag x$3 = evidence$20;
                Null$ x$4 = RDD$.MODULE$.rddToPairRDDFunctions$default$4(x$1);
                return RDD$.MODULE$.rddToPairRDDFunctions(x$1, x$2, x$3, null).mapValues((Function1 & Serializable & scala.Serializable)tile -> new BufferedTile(tile, GridBounds$.MODULE$.apply(0, 0, BoxesRunTime.unboxToInt((Object)tile.cols()) - 1, BoxesRunTime.unboxToInt((Object)tile.rows()) - 1)));
            });
            tuple2 = this.apply(fakeBuffers, (TileLayerMetadata)((Metadata)rdd).metadata(), destCrs, targetLayout, options, partitioner, evidence$17, evidence$18, evidence$19, evidence$20, evidence$21, evidence$24, evidence$25);
        } else {
            tuple2 = this.apply(package$.MODULE$.withBufferTilesRDDMethodsWrapper(rdd, evidence$17, evidence$19, evidence$22, evidence$20, evidence$23).bufferTiles(bufferSize), (TileLayerMetadata)((Metadata)rdd).metadata(), destCrs, targetLayout, options, partitioner, evidence$17, evidence$18, evidence$19, evidence$20, evidence$21, evidence$24, evidence$25);
        }
        return tuple2;
    }

    private TileRDDReproject.ReprojectSummary matchReprojectRasterExtent(CRS src, CRS dst, LayoutDefinition layout, Option<KeyBounds<SpatialKey>> keyBounds, SparkContext sc) {
        GridBounds gridBounds;
        Option<KeyBounds<SpatialKey>> option = keyBounds;
        if (option instanceof Some) {
            Some some = (Some)option;
            KeyBounds kb = (KeyBounds)some.value();
            gridBounds = KeyBounds$.MODULE$.withSpatialComponentKeyBoundsMethods(kb, geotrellis.util.package$.MODULE$.identityComponent()).toGridBounds();
        } else if (None$.MODULE$.equals(option)) {
            gridBounds = GridBounds$.MODULE$.apply(0, 0, layout.layoutCols(), layout.layoutRows());
        } else {
            throw new MatchError(option);
        }
        GridBounds bounds = gridBounds;
        MapKeyTransform mapTransform = layout.mapTransform();
        Function2 & Serializable & scala.Serializable getRasterExtent = (Function2 & Serializable & scala.Serializable)(col, row) -> RasterExtent$.MODULE$.apply(mapTransform.apply(BoxesRunTime.unboxToInt((Object)col), BoxesRunTime.unboxToInt((Object)row)), layout.tileCols(), layout.tileRows());
        Vector chunks = bounds.split$mcI$sp(512, 512).toVector();
        return (TileRDDReproject.ReprojectSummary)sc.parallelize((Seq)chunks, chunks.length(), ClassTag$.MODULE$.apply(GridBounds.class)).map((Function1 & Serializable & scala.Serializable)boundsChunk -> {
            Iterator splitWork = boundsChunk.split$mcI$sp(128, 128).map((Function1 & Serializable & scala.Serializable)subChunk -> Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
                Function2 transform = Proj4Transform$.MODULE$.apply(src, dst);
                return (TileRDDReproject.ReprojectSummary)subChunk.coordsIter().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 == null) {
                        throw new MatchError((Object)tuple2);
                    }
                    int col = tuple2._1$mcI$sp();
                    int row = tuple2._2$mcI$sp();
                    RasterExtent source = (RasterExtent)getRasterExtent.apply((Object)BoxesRunTime.boxToInteger((int)col), (Object)BoxesRunTime.boxToInteger((int)row));
                    RasterExtent target = ReprojectRasterExtent$.MODULE$.apply(source, transform);
                    TileRDDReproject.ReprojectSummary reprojectSummary = new TileRDDReproject.ReprojectSummary(BoxesRunTime.unboxToInt((Object)source.size()), BoxesRunTime.unboxToInt((Object)target.size()), target.extent(), target.cellSize());
                    return reprojectSummary;
                }).reduce((Function2 & Serializable & scala.Serializable)(x$8, x$9) -> x$8.combine((TileRDDReproject.ReprojectSummary)x$9));
            }, ExecutionContext.Implicits$.MODULE$.global()));
            return (TileRDDReproject.ReprojectSummary)((TraversableOnce)Await$.MODULE$.result((Awaitable)Future$.MODULE$.sequence((TraversableOnce)splitWork, (CanBuildFrom)Iterator$.MODULE$.IteratorCanBuildFrom(), ExecutionContext.Implicits$.MODULE$.global()), (Duration)Duration$.MODULE$.Inf())).reduce((Function2 & Serializable & scala.Serializable)(x$10, x$11) -> x$10.combine((TileRDDReproject.ReprojectSummary)x$11));
        }, ClassTag$.MODULE$.apply(TileRDDReproject.ReprojectSummary.class)).reduce((Function2 & Serializable & scala.Serializable)(x$12, x$13) -> x$12.combine((TileRDDReproject.ReprojectSummary)x$13));
    }

    public static final /* synthetic */ Option $anonfun$apply$1(RDD bufferedTiles$1) {
        return bufferedTiles$1.partitioner();
    }

    public static final /* synthetic */ KeyBounds $anonfun$apply$2(Component evidence$1$1, KeyBounds x0$1) {
        KeyBounds keyBounds = x0$1;
        if (keyBounds == null) {
            throw new MatchError((Object)keyBounds);
        }
        Object s = keyBounds.minKey();
        Object e = keyBounds.maxKey();
        KeyBounds keyBounds2 = new KeyBounds(geotrellis.util.package$.MODULE$.withGetComponentMethods(s).getComponent((GetComponent)evidence$1$1), geotrellis.util.package$.MODULE$.withGetComponentMethods(e).getComponent((GetComponent)evidence$1$1));
        return keyBounds2;
    }

    public static final /* synthetic */ Iterator $anonfun$apply$3(Component evidence$1$1, LayoutDefinition layout$1, CRS crs$1, CRS destCrs$1, MapKeyTransform maptrans$1, LayoutDefinition newLayout$1, Iterator partition) {
        return partition.flatMap((Function1 & Serializable & scala.Serializable)x0$2 -> {
            BufferedTile bufferedTile;
            Object key;
            block3: {
                Tuple2 tuple2;
                block2: {
                    tuple2 = x0$2;
                    if (tuple2 == null) break block2;
                    key = tuple2._1();
                    bufferedTile = (BufferedTile)tuple2._2();
                    if (bufferedTile != null) break block3;
                }
                throw new MatchError((Object)tuple2);
            }
            CellGrid tile = (CellGrid)bufferedTile.tile();
            GridBounds gridBounds = bufferedTile.targetArea();
            Extent innerExtent = ((SpatialKey)geotrellis.util.package$.MODULE$.withGetComponentMethods(key).getComponent((GetComponent)evidence$1$1)).extent(layout$1);
            RasterExtent innerRasterExtent = RasterExtent$.MODULE$.apply(innerExtent, gridBounds.width$mcI$sp(), gridBounds.height$mcI$sp());
            GridBounds outerGridBounds = GridBounds$.MODULE$.apply(-gridBounds.colMin$mcI$sp(), -gridBounds.rowMin$mcI$sp(), BoxesRunTime.unboxToInt((Object)tile.cols()) - gridBounds.colMin$mcI$sp() - 1, BoxesRunTime.unboxToInt((Object)tile.rows()) - gridBounds.rowMin$mcI$sp() - 1);
            Extent outerExtent = innerRasterExtent.extentFor$mcI$sp(outerGridBounds, false);
            Polygon destRegion = new ProjectedExtent(innerExtent, crs$1).reprojectAsPolygon(destCrs$1, 0.05);
            GenTraversableOnce genTraversableOnce = (GenTraversableOnce)maptrans$1.keysForGeometry((Geometry)destRegion).map((Function1 & Serializable & scala.Serializable)newKey -> {
                RasterExtent destRE = RasterExtent$.MODULE$.apply(maptrans$1.apply(newKey), newLayout$1.tileLayout().tileCols(), newLayout$1.tileLayout().tileRows());
                return new Tuple2(geotrellis.util.package$.MODULE$.withSetComponentMethods(key).setComponent(newKey, (SetComponent)evidence$1$1), (Object)new Tuple3((Object)new Raster(tile, outerExtent), (Object)destRE, (Object)destRegion));
            }, Set$.MODULE$.canBuildFrom());
            return genTraversableOnce;
        });
    }

    private static final CellGrid createCombiner$1(Tuple3 tup, RasterRegionReproject rrp$1, CRS crs$1, CRS destCrs$1, Reproject.Options rasterReprojectOptions$1) {
        Tuple3 tuple3 = tup;
        if (tuple3 == null) {
            throw new MatchError((Object)tuple3);
        }
        Raster raster = (Raster)tuple3._1();
        RasterExtent destRE = (RasterExtent)tuple3._2();
        Polygon destRegion = (Polygon)tuple3._3();
        Tuple3 tuple32 = new Tuple3((Object)raster, (Object)destRE, (Object)destRegion);
        Tuple3 tuple33 = tuple32;
        Raster raster2 = (Raster)tuple33._1();
        RasterExtent destRE2 = (RasterExtent)tuple33._2();
        Polygon destRegion2 = (Polygon)tuple33._3();
        return rrp$1.regionReproject(raster2, crs$1, destCrs$1, destRE2, destRegion2, rasterReprojectOptions$1.method(), rasterReprojectOptions$1.errorThreshold()).tile();
    }

    private static final CellGrid mergeValues$1(CellGrid reprojectedTile, Tuple3 toReproject, RasterRegionReproject rrp$1, CRS crs$1, CRS destCrs$1, Reproject.Options rasterReprojectOptions$1) {
        Tuple3 tuple3 = toReproject;
        if (tuple3 == null) {
            throw new MatchError((Object)tuple3);
        }
        Raster raster = (Raster)tuple3._1();
        RasterExtent destRE = (RasterExtent)tuple3._2();
        Polygon destRegion = (Polygon)tuple3._3();
        Tuple3 tuple32 = new Tuple3((Object)raster, (Object)destRE, (Object)destRegion);
        Tuple3 tuple33 = tuple32;
        Raster raster2 = (Raster)tuple33._1();
        RasterExtent destRE2 = (RasterExtent)tuple33._2();
        Polygon destRegion2 = (Polygon)tuple33._3();
        Raster destRaster = new Raster(reprojectedTile, destRE2.extent());
        return rrp$1.regionReprojectMutable(raster2, crs$1, destCrs$1, destRaster, destRegion2, rasterReprojectOptions$1.method(), rasterReprojectOptions$1.errorThreshold()).tile();
    }

    private static final CellGrid mergeCombiners$1(CellGrid reproj1, CellGrid reproj2, Function1 evidence$6$1) {
        return (CellGrid)((TileMergeMethods)evidence$6$1.apply((Object)reproj1)).merge((Object)reproj2);
    }

    public static final /* synthetic */ CellGrid $anonfun$apply$6(RasterRegionReproject rrp$1, CRS crs$1, CRS destCrs$1, Reproject.Options rasterReprojectOptions$1, Tuple3 tup) {
        return TileRDDReproject$.createCombiner$1(tup, rrp$1, crs$1, destCrs$1, rasterReprojectOptions$1);
    }

    public static final /* synthetic */ CellGrid $anonfun$apply$7(RasterRegionReproject rrp$1, CRS crs$1, CRS destCrs$1, Reproject.Options rasterReprojectOptions$1, CellGrid reprojectedTile, Tuple3 toReproject) {
        return TileRDDReproject$.mergeValues$1(reprojectedTile, toReproject, rrp$1, crs$1, destCrs$1, rasterReprojectOptions$1);
    }

    public static final /* synthetic */ CellGrid $anonfun$apply$8(Function1 evidence$6$1, CellGrid reproj1, CellGrid reproj2) {
        return TileRDDReproject$.mergeCombiners$1(reproj1, reproj2, evidence$6$1);
    }

    public static final /* synthetic */ CellGrid $anonfun$apply$9(RasterRegionReproject rrp$1, CRS crs$1, CRS destCrs$1, Reproject.Options rasterReprojectOptions$1, Tuple3 tup) {
        return TileRDDReproject$.createCombiner$1(tup, rrp$1, crs$1, destCrs$1, rasterReprojectOptions$1);
    }

    public static final /* synthetic */ CellGrid $anonfun$apply$10(RasterRegionReproject rrp$1, CRS crs$1, CRS destCrs$1, Reproject.Options rasterReprojectOptions$1, CellGrid reprojectedTile, Tuple3 toReproject) {
        return TileRDDReproject$.mergeValues$1(reprojectedTile, toReproject, rrp$1, crs$1, destCrs$1, rasterReprojectOptions$1);
    }

    public static final /* synthetic */ CellGrid $anonfun$apply$11(Function1 evidence$6$1, CellGrid reproj1, CellGrid reproj2) {
        return TileRDDReproject$.mergeCombiners$1(reproj1, reproj2, evidence$6$1);
    }

    private static final /* synthetic */ Function2 transform$lzycompute$1(LazyRef transform$lzy$1, CRS crs$2, CRS destCrs$2) {
        Function2 function2;
        LazyRef lazyRef = transform$lzy$1;
        synchronized (lazyRef) {
            function2 = transform$lzy$1.initialized() ? (Function2)transform$lzy$1.value() : (Function2)transform$lzy$1.initialize((Object)Transform$.MODULE$.apply(crs$2, destCrs$2));
        }
        return function2;
    }

    private static final Function2 transform$1(LazyRef transform$lzy$1, CRS crs$2, CRS destCrs$2) {
        return transform$lzy$1.initialized() ? (Function2)transform$lzy$1.value() : TileRDDReproject$.transform$lzycompute$1(transform$lzy$1, crs$2, destCrs$2);
    }

    public static final /* synthetic */ boolean $anonfun$apply$12(RDD rdd$1, Boundable evidence$9$1, Object x$6) {
        return ((TileLayerMetadata)((Metadata)rdd$1).metadata()).bounds().includes(x$6, evidence$9$1);
    }

    private TileRDDReproject$() {
        MODULE$ = this;
    }
}

