/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.spark.store.file;

import geotrellis.layer.Boundable;
import geotrellis.layer.Bounds;
import geotrellis.layer.EmptyBounds$;
import geotrellis.layer.KeyBounds$;
import geotrellis.spark.ContextRDD;
import geotrellis.spark.store.FilteringLayerReader;
import geotrellis.spark.store.file.FileLayerReader$;
import geotrellis.spark.store.file.FileRDDReader$;
import geotrellis.store.AttributeStore;
import geotrellis.store.LayerAttributes;
import geotrellis.store.LayerId;
import geotrellis.store.LayerQuery;
import geotrellis.store.avro.AvroRecordCodec;
import geotrellis.store.file.FileAttributeStore;
import geotrellis.store.file.FileLayerHeader;
import geotrellis.store.file.FileLayerHeader$;
import geotrellis.store.file.KeyPathGenerator$;
import geotrellis.store.index.Index$;
import geotrellis.store.index.KeyIndex;
import geotrellis.store.package;
import geotrellis.util.Component;
import geotrellis.util.package$;
import io.circe.Decoder;
import java.io.Serializable;
import org.apache.avro.Schema;
import org.apache.spark.SparkContext;
import org.apache.spark.rdd.RDD;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.Seq;
import scala.concurrent.ExecutionContext;
import scala.math.BigInt;
import scala.reflect.ClassTag;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005=e\u0001B\b\u0011\u0001eA\u0001b\t\u0001\u0003\u0006\u0004%\t\u0001\n\u0005\tQ\u0001\u0011\t\u0011)A\u0005K!A\u0011\u0006\u0001B\u0001B\u0003%!\u0006\u0003\u00058\u0001\t\u0005\t\u0015a\u00039\u0011\u0015\t\u0005\u0001\"\u0001C\u0011\u001dI\u0005A1A\u0005\u0002)Caa\u0014\u0001!\u0002\u0013Y\u0005\"\u0002)\u0001\t\u0003\tvaBA.!!\u0005\u0011Q\f\u0004\u0007\u001fAA\t!a\u0018\t\r\u0005SA\u0011AA4\u0011\u001d\tIG\u0003C\u0001\u0003WBq!!\u001b\u000b\t\u0003\t)\bC\u0004\u0002j)!\t!! \u0003\u001f\u0019KG.\u001a'bs\u0016\u0014(+Z1eKJT!!\u0005\n\u0002\t\u0019LG.\u001a\u0006\u0003'Q\tQa\u001d;pe\u0016T!!\u0006\f\u0002\u000bM\u0004\u0018M]6\u000b\u0003]\t!bZ3piJ,G\u000e\\5t\u0007\u0001\u0019\"\u0001\u0001\u000e\u0011\u0007mab$D\u0001\u0013\u0013\ti\"C\u0001\u000bGS2$XM]5oO2\u000b\u00170\u001a:SK\u0006$WM\u001d\t\u0003?\u0005j\u0011\u0001\t\u0006\u0003'YI!A\t\u0011\u0003\u000f1\u000b\u00170\u001a:JI\u0006q\u0011\r\u001e;sS\n,H/Z*u_J,W#A\u0013\u0011\u0005}1\u0013BA\u0014!\u00059\tE\u000f\u001e:jEV$Xm\u0015;pe\u0016\fq\"\u0019;ue&\u0014W\u000f^3Ti>\u0014X\rI\u0001\fG\u0006$\u0018\r\\8h!\u0006$\b\u000e\u0005\u0002,i9\u0011AF\r\t\u0003[Aj\u0011A\f\u0006\u0003_a\ta\u0001\u0010:p_Rt$\"A\u0019\u0002\u000bM\u001c\u0017\r\\1\n\u0005M\u0002\u0014A\u0002)sK\u0012,g-\u0003\u00026m\t11\u000b\u001e:j]\u001eT!a\r\u0019\u0002\u0005M\u001c\u0007CA\u001d@\u001b\u0005Q$BA\u000b<\u0015\taT(\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002}\u0005\u0019qN]4\n\u0005\u0001S$\u0001D*qCJ\\7i\u001c8uKb$\u0018A\u0002\u001fj]&$h\bF\u0002D\u000f\"#\"\u0001\u0012$\u0011\u0005\u0015\u0003Q\"\u0001\t\t\u000b]*\u00019\u0001\u001d\t\u000b\r*\u0001\u0019A\u0013\t\u000b%*\u0001\u0019\u0001\u0016\u0002)\u0011,g-Y;mi:+X\u000eU1si&$\u0018n\u001c8t+\u0005Y\u0005C\u0001'N\u001b\u0005\u0001\u0014B\u0001(1\u0005\rIe\u000e^\u0001\u0016I\u00164\u0017-\u001e7u\u001dVl\u0007+\u0019:uSRLwN\\:!\u0003\u0011\u0011X-\u00193\u0016\tISFm\u001a\u000b\n'\u0006}\u00121IA'\u0003#\"b\u0002V5rs\u0006\u001d\u0011qCA\u000f\u0003G\tI\u0003E\u0003V-b\u001bg-D\u0001\u0015\u0013\t9FC\u0001\u0006D_:$X\r\u001f;S\t\u0012\u0003\"!\u0017.\r\u0001\u0011)1\f\u0003b\u00019\n\t1*\u0005\u0002^AB\u0011AJX\u0005\u0003?B\u0012qAT8uQ&tw\r\u0005\u0002MC&\u0011!\r\r\u0002\u0004\u0003:L\bCA-e\t\u0015)\u0007B1\u0001]\u0005\u00051\u0006CA-h\t\u0015A\u0007B1\u0001]\u0005\u0005i\u0005b\u00026\t\u0003\u0003\u0005\u001da[\u0001\u000bKZLG-\u001a8dK\u0012\n\u0004c\u00017p16\tQN\u0003\u0002oA\u0005!\u0011M\u001e:p\u0013\t\u0001XNA\bBmJ|'+Z2pe\u0012\u001cu\u000eZ3d\u0011\u001d\u0011\b\"!AA\u0004M\f!\"\u001a<jI\u0016t7-\u001a\u00133!\r!x\u000fW\u0007\u0002k*\u0011aOF\u0001\u0006Y\u0006LXM]\u0005\u0003qV\u0014\u0011BQ8v]\u0012\f'\r\\3\t\u000fiD\u0011\u0011!a\u0002w\u0006QQM^5eK:\u001cW\rJ\u001a\u0011\tq\f\u0019\u0001W\u0007\u0002{*\u0011ap`\u0001\u0006G&\u00148-\u001a\u0006\u0003\u0003\u0003\t!![8\n\u0007\u0005\u0015QPA\u0004EK\u000e|G-\u001a:\t\u0013\u0005%\u0001\"!AA\u0004\u0005-\u0011AC3wS\u0012,gnY3%iA)\u0011QBA\n16\u0011\u0011q\u0002\u0006\u0004\u0003#\u0001\u0014a\u0002:fM2,7\r^\u0005\u0005\u0003+\tyA\u0001\u0005DY\u0006\u001c8\u000fV1h\u0011%\tI\u0002CA\u0001\u0002\b\tY\"\u0001\u0006fm&$WM\\2fIU\u00022\u0001\\8d\u0011%\ty\u0002CA\u0001\u0002\b\t\t#\u0001\u0006fm&$WM\\2fIY\u0002R!!\u0004\u0002\u0014\rD\u0011\"!\n\t\u0003\u0003\u0005\u001d!a\n\u0002\u0015\u00154\u0018\u000eZ3oG\u0016$s\u0007\u0005\u0003}\u0003\u00071\u0007\"CA\u0016\u0011\u0005\u0005\t9AA\u0017\u0003))g/\u001b3f]\u000e,G\u0005\u000f\t\b\u0003_\t)DZA\u001d\u001b\t\t\tDC\u0002\u00024Y\tA!\u001e;jY&!\u0011qGA\u0019\u0005%\u0019u.\u001c9p]\u0016tG\u000f\u0005\u0003u\u0003wA\u0016bAA\u001fk\n1!i\\;oINDa!!\u0011\t\u0001\u0004q\u0012AA5e\u0011\u001d\t)\u0005\u0003a\u0001\u0003\u000f\n\u0011\u0002^5mKF+XM]=\u0011\u000b}\tI\u0005\u00174\n\u0007\u0005-\u0003E\u0001\u0006MCf,'/U;fefDa!a\u0014\t\u0001\u0004Y\u0015!\u00048v[B\u000b'\u000f^5uS>t7\u000fC\u0004\u0002T!\u0001\r!!\u0016\u0002\u001f\u0019LG\u000e^3s\u0013:$W\r_(oYf\u00042\u0001TA,\u0013\r\tI\u0006\r\u0002\b\u0005>|G.Z1o\u0003=1\u0015\u000e\\3MCf,'OU3bI\u0016\u0014\bCA#\u000b'\rQ\u0011\u0011\r\t\u0004\u0019\u0006\r\u0014bAA3a\t1\u0011I\\=SK\u001a$\"!!\u0018\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\r\u00055\u0014\u0011OA:)\r!\u0015q\u000e\u0005\u0006o1\u0001\u001d\u0001\u000f\u0005\u0006G1\u0001\r!\n\u0005\u0006S1\u0001\rA\u000b\u000b\u0005\u0003o\nY\bF\u0002E\u0003sBQaN\u0007A\u0004aBQ!K\u0007A\u0002)\"B!a \u0002\u0004R\u0019A)!!\t\u000b]r\u00019\u0001\u001d\t\r\rr\u0001\u0019AAC!\u0011\t9)a#\u000e\u0005\u0005%%BA\t!\u0013\u0011\ti)!#\u0003%\u0019KG.Z!uiJL'-\u001e;f'R|'/\u001a")
public class FileLayerReader
extends FilteringLayerReader<LayerId> {
    private final AttributeStore attributeStore;
    private final String catalogPath;
    private final SparkContext sc;
    private final int defaultNumPartitions;

    public static FileLayerReader apply(FileAttributeStore fileAttributeStore, SparkContext sparkContext) {
        return FileLayerReader$.MODULE$.apply(fileAttributeStore, sparkContext);
    }

    public static FileLayerReader apply(String string, SparkContext sparkContext) {
        return FileLayerReader$.MODULE$.apply(string, sparkContext);
    }

    public static FileLayerReader apply(AttributeStore attributeStore, String string, SparkContext sparkContext) {
        return FileLayerReader$.MODULE$.apply(attributeStore, string, sparkContext);
    }

    @Override
    public AttributeStore attributeStore() {
        return this.attributeStore;
    }

    @Override
    public int defaultNumPartitions() {
        return this.defaultNumPartitions;
    }

    public <K, V, M> ContextRDD<K, V, M> read(LayerId id, LayerQuery<K, M> tileQuery, int numPartitions, boolean filterIndexOnly, AvroRecordCodec<K> evidence$1, Boundable<K> evidence$2, Decoder<K> evidence$3, ClassTag<K> evidence$4, AvroRecordCodec<V> evidence$5, ClassTag<V> evidence$6, Decoder<M> evidence$7, Component<M, Bounds<K>> evidence$8) {
        if (!this.attributeStore().layerExists(id)) {
            throw new package.LayerNotFoundError(id);
        }
        LayerAttributes layerAttributes = this.liftedTree1$1(id, evidence$7, evidence$4);
        if (layerAttributes == null) {
            throw new MatchError((Object)layerAttributes);
        }
        FileLayerHeader header = (FileLayerHeader)layerAttributes.header();
        Object metadata = layerAttributes.metadata();
        KeyIndex keyIndex = layerAttributes.keyIndex();
        Schema writerSchema = layerAttributes.schema();
        Tuple4 tuple4 = new Tuple4((Object)header, metadata, (Object)keyIndex, (Object)writerSchema);
        Tuple4 tuple42 = tuple4;
        FileLayerHeader header2 = (FileLayerHeader)tuple42._1();
        Object metadata2 = tuple42._2();
        KeyIndex keyIndex2 = (KeyIndex)tuple42._3();
        Schema writerSchema2 = (Schema)tuple42._4();
        String layerPath = header2.path();
        Seq queryKeyBounds = tileQuery.apply(metadata2);
        Object layerMetadata = package$.MODULE$.withSetComponentMethods(metadata2).setComponent(queryKeyBounds.foldLeft((Object)EmptyBounds$.MODULE$, (Function2 & Serializable & scala.Serializable)(x$2, x$3) -> x$2.combine((Bounds)x$3, evidence$2)), evidence$8);
        int maxWidth = Index$.MODULE$.digits(keyIndex2.toIndex(keyIndex2.keyBounds().maxKey()));
        Function1 keyPath = KeyPathGenerator$.MODULE$.apply(this.catalogPath, layerPath, maxWidth);
        Function1 & Serializable & scala.Serializable decompose = (Function1 & Serializable & scala.Serializable)bounds -> keyIndex2.indexRanges(KeyBounds$.MODULE$.keyBoundsToTuple(bounds));
        RDD<Tuple2<K, V>> rdd = FileRDDReader$.MODULE$.read((Function1<BigInt, String>)keyPath, queryKeyBounds, decompose, filterIndexOnly, (Option<Schema>)new Some((Object)writerSchema2), (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)numPartitions)), (Function0<ExecutionContext>)(Function0 & Serializable & scala.Serializable)() -> FileRDDReader$.MODULE$.read$default$7(), evidence$1, evidence$2, evidence$5, this.sc);
        return new ContextRDD<K, V, Object>(rdd, layerMetadata);
    }

    private final /* synthetic */ LayerAttributes liftedTree1$1(LayerId id$1, Decoder evidence$7$1, ClassTag evidence$4$1) {
        LayerAttributes layerAttributes;
        try {
            layerAttributes = this.attributeStore().readLayerAttributes(id$1, FileLayerHeader$.MODULE$.fileLayerHeaderDecoder(), evidence$7$1, evidence$4$1);
        }
        catch (package.AttributeNotFoundError e) {
            throw new package.LayerReadError(id$1).initCause((Throwable)e);
        }
        return layerAttributes;
    }

    public FileLayerReader(AttributeStore attributeStore, String catalogPath, SparkContext sc) {
        this.attributeStore = attributeStore;
        this.catalogPath = catalogPath;
        this.sc = sc;
        this.defaultNumPartitions = sc.defaultParallelism();
    }
}

