/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.spark.store.hadoop;

import geotrellis.layer.Boundable;
import geotrellis.layer.KeyBounds;
import geotrellis.layer.KeyBounds$;
import geotrellis.spark.util.KryoWrapper;
import geotrellis.spark.util.KryoWrapper$;
import geotrellis.store.avro.AvroEncoder$;
import geotrellis.store.avro.AvroRecordCodec;
import geotrellis.store.avro.codecs.KeyValueRecordCodec;
import geotrellis.store.avro.codecs.KeyValueRecordCodec$;
import geotrellis.store.hadoop.formats.FilterMapFileInputFormat;
import geotrellis.store.hadoop.formats.FilterMapFileInputFormat$;
import geotrellis.store.hadoop.package$;
import java.io.Serializable;
import org.apache.avro.Schema;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.BigIntWritable;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.mapreduce.lib.input.SequenceFileInputFormat;
import org.apache.spark.SparkContext;
import org.apache.spark.rdd.RDD;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Vector;
import scala.math.BigInt;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class HadoopRDDReader$ {
    public static HadoopRDDReader$ MODULE$;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    static {
        new HadoopRDDReader$();
    }

    private Logger logger$lzycompute() {
        HadoopRDDReader$ hadoopRDDReader$ = this;
        synchronized (hadoopRDDReader$) {
            if (!this.bitmap$trans$0) {
                this.logger = LoggerFactory.getLogger((String)"geotrellis.spark.store.hadoop.HadoopRDDReader");
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    private Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    public <K, V> RDD<Tuple2<K, V>> readFully(Path path, Option<Schema> writerSchema, AvroRecordCodec<K> evidence$1, Boundable<K> evidence$2, AvroRecordCodec<V> evidence$3, SparkContext sc) {
        Path dataPath = path.suffix("/*[0-9]*/data");
        if (this.logger().isDebugEnabled()) {
            this.logger().debug(new StringBuilder(13).append("Loading from ").append(dataPath).toString());
        }
        Configuration conf = sc.hadoopConfiguration();
        Configuration inputConf = package$.MODULE$.withHadoopConfigurationMethods(conf).withInputPath(dataPath);
        KeyValueRecordCodec codec = KeyValueRecordCodec$.MODULE$.apply(evidence$1, evidence$3);
        KryoWrapper<Option<Schema>> kwWriterSchema = KryoWrapper$.MODULE$.apply(writerSchema, ClassTag$.MODULE$.apply(Option.class));
        return sc.newAPIHadoopRDD(inputConf, SequenceFileInputFormat.class, BigIntWritable.class, BytesWritable.class).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            BytesWritable valueWritable = (BytesWritable)tuple2._2();
            TraversableOnce traversableOnce = (TraversableOnce)AvroEncoder$.MODULE$.fromBinary((Schema)((Option)kwWriterSchema.value()).getOrElse((Function0 & Serializable & scala.Serializable)() -> codec.schema()), valueWritable.getBytes(), (AvroRecordCodec)codec);
            return traversableOnce;
        }, ClassTag$.MODULE$.apply(Tuple2.class));
    }

    public <K, V> Option<Schema> readFully$default$2() {
        return None$.MODULE$;
    }

    public <K, V> RDD<Tuple2<K, V>> readFiltered(Path path, Seq<KeyBounds<K>> queryKeyBounds, Function1<KeyBounds<K>, Seq<Tuple2<BigInt, BigInt>>> decomposeBounds, boolean indexFilterOnly, Option<Schema> writerSchema, AvroRecordCodec<K> evidence$4, Boundable<K> evidence$5, AvroRecordCodec<V> evidence$6, SparkContext sc) {
        if (queryKeyBounds.isEmpty()) {
            return sc.emptyRDD(ClassTag$.MODULE$.apply(Tuple2.class));
        }
        Path dataPath = path.suffix("/*[0-9]*/data");
        if (this.logger().isDebugEnabled()) {
            this.logger().debug(new StringBuilder(13).append("Loading from ").append(dataPath).toString());
        }
        Configuration conf = sc.hadoopConfiguration();
        Configuration inputConf = package$.MODULE$.withHadoopConfigurationMethods(conf).withInputPath(dataPath);
        Function1 & Serializable & scala.Serializable includeKey = (Function1 & Serializable & scala.Serializable)key -> BoxesRunTime.boxToBoolean((boolean)KeyBounds$.MODULE$.includeKey(queryKeyBounds, key, evidence$5));
        Tuple2[] indexRanges = (Tuple2[])((TraversableOnce)queryKeyBounds.flatMap(decomposeBounds, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Tuple2.class));
        package$.MODULE$.withHadoopConfigurationMethods(inputConf).setSerialized(FilterMapFileInputFormat$.MODULE$.FILTER_INFO_KEY(), (Object)indexRanges);
        KeyValueRecordCodec codec = KeyValueRecordCodec$.MODULE$.apply(evidence$4, evidence$6);
        KryoWrapper<Option<Schema>> kwWriterSchema = KryoWrapper$.MODULE$.apply(writerSchema, ClassTag$.MODULE$.apply(Option.class));
        return sc.newAPIHadoopRDD(inputConf, FilterMapFileInputFormat.class, BigIntWritable.class, BytesWritable.class).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            BytesWritable valueWritable = (BytesWritable)tuple2._2();
            Vector items = (Vector)AvroEncoder$.MODULE$.fromBinary((Schema)((Option)kwWriterSchema.value()).getOrElse((Function0 & Serializable & scala.Serializable)() -> codec.schema()), valueWritable.getBytes(), (AvroRecordCodec)codec);
            Vector vector = indexFilterOnly ? items : (TraversableOnce)items.filter((Function1 & Serializable & scala.Serializable)row -> BoxesRunTime.boxToBoolean((boolean)HadoopRDDReader$.$anonfun$readFiltered$4(includeKey, row)));
            return vector;
        }, ClassTag$.MODULE$.apply(Tuple2.class));
    }

    public <K, V> Option<Schema> readFiltered$default$5() {
        return None$.MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$readFiltered$4(Function1 includeKey$1, Tuple2 row) {
        return BoxesRunTime.unboxToBoolean((Object)includeKey$1.apply(row._1()));
    }

    private HadoopRDDReader$() {
        MODULE$ = this;
    }
}

