/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.spark.store.slippy;

import geotrellis.layer.SpatialKey;
import geotrellis.layer.SpatialKey$;
import geotrellis.spark.store.slippy.FileSlippyTileReader$;
import geotrellis.spark.store.slippy.SlippyTileReader;
import geotrellis.spark.store.slippy.SlippyTileReader$;
import geotrellis.util.Filesystem$;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.SuffixFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.spark.HashPartitioner;
import org.apache.spark.Partitioner;
import org.apache.spark.SparkContext;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Mc\u0001\u0002\b\u0010\u0001aA\u0001b\f\u0001\u0003\u0002\u0003\u0006I\u0001\r\u0005\tw\u0001\u0011\t\u0011)A\u0005y!AQ\t\u0001B\u0001B\u0003%a\tC\u0003V\u0001\u0011\u0005a\u000bC\u0003]\u0001\u0011%Q\fC\u0003]\u0001\u0011%\u0011\u000eC\u0003m\u0001\u0011\u0005Q\u000eC\u0003m\u0001\u0011\u0005QoB\u0005\u0002\u001a=\t\t\u0011#\u0001\u0002\u001c\u0019AabDA\u0001\u0012\u0003\ti\u0002\u0003\u0004V\u0015\u0011\u0005\u0011Q\u0005\u0005\n\u0003OQ\u0011\u0013!C\u0001\u0003SA\u0011\"a\u0011\u000b\u0003\u0003%I!!\u0012\u0003)\u0019KG.Z*mSB\u0004\u0018\u0010V5mKJ+\u0017\rZ3s\u0015\t\u0001\u0012#\u0001\u0004tY&\u0004\b/\u001f\u0006\u0003%M\tQa\u001d;pe\u0016T!\u0001F\u000b\u0002\u000bM\u0004\u0018M]6\u000b\u0003Y\t!bZ3piJ,G\u000e\\5t\u0007\u0001)\"!\u0007\u0014\u0014\u0007\u0001Q\u0002\u0005\u0005\u0002\u001c=5\tADC\u0001\u001e\u0003\u0015\u00198-\u00197b\u0013\tyBD\u0001\u0004B]f\u0014VM\u001a\t\u0004C\t\"S\"A\b\n\u0005\rz!\u0001E*mSB\u0004\u0018\u0010V5mKJ+\u0017\rZ3s!\t)c\u0005\u0004\u0001\u0005\u000b\u001d\u0002!\u0019\u0001\u0015\u0003\u0003Q\u000b\"!\u000b\u0017\u0011\u0005mQ\u0013BA\u0016\u001d\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"aG\u0017\n\u00059b\"aA!os\u0006\u0019QO]5\u0011\u0005EBdB\u0001\u001a7!\t\u0019D$D\u00015\u0015\t)t#\u0001\u0004=e>|GOP\u0005\u0003oq\ta\u0001\u0015:fI\u00164\u0017BA\u001d;\u0005\u0019\u0019FO]5oO*\u0011q\u0007H\u0001\u000bKb$XM\\:j_:\u001c\bcA\u001fCa9\u0011a\b\u0011\b\u0003g}J\u0011!H\u0005\u0003\u0003r\tq\u0001]1dW\u0006<W-\u0003\u0002D\t\n\u00191+Z9\u000b\u0005\u0005c\u0012!\u00034s_6\u0014\u0015\u0010^3t!\u0015Yr)S(%\u0013\tAEDA\u0005Gk:\u001cG/[8oeA\u0011!*T\u0007\u0002\u0017*\u0011A*F\u0001\u0006Y\u0006LXM]\u0005\u0003\u001d.\u0013!b\u00159bi&\fGnS3z!\rY\u0002KU\u0005\u0003#r\u0011Q!\u0011:sCf\u0004\"aG*\n\u0005Qc\"\u0001\u0002\"zi\u0016\fa\u0001P5oSRtDcA,[7R\u0011\u0001,\u0017\t\u0004C\u0001!\u0003\"B#\u0005\u0001\u00041\u0005\"B\u0018\u0005\u0001\u0004\u0001\u0004bB\u001e\u0005!\u0003\u0005\r\u0001P\u0001\nY&\u001cHOR5mKN$\"AX4\u0011\u0007u\u0012u\f\u0005\u0002aK6\t\u0011M\u0003\u0002cG\u0006\u0011\u0011n\u001c\u0006\u0002I\u0006!!.\u0019<b\u0013\t1\u0017M\u0001\u0003GS2,\u0007\"\u00025\u0006\u0001\u0004\u0001\u0014\u0001\u00029bi\"$\"A\u00186\t\u000b-4\u0001\u0019A0\u0002\t\u0019LG.Z\u0001\u0005e\u0016\fG\rF\u0002%]NDQa\\\u0004A\u0002A\fAA_8p[B\u00111$]\u0005\u0003er\u00111!\u00138u\u0011\u0015!x\u00011\u0001J\u0003\rYW-\u001f\u000b\u0004m\u0006]AcA<\u0002\fA)\u00010!\u0001\u0002\u00065\t\u0011P\u0003\u0002{w\u0006\u0019!\u000f\u001a3\u000b\u0005Qa(BA?\u007f\u0003\u0019\t\u0007/Y2iK*\tq0A\u0002pe\u001eL1!a\u0001z\u0005\r\u0011F\t\u0012\t\u00067\u0005\u001d\u0011\nJ\u0005\u0004\u0003\u0013a\"A\u0002+va2,'\u0007C\u0004\u0002\u000e!\u0001\u001d!a\u0004\u0002\u0005M\u001c\u0007\u0003BA\t\u0003'i\u0011a_\u0005\u0004\u0003+Y(\u0001D*qCJ\\7i\u001c8uKb$\b\"B8\t\u0001\u0004\u0001\u0018\u0001\u0006$jY\u0016\u001cF.\u001b9qsRKG.\u001a*fC\u0012,'\u000f\u0005\u0002\"\u0015M!!BGA\u0010!\rY\u0012\u0011E\u0005\u0004\u0003Ga\"\u0001D*fe&\fG.\u001b>bE2,GCAA\u000e\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%eU!\u00111FA!+\t\tiCK\u0002=\u0003_Y#!!\r\u0011\t\u0005M\u0012QH\u0007\u0003\u0003kQA!a\u000e\u0002:\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003wa\u0012AC1o]>$\u0018\r^5p]&!\u0011qHA\u001b\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a\u0003\u0006O1\u0011\r\u0001K\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0002HA!\u0011\u0011JA(\u001b\t\tYEC\u0002\u0002N\r\fA\u0001\\1oO&!\u0011\u0011KA&\u0005\u0019y%M[3di\u0002")
public class FileSlippyTileReader<T>
implements SlippyTileReader<T> {
    private final String uri;
    private final Seq<String> extensions;
    private final Function2<SpatialKey, byte[], T> fromBytes;

    public static <T> Seq<String> $lessinit$greater$default$2() {
        return FileSlippyTileReader$.MODULE$.$lessinit$greater$default$2();
    }

    @Override
    public T read(int zoom, int x, int y) {
        return (T)SlippyTileReader.read$(this, zoom, x, y);
    }

    private Seq<File> listFiles(String path) {
        return this.listFiles(new File(path));
    }

    private Seq<File> listFiles(File file) {
        return this.extensions.isEmpty() ? ((TraversableOnce)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(FileUtils.listFiles((File)file, (IOFileFilter)TrueFileFilter.INSTANCE, (IOFileFilter)TrueFileFilter.INSTANCE)).asScala()).toSeq() : ((TraversableOnce)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(FileUtils.listFiles((File)file, (IOFileFilter)new SuffixFileFilter((List)JavaConverters$.MODULE$.seqAsJavaListConverter(this.extensions).asJava()), (IOFileFilter)TrueFileFilter.INSTANCE)).asScala()).toSeq();
    }

    @Override
    public T read(int zoom, SpatialKey key) {
        File dir = new File(this.uri, new StringBuilder(2).append(zoom).append("/").append(key.col()).append("/").toString());
        Function2<SpatialKey, byte[], T> lFromBytes = this.fromBytes;
        Seq seq = (Seq)this.listFiles(dir).filter((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)FileSlippyTileReader.$anonfun$read$1(key, f)));
        Some some = Seq$.MODULE$.unapplySeq(seq);
        if (!some.isEmpty() && some.get() != null && ((SeqLike)some.get()).lengthCompare(0) == 0) {
            throw new FileNotFoundException(new StringBuilder(2).append(dir).append("/").append(key.row()).append("*").toString());
        }
        Some some2 = Seq$.MODULE$.unapplySeq(seq);
        if (some2.isEmpty() || some2.get() == null || ((SeqLike)some2.get()).lengthCompare(1) != 0) {
            throw new IllegalArgumentException(new StringBuilder(34).append("More than one file matches path ").append(dir).append("/").append(key.row()).append("*").toString());
        }
        File tilePath = (File)((SeqLike)some2.get()).apply(0);
        Object object = lFromBytes.apply((Object)key, (Object)Filesystem$.MODULE$.slurp(tilePath.getAbsolutePath(), Filesystem$.MODULE$.slurp$default$2()));
        return (T)object;
    }

    @Override
    public RDD<Tuple2<SpatialKey, T>> read(int zoom, SparkContext sc) {
        Seq paths = (Seq)this.listFiles(new File(this.uri, Integer.toString(zoom)).getPath()).flatMap((Function1 & Serializable & scala.Serializable)file -> {
            Iterable iterable;
            String path;
            String string = path = file.getAbsolutePath();
            Option option = SlippyTileReader$.MODULE$.TilePath().unapplySeq((CharSequence)string);
            if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(2) == 0) {
                String x = (String)((LinearSeqOptimized)option.get()).apply(0);
                String y = (String)((LinearSeqOptimized)option.get()).apply(1);
                iterable = Option$.MODULE$.option2Iterable((Option)new Some((Object)new Tuple2((Object)new SpatialKey(new StringOps(Predef$.MODULE$.augmentString(x)).toInt(), new StringOps(Predef$.MODULE$.augmentString(y)).toInt()), (Object)path)));
            } else {
                iterable = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
            }
            return iterable;
        }, Seq$.MODULE$.canBuildFrom());
        Function2 lFromBytes = this.fromBytes;
        int numPartitions = package$.MODULE$.min(paths.size(), package$.MODULE$.max(paths.size() / 10, 50));
        return RDD$.MODULE$.rddToPairRDDFunctions(sc.parallelize(paths.toSeq(), sc.parallelize$default$2(), ClassTag$.MODULE$.apply(Tuple2.class)), ClassTag$.MODULE$.apply(SpatialKey.class), ClassTag$.MODULE$.apply(String.class), SpatialKey$.MODULE$.ordering()).partitionBy((Partitioner)new HashPartitioner(numPartitions)).mapPartitions((Function1 & Serializable & scala.Serializable)partition -> partition.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            SpatialKey key = (SpatialKey)tuple2._1();
            String path = (String)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)key, lFromBytes.apply((Object)key, (Object)Filesystem$.MODULE$.slurp(path, Filesystem$.MODULE$.slurp$default$2())));
            return tuple22;
        }), true, ClassTag$.MODULE$.apply(Tuple2.class));
    }

    public static final /* synthetic */ boolean $anonfun$read$1(SpatialKey key$1, File f) {
        return f.getName().startsWith(String.valueOf(BoxesRunTime.boxToInteger((int)key$1.row())));
    }

    public FileSlippyTileReader(String uri, Seq<String> extensions, Function2<SpatialKey, byte[], T> fromBytes) {
        this.uri = uri;
        this.extensions = extensions;
        this.fromBytes = fromBytes;
        SlippyTileReader.$init$(this);
    }
}

