/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.spark.summary.polygonal;

import cats.kernel.Semigroup;
import cats.syntax.package;
import geotrellis.layer.LayoutDefinition;
import geotrellis.layer.Metadata;
import geotrellis.layer.SpatialKey;
import geotrellis.layer.SpatialKey$;
import geotrellis.layer.TileLayerMetadata;
import geotrellis.raster.CellGrid;
import geotrellis.raster.Grid;
import geotrellis.raster.Raster;
import geotrellis.raster.package$;
import geotrellis.raster.rasterize.Rasterizer;
import geotrellis.raster.summary.GridVisitor;
import geotrellis.raster.summary.polygonal.PolygonalSummaryResult;
import geotrellis.raster.summary.polygonal.PolygonalSummaryResult$;
import geotrellis.vector.Extent;
import geotrellis.vector.Feature;
import java.io.Serializable;
import java.util.UUID;
import org.apache.spark.rdd.RDD;
import org.apache.spark.rdd.RDD$;
import org.locationtech.jts.geom.Geometry;
import scala.Function1;
import scala.Function2;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.math.Ordering$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;

public final class RDDPolygonalSummary$ {
    public static RDDPolygonalSummary$ MODULE$;

    static {
        new RDDPolygonalSummary$();
    }

    public <R, T extends CellGrid<Object>> RDD<Feature<Geometry, PolygonalSummaryResult<R>>> apply(RDD<Tuple2<SpatialKey, T>> rasterRdd, RDD<Geometry> geometryRdd, GridVisitor<Raster<T>, R> visitor, Rasterizer.Options options, Semigroup<R> semigroupR, ClassTag<R> tagR) {
        LayoutDefinition layout = ((TileLayerMetadata)((Metadata)rasterRdd).metadata()).layout();
        RDD keyedGeometryRdd = geometryRdd.flatMap((Function1 & Serializable & scala.Serializable)geom -> {
            UUID uuid = UUID.randomUUID();
            Set keys = layout.mapTransform().keysForGeometry(geom);
            return (TraversableOnce)keys.map((Function1 & Serializable & scala.Serializable)k -> new Tuple2(k, (Object)new Feature(geom, (Object)uuid)), Set$.MODULE$.canBuildFrom());
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        RDD joinedRdd = RDD$.MODULE$.rddToPairRDDFunctions(keyedGeometryRdd, ClassTag$.MODULE$.apply(SpatialKey.class), ClassTag$.MODULE$.apply(Feature.class), SpatialKey$.MODULE$.ordering()).join(rasterRdd);
        RDD featuresWithSummaries = joinedRdd.map((Function1 & Serializable & scala.Serializable)data -> {
            SpatialKey spatialKey = (SpatialKey)data._1();
            Feature feature = (Feature)((Tuple2)data._2())._1();
            CellGrid tile = (CellGrid)((Tuple2)data._2())._2();
            Extent extent = layout.mapTransform().keyToExtent(spatialKey);
            Raster raster = new Raster(tile, extent);
            PolygonalSummaryResult result = geotrellis.raster.summary.polygonal.package$.MODULE$.withPolygonalSummaryMethods((Grid)raster).polygonalSummary(feature.geom(), (GridVisitor)visitor.getClass().newInstance(), options, package$.MODULE$.rasterHasRasterExtent());
            return new Tuple2(feature.data(), (Object)new Feature(feature.geom(), (Object)result));
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        return RDD$.MODULE$.rddToPairRDDFunctions(featuresWithSummaries, ClassTag$.MODULE$.apply(UUID.class), ClassTag$.MODULE$.apply(Feature.class), Ordering$.MODULE$.ordered((Function1)Predef$.MODULE$.$conforms())).reduceByKey((Function2 & Serializable & scala.Serializable)(a, b) -> new Feature(a.geom(), package.semigroup$.MODULE$.catsSyntaxSemigroup(a.data(), PolygonalSummaryResult$.MODULE$.semigroup(semigroupR, tagR)).combine(b.data()))).map((Function1 & Serializable & scala.Serializable)x$1 -> (Feature)x$1._2(), ClassTag$.MODULE$.apply(Feature.class));
    }

    private RDDPolygonalSummary$() {
        MODULE$ = this;
    }
}

