/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.spark.tiling;

import geotrellis.layer.LayoutDefinition;
import geotrellis.layer.MapKeyTransform;
import geotrellis.layer.SpatialKey;
import geotrellis.layer.SpatialKey$;
import geotrellis.raster.CellGrid;
import geotrellis.raster.DataType;
import geotrellis.raster.Dimensions;
import geotrellis.raster.merge.TileMergeMethods;
import geotrellis.raster.prototype.TilePrototypeMethods;
import geotrellis.raster.resample.NearestNeighbor$;
import geotrellis.raster.resample.ResampleMethod;
import geotrellis.spark.tiling.TilerKeyMethods;
import geotrellis.util.Component;
import geotrellis.util.GetComponent;
import geotrellis.util.package$;
import geotrellis.vector.Extent;
import java.io.Serializable;
import org.apache.spark.rdd.RDD;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.MatchError;
import scala.Tuple2;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;

public final class CutTiles$ {
    public static CutTiles$ MODULE$;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    static {
        new CutTiles$();
    }

    private Logger logger$lzycompute() {
        CutTiles$ cutTiles$ = this;
        synchronized (cutTiles$) {
            if (!this.bitmap$trans$0) {
                this.logger = LoggerFactory.getLogger((String)"geotrellis.spark.tiling.CutTiles");
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    private Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    public <K1, K2, V extends CellGrid<Object>> RDD<Tuple2<K2, V>> apply(RDD<Tuple2<K1, V>> rdd, DataType cellType, LayoutDefinition layoutDefinition, ResampleMethod resampleMethod, Function1<K1, TilerKeyMethods<K1, K2>> evidence$1, Component<K2, SpatialKey> evidence$2, ClassTag<K2> evidence$3, ClassTag<V> evidence$4, Function1<V, TileMergeMethods<V>> evidence$5, Function1<V, TilePrototypeMethods<V>> evidence$6) {
        if (this.logger().isDebugEnabled()) {
            this.logger().debug(new StringBuilder(14).append("CutTiles(").append(rdd).append(", ").append(cellType).append(", ").append(resampleMethod).append(")").toString());
        }
        MapKeyTransform mapTransform = layoutDefinition.mapTransform();
        Dimensions dimensions = layoutDefinition.tileLayout().tileDimensions();
        if (dimensions == null) {
            throw new MatchError((Object)dimensions);
        }
        int tileCols = dimensions.cols$mcI$sp();
        int tileRows = dimensions.rows$mcI$sp();
        Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(tileCols, tileRows);
        Tuple2.mcII.sp sp3 = sp2;
        int tileCols2 = sp3._1$mcI$sp();
        int tileRows2 = sp3._2$mcI$sp();
        return rdd.flatMap((Function1 & Serializable & scala.Serializable)tup -> {
            Extent extent;
            CellGrid tile;
            Object inKey;
            block1: {
                Tuple2 tuple2 = tup;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                Object inKey2 = tuple2._1();
                CellGrid tile2 = (CellGrid)tuple2._2();
                Tuple2 tuple22 = new Tuple2(inKey2, (Object)tile2);
                Tuple2 tuple23 = tuple22;
                inKey = tuple23._1();
                tile = (CellGrid)tuple23._2();
                extent = ((TilerKeyMethods)evidence$1.apply(inKey)).extent();
                if (!MODULE$.logger().isDebugEnabled()) break block1;
                MODULE$.logger().debug(new StringBuilder(28).append("Cutting ").append(inKey).append(" of ").append(tile.dimensions()).append(" cells covering ").append(extent).toString());
            }
            return mapTransform.apply(extent).coordsIter().map((Function1 & Serializable & scala.Serializable)spatialComponent -> {
                Object outKey = ((TilerKeyMethods)evidence$1.apply(inKey)).translate(SpatialKey$.MODULE$.tupToKey(spatialComponent));
                if (MODULE$.logger().isDebugEnabled()) {
                    MODULE$.logger().debug(new StringBuilder(26).append("Merge ").append(inKey).append(" into ").append(outKey).append(" of (").append(tileCols2).append(", ").append(tileRows2).append(") cells").toString());
                }
                CellGrid newTile = ((TilePrototypeMethods)evidence$6.apply((Object)tile)).prototype(cellType, tileCols2, tileRows2);
                return new Tuple2(outKey, ((TileMergeMethods)evidence$5.apply((Object)newTile)).merge(mapTransform.keyToExtent((SpatialKey)package$.MODULE$.withGetComponentMethods(outKey).getComponent((GetComponent)evidence$2)), extent, (Object)tile, resampleMethod));
            });
        }, ClassTag$.MODULE$.apply(Tuple2.class));
    }

    public <K1, K2, V extends CellGrid<Object>> ResampleMethod apply$default$4() {
        return NearestNeighbor$.MODULE$;
    }

    private CutTiles$() {
        MODULE$ = this;
    }
}

