/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.util;

import geotrellis.util.ByteReader;
import geotrellis.util.RangeReader;
import geotrellis.util.StreamingByteReader$;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import scala.Array$;
import scala.Predef$;
import scala.collection.immutable.NumericRange;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong;

@ScalaSignature(bytes="\u0006\u0001\u0005%e\u0001B\u0001\u0003\u0001\u001d\u00111c\u0015;sK\u0006l\u0017N\\4CsR,'+Z1eKJT!a\u0001\u0003\u0002\tU$\u0018\u000e\u001c\u0006\u0002\u000b\u0005Qq-Z8ue\u0016dG.[:\u0004\u0001M\u0019\u0001\u0001\u0003\b\u0011\u0005%aQ\"\u0001\u0006\u000b\u0003-\tQa]2bY\u0006L!!\u0004\u0006\u0003\r\u0005s\u0017PU3g!\ty\u0001#D\u0001\u0003\u0013\t\t\"A\u0001\u0006CsR,'+Z1eKJD\u0001b\u0005\u0001\u0003\u0002\u0003\u0006I\u0001F\u0001\fe\u0006tw-\u001a*fC\u0012,'\u000f\u0005\u0002\u0010+%\u0011aC\u0001\u0002\f%\u0006tw-\u001a*fC\u0012,'\u000f\u0003\u0005\u0019\u0001\t\u0005\t\u0015!\u0003\u001a\u0003%\u0019\u0007.\u001e8l'&TX\r\u0005\u0002\n5%\u00111D\u0003\u0002\u0004\u0013:$\b\"B\u000f\u0001\t\u0003q\u0012A\u0002\u001fj]&$h\bF\u0002 A\u0005\u0002\"a\u0004\u0001\t\u000bMa\u0002\u0019\u0001\u000b\t\u000faa\u0002\u0013!a\u00013!I1\u0005\u0001a\u0001\u0002\u0004%I\u0001J\u0001\u000bG\",hn\u001b\"zi\u0016\u001cX#A\u0013\u0011\u0007%1\u0003&\u0003\u0002(\u0015\t)\u0011I\u001d:bsB\u0011\u0011\"K\u0005\u0003U)\u0011AAQ=uK\"IA\u0006\u0001a\u0001\u0002\u0004%I!L\u0001\u000fG\",hn\u001b\"zi\u0016\u001cx\fJ3r)\tq\u0013\u0007\u0005\u0002\n_%\u0011\u0001G\u0003\u0002\u0005+:LG\u000fC\u00043W\u0005\u0005\t\u0019A\u0013\u0002\u0007a$\u0013\u0007C\u00055\u0001\u0001\u0007\t\u0011)Q\u0005K\u0005Y1\r[;oW\nKH/Z:!\u0011%1\u0004\u00011AA\u0002\u0013%q'A\u0006dQVt7NQ;gM\u0016\u0014X#\u0001\u001d\u0011\u0005erT\"\u0001\u001e\u000b\u0005mb\u0014a\u00018j_*\tQ(\u0001\u0003kCZ\f\u0017BA ;\u0005)\u0011\u0015\u0010^3Ck\u001a4WM\u001d\u0005\n\u0003\u0002\u0001\r\u00111A\u0005\n\t\u000bqb\u00195v].\u0014UO\u001a4fe~#S-\u001d\u000b\u0003]\rCqA\r!\u0002\u0002\u0003\u0007\u0001\bC\u0005F\u0001\u0001\u0007\t\u0011)Q\u0005q\u0005a1\r[;oW\n+hMZ3sA!9q\t\u0001a\u0001\n\u0013A\u0015AC2ik:\\'+\u00198hKV\t\u0011\nE\u0002K\u001fFk\u0011a\u0013\u0006\u0003\u00196\u000b\u0011\"[7nkR\f'\r\\3\u000b\u00059S\u0011AC2pY2,7\r^5p]&\u0011\u0001k\u0013\u0002\r\u001dVlWM]5d%\u0006tw-\u001a\t\u0003\u0013IK!a\u0015\u0006\u0003\t1{gn\u001a\u0005\b+\u0002\u0001\r\u0011\"\u0003W\u00039\u0019\u0007.\u001e8l%\u0006tw-Z0%KF$\"AL,\t\u000fI\"\u0016\u0011!a\u0001\u0013\"1\u0011\f\u0001Q!\n%\u000b1b\u00195v].\u0014\u0016M\\4fA!91\f\u0001a\u0001\n\u0013a\u0016\u0001\u00044jY\u0016\u0004vn]5uS>tW#A)\t\u000fy\u0003\u0001\u0019!C\u0005?\u0006\u0001b-\u001b7f!>\u001c\u0018\u000e^5p]~#S-\u001d\u000b\u0003]\u0001DqAM/\u0002\u0002\u0003\u0007\u0011\u000b\u0003\u0004c\u0001\u0001\u0006K!U\u0001\u000eM&dW\rU8tSRLwN\u001c\u0011\t\u000f\u0011\u0004\u0001\u0019!C\u0005K\u0006I!-\u001f;f\u001fJ$WM]\u000b\u0002MB\u0011\u0011hZ\u0005\u0003Qj\u0012\u0011BQ=uK>\u0013H-\u001a:\t\u000f)\u0004\u0001\u0019!C\u0005W\u0006i!-\u001f;f\u001fJ$WM]0%KF$\"A\f7\t\u000fIJ\u0017\u0011!a\u0001M\"1a\u000e\u0001Q!\n\u0019\f!BY=uK>\u0013H-\u001a:!\u0011\u0015\u0001\b\u0001\"\u0001]\u0003!\u0001xn]5uS>t\u0007\"\u00029\u0001\t\u0003\u0011HC\u0001\bt\u0011\u0015!\u0018\u000f1\u0001R\u0003-qWm\u001e)pg&$\u0018n\u001c8\t\u000bY\u0004A\u0011A3\u0002\u000b=\u0014H-\u001a:\t\u000bY\u0004A\u0011\u0001=\u0015\u00059J\b\"\u00023x\u0001\u00041\u0007\"B>\u0001\t\u0013a\u0018!\u0003:fC\u0012\u001c\u0005.\u001e8l)\tqS\u0010C\u0003\u007fu\u0002\u0007\u0011*\u0001\u0005oK^\u0014\u0016M\\4f\u0011\u001d\t\t\u0001\u0001C\u0005\u0003\u0007\t1\"\u001a8tkJ,7\t[;oWR\u0019a&!\u0002\t\r\u0005\u001dq\u00101\u0001\u001a\u0003\u0019aWM\\4uQ\"9\u00111\u0002\u0001\u0005\u0002\u00055\u0011\u0001C4fi\nKH/Z:\u0015\u0007\u0015\ny\u0001C\u0004\u0002\b\u0005%\u0001\u0019A\r\t\u000f\u0005M\u0001\u0001\"\u0001\u0002\u0016\u0005\u0019q-\u001a;\u0016\u0003!Bq!!\u0007\u0001\t\u0003\tY\"A\u0004hKR\u001c\u0005.\u0019:\u0016\u0005\u0005u\u0001cA\u0005\u0002 %\u0019\u0011\u0011\u0005\u0006\u0003\t\rC\u0017M\u001d\u0005\b\u0003K\u0001A\u0011AA\u0014\u0003!9W\r^*i_J$XCAA\u0015!\rI\u00111F\u0005\u0004\u0003[Q!!B*i_J$\bbBA\u0019\u0001\u0011\u0005\u00111G\u0001\u0007O\u0016$\u0018J\u001c;\u0016\u0003eAq!a\u000e\u0001\t\u0003\tI$\u0001\u0005hKR4En\\1u+\t\tY\u0004E\u0002\n\u0003{I1!a\u0010\u000b\u0005\u00151En\\1u\u0011\u001d\t\u0019\u0005\u0001C\u0001\u0003\u000b\n\u0011bZ3u\t>,(\r\\3\u0016\u0005\u0005\u001d\u0003cA\u0005\u0002J%\u0019\u00111\n\u0006\u0003\r\u0011{WO\u00197f\u0011\u0019\ty\u0005\u0001C\u00019\u00069q-\u001a;M_:<waBA*\u0005!\u0005\u0011QK\u0001\u0014'R\u0014X-Y7j]\u001e\u0014\u0015\u0010^3SK\u0006$WM\u001d\t\u0004\u001f\u0005]cAB\u0001\u0003\u0011\u0003\tIfE\u0002\u0002X!Aq!HA,\t\u0003\ti\u0006\u0006\u0002\u0002V!A\u0011\u0011MA,\t\u0003\t\u0019'A\u0003baBd\u0017\u0010F\u0002 \u0003KBaaEA0\u0001\u0004!\u0002\u0002CA1\u0003/\"\t!!\u001b\u0015\u000b}\tY'!\u001c\t\rM\t9\u00071\u0001\u0015\u0011\u0019A\u0012q\ra\u00013!Q\u0011\u0011OA,#\u0003%\t!a\u001d\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00133+\t\t)HK\u0002\u001a\u0003oZ#!!\u001f\u0011\t\u0005m\u0014QQ\u0007\u0003\u0003{RA!a \u0002\u0002\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0003\u0007S\u0011AC1o]>$\u0018\r^5p]&!\u0011qQA?\u0005E)hn\u00195fG.,GMV1sS\u0006t7-\u001a")
public class StreamingByteReader
implements ByteReader {
    private final RangeReader rangeReader;
    private final int chunkSize;
    private byte[] chunkBytes;
    private ByteBuffer chunkBuffer;
    private NumericRange<Object> chunkRange;
    private long filePosition;
    private ByteOrder byteOrder;

    public static int $lessinit$greater$default$2() {
        return StreamingByteReader$.MODULE$.$lessinit$greater$default$2();
    }

    public static StreamingByteReader apply(RangeReader rangeReader, int n) {
        return StreamingByteReader$.MODULE$.apply(rangeReader, n);
    }

    public static StreamingByteReader apply(RangeReader rangeReader) {
        return StreamingByteReader$.MODULE$.apply(rangeReader);
    }

    private byte[] chunkBytes() {
        return this.chunkBytes;
    }

    private void chunkBytes_$eq(byte[] x$1) {
        this.chunkBytes = x$1;
    }

    private ByteBuffer chunkBuffer() {
        return this.chunkBuffer;
    }

    private void chunkBuffer_$eq(ByteBuffer x$1) {
        this.chunkBuffer = x$1;
    }

    private NumericRange<Object> chunkRange() {
        return this.chunkRange;
    }

    private void chunkRange_$eq(NumericRange<Object> x$1) {
        this.chunkRange = x$1;
    }

    private long filePosition() {
        return this.filePosition;
    }

    private void filePosition_$eq(long x$1) {
        this.filePosition = x$1;
    }

    private ByteOrder byteOrder() {
        return this.byteOrder;
    }

    private void byteOrder_$eq(ByteOrder x$1) {
        this.byteOrder = x$1;
    }

    @Override
    public long position() {
        return this.filePosition();
    }

    @Override
    public ByteReader position(long newPosition) {
        this.filePosition_$eq(newPosition);
        return this;
    }

    @Override
    public ByteOrder order() {
        return this.byteOrder();
    }

    @Override
    public void order(ByteOrder byteOrder) {
        block0: {
            this.byteOrder_$eq(byteOrder);
            if (this.chunkBuffer() == null) break block0;
            this.chunkBuffer().order(byteOrder);
        }
    }

    private void readChunk(NumericRange<Object> newRange) {
        if (this.chunkBytes() != null && BoxesRunTime.unboxToLong((Object)newRange.start()) >= BoxesRunTime.unboxToLong((Object)this.chunkRange().start()) && BoxesRunTime.unboxToLong((Object)newRange.end()) <= BoxesRunTime.unboxToLong((Object)this.chunkRange().end())) {
            return;
        }
        if (this.chunkBytes() != null && BoxesRunTime.unboxToLong((Object)this.chunkRange().start()) <= BoxesRunTime.unboxToLong((Object)newRange.end()) && BoxesRunTime.unboxToLong((Object)newRange.start()) <= BoxesRunTime.unboxToLong((Object)this.chunkRange().end())) {
            NumericRange.Inclusive intersection = new RichLong(Predef$.MODULE$.longWrapper(package$.MODULE$.max(BoxesRunTime.unboxToLong((Object)this.chunkRange().start()), BoxesRunTime.unboxToLong((Object)newRange.start())))).to((Object)BoxesRunTime.boxToLong((long)package$.MODULE$.min(BoxesRunTime.unboxToLong((Object)this.chunkRange().end()), BoxesRunTime.unboxToLong((Object)newRange.end()))));
            byte[] newChunkBytes = (byte[])Array$.MODULE$.ofDim(newRange.length(), ClassTag$.MODULE$.Byte());
            System.arraycopy(this.chunkBytes(), (int)(BoxesRunTime.unboxToLong((Object)intersection.start()) - BoxesRunTime.unboxToLong((Object)this.chunkRange().start())), newChunkBytes, (int)(BoxesRunTime.unboxToLong((Object)intersection.start()) - BoxesRunTime.unboxToLong((Object)newRange.start())), intersection.length());
            if (BoxesRunTime.unboxToLong((Object)newRange.start()) < BoxesRunTime.unboxToLong((Object)this.chunkRange().start())) {
                int length = (int)(BoxesRunTime.unboxToLong((Object)this.chunkRange().start()) - BoxesRunTime.unboxToLong((Object)newRange.start()));
                byte[] bytes = this.rangeReader.readRange(BoxesRunTime.unboxToLong((Object)newRange.start()), length);
                System.arraycopy(bytes, 0, newChunkBytes, 0, length);
            }
            if (BoxesRunTime.unboxToLong((Object)newRange.end()) > BoxesRunTime.unboxToLong((Object)this.chunkRange().end())) {
                int length = (int)(BoxesRunTime.unboxToLong((Object)newRange.end()) - BoxesRunTime.unboxToLong((Object)this.chunkRange().end()));
                byte[] bytes = this.rangeReader.readRange(BoxesRunTime.unboxToLong((Object)this.chunkRange().end()) + 1L, length);
                System.arraycopy(bytes, 0, newChunkBytes, newRange.length() - length, length);
            }
            this.chunkBytes_$eq(newChunkBytes);
            this.chunkRange_$eq(newRange);
            this.chunkBuffer_$eq(ByteBuffer.wrap(this.chunkBytes()).order(this.byteOrder()));
        } else {
            this.chunkBytes_$eq(this.rangeReader.readRange(BoxesRunTime.unboxToLong((Object)newRange.start()), newRange.length()));
            this.chunkRange_$eq(newRange);
            this.chunkBuffer_$eq(ByteBuffer.wrap(this.chunkBytes()).order(this.byteOrder()));
        }
    }

    private void ensureChunk(int length) {
        block1: {
            long trimmed = package$.MODULE$.min((long)length, this.rangeReader.totalLength() - this.filePosition());
            if (!this.chunkRange().contains((Object)BoxesRunTime.boxToLong((long)this.filePosition())) || !this.chunkRange().contains((Object)BoxesRunTime.boxToLong((long)(this.filePosition() + trimmed - 1L)))) {
                long len = package$.MODULE$.min((long)package$.MODULE$.max(length, this.chunkSize), this.rangeReader.totalLength() - this.filePosition());
                this.readChunk((NumericRange<Object>)new RichLong(Predef$.MODULE$.longWrapper(this.filePosition())).to((Object)BoxesRunTime.boxToLong((long)(this.filePosition() + len - 1L))));
            }
            if (this.filePosition() == BoxesRunTime.unboxToLong((Object)this.chunkRange().start()) + (long)this.chunkBuffer().position()) break block1;
            this.chunkBuffer().position((int)(this.filePosition() - BoxesRunTime.unboxToLong((Object)this.chunkRange().start())));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public byte[] getBytes(int length) {
        void var2_2;
        this.ensureChunk(length);
        byte[] bytes = (byte[])Array$.MODULE$.ofDim(length, ClassTag$.MODULE$.Byte());
        this.chunkBuffer().get(bytes);
        this.filePosition_$eq(this.filePosition() + (long)length);
        return var2_2;
    }

    @Override
    public byte get() {
        this.ensureChunk(1);
        this.filePosition_$eq(this.filePosition() + 1L);
        return this.chunkBuffer().get();
    }

    @Override
    public char getChar() {
        this.ensureChunk(2);
        this.filePosition_$eq(this.filePosition() + 2L);
        return this.chunkBuffer().getChar();
    }

    @Override
    public short getShort() {
        this.ensureChunk(2);
        this.filePosition_$eq(this.filePosition() + 2L);
        return this.chunkBuffer().getShort();
    }

    @Override
    public int getInt() {
        this.ensureChunk(4);
        this.filePosition_$eq(this.filePosition() + 4L);
        return this.chunkBuffer().getInt();
    }

    @Override
    public float getFloat() {
        this.ensureChunk(4);
        this.filePosition_$eq(this.filePosition() + 4L);
        return this.chunkBuffer().getFloat();
    }

    @Override
    public double getDouble() {
        this.ensureChunk(8);
        this.filePosition_$eq(this.filePosition() + 8L);
        return this.chunkBuffer().getDouble();
    }

    @Override
    public long getLong() {
        this.ensureChunk(8);
        this.filePosition_$eq(this.filePosition() + 8L);
        return this.chunkBuffer().getLong();
    }

    public StreamingByteReader(RangeReader rangeReader, int chunkSize) {
        this.rangeReader = rangeReader;
        this.chunkSize = chunkSize;
        this.chunkRange = new RichLong(Predef$.MODULE$.longWrapper(1L)).to((Object)BoxesRunTime.boxToLong((long)0L));
        this.filePosition = 0L;
        this.byteOrder = ByteOrder.BIG_ENDIAN;
    }
}

