/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.util;

import geotrellis.util.ByteReader;
import geotrellis.util.RangeReader;
import geotrellis.util.StreamingByteReader$;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import scala.Array$;
import scala.Predef$;
import scala.collection.immutable.NumericRange;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichLong;

@ScalaSignature(bytes="\u0006\u0001\u0005%e\u0001B\u0014)\u00015B\u0001\u0002\u000f\u0001\u0003\u0002\u0003\u0006I!\u000f\u0005\ty\u0001\u0011\t\u0011)A\u0005{!)\u0001\t\u0001C\u0001\u0003\"IQ\t\u0001a\u0001\u0002\u0004%IA\u0012\u0005\n\u001b\u0002\u0001\r\u00111A\u0005\n9C\u0011\u0002\u0016\u0001A\u0002\u0003\u0005\u000b\u0015B$\t\u0013U\u0003\u0001\u0019!a\u0001\n\u00131\u0006\"C0\u0001\u0001\u0004\u0005\r\u0011\"\u0003a\u0011%\u0011\u0007\u00011A\u0001B\u0003&q\u000bC\u0004d\u0001\u0001\u0007I\u0011\u00023\t\u000fA\u0004\u0001\u0019!C\u0005c\"11\u000f\u0001Q!\n\u0015Dq\u0001\u001e\u0001A\u0002\u0013%Q\u000fC\u0004w\u0001\u0001\u0007I\u0011B<\t\re\u0004\u0001\u0015)\u0003n\u0011\u001dQ\b\u00011A\u0005\nmD\u0001b \u0001A\u0002\u0013%\u0011\u0011\u0001\u0005\b\u0003\u000b\u0001\u0001\u0015)\u0003}\u0011\u0019\t9\u0001\u0001C\u0001k\"9\u0011q\u0001\u0001\u0005\u0002\u0005%\u0001BBA\b\u0001\u0011\u00051\u0010C\u0004\u0002\u0010\u0001!\t!!\u0005\t\u000f\u0005U\u0001\u0001\"\u0003\u0002\u0018!9\u0011Q\u0004\u0001\u0005\n\u0005}\u0001bBA\u0013\u0001\u0011\u0005\u0011q\u0005\u0005\b\u0003W\u0001A\u0011AA\u0017\u0011\u001d\ty\u0003\u0001C\u0001\u0003cAq!!\u000f\u0001\t\u0003\tY\u0004C\u0004\u0002D\u0001!\t!!\u0012\t\u000f\u0005\u001d\u0003\u0001\"\u0001\u0002J!9\u0011\u0011\u000b\u0001\u0005\u0002\u0005M\u0003BBA.\u0001\u0011\u0005QoB\u0004\u0002^!B\t!a\u0018\u0007\r\u001dB\u0003\u0012AA1\u0011\u0019\u0001%\u0005\"\u0001\u0002d!9\u0011Q\r\u0012\u0005\u0002\u0005\u001d\u0004bBA3E\u0011\u0005\u00111\u000e\u0005\n\u0003c\u0012\u0013\u0013!C\u0001\u0003g\u00121c\u0015;sK\u0006l\u0017N\\4CsR,'+Z1eKJT!!\u000b\u0016\u0002\tU$\u0018\u000e\u001c\u0006\u0002W\u0005Qq-Z8ue\u0016dG.[:\u0004\u0001M\u0019\u0001A\f\u001b\u0011\u0005=\u0012T\"\u0001\u0019\u000b\u0003E\nQa]2bY\u0006L!a\r\u0019\u0003\r\u0005s\u0017PU3g!\t)d'D\u0001)\u0013\t9\u0004F\u0001\u0006CsR,'+Z1eKJ\f1B]1oO\u0016\u0014V-\u00193feB\u0011QGO\u0005\u0003w!\u00121BU1oO\u0016\u0014V-\u00193fe\u0006I1\r[;oWNK'0\u001a\t\u0003_yJ!a\u0010\u0019\u0003\u0007%sG/\u0001\u0004=S:LGO\u0010\u000b\u0004\u0005\u000e#\u0005CA\u001b\u0001\u0011\u0015A4\u00011\u0001:\u0011\u001da4\u0001%AA\u0002u\n!b\u00195v].\u0014\u0015\u0010^3t+\u00059\u0005cA\u0018I\u0015&\u0011\u0011\n\r\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003_-K!\u0001\u0014\u0019\u0003\t\tKH/Z\u0001\u000fG\",hn\u001b\"zi\u0016\u001cx\fJ3r)\ty%\u000b\u0005\u00020!&\u0011\u0011\u000b\r\u0002\u0005+:LG\u000fC\u0004T\u000b\u0005\u0005\t\u0019A$\u0002\u0007a$\u0013'A\u0006dQVt7NQ=uKN\u0004\u0013aC2ik:\\')\u001e4gKJ,\u0012a\u0016\t\u00031vk\u0011!\u0017\u0006\u00035n\u000b1A\\5p\u0015\u0005a\u0016\u0001\u00026bm\u0006L!AX-\u0003\u0015\tKH/\u001a\"vM\u001a,'/A\bdQVt7NQ;gM\u0016\u0014x\fJ3r)\ty\u0015\rC\u0004T\u0011\u0005\u0005\t\u0019A,\u0002\u0019\rDWO\\6Ck\u001a4WM\u001d\u0011\u0002\u0015\rDWO\\6SC:<W-F\u0001f!\r17.\\\u0007\u0002O*\u0011\u0001.[\u0001\nS6lW\u000f^1cY\u0016T!A\u001b\u0019\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002mO\naa*^7fe&\u001c'+\u00198hKB\u0011qF\\\u0005\u0003_B\u0012A\u0001T8oO\u0006q1\r[;oWJ\u000bgnZ3`I\u0015\fHCA(s\u0011\u001d\u00196\"!AA\u0002\u0015\f1b\u00195v].\u0014\u0016M\\4fA\u0005aa-\u001b7f!>\u001c\u0018\u000e^5p]V\tQ.\u0001\tgS2,\u0007k\\:ji&|gn\u0018\u0013fcR\u0011q\n\u001f\u0005\b':\t\t\u00111\u0001n\u000351\u0017\u000e\\3Q_NLG/[8oA\u0005I!-\u001f;f\u001fJ$WM]\u000b\u0002yB\u0011\u0001,`\u0005\u0003}f\u0013\u0011BQ=uK>\u0013H-\u001a:\u0002\u001b\tLH/Z(sI\u0016\u0014x\fJ3r)\ry\u00151\u0001\u0005\b'F\t\t\u00111\u0001}\u0003)\u0011\u0017\u0010^3Pe\u0012,'\u000fI\u0001\ta>\u001c\u0018\u000e^5p]R\u0019A'a\u0003\t\r\u00055A\u00031\u0001n\u0003-qWm\u001e)pg&$\u0018n\u001c8\u0002\u000b=\u0014H-\u001a:\u0015\u0007=\u000b\u0019\u0002C\u0003{-\u0001\u0007A0A\u0005sK\u0006$7\t[;oWR\u0019q*!\u0007\t\r\u0005mq\u00031\u0001f\u0003!qWm\u001e*b]\u001e,\u0017aC3ogV\u0014Xm\u00115v].$2!PA\u0011\u0011\u0019\t\u0019\u0003\u0007a\u0001{\u00051A.\u001a8hi\"\f\u0001bZ3u\u0005f$Xm\u001d\u000b\u0004\u000f\u0006%\u0002BBA\u00123\u0001\u0007Q(A\u0002hKR,\u0012AS\u0001\bO\u0016$8\t[1s+\t\t\u0019\u0004E\u00020\u0003kI1!a\u000e1\u0005\u0011\u0019\u0005.\u0019:\u0002\u0011\u001d,Go\u00155peR,\"!!\u0010\u0011\u0007=\ny$C\u0002\u0002BA\u0012Qa\u00155peR\faaZ3u\u0013:$X#A\u001f\u0002\u0011\u001d,GO\u00127pCR,\"!a\u0013\u0011\u0007=\ni%C\u0002\u0002PA\u0012QA\u00127pCR\f\u0011bZ3u\t>,(\r\\3\u0016\u0005\u0005U\u0003cA\u0018\u0002X%\u0019\u0011\u0011\f\u0019\u0003\r\u0011{WO\u00197f\u0003\u001d9W\r\u001e'p]\u001e\f1c\u0015;sK\u0006l\u0017N\\4CsR,'+Z1eKJ\u0004\"!\u000e\u0012\u0014\u0005\trCCAA0\u0003\u0015\t\u0007\u000f\u001d7z)\r\u0011\u0015\u0011\u000e\u0005\u0006q\u0011\u0002\r!\u000f\u000b\u0006\u0005\u00065\u0014q\u000e\u0005\u0006q\u0015\u0002\r!\u000f\u0005\u0006y\u0015\u0002\r!P\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000f\n\u001a\u0016\u0005\u0005U$fA\u001f\u0002x-\u0012\u0011\u0011\u0010\t\u0005\u0003w\n))\u0004\u0002\u0002~)!\u0011qPAA\u0003%)hn\u00195fG.,GMC\u0002\u0002\u0004B\n!\"\u00198o_R\fG/[8o\u0013\u0011\t9)! \u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\r")
public class StreamingByteReader
implements ByteReader {
    private final RangeReader rangeReader;
    private final int chunkSize;
    private byte[] chunkBytes;
    private ByteBuffer chunkBuffer;
    private NumericRange<Object> chunkRange;
    private long filePosition;
    private ByteOrder byteOrder;

    public static int $lessinit$greater$default$2() {
        return StreamingByteReader$.MODULE$.$lessinit$greater$default$2();
    }

    public static StreamingByteReader apply(RangeReader rangeReader, int n) {
        return StreamingByteReader$.MODULE$.apply(rangeReader, n);
    }

    public static StreamingByteReader apply(RangeReader rangeReader) {
        return StreamingByteReader$.MODULE$.apply(rangeReader);
    }

    private byte[] chunkBytes() {
        return this.chunkBytes;
    }

    private void chunkBytes_$eq(byte[] x$1) {
        this.chunkBytes = x$1;
    }

    private ByteBuffer chunkBuffer() {
        return this.chunkBuffer;
    }

    private void chunkBuffer_$eq(ByteBuffer x$1) {
        this.chunkBuffer = x$1;
    }

    private NumericRange<Object> chunkRange() {
        return this.chunkRange;
    }

    private void chunkRange_$eq(NumericRange<Object> x$1) {
        this.chunkRange = x$1;
    }

    private long filePosition() {
        return this.filePosition;
    }

    private void filePosition_$eq(long x$1) {
        this.filePosition = x$1;
    }

    private ByteOrder byteOrder() {
        return this.byteOrder;
    }

    private void byteOrder_$eq(ByteOrder x$1) {
        this.byteOrder = x$1;
    }

    @Override
    public long position() {
        return this.filePosition();
    }

    @Override
    public ByteReader position(long newPosition) {
        this.filePosition_$eq(newPosition);
        return this;
    }

    @Override
    public ByteOrder order() {
        return this.byteOrder();
    }

    @Override
    public void order(ByteOrder byteOrder) {
        block0: {
            this.byteOrder_$eq(byteOrder);
            if (this.chunkBuffer() == null) break block0;
            this.chunkBuffer().order(byteOrder);
        }
    }

    private void readChunk(NumericRange<Object> newRange) {
        if (this.chunkBytes() != null && BoxesRunTime.unboxToLong((Object)newRange.start()) >= BoxesRunTime.unboxToLong((Object)this.chunkRange().start()) && BoxesRunTime.unboxToLong((Object)newRange.end()) <= BoxesRunTime.unboxToLong((Object)this.chunkRange().end())) {
            return;
        }
        if (this.chunkBytes() != null && BoxesRunTime.unboxToLong((Object)this.chunkRange().start()) <= BoxesRunTime.unboxToLong((Object)newRange.end()) && BoxesRunTime.unboxToLong((Object)newRange.start()) <= BoxesRunTime.unboxToLong((Object)this.chunkRange().end())) {
            NumericRange.Inclusive intersection = new RichLong(Predef$.MODULE$.longWrapper(package$.MODULE$.max(BoxesRunTime.unboxToLong((Object)this.chunkRange().start()), BoxesRunTime.unboxToLong((Object)newRange.start())))).to((Object)BoxesRunTime.boxToLong((long)package$.MODULE$.min(BoxesRunTime.unboxToLong((Object)this.chunkRange().end()), BoxesRunTime.unboxToLong((Object)newRange.end()))));
            byte[] newChunkBytes = (byte[])Array$.MODULE$.ofDim(newRange.length(), ClassTag$.MODULE$.Byte());
            System.arraycopy(this.chunkBytes(), (int)(BoxesRunTime.unboxToLong((Object)intersection.start()) - BoxesRunTime.unboxToLong((Object)this.chunkRange().start())), newChunkBytes, (int)(BoxesRunTime.unboxToLong((Object)intersection.start()) - BoxesRunTime.unboxToLong((Object)newRange.start())), intersection.length());
            if (BoxesRunTime.unboxToLong((Object)newRange.start()) < BoxesRunTime.unboxToLong((Object)this.chunkRange().start())) {
                int length = (int)(BoxesRunTime.unboxToLong((Object)this.chunkRange().start()) - BoxesRunTime.unboxToLong((Object)newRange.start()));
                byte[] bytes = this.rangeReader.readRange(BoxesRunTime.unboxToLong((Object)newRange.start()), length);
                System.arraycopy(bytes, 0, newChunkBytes, 0, length);
            }
            if (BoxesRunTime.unboxToLong((Object)newRange.end()) > BoxesRunTime.unboxToLong((Object)this.chunkRange().end())) {
                int length = (int)(BoxesRunTime.unboxToLong((Object)newRange.end()) - BoxesRunTime.unboxToLong((Object)this.chunkRange().end()));
                byte[] bytes = this.rangeReader.readRange(BoxesRunTime.unboxToLong((Object)this.chunkRange().end()) + 1L, length);
                System.arraycopy(bytes, 0, newChunkBytes, newRange.length() - length, length);
            }
            this.chunkBytes_$eq(newChunkBytes);
            this.chunkRange_$eq(newRange);
            this.chunkBuffer_$eq(ByteBuffer.wrap(this.chunkBytes()).order(this.byteOrder()));
        } else {
            this.chunkBytes_$eq(this.rangeReader.readRange(BoxesRunTime.unboxToLong((Object)newRange.start()), newRange.length()));
            this.chunkRange_$eq(newRange);
            this.chunkBuffer_$eq(ByteBuffer.wrap(this.chunkBytes()).order(this.byteOrder()));
        }
    }

    private int ensureChunk(int length) {
        long trimmed = package$.MODULE$.min((long)length, this.rangeReader.totalLength() - this.filePosition());
        if (!this.chunkRange().contains((Object)BoxesRunTime.boxToLong((long)this.filePosition())) || !this.chunkRange().contains((Object)BoxesRunTime.boxToLong((long)(this.filePosition() + trimmed - 1L)))) {
            long len = package$.MODULE$.min((long)package$.MODULE$.max(length, this.chunkSize), this.rangeReader.totalLength() - this.filePosition());
            this.readChunk((NumericRange<Object>)new RichLong(Predef$.MODULE$.longWrapper(this.filePosition())).to((Object)BoxesRunTime.boxToLong((long)(this.filePosition() + len - 1L))));
        }
        Object object = this.filePosition() != BoxesRunTime.unboxToLong((Object)this.chunkRange().start()) + (long)this.chunkBuffer().position() ? this.chunkBuffer().position((int)(this.filePosition() - BoxesRunTime.unboxToLong((Object)this.chunkRange().start()))) : BoxedUnit.UNIT;
        return (int)trimmed;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public byte[] getBytes(int length) {
        void var3_3;
        int actualLength = this.ensureChunk(length);
        byte[] bytes = (byte[])Array$.MODULE$.ofDim(actualLength, ClassTag$.MODULE$.Byte());
        this.chunkBuffer().get(bytes);
        this.filePosition_$eq(this.filePosition() + (long)actualLength);
        return var3_3;
    }

    @Override
    public byte get() {
        this.ensureChunk(1);
        this.filePosition_$eq(this.filePosition() + 1L);
        return this.chunkBuffer().get();
    }

    @Override
    public char getChar() {
        this.ensureChunk(2);
        this.filePosition_$eq(this.filePosition() + 2L);
        return this.chunkBuffer().getChar();
    }

    @Override
    public short getShort() {
        this.ensureChunk(2);
        this.filePosition_$eq(this.filePosition() + 2L);
        return this.chunkBuffer().getShort();
    }

    @Override
    public int getInt() {
        this.ensureChunk(4);
        this.filePosition_$eq(this.filePosition() + 4L);
        return this.chunkBuffer().getInt();
    }

    @Override
    public float getFloat() {
        this.ensureChunk(4);
        this.filePosition_$eq(this.filePosition() + 4L);
        return this.chunkBuffer().getFloat();
    }

    @Override
    public double getDouble() {
        this.ensureChunk(8);
        this.filePosition_$eq(this.filePosition() + 8L);
        return this.chunkBuffer().getDouble();
    }

    @Override
    public long getLong() {
        this.ensureChunk(8);
        this.filePosition_$eq(this.filePosition() + 8L);
        return this.chunkBuffer().getLong();
    }

    public StreamingByteReader(RangeReader rangeReader, int chunkSize) {
        this.rangeReader = rangeReader;
        this.chunkSize = chunkSize;
        this.chunkRange = new RichLong(Predef$.MODULE$.longWrapper(1L)).to((Object)BoxesRunTime.boxToLong((long)0L));
        this.filePosition = 0L;
        this.byteOrder = ByteOrder.BIG_ENDIAN;
    }
}

