/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.util;

import geotrellis.util.FileRangeReader$;
import geotrellis.util.RangeReader;
import java.io.File;
import java.io.FileInputStream;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import scala.Array$;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001Y3A\u0001D\u0007\u0001%!AQ\u0004\u0001BC\u0002\u0013\u0005a\u0004\u0003\u0005(\u0001\t\u0005\t\u0015!\u0003 \u0011\u0015A\u0003\u0001\"\u0001*\u0011\u001da\u0003A1A\u0005\u00025Ba!\r\u0001!\u0002\u0013q\u0003\"\u0002\u001a\u0001\t\u0003\u0019t!B!\u000e\u0011\u0003\u0011e!\u0002\u0007\u000e\u0011\u0003\u0019\u0005\"\u0002\u0015\t\t\u0003!\u0005\"B#\t\t\u00031\u0005\"B#\t\t\u0003!&a\u0004$jY\u0016\u0014\u0016M\\4f%\u0016\fG-\u001a:\u000b\u00059y\u0011\u0001B;uS2T\u0011\u0001E\u0001\u000bO\u0016|GO]3mY&\u001c8\u0001A\n\u0004\u0001MI\u0002C\u0001\u000b\u0018\u001b\u0005)\"\"\u0001\f\u0002\u000bM\u001c\u0017\r\\1\n\u0005a)\"AB!osJ+g\r\u0005\u0002\u001b75\tQ\"\u0003\u0002\u001d\u001b\tY!+\u00198hKJ+\u0017\rZ3s\u0003\u00111\u0017\u000e\\3\u0016\u0003}\u0001\"\u0001I\u0013\u000e\u0003\u0005R!AI\u0012\u0002\u0005%|'\"\u0001\u0013\u0002\t)\fg/Y\u0005\u0003M\u0005\u0012AAR5mK\u0006)a-\u001b7fA\u00051A(\u001b8jiz\"\"AK\u0016\u0011\u0005i\u0001\u0001\"B\u000f\u0004\u0001\u0004y\u0012a\u0003;pi\u0006dG*\u001a8hi\",\u0012A\f\t\u0003)=J!\u0001M\u000b\u0003\t1{gnZ\u0001\ri>$\u0018\r\u001c'f]\u001e$\b\u000eI\u0001\u0011e\u0016\fGm\u00117jaB,GMU1oO\u0016$2\u0001\u000e\u001e=!\r!RgN\u0005\u0003mU\u0011Q!\u0011:sCf\u0004\"\u0001\u0006\u001d\n\u0005e*\"\u0001\u0002\"zi\u0016DQa\u000f\u0004A\u00029\nQa\u001d;beRDQ!\u0010\u0004A\u0002y\na\u0001\\3oORD\u0007C\u0001\u000b@\u0013\t\u0001UCA\u0002J]R\fqBR5mKJ\u000bgnZ3SK\u0006$WM\u001d\t\u00035!\u0019\"\u0001C\n\u0015\u0003\t\u000bQ!\u00199qYf$\"AK$\t\u000b!S\u0001\u0019A%\u0002\tA\fG\u000f\u001b\t\u0003\u0015Fs!aS(\u0011\u00051+R\"A'\u000b\u00059\u000b\u0012A\u0002\u001fs_>$h(\u0003\u0002Q+\u00051\u0001K]3eK\u001aL!AU*\u0003\rM#(/\u001b8h\u0015\t\u0001V\u0003\u0006\u0002++\")Qd\u0003a\u0001?\u0001")
public class FileRangeReader
implements RangeReader {
    private final File file;
    private final long totalLength;

    public static FileRangeReader apply(File file) {
        return FileRangeReader$.MODULE$.apply(file);
    }

    public static FileRangeReader apply(String string) {
        return FileRangeReader$.MODULE$.apply(string);
    }

    @Override
    public byte[] readRange(long start, int length) {
        return RangeReader.readRange$(this, start, length);
    }

    @Override
    public byte[] readAll() {
        return RangeReader.readAll$(this);
    }

    public File file() {
        return this.file;
    }

    @Override
    public long totalLength() {
        return this.totalLength;
    }

    @Override
    public byte[] readClippedRange(long start, int length) {
        FileInputStream inputStream = new FileInputStream(this.file());
        FileChannel channel = inputStream.getChannel();
        MappedByteBuffer buffer = channel.map(FileChannel.MapMode.READ_ONLY, start, length);
        int i = 0;
        byte[] data = (byte[])Array$.MODULE$.ofDim(buffer.capacity(), ClassTag$.MODULE$.Byte());
        while (buffer.hasRemaining()) {
            int n = package$.MODULE$.min(buffer.remaining(), 262144);
            buffer.get(data, i, n);
            i += n;
        }
        channel.close();
        inputStream.close();
        return data;
    }

    public FileRangeReader(File file) {
        this.file = file;
        RangeReader.$init$(this);
        this.totalLength = file.length();
    }
}

