/*
 * Decompiled with CFR 0.152.
 */
package geotrellis.util;

import geotrellis.util.HttpRangeReader$;
import geotrellis.util.RangeReader;
import java.io.Serializable;
import java.net.URI;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Try$;
import scalaj.http.Http$;
import scalaj.http.HttpRequest;
import scalaj.http.HttpResponse;

@ScalaSignature(bytes="\u0006\u0001\u00055a\u0001B\n\u0015\u0001eA\u0001\u0002\n\u0001\u0003\u0002\u0003\u0006I!\n\u0005\t[\u0001\u0011\t\u0011)A\u0005]!)\u0011\u0007\u0001C\u0001e!9a\u0007\u0001b\u0001\n\u00039\u0004B\u0002!\u0001A\u0003%\u0001\bC\u0004B\u0001\t\u0007I\u0011\u0001\"\t\r\u0019\u0003\u0001\u0015!\u0003D\u0011\u00159\u0005\u0001\"\u0001I\u0011!1\u0006\u0001#b!\n\u00139v!\u00023\u0015\u0011\u0003)g!B\n\u0015\u0011\u00031\u0007\"B\u0019\f\t\u00039\u0007\"\u00025\f\t\u0003I\u0007\"\u00025\f\t\u00039\b\"\u00025\f\t\u0003i\bBB@\f\t\u0003\t\t\u0001\u0003\u0004\u0000\u0017\u0011\u0005\u0011Q\u0001\u0005\u0007\u007f.!\t!!\u0003\u0003\u001f!#H\u000f\u001d*b]\u001e,'+Z1eKJT!!\u0006\f\u0002\tU$\u0018\u000e\u001c\u0006\u0002/\u0005Qq-Z8ue\u0016dG.[:\u0004\u0001M\u0019\u0001A\u0007\u0011\u0011\u0005mqR\"\u0001\u000f\u000b\u0003u\tQa]2bY\u0006L!a\b\u000f\u0003\r\u0005s\u0017PU3g!\t\t#%D\u0001\u0015\u0013\t\u0019CCA\u0006SC:<WMU3bI\u0016\u0014\u0018aA;sYB\u0011aeK\u0007\u0002O)\u0011\u0001&K\u0001\u0004]\u0016$(\"\u0001\u0016\u0002\t)\fg/Y\u0005\u0003Y\u001d\u00121!\u0016*M\u00039)8/\u001a%fC\u0012\u0014V-];fgR\u0004\"aG\u0018\n\u0005Ab\"a\u0002\"p_2,\u0017M\\\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007M\"T\u0007\u0005\u0002\"\u0001!)Ae\u0001a\u0001K!)Qf\u0001a\u0001]\u00059!/Z9vKN$X#\u0001\u001d\u0011\u0005erT\"\u0001\u001e\u000b\u0005mb\u0014\u0001\u00025uiBT\u0011!P\u0001\u0007g\u000e\fG.\u00196\n\u0005}R$a\u0003%uiB\u0014V-];fgR\f\u0001B]3rk\u0016\u001cH\u000fI\u0001\fi>$\u0018\r\u001c'f]\u001e$\b.F\u0001D!\tYB)\u0003\u0002F9\t!Aj\u001c8h\u00031!x\u000e^1m\u0019\u0016tw\r\u001e5!\u0003A\u0011X-\u00193DY&\u0004\b/\u001a3SC:<W\rF\u0002J\u001fF\u00032a\u0007&M\u0013\tYEDA\u0003BeJ\f\u0017\u0010\u0005\u0002\u001c\u001b&\u0011a\n\b\u0002\u0005\u0005f$X\rC\u0003Q\u0011\u0001\u00071)A\u0003ti\u0006\u0014H\u000fC\u0003S\u0011\u0001\u00071+\u0001\u0004mK:<G\u000f\u001b\t\u00037QK!!\u0016\u000f\u0003\u0007%sG/\u0001\u0004m_\u001e<WM]\u000b\u00021B\u0011\u0011LX\u0007\u00025*\u00111\fX\u0001\u0006Y><Gg\u001d\u0006\u0002;\u0006\u0019qN]4\n\u0005}S&A\u0002'pO\u001e,'\u000f\u000b\u0002\nCB\u00111DY\u0005\u0003Gr\u0011\u0011\u0002\u001e:b]NLWM\u001c;\u0002\u001f!#H\u000f\u001d*b]\u001e,'+Z1eKJ\u0004\"!I\u0006\u0014\u0005-QB#A3\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u0005MR\u0007\"B6\u000e\u0001\u0004a\u0017aB1eIJ,7o\u001d\t\u0003[Rt!A\u001c:\u0011\u0005=dR\"\u00019\u000b\u0005ED\u0012A\u0002\u001fs_>$h(\u0003\u0002t9\u00051\u0001K]3eK\u001aL!!\u001e<\u0003\rM#(/\u001b8h\u0015\t\u0019H\u0004\u0006\u00024q\")\u0011P\u0004a\u0001u\u0006\u0019QO]5\u0011\u0005\u0019Z\u0018B\u0001?(\u0005\r)&+\u0013\u000b\u0003gyDQ\u0001J\bA\u0002\u0015\n!c^5uQ>,H\u000fS3bIJ+\u0017/^3tiR\u00191'a\u0001\t\u000b\u0011\u0002\u0002\u0019A\u0013\u0015\u0007M\n9\u0001C\u0003l#\u0001\u0007A\u000eF\u00024\u0003\u0017AQ!\u001f\nA\u0002i\u0004")
public class HttpRangeReader
implements RangeReader {
    private transient Logger logger;
    private final HttpRequest request;
    private final long totalLength;
    private volatile transient boolean bitmap$trans$0;

    public static HttpRangeReader withoutHeadRequest(URI uRI) {
        return HttpRangeReader$.MODULE$.withoutHeadRequest(uRI);
    }

    public static HttpRangeReader withoutHeadRequest(String string) {
        return HttpRangeReader$.MODULE$.withoutHeadRequest(string);
    }

    public static HttpRangeReader withoutHeadRequest(URL uRL) {
        return HttpRangeReader$.MODULE$.withoutHeadRequest(uRL);
    }

    public static HttpRangeReader apply(URL uRL) {
        return HttpRangeReader$.MODULE$.apply(uRL);
    }

    public static HttpRangeReader apply(URI uRI) {
        return HttpRangeReader$.MODULE$.apply(uRI);
    }

    public static HttpRangeReader apply(String string) {
        return HttpRangeReader$.MODULE$.apply(string);
    }

    @Override
    public byte[] readRange(long start, int length) {
        return RangeReader.readRange$(this, start, length);
    }

    @Override
    public byte[] readAll() {
        return RangeReader.readAll$(this);
    }

    private Logger logger$lzycompute() {
        HttpRangeReader httpRangeReader = this;
        synchronized (httpRangeReader) {
            if (!this.bitmap$trans$0) {
                this.logger = LoggerFactory.getLogger(HttpRangeReader.class);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    private Logger logger() {
        if (!this.bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public HttpRequest request() {
        return this.request;
    }

    @Override
    public long totalLength() {
        return this.totalLength;
    }

    @Override
    public byte[] readClippedRange(long start, int length) {
        HttpResponse res;
        block0: {
            res = this.request().method("GET").header("Range", new StringBuilder(7).append("bytes=").append(start).append("-").append(start + (long)length).toString()).asBytes();
            Predef$.MODULE$.require(res.code() != 416, (Function0 & Serializable & scala.Serializable)() -> "Server unable to generate the byte range between ${start} and ${start + length}");
            if (res.code() == 206) break block0;
            this.logger().info("Server responded to range request with HTTP code other than PARTIAL_RESPONSE (206)");
        }
        return (byte[])res.body();
    }

    public HttpRangeReader(URL url, boolean useHeadRequest) {
        long l;
        RangeReader.$init$(this);
        this.request = Http$.MODULE$.apply(url.toString());
        HttpResponse headers = useHeadRequest ? this.request().method("HEAD").asString() : this.request().method("GET").execute((Function1 & Serializable & scala.Serializable)is -> "");
        Option option = headers.header("Content-Length").flatMap((Function1 & Serializable & scala.Serializable)cl -> Try$.MODULE$.apply((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(cl)).toLong()).toOption());
        if (option instanceof Some) {
            long num;
            Some some = (Some)option;
            l = num = BoxesRunTime.unboxToLong((Object)some.value());
        } else if (None$.MODULE$.equals(option)) {
            l = -1L;
        } else {
            throw new MatchError((Object)option);
        }
        long contentLength = l;
        headers.throwError();
        Predef$.MODULE$.require(headers.header("Accept-Ranges").contains((Object)"bytes"), (Function0 & Serializable & scala.Serializable)() -> "Server doesn't support ranged byte reads");
        Predef$.MODULE$.require(contentLength > 0L, (Function0 & Serializable & scala.Serializable)() -> "Server didn't provide (required) \"Content-Length\" headers, unable to do range-based read");
        this.totalLength = contentLength;
    }
}

