/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.ext.loggly.io;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;

public class DiscardingRollingOutputStream
extends OutputStream {
    public static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private ByteArrayOutputStream currentBucket;
    private final ReentrantLock currentBucketLock = new ReentrantLock();
    private final BlockingDeque<ByteArrayOutputStream> filledBuckets;
    private final ConcurrentLinkedQueue<ByteArrayOutputStream> recycledBucketPool;
    private long maxBucketSizeInBytes;
    private final AtomicInteger discardedBucketCount = new AtomicInteger();

    public DiscardingRollingOutputStream(int n, int n2) {
        if (n2 < 2) {
            throw new IllegalArgumentException("'maxBucketCount' must be >1");
        }
        this.maxBucketSizeInBytes = n;
        this.filledBuckets = new LinkedBlockingDeque<ByteArrayOutputStream>(n2);
        this.recycledBucketPool = new ConcurrentLinkedQueue();
        this.currentBucket = this.newBucket();
    }

    @Override
    public void write(int n) throws IOException {
        this.currentBucketLock.lock();
        try {
            this.currentBucket.write(n);
            this.rollCurrentBucketIfNeeded();
        }
        finally {
            this.currentBucketLock.unlock();
        }
    }

    @Override
    public void write(byte[] byArray) throws IOException {
        this.currentBucketLock.lock();
        try {
            this.currentBucket.write(byArray);
            this.rollCurrentBucketIfNeeded();
        }
        finally {
            this.currentBucketLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.currentBucketLock.lock();
        try {
            this.currentBucket.write(byArray, n, n2);
            this.rollCurrentBucketIfNeeded();
        }
        finally {
            this.currentBucketLock.unlock();
        }
    }

    @Override
    public void flush() throws IOException {
        this.currentBucketLock.lock();
        try {
            this.currentBucket.flush();
        }
        finally {
            this.currentBucketLock.unlock();
        }
    }

    @Override
    public void close() {
    }

    private void rollCurrentBucketIfNeeded() {
        if ((long)this.currentBucket.size() < this.maxBucketSizeInBytes) {
            return;
        }
        this.rollCurrentBucket();
    }

    public void rollCurrentBucketIfNotEmpty() {
        if (this.currentBucket.size() == 0) {
            return;
        }
        this.rollCurrentBucket();
    }

    public void rollCurrentBucket() {
        this.currentBucketLock.lock();
        try {
            boolean bl = this.filledBuckets.offer(this.currentBucket);
            if (bl) {
                this.onBucketRoll(this.currentBucket);
            } else {
                this.onBucketDiscard(this.currentBucket);
                this.discardedBucketCount.incrementAndGet();
            }
            this.currentBucket = this.newBucket();
        }
        finally {
            this.currentBucketLock.unlock();
        }
    }

    protected void onBucketDiscard(ByteArrayOutputStream byteArrayOutputStream) {
    }

    protected void onBucketRoll(ByteArrayOutputStream byteArrayOutputStream) {
    }

    protected ByteArrayOutputStream newBucket() {
        ByteArrayOutputStream byteArrayOutputStream = this.recycledBucketPool.poll();
        if (byteArrayOutputStream == null) {
            byteArrayOutputStream = new ByteArrayOutputStream();
        }
        return byteArrayOutputStream;
    }

    public void recycleBucket(ByteArrayOutputStream byteArrayOutputStream) {
        byteArrayOutputStream.reset();
        this.recycledBucketPool.offer(byteArrayOutputStream);
    }

    public BlockingDeque<ByteArrayOutputStream> getFilledBuckets() {
        return this.filledBuckets;
    }

    public int getDiscardedBucketCount() {
        return this.discardedBucketCount.get();
    }

    public long getCurrentOutputStreamSize() {
        long l = 0L;
        for (ByteArrayOutputStream byteArrayOutputStream : this.filledBuckets) {
            l += (long)byteArrayOutputStream.size();
        }
        return l += (long)this.currentBucket.size();
    }

    public String toString() {
        return "DiscardingRollingOutputStream{currentBucket.bytesWritten=" + this.currentBucket.size() + ", filledBuckets.size=" + this.filledBuckets.size() + ", discardedBucketCount=" + this.discardedBucketCount + ", recycledBucketPool.size=" + this.recycledBucketPool.size() + '}';
    }
}

