/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.ext.spring.web;

import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.ext.spring.LogbackConfigurer;
import java.io.FileNotFoundException;
import java.lang.reflect.Method;
import javax.servlet.ServletContext;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.ResourceUtils;
import org.springframework.util.SystemPropertyUtils;
import org.springframework.web.util.WebUtils;

public class WebLogbackConfigurer {
    public static final String CONFIG_LOCATION_PARAM = "logbackConfigLocation";
    public static final String EXPOSE_WEB_APP_ROOT_PARAM = "logbackExposeWebAppRoot";

    private WebLogbackConfigurer() {
    }

    public static void initLogging(ServletContext servletContext) {
        String location;
        if (WebLogbackConfigurer.exposeWebAppRoot(servletContext)) {
            WebUtils.setWebAppRootSystemProperty((ServletContext)servletContext);
        }
        if ((location = servletContext.getInitParameter(CONFIG_LOCATION_PARAM)) != null) {
            try {
                if (!ResourceUtils.isUrl((String)location)) {
                    location = SystemPropertyUtils.resolvePlaceholders((String)location);
                    location = WebUtils.getRealPath((ServletContext)servletContext, (String)location);
                }
                servletContext.log("Initializing Logback from [" + location + "]");
                LogbackConfigurer.initLogging(location);
            }
            catch (FileNotFoundException ex) {
                throw new IllegalArgumentException("Invalid 'logbackConfigLocation' parameter: " + ex.getMessage());
            }
            catch (JoranException e) {
                throw new RuntimeException("Unexpected error while configuring logback", e);
            }
        }
        try {
            Class julBridge = ClassUtils.forName((String)"org.slf4j.bridge.SLF4JBridgeHandler", (ClassLoader)ClassUtils.getDefaultClassLoader());
            Method install = ReflectionUtils.findMethod((Class)julBridge, (String)"install");
            if (install != null) {
                servletContext.log("Installing JUL to SLF4J bridge");
                ReflectionUtils.invokeMethod((Method)install, null);
            }
        }
        catch (ClassNotFoundException ignored) {
            servletContext.log("JUL to SLF4J bridge is not available on the classpath");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shutdownLogging(ServletContext servletContext) {
        try {
            Class julBridge = ClassUtils.forName((String)"org.slf4j.bridge.SLF4JBridgeHandler", (ClassLoader)ClassUtils.getDefaultClassLoader());
            Method uninstall = ReflectionUtils.findMethod((Class)julBridge, (String)"uninstall");
            if (uninstall != null) {
                servletContext.log("Uninstalling JUL to SLF4J bridge");
                ReflectionUtils.invokeMethod((Method)uninstall, null);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        try {
            servletContext.log("Shutting down Logback");
            LogbackConfigurer.shutdownLogging();
        }
        finally {
            if (WebLogbackConfigurer.exposeWebAppRoot(servletContext)) {
                WebUtils.removeWebAppRootSystemProperty((ServletContext)servletContext);
            }
        }
    }

    private static boolean exposeWebAppRoot(ServletContext servletContext) {
        String exposeWebAppRootParam = servletContext.getInitParameter(EXPOSE_WEB_APP_ROOT_PARAM);
        return exposeWebAppRootParam == null || Boolean.valueOf(exposeWebAppRootParam) != false;
    }
}

