/*
 * Decompiled with CFR 0.152.
 */
package org.logcapture.junit4;

import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import java.util.List;
import org.hamcrest.Matcher;
import org.junit.rules.MethodRule;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.Statement;
import org.logcapture.LogCapture;
import org.logcapture.logback.StubAppender;
import org.slf4j.LoggerFactory;

public class LogCaptureRule
implements MethodRule,
TestRule {
    private final String loggerName;
    private StubAppender logAppender;

    public LogCaptureRule() {
        this("ROOT");
    }

    public LogCaptureRule(String loggerName) {
        this.loggerName = loggerName;
    }

    public Statement apply(Statement base, Description description) {
        return this.apply(base, null, null);
    }

    public Statement apply(final Statement base, FrameworkMethod method, Object target) {
        return new Statement(){

            public void evaluate() throws Throwable {
                LogCaptureRule.this.logAppender = new StubAppender();
                Logger root = (Logger)LoggerFactory.getLogger((String)LogCaptureRule.this.loggerName);
                root.addAppender((Appender)LogCaptureRule.this.logAppender);
                try {
                    base.evaluate();
                }
                finally {
                    root.detachAppender((Appender)LogCaptureRule.this.logAppender);
                }
            }
        };
    }

    public LogCapture logged(Matcher<List<ILoggingEvent>> expectedLoggingMessage) {
        return new LogCapture(this.logAppender.events()).logged(expectedLoggingMessage);
    }

    public LogCapture logged(Matcher<List<ILoggingEvent>> expectedLoggingMessage, Integer times) {
        return new LogCapture(this.logAppender.events()).logged(expectedLoggingMessage, times);
    }
}

