/*
 * Decompiled with CFR 0.152.
 */
package org.logcapture.junit5;

import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import java.util.List;
import org.hamcrest.Matcher;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.logcapture.LogCapture;
import org.logcapture.logback.StubAppender;
import org.slf4j.LoggerFactory;

public class LogCaptureExtension
implements BeforeEachCallback,
AfterEachCallback {
    private final String loggerName;
    private StubAppender logAppender;
    private Logger root;

    public LogCaptureExtension() {
        this("ROOT");
    }

    public LogCaptureExtension(String loggerName) {
        this.loggerName = loggerName;
    }

    public void beforeEach(ExtensionContext context) {
        this.logAppender = new StubAppender();
        this.root = (Logger)LoggerFactory.getLogger((String)this.loggerName);
        this.root.addAppender((Appender)this.logAppender);
    }

    public void afterEach(ExtensionContext context) {
        this.root.detachAppender((Appender)this.logAppender);
    }

    public LogCapture logged(Matcher<List<ILoggingEvent>> expectedLoggingMessage) {
        return new LogCapture(this.logAppender.events()).logged(expectedLoggingMessage);
    }

    public LogCapture logged(Matcher<List<ILoggingEvent>> expectedLoggingMessage, Integer times) {
        return new LogCapture(this.logAppender.events()).logged(expectedLoggingMessage, times);
    }
}

