/*
 * Decompiled with CFR 0.152.
 */
package org.jets3t.apps.uploader;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import javax.swing.filechooser.FileFilter;

public class UploaderFileExtensionFilter
extends FileFilter {
    private String description = null;
    private List acceptableFileExtensionsList = null;

    public UploaderFileExtensionFilter(String description, List fileExtensionsList) {
        this.description = description;
        this.acceptableFileExtensionsList = new ArrayList();
        Iterator iter = fileExtensionsList.iterator();
        while (iter.hasNext()) {
            String extension = iter.next().toString();
            extension = extension.toLowerCase(Locale.getDefault());
            this.acceptableFileExtensionsList.add(extension);
        }
    }

    public boolean accept(File file) {
        if (file.isDirectory()) {
            return true;
        }
        String fileName = file.getName();
        if (fileName.indexOf(".") >= 0 && fileName.lastIndexOf(".") < fileName.length()) {
            String fileExt = fileName.substring(fileName.lastIndexOf(".") + 1);
            fileExt = fileExt.toLowerCase(Locale.getDefault());
            return this.acceptableFileExtensionsList.contains(fileExt);
        }
        return false;
    }

    public String getDescription() {
        return this.description;
    }
}

