/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.nt;

import java.io.IOException;
import java.nio.channels.SocketChannel;
import java.time.Duration;
import java.util.TimerTask;
import oracle.jdbc.internal.Monitor;
import oracle.net.nt.TcpMultiplexer;
import oracle.net.nt.TimeoutInterruptHandler;

public final class AsyncOutboundTimeoutHandler {
    private final AsyncOutboundTimeoutHandler loginTimeoutHandler;
    private final IOException error;
    private final Monitor monitor = Monitor.newInstance();
    private SocketChannel channel = null;
    private TimerTask timeoutTask = null;
    private boolean isExpired = false;

    private AsyncOutboundTimeoutHandler(AsyncOutboundTimeoutHandler asyncOutboundTimeoutHandler, IOException iOException) {
        this.loginTimeoutHandler = asyncOutboundTimeoutHandler;
        this.error = iOException;
    }

    final void setChannel(SocketChannel socketChannel) throws IOException {
        if (this.loginTimeoutHandler != null) {
            this.loginTimeoutHandler.setChannel(socketChannel);
        }
        try (Monitor.CloseableLock closeableLock = this.monitor.acquireCloseableLock();){
            this.ensureUnexpired();
            this.channel = socketChannel;
        }
    }

    public final void scheduleTimeout(Duration duration) throws IOException {
        try (Monitor.CloseableLock closeableLock = this.monitor.acquireCloseableLock();){
            this.ensureUnexpired();
            this.cancelTimeout();
            this.scheduleTimeoutTask(duration);
        }
    }

    private void scheduleTimeoutTask(Duration duration) {
        this.timeoutTask = TimeoutInterruptHandler.scheduleTask(() -> {
            try (Monitor.CloseableLock closeableLock = this.monitor.acquireCloseableLock();){
                if (this.channel != null) {
                    TcpMultiplexer.cancelRegistration(this.channel, this.error);
                }
                this.isExpired = true;
            }
        }, duration.toMillis());
    }

    public final boolean cancelTimeout() {
        try (Monitor.CloseableLock closeableLock = this.monitor.acquireCloseableLock();){
            if (this.timeoutTask != null) {
                boolean bl = this.timeoutTask.cancel();
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    private final void ensureUnexpired() throws IOException {
        if (this.isExpired) {
            throw this.error;
        }
    }

    public static AsyncOutboundTimeoutHandler newInstance(AsyncOutboundTimeoutHandler asyncOutboundTimeoutHandler, IOException iOException) {
        return new AsyncOutboundTimeoutHandler(asyncOutboundTimeoutHandler, iOException);
    }

    public static AsyncOutboundTimeoutHandler newScheduledInstance(AsyncOutboundTimeoutHandler asyncOutboundTimeoutHandler, Duration duration, IOException iOException) {
        AsyncOutboundTimeoutHandler asyncOutboundTimeoutHandler2 = new AsyncOutboundTimeoutHandler(asyncOutboundTimeoutHandler, iOException);
        asyncOutboundTimeoutHandler2.scheduleTimeoutTask(duration);
        return asyncOutboundTimeoutHandler2;
    }
}

