/*
 * Decompiled with CFR 0.152.
 */
package oracle.xdb.spi;

import java.sql.Timestamp;
import java.util.Hashtable;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import javax.naming.directory.InvalidAttributeValueException;
import oracle.aurora.rdbms.DbmsJava;
import oracle.xdb.XDBError;
import oracle.xdb.bean.XMLTypeBean;
import oracle.xdb.dom.XDBDocument;
import oracle.xdb.dom.XDBNode;
import oracle.xdb.spi.XDBContext;

public class XDBResource {
    private static final String NAME_COMPONENT_SEPARATOR = "/";
    private long m_resCState;
    private String m_path;
    private Hashtable m_env;
    private static String CSTATE_NOT_INITIALIZED = "CSTATE_NOT_INITIALIZED";

    public XDBResource(Hashtable hashtable) throws NamingException {
        this.m_resCState = 0L;
        this.m_path = (String)hashtable.get("java.naming.provider.url");
        long[] lArray = new long[1];
        long l = this.loadCState(this.m_path, lArray);
        if (l == 0L) {
            this.m_resCState = lArray[0];
        }
    }

    public XDBResource(Hashtable hashtable, String string) throws NamingException {
        this.m_path = string;
        long[] lArray = new long[1];
        long l = this.loadCState(this.m_path, lArray);
        if (l == 0L) {
            this.m_resCState = lArray[0];
        }
    }

    public XDBResource(Hashtable hashtable, String string, long l) throws NamingException {
        this.m_path = string;
        this.m_resCState = l;
    }

    private void checkCState() throws InvalidAttributeValueException {
        if (this.m_resCState == 0L) {
            throw new InvalidAttributeValueException(XDBError.getMsg("INVALID_OBJECT_ERROR"));
        }
    }

    public String getACL() throws InvalidAttributeValueException {
        this.checkCState();
        return this.getACLNative(this.m_resCState);
    }

    private native String getACLNative(long var1);

    public String getAuthor() throws InvalidAttributeValueException {
        this.checkCState();
        return this.getAuthorNative(this.m_resCState);
    }

    private native String getAuthorNative(long var1);

    private native String getCharSetNative(long var1);

    public String getCharacterSet() throws InvalidAttributeValueException {
        this.checkCState();
        return this.getCharSetNative(this.m_resCState);
    }

    public String getComment() throws InvalidAttributeValueException {
        this.checkCState();
        return this.getCommentNative(this.m_resCState);
    }

    private native String getCommentNative(long var1);

    public Object getContent() throws InvalidAttributeValueException {
        long l = 0L;
        Object object = null;
        this.checkCState();
        if (this.isDirNative(this.m_resCState)) {
            object = new XDBContext(this.m_env, this.m_path, this.m_resCState);
        } else {
            l = this.getContentNative(this.m_resCState);
            XDBDocument xDBDocument = new XDBDocument(null, l);
            String[] stringArray = new String[1];
            String string = XDBContext.getSchemaNameNative(xDBDocument.toCState(), stringArray);
            if (string == null) {
                object = xDBDocument;
            } else {
                try {
                    XMLTypeBean xMLTypeBean = (XMLTypeBean)DbmsJava.classForNameAndSchema((String)string, (String)stringArray[0].toUpperCase()).newInstance();
                    xMLTypeBean.setOwner(xDBDocument);
                    xMLTypeBean.setKidNum(0L);
                    xMLTypeBean.setXobCstate(((XDBNode)((Object)xDBDocument.getDocumentElement())).toCState());
                    object = xMLTypeBean;
                }
                catch (Exception exception) {
                    object = xDBDocument;
                }
            }
        }
        return object;
    }

    private native long getContentNative(long var1);

    public String getContentType() throws InvalidAttributeValueException {
        this.checkCState();
        return this.getContentTypeNative(this.m_resCState);
    }

    private native String getContentTypeNative(long var1);

    private native String getCreateDateNative(long var1);

    public Timestamp getCreationDate() throws InvalidAttributeValueException {
        this.checkCState();
        Timestamp timestamp = Timestamp.valueOf(this.getCreateDateNative(this.m_resCState));
        return timestamp;
    }

    public String getCreator() throws InvalidAttributeValueException {
        this.checkCState();
        return this.getCreatorNative(this.m_resCState);
    }

    private native String getCreatorNative(long var1);

    public String getDisplayName() throws InvalidAttributeValueException {
        this.checkCState();
        return this.getDisplayNameNative(this.m_resCState);
    }

    private native String getDisplayNameNative(long var1);

    public String getLanguage() throws InvalidAttributeValueException {
        this.checkCState();
        return this.getLanguageNative(this.m_resCState);
    }

    private native String getLanguageNative(long var1);

    private native String getLastModDateNative(long var1);

    public String getLastModifier() throws InvalidAttributeValueException {
        this.checkCState();
        return this.getLastModifierNative(this.m_resCState);
    }

    private native String getLastModifierNative(long var1);

    public Timestamp getModificationDate() throws InvalidAttributeValueException {
        this.checkCState();
        Timestamp timestamp = Timestamp.valueOf(this.getLastModDateNative(this.m_resCState));
        return timestamp;
    }

    public String getOwner() throws InvalidAttributeValueException {
        this.checkCState();
        return this.getOwnerNative(this.m_resCState);
    }

    public long getOwnerId() throws InvalidAttributeValueException {
        this.checkCState();
        return this.getOwnerIdNative(this.m_resCState);
    }

    private native long getOwnerIdNative(long var1);

    private native String getOwnerNative(long var1);

    public int getRefCount() throws InvalidAttributeValueException {
        this.checkCState();
        return this.getRefCountNative(this.m_resCState);
    }

    private native int getRefCountNative(long var1);

    public String getSchemaElement() throws InvalidAttributeValueException {
        this.checkCState();
        return this.getSchemaNative(this.m_resCState);
    }

    private native String getSchemaNative(long var1);

    public int getVersionId() throws InvalidAttributeValueException {
        this.checkCState();
        return this.getVersionIdNative(this.m_resCState);
    }

    private native int getVersionIdNative(long var1);

    private native boolean isDirNative(long var1);

    private native long loadCState(String var1, long[] var2);

    public void save() throws InvalidAttributeValueException {
        this.checkCState();
        this.saveNative(this.m_resCState);
    }

    private native void saveNative(long var1);

    public void setACL(String string) throws InvalidAttributeValueException {
        this.checkCState();
        this.setACLNative(this.m_resCState, string, true);
    }

    private native long setACLNative(long var1, String var3, boolean var4);

    public void setAuthor(String string) throws InvalidAttributeValueException {
        this.checkCState();
        this.setAuthorNative(this.m_resCState, string);
    }

    private native void setAuthorNative(long var1, String var3);

    private native void setCharSetNative(long var1, String var3);

    public void setCharacterSet(String string) throws InvalidAttributeValueException {
        this.checkCState();
        this.setCharSetNative(this.m_resCState, string);
    }

    public void setComment(String string) throws InvalidAttributeValueException {
        this.checkCState();
        this.setCommentNative(this.m_resCState, string);
    }

    private native void setCommentNative(long var1, String var3);

    public void setContent(Object object) throws InvalidAttributeValueException, OperationNotSupportedException {
        long l = 0L;
        this.checkCState();
        if (object instanceof XMLTypeBean) {
            XDBDocument xDBDocument = (XDBDocument)((XMLTypeBean)object).getOwnerDocument();
            l = xDBDocument.toCState();
        } else if (object instanceof XDBDocument) {
            l = ((XDBDocument)object).toCState();
        } else {
            if (object instanceof XDBContext) {
                return;
            }
            throw new OperationNotSupportedException(XDBError.getMsg("INVALID_OBJECT_ERROR"));
        }
        this.setContentNative(this.m_resCState, l);
    }

    private native long setContentNative(long var1, long var3);

    public void setContentType(String string) throws InvalidAttributeValueException {
        this.checkCState();
        this.setContentTypeNative(this.m_resCState, string);
    }

    private native void setContentTypeNative(long var1, String var3);

    private native void setCreateDateNative(long var1, String var3);

    public void setCreationDate(Timestamp timestamp) throws InvalidAttributeValueException {
        this.checkCState();
        this.setCreateDateNative(this.m_resCState, timestamp.toString());
    }

    public void setCreator(String string) throws InvalidAttributeValueException {
        this.checkCState();
        this.setCreatorNative(this.m_resCState, string);
    }

    private native void setCreatorNative(long var1, String var3);

    public void setDisplayName(String string) throws InvalidAttributeValueException {
        this.checkCState();
        this.setDisplayNameNative(this.m_resCState, string);
    }

    private native void setDisplayNameNative(long var1, String var3);

    private void setInheritedACL(String string) throws InvalidAttributeValueException {
        this.checkCState();
        this.setACLNative(this.m_resCState, string, false);
    }

    public void setLanguage(String string) throws InvalidAttributeValueException {
        this.checkCState();
        this.setLanguageNative(this.m_resCState, string);
    }

    private native void setLanguageNative(long var1, String var3);

    private native void setLastModDateNative(long var1, String var3);

    public void setLastModifier(String string) throws InvalidAttributeValueException {
        this.checkCState();
        this.setLastModifierNative(this.m_resCState, string);
    }

    private native void setLastModifierNative(long var1, String var3);

    public void setModificationDate(Timestamp timestamp) throws InvalidAttributeValueException {
        this.checkCState();
        this.setLastModDateNative(this.m_resCState, timestamp.toString());
    }

    public void setOwner(String string) throws InvalidAttributeValueException {
        this.checkCState();
        this.setOwnerNative(this.m_resCState, string);
    }

    public void setOwnerId(long l) throws InvalidAttributeValueException {
        this.checkCState();
        this.setOwnerIdNative(this.m_resCState, l);
    }

    private native void setOwnerIdNative(long var1, long var3);

    private native void setOwnerNative(long var1, String var3);

    private native void setSchemaNative(long var1, String var3);
}

