/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.assimp;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.assimp.AIString;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct aiExportDataBlob")
public class AIExportDataBlob
extends Struct<AIExportDataBlob>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int SIZE;
    public static final int DATA;
    public static final int NAME;
    public static final int NEXT;

    protected AIExportDataBlob(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected AIExportDataBlob create(long address, @Nullable ByteBuffer container) {
        return new AIExportDataBlob(address, container);
    }

    public AIExportDataBlob(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), AIExportDataBlob.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="size_t")
    public long size() {
        return AIExportDataBlob.nsize(this.address());
    }

    @NativeType(value="void *")
    public ByteBuffer data() {
        return AIExportDataBlob.ndata(this.address());
    }

    @NativeType(value="struct aiString")
    public AIString name() {
        return AIExportDataBlob.nname(this.address());
    }

    @NativeType(value="struct aiExportDataBlob *")
    public @Nullable AIExportDataBlob next() {
        return AIExportDataBlob.nnext(this.address());
    }

    public AIExportDataBlob data(@NativeType(value="void *") ByteBuffer value) {
        AIExportDataBlob.ndata(this.address(), value);
        return this;
    }

    public AIExportDataBlob name(@NativeType(value="struct aiString") AIString value) {
        AIExportDataBlob.nname(this.address(), value);
        return this;
    }

    public AIExportDataBlob name(Consumer<AIString> consumer) {
        consumer.accept(this.name());
        return this;
    }

    public AIExportDataBlob next(@NativeType(value="struct aiExportDataBlob *") @Nullable AIExportDataBlob value) {
        AIExportDataBlob.nnext(this.address(), value);
        return this;
    }

    public AIExportDataBlob set(ByteBuffer data, AIString name, @Nullable AIExportDataBlob next) {
        this.data(data);
        this.name(name);
        this.next(next);
        return this;
    }

    public AIExportDataBlob set(AIExportDataBlob src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static AIExportDataBlob malloc() {
        return new AIExportDataBlob(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static AIExportDataBlob calloc() {
        return new AIExportDataBlob(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static AIExportDataBlob create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new AIExportDataBlob(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static AIExportDataBlob create(long address) {
        return new AIExportDataBlob(address, null);
    }

    public static @Nullable AIExportDataBlob createSafe(long address) {
        return address == 0L ? null : new AIExportDataBlob(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)AIExportDataBlob.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = AIExportDataBlob.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static AIExportDataBlob mallocStack() {
        return AIExportDataBlob.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static AIExportDataBlob callocStack() {
        return AIExportDataBlob.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static AIExportDataBlob mallocStack(MemoryStack stack) {
        return AIExportDataBlob.malloc(stack);
    }

    @Deprecated
    public static AIExportDataBlob callocStack(MemoryStack stack) {
        return AIExportDataBlob.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return AIExportDataBlob.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return AIExportDataBlob.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return AIExportDataBlob.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return AIExportDataBlob.calloc(capacity, stack);
    }

    public static AIExportDataBlob malloc(MemoryStack stack) {
        return new AIExportDataBlob(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static AIExportDataBlob calloc(MemoryStack stack) {
        return new AIExportDataBlob(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long nsize(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)SIZE));
    }

    public static ByteBuffer ndata(long struct) {
        return MemoryUtil.memByteBuffer((long)MemoryUtil.memGetAddress((long)(struct + (long)DATA)), (int)((int)AIExportDataBlob.nsize(struct)));
    }

    public static AIString nname(long struct) {
        return AIString.create(struct + (long)NAME);
    }

    public static @Nullable AIExportDataBlob nnext(long struct) {
        return AIExportDataBlob.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)NEXT)));
    }

    public static void nsize(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)SIZE), (long)value);
    }

    public static void ndata(long struct, ByteBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)DATA), (long)MemoryUtil.memAddress((ByteBuffer)value));
        AIExportDataBlob.nsize(struct, value.remaining());
    }

    public static void nname(long struct, AIString value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)NAME), (long)AIString.SIZEOF);
    }

    public static void nnext(long struct, @Nullable AIExportDataBlob value) {
        MemoryUtil.memPutAddress((long)(struct + (long)NEXT), (long)MemoryUtil.memAddressSafe((Pointer)value));
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)DATA)));
    }

    static {
        Struct.Layout layout = AIExportDataBlob.__struct((Struct.Member[])new Struct.Member[]{AIExportDataBlob.__member((int)POINTER_SIZE), AIExportDataBlob.__member((int)POINTER_SIZE), AIExportDataBlob.__member((int)AIString.SIZEOF, (int)AIString.ALIGNOF), AIExportDataBlob.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        SIZE = layout.offsetof(0);
        DATA = layout.offsetof(1);
        NAME = layout.offsetof(2);
        NEXT = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<AIExportDataBlob, Buffer>
    implements NativeResource {
        private static final AIExportDataBlob ELEMENT_FACTORY = AIExportDataBlob.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected AIExportDataBlob getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="size_t")
        public long size() {
            return AIExportDataBlob.nsize(this.address());
        }

        @NativeType(value="void *")
        public ByteBuffer data() {
            return AIExportDataBlob.ndata(this.address());
        }

        @NativeType(value="struct aiString")
        public AIString name() {
            return AIExportDataBlob.nname(this.address());
        }

        @NativeType(value="struct aiExportDataBlob *")
        public @Nullable AIExportDataBlob next() {
            return AIExportDataBlob.nnext(this.address());
        }

        public Buffer data(@NativeType(value="void *") ByteBuffer value) {
            AIExportDataBlob.ndata(this.address(), value);
            return this;
        }

        public Buffer name(@NativeType(value="struct aiString") AIString value) {
            AIExportDataBlob.nname(this.address(), value);
            return this;
        }

        public Buffer name(Consumer<AIString> consumer) {
            consumer.accept(this.name());
            return this;
        }

        public Buffer next(@NativeType(value="struct aiExportDataBlob *") @Nullable AIExportDataBlob value) {
            AIExportDataBlob.nnext(this.address(), value);
            return this;
        }
    }
}

