/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.bgfx;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct bgfx_view_stats_t")
public class BGFXViewStats
extends Struct<BGFXViewStats> {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int NAME;
    public static final int VIEW;
    public static final int CPUTIMEBEGIN;
    public static final int CPUTIMEEND;
    public static final int GPUTIMEBEGIN;
    public static final int GPUTIMEEND;
    public static final int GPUFRAMENUM;

    protected BGFXViewStats(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected BGFXViewStats create(long address, @Nullable ByteBuffer container) {
        return new BGFXViewStats(address, container);
    }

    public BGFXViewStats(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), BGFXViewStats.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="char[256]")
    public ByteBuffer name() {
        return BGFXViewStats.nname(this.address());
    }

    @NativeType(value="char[256]")
    public String nameString() {
        return BGFXViewStats.nnameString(this.address());
    }

    @NativeType(value="bgfx_view_id_t")
    public short view() {
        return BGFXViewStats.nview(this.address());
    }

    @NativeType(value="int64_t")
    public long cpuTimeBegin() {
        return BGFXViewStats.ncpuTimeBegin(this.address());
    }

    @NativeType(value="int64_t")
    public long cpuTimeEnd() {
        return BGFXViewStats.ncpuTimeEnd(this.address());
    }

    @NativeType(value="int64_t")
    public long gpuTimeBegin() {
        return BGFXViewStats.ngpuTimeBegin(this.address());
    }

    @NativeType(value="int64_t")
    public long gpuTimeEnd() {
        return BGFXViewStats.ngpuTimeEnd(this.address());
    }

    @NativeType(value="uint32_t")
    public int gpuFrameNum() {
        return BGFXViewStats.ngpuFrameNum(this.address());
    }

    public static BGFXViewStats create(long address) {
        return new BGFXViewStats(address, null);
    }

    @Nullable
    public static BGFXViewStats createSafe(long address) {
        return address == 0L ? null : new BGFXViewStats(address, null);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static ByteBuffer nname(long struct) {
        return MemoryUtil.memByteBuffer((long)(struct + (long)NAME), (int)256);
    }

    public static String nnameString(long struct) {
        return MemoryUtil.memASCII((long)(struct + (long)NAME));
    }

    public static short nview(long struct) {
        return UNSAFE.getShort(null, struct + (long)VIEW);
    }

    public static long ncpuTimeBegin(long struct) {
        return UNSAFE.getLong(null, struct + (long)CPUTIMEBEGIN);
    }

    public static long ncpuTimeEnd(long struct) {
        return UNSAFE.getLong(null, struct + (long)CPUTIMEEND);
    }

    public static long ngpuTimeBegin(long struct) {
        return UNSAFE.getLong(null, struct + (long)GPUTIMEBEGIN);
    }

    public static long ngpuTimeEnd(long struct) {
        return UNSAFE.getLong(null, struct + (long)GPUTIMEEND);
    }

    public static int ngpuFrameNum(long struct) {
        return UNSAFE.getInt(null, struct + (long)GPUFRAMENUM);
    }

    static {
        Struct.Layout layout = BGFXViewStats.__struct((Struct.Member[])new Struct.Member[]{BGFXViewStats.__array((int)1, (int)256), BGFXViewStats.__member((int)2), BGFXViewStats.__member((int)8), BGFXViewStats.__member((int)8), BGFXViewStats.__member((int)8), BGFXViewStats.__member((int)8), BGFXViewStats.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        NAME = layout.offsetof(0);
        VIEW = layout.offsetof(1);
        CPUTIMEBEGIN = layout.offsetof(2);
        CPUTIMEEND = layout.offsetof(3);
        GPUTIMEBEGIN = layout.offsetof(4);
        GPUTIMEEND = layout.offsetof(5);
        GPUFRAMENUM = layout.offsetof(6);
    }

    public static class Buffer
    extends StructBuffer<BGFXViewStats, Buffer> {
        private static final BGFXViewStats ELEMENT_FACTORY = BGFXViewStats.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected BGFXViewStats getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="char[256]")
        public ByteBuffer name() {
            return BGFXViewStats.nname(this.address());
        }

        @NativeType(value="char[256]")
        public String nameString() {
            return BGFXViewStats.nnameString(this.address());
        }

        @NativeType(value="bgfx_view_id_t")
        public short view() {
            return BGFXViewStats.nview(this.address());
        }

        @NativeType(value="int64_t")
        public long cpuTimeBegin() {
            return BGFXViewStats.ncpuTimeBegin(this.address());
        }

        @NativeType(value="int64_t")
        public long cpuTimeEnd() {
            return BGFXViewStats.ncpuTimeEnd(this.address());
        }

        @NativeType(value="int64_t")
        public long gpuTimeBegin() {
            return BGFXViewStats.ngpuTimeBegin(this.address());
        }

        @NativeType(value="int64_t")
        public long gpuTimeEnd() {
            return BGFXViewStats.ngpuTimeEnd(this.address());
        }

        @NativeType(value="uint32_t")
        public int gpuFrameNum() {
            return BGFXViewStats.ngpuFrameNum(this.address());
        }
    }
}

