/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.bgfx;

import java.nio.ByteBuffer;
import java.nio.ShortBuffer;
import javax.annotation.Nullable;
import org.lwjgl.bgfx.BGFXCapsGPU;
import org.lwjgl.bgfx.BGFXCapsLimits;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;

@NativeType(value="struct bgfx_caps_t")
public class BGFXCaps
extends Struct<BGFXCaps> {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int RENDERERTYPE;
    public static final int SUPPORTED;
    public static final int VENDORID;
    public static final int DEVICEID;
    public static final int HOMOGENEOUSDEPTH;
    public static final int ORIGINBOTTOMLEFT;
    public static final int NUMGPUS;
    public static final int GPU;
    public static final int LIMITS;
    public static final int FORMATS;

    protected BGFXCaps(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected BGFXCaps create(long address, @Nullable ByteBuffer container) {
        return new BGFXCaps(address, container);
    }

    public BGFXCaps(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), BGFXCaps.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="bgfx_renderer_type_t")
    public int rendererType() {
        return BGFXCaps.nrendererType(this.address());
    }

    @NativeType(value="uint64_t")
    public long supported() {
        return BGFXCaps.nsupported(this.address());
    }

    @NativeType(value="uint16_t")
    public short vendorId() {
        return BGFXCaps.nvendorId(this.address());
    }

    @NativeType(value="uint16_t")
    public short deviceId() {
        return BGFXCaps.ndeviceId(this.address());
    }

    @NativeType(value="bool")
    public boolean homogeneousDepth() {
        return BGFXCaps.nhomogeneousDepth(this.address());
    }

    @NativeType(value="bool")
    public boolean originBottomLeft() {
        return BGFXCaps.noriginBottomLeft(this.address());
    }

    @NativeType(value="uint8_t")
    public byte numGPUs() {
        return BGFXCaps.nnumGPUs(this.address());
    }

    @NativeType(value="bgfx_caps_gpu_t[4]")
    public BGFXCapsGPU.Buffer gpu() {
        return BGFXCaps.ngpu(this.address());
    }

    @NativeType(value="bgfx_caps_gpu_t")
    public BGFXCapsGPU gpu(int index) {
        return BGFXCaps.ngpu(this.address(), index);
    }

    @NativeType(value="bgfx_caps_limits_t")
    public BGFXCapsLimits limits() {
        return BGFXCaps.nlimits(this.address());
    }

    @NativeType(value="uint16_t[BGFX_TEXTURE_FORMAT_COUNT]")
    public ShortBuffer formats() {
        return BGFXCaps.nformats(this.address());
    }

    @NativeType(value="uint16_t")
    public short formats(int index) {
        return BGFXCaps.nformats(this.address(), index);
    }

    public static BGFXCaps create(long address) {
        return new BGFXCaps(address, null);
    }

    @Nullable
    public static BGFXCaps createSafe(long address) {
        return address == 0L ? null : new BGFXCaps(address, null);
    }

    public static int nrendererType(long struct) {
        return UNSAFE.getInt(null, struct + (long)RENDERERTYPE);
    }

    public static long nsupported(long struct) {
        return UNSAFE.getLong(null, struct + (long)SUPPORTED);
    }

    public static short nvendorId(long struct) {
        return UNSAFE.getShort(null, struct + (long)VENDORID);
    }

    public static short ndeviceId(long struct) {
        return UNSAFE.getShort(null, struct + (long)DEVICEID);
    }

    public static boolean nhomogeneousDepth(long struct) {
        return UNSAFE.getByte(null, struct + (long)HOMOGENEOUSDEPTH) != 0;
    }

    public static boolean noriginBottomLeft(long struct) {
        return UNSAFE.getByte(null, struct + (long)ORIGINBOTTOMLEFT) != 0;
    }

    public static byte nnumGPUs(long struct) {
        return UNSAFE.getByte(null, struct + (long)NUMGPUS);
    }

    public static BGFXCapsGPU.Buffer ngpu(long struct) {
        return BGFXCapsGPU.create(struct + (long)GPU, Byte.toUnsignedInt(BGFXCaps.nnumGPUs(struct)));
    }

    public static BGFXCapsGPU ngpu(long struct, int index) {
        return BGFXCapsGPU.create(struct + (long)GPU + Checks.check((int)index, (int)Byte.toUnsignedInt(BGFXCaps.nnumGPUs(struct))) * (long)BGFXCapsGPU.SIZEOF);
    }

    public static BGFXCapsLimits nlimits(long struct) {
        return BGFXCapsLimits.create(struct + (long)LIMITS);
    }

    public static ShortBuffer nformats(long struct) {
        return MemoryUtil.memShortBuffer((long)(struct + (long)FORMATS), (int)96);
    }

    public static short nformats(long struct, int index) {
        return UNSAFE.getShort(null, struct + (long)FORMATS + Checks.check((int)index, (int)96) * 2L);
    }

    static {
        Struct.Layout layout = BGFXCaps.__struct((Struct.Member[])new Struct.Member[]{BGFXCaps.__member((int)4), BGFXCaps.__member((int)8), BGFXCaps.__member((int)2), BGFXCaps.__member((int)2), BGFXCaps.__member((int)1), BGFXCaps.__member((int)1), BGFXCaps.__member((int)1), BGFXCaps.__array((int)BGFXCapsGPU.SIZEOF, (int)BGFXCapsGPU.ALIGNOF, (int)4), BGFXCaps.__member((int)BGFXCapsLimits.SIZEOF, (int)BGFXCapsLimits.ALIGNOF), BGFXCaps.__array((int)2, (int)96)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        RENDERERTYPE = layout.offsetof(0);
        SUPPORTED = layout.offsetof(1);
        VENDORID = layout.offsetof(2);
        DEVICEID = layout.offsetof(3);
        HOMOGENEOUSDEPTH = layout.offsetof(4);
        ORIGINBOTTOMLEFT = layout.offsetof(5);
        NUMGPUS = layout.offsetof(6);
        GPU = layout.offsetof(7);
        LIMITS = layout.offsetof(8);
        FORMATS = layout.offsetof(9);
    }
}

