/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.bgfx;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;

@NativeType(value="struct bgfx_init_limits_t")
public class BGFXInitLimits
extends Struct<BGFXInitLimits>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int MAXENCODERS;
    public static final int MINRESOURCECBSIZE;
    public static final int TRANSIENTVBSIZE;
    public static final int TRANSIENTIBSIZE;

    protected BGFXInitLimits(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected BGFXInitLimits create(long address, @Nullable ByteBuffer container) {
        return new BGFXInitLimits(address, container);
    }

    public BGFXInitLimits(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), BGFXInitLimits.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="uint16_t")
    public short maxEncoders() {
        return BGFXInitLimits.nmaxEncoders(this.address());
    }

    @NativeType(value="uint32_t")
    public int minResourceCbSize() {
        return BGFXInitLimits.nminResourceCbSize(this.address());
    }

    @NativeType(value="uint32_t")
    public int transientVbSize() {
        return BGFXInitLimits.ntransientVbSize(this.address());
    }

    @NativeType(value="uint32_t")
    public int transientIbSize() {
        return BGFXInitLimits.ntransientIbSize(this.address());
    }

    public BGFXInitLimits maxEncoders(@NativeType(value="uint16_t") short value) {
        BGFXInitLimits.nmaxEncoders(this.address(), value);
        return this;
    }

    public BGFXInitLimits minResourceCbSize(@NativeType(value="uint32_t") int value) {
        BGFXInitLimits.nminResourceCbSize(this.address(), value);
        return this;
    }

    public BGFXInitLimits transientVbSize(@NativeType(value="uint32_t") int value) {
        BGFXInitLimits.ntransientVbSize(this.address(), value);
        return this;
    }

    public BGFXInitLimits transientIbSize(@NativeType(value="uint32_t") int value) {
        BGFXInitLimits.ntransientIbSize(this.address(), value);
        return this;
    }

    public BGFXInitLimits set(short maxEncoders, int minResourceCbSize, int transientVbSize, int transientIbSize) {
        this.maxEncoders(maxEncoders);
        this.minResourceCbSize(minResourceCbSize);
        this.transientVbSize(transientVbSize);
        this.transientIbSize(transientIbSize);
        return this;
    }

    public BGFXInitLimits set(BGFXInitLimits src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static BGFXInitLimits malloc() {
        return new BGFXInitLimits(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static BGFXInitLimits calloc() {
        return new BGFXInitLimits(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static BGFXInitLimits create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new BGFXInitLimits(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static BGFXInitLimits create(long address) {
        return new BGFXInitLimits(address, null);
    }

    @Nullable
    public static BGFXInitLimits createSafe(long address) {
        return address == 0L ? null : new BGFXInitLimits(address, null);
    }

    @Deprecated
    public static BGFXInitLimits mallocStack() {
        return BGFXInitLimits.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static BGFXInitLimits callocStack() {
        return BGFXInitLimits.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static BGFXInitLimits mallocStack(MemoryStack stack) {
        return BGFXInitLimits.malloc(stack);
    }

    @Deprecated
    public static BGFXInitLimits callocStack(MemoryStack stack) {
        return BGFXInitLimits.calloc(stack);
    }

    public static BGFXInitLimits malloc(MemoryStack stack) {
        return new BGFXInitLimits(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static BGFXInitLimits calloc(MemoryStack stack) {
        return new BGFXInitLimits(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static short nmaxEncoders(long struct) {
        return UNSAFE.getShort(null, struct + (long)MAXENCODERS);
    }

    public static int nminResourceCbSize(long struct) {
        return UNSAFE.getInt(null, struct + (long)MINRESOURCECBSIZE);
    }

    public static int ntransientVbSize(long struct) {
        return UNSAFE.getInt(null, struct + (long)TRANSIENTVBSIZE);
    }

    public static int ntransientIbSize(long struct) {
        return UNSAFE.getInt(null, struct + (long)TRANSIENTIBSIZE);
    }

    public static void nmaxEncoders(long struct, short value) {
        UNSAFE.putShort(null, struct + (long)MAXENCODERS, value);
    }

    public static void nminResourceCbSize(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)MINRESOURCECBSIZE, value);
    }

    public static void ntransientVbSize(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TRANSIENTVBSIZE, value);
    }

    public static void ntransientIbSize(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TRANSIENTIBSIZE, value);
    }

    static {
        Struct.Layout layout = BGFXInitLimits.__struct((Struct.Member[])new Struct.Member[]{BGFXInitLimits.__member((int)2), BGFXInitLimits.__member((int)4), BGFXInitLimits.__member((int)4), BGFXInitLimits.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        MAXENCODERS = layout.offsetof(0);
        MINRESOURCECBSIZE = layout.offsetof(1);
        TRANSIENTVBSIZE = layout.offsetof(2);
        TRANSIENTIBSIZE = layout.offsetof(3);
    }
}

