/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.fmod;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class FMOD_ERRORCALLBACK_INFO
extends Struct<FMOD_ERRORCALLBACK_INFO>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int RESULT;
    public static final int INSTANCETYPE;
    public static final int INSTANCE;
    public static final int FUNCTIONNAME;
    public static final int FUNCTIONPARAMS;

    protected FMOD_ERRORCALLBACK_INFO(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected FMOD_ERRORCALLBACK_INFO create(long address, @Nullable ByteBuffer container) {
        return new FMOD_ERRORCALLBACK_INFO(address, container);
    }

    public FMOD_ERRORCALLBACK_INFO(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), FMOD_ERRORCALLBACK_INFO.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="FMOD_RESULT")
    public int result() {
        return FMOD_ERRORCALLBACK_INFO.nresult(this.address());
    }

    @NativeType(value="FMOD_ERRORCALLBACK_INSTANCETYPE")
    public int instancetype() {
        return FMOD_ERRORCALLBACK_INFO.ninstancetype(this.address());
    }

    @NativeType(value="void *")
    public long instance() {
        return FMOD_ERRORCALLBACK_INFO.ninstance(this.address());
    }

    @NativeType(value="char const *")
    public ByteBuffer functionname() {
        return FMOD_ERRORCALLBACK_INFO.nfunctionname(this.address());
    }

    @NativeType(value="char const *")
    public String functionnameString() {
        return FMOD_ERRORCALLBACK_INFO.nfunctionnameString(this.address());
    }

    @NativeType(value="char const *")
    public ByteBuffer functionparams() {
        return FMOD_ERRORCALLBACK_INFO.nfunctionparams(this.address());
    }

    @NativeType(value="char const *")
    public String functionparamsString() {
        return FMOD_ERRORCALLBACK_INFO.nfunctionparamsString(this.address());
    }

    public FMOD_ERRORCALLBACK_INFO result(@NativeType(value="FMOD_RESULT") int value) {
        FMOD_ERRORCALLBACK_INFO.nresult(this.address(), value);
        return this;
    }

    public FMOD_ERRORCALLBACK_INFO instancetype(@NativeType(value="FMOD_ERRORCALLBACK_INSTANCETYPE") int value) {
        FMOD_ERRORCALLBACK_INFO.ninstancetype(this.address(), value);
        return this;
    }

    public FMOD_ERRORCALLBACK_INFO instance(@NativeType(value="void *") long value) {
        FMOD_ERRORCALLBACK_INFO.ninstance(this.address(), value);
        return this;
    }

    public FMOD_ERRORCALLBACK_INFO functionname(@NativeType(value="char const *") ByteBuffer value) {
        FMOD_ERRORCALLBACK_INFO.nfunctionname(this.address(), value);
        return this;
    }

    public FMOD_ERRORCALLBACK_INFO functionparams(@NativeType(value="char const *") ByteBuffer value) {
        FMOD_ERRORCALLBACK_INFO.nfunctionparams(this.address(), value);
        return this;
    }

    public FMOD_ERRORCALLBACK_INFO set(int result, int instancetype, long instance, ByteBuffer functionname, ByteBuffer functionparams) {
        this.result(result);
        this.instancetype(instancetype);
        this.instance(instance);
        this.functionname(functionname);
        this.functionparams(functionparams);
        return this;
    }

    public FMOD_ERRORCALLBACK_INFO set(FMOD_ERRORCALLBACK_INFO src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static FMOD_ERRORCALLBACK_INFO malloc() {
        return new FMOD_ERRORCALLBACK_INFO(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static FMOD_ERRORCALLBACK_INFO calloc() {
        return new FMOD_ERRORCALLBACK_INFO(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static FMOD_ERRORCALLBACK_INFO create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new FMOD_ERRORCALLBACK_INFO(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static FMOD_ERRORCALLBACK_INFO create(long address) {
        return new FMOD_ERRORCALLBACK_INFO(address, null);
    }

    @Nullable
    public static FMOD_ERRORCALLBACK_INFO createSafe(long address) {
        return address == 0L ? null : new FMOD_ERRORCALLBACK_INFO(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)FMOD_ERRORCALLBACK_INFO.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = FMOD_ERRORCALLBACK_INFO.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static FMOD_ERRORCALLBACK_INFO malloc(MemoryStack stack) {
        return new FMOD_ERRORCALLBACK_INFO(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static FMOD_ERRORCALLBACK_INFO calloc(MemoryStack stack) {
        return new FMOD_ERRORCALLBACK_INFO(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nresult(long struct) {
        return UNSAFE.getInt(null, struct + (long)RESULT);
    }

    public static int ninstancetype(long struct) {
        return UNSAFE.getInt(null, struct + (long)INSTANCETYPE);
    }

    public static long ninstance(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)INSTANCE));
    }

    public static ByteBuffer nfunctionname(long struct) {
        return MemoryUtil.memByteBufferNT1((long)MemoryUtil.memGetAddress((long)(struct + (long)FUNCTIONNAME)));
    }

    public static String nfunctionnameString(long struct) {
        return MemoryUtil.memUTF8((long)MemoryUtil.memGetAddress((long)(struct + (long)FUNCTIONNAME)));
    }

    public static ByteBuffer nfunctionparams(long struct) {
        return MemoryUtil.memByteBufferNT1((long)MemoryUtil.memGetAddress((long)(struct + (long)FUNCTIONPARAMS)));
    }

    public static String nfunctionparamsString(long struct) {
        return MemoryUtil.memUTF8((long)MemoryUtil.memGetAddress((long)(struct + (long)FUNCTIONPARAMS)));
    }

    public static void nresult(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)RESULT, value);
    }

    public static void ninstancetype(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)INSTANCETYPE, value);
    }

    public static void ninstance(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)INSTANCE), (long)Checks.check((long)value));
    }

    public static void nfunctionname(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)value);
        }
        MemoryUtil.memPutAddress((long)(struct + (long)FUNCTIONNAME), (long)MemoryUtil.memAddress((ByteBuffer)value));
    }

    public static void nfunctionparams(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)value);
        }
        MemoryUtil.memPutAddress((long)(struct + (long)FUNCTIONPARAMS), (long)MemoryUtil.memAddress((ByteBuffer)value));
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)INSTANCE)));
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)FUNCTIONNAME)));
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)FUNCTIONPARAMS)));
    }

    static {
        Struct.Layout layout = FMOD_ERRORCALLBACK_INFO.__struct((Struct.Member[])new Struct.Member[]{FMOD_ERRORCALLBACK_INFO.__member((int)4), FMOD_ERRORCALLBACK_INFO.__member((int)4), FMOD_ERRORCALLBACK_INFO.__member((int)POINTER_SIZE), FMOD_ERRORCALLBACK_INFO.__member((int)POINTER_SIZE), FMOD_ERRORCALLBACK_INFO.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        RESULT = layout.offsetof(0);
        INSTANCETYPE = layout.offsetof(1);
        INSTANCE = layout.offsetof(2);
        FUNCTIONNAME = layout.offsetof(3);
        FUNCTIONPARAMS = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<FMOD_ERRORCALLBACK_INFO, Buffer>
    implements NativeResource {
        private static final FMOD_ERRORCALLBACK_INFO ELEMENT_FACTORY = FMOD_ERRORCALLBACK_INFO.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected FMOD_ERRORCALLBACK_INFO getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="FMOD_RESULT")
        public int result() {
            return FMOD_ERRORCALLBACK_INFO.nresult(this.address());
        }

        @NativeType(value="FMOD_ERRORCALLBACK_INSTANCETYPE")
        public int instancetype() {
            return FMOD_ERRORCALLBACK_INFO.ninstancetype(this.address());
        }

        @NativeType(value="void *")
        public long instance() {
            return FMOD_ERRORCALLBACK_INFO.ninstance(this.address());
        }

        @NativeType(value="char const *")
        public ByteBuffer functionname() {
            return FMOD_ERRORCALLBACK_INFO.nfunctionname(this.address());
        }

        @NativeType(value="char const *")
        public String functionnameString() {
            return FMOD_ERRORCALLBACK_INFO.nfunctionnameString(this.address());
        }

        @NativeType(value="char const *")
        public ByteBuffer functionparams() {
            return FMOD_ERRORCALLBACK_INFO.nfunctionparams(this.address());
        }

        @NativeType(value="char const *")
        public String functionparamsString() {
            return FMOD_ERRORCALLBACK_INFO.nfunctionparamsString(this.address());
        }

        public Buffer result(@NativeType(value="FMOD_RESULT") int value) {
            FMOD_ERRORCALLBACK_INFO.nresult(this.address(), value);
            return this;
        }

        public Buffer instancetype(@NativeType(value="FMOD_ERRORCALLBACK_INSTANCETYPE") int value) {
            FMOD_ERRORCALLBACK_INFO.ninstancetype(this.address(), value);
            return this;
        }

        public Buffer instance(@NativeType(value="void *") long value) {
            FMOD_ERRORCALLBACK_INFO.ninstance(this.address(), value);
            return this;
        }

        public Buffer functionname(@NativeType(value="char const *") ByteBuffer value) {
            FMOD_ERRORCALLBACK_INFO.nfunctionname(this.address(), value);
            return this;
        }

        public Buffer functionparams(@NativeType(value="char const *") ByteBuffer value) {
            FMOD_ERRORCALLBACK_INFO.nfunctionparams(this.address(), value);
            return this;
        }
    }
}

