/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.fmod;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct FMOD_DSP_BUFFER_ARRAY")
public class FMOD_DSP_BUFFER_ARRAY
extends Struct<FMOD_DSP_BUFFER_ARRAY>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int NUMBUFFERS;
    public static final int BUFFERNUMCHANNELS;
    public static final int BUFFERCHANNELMASK;
    public static final int BUFFERS;
    public static final int SPEAKERMODE;

    protected FMOD_DSP_BUFFER_ARRAY(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected FMOD_DSP_BUFFER_ARRAY create(long address, @Nullable ByteBuffer container) {
        return new FMOD_DSP_BUFFER_ARRAY(address, container);
    }

    public FMOD_DSP_BUFFER_ARRAY(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), FMOD_DSP_BUFFER_ARRAY.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    public int numbuffers() {
        return FMOD_DSP_BUFFER_ARRAY.nnumbuffers(this.address());
    }

    @NativeType(value="int *")
    public IntBuffer buffernumchannels() {
        return FMOD_DSP_BUFFER_ARRAY.nbuffernumchannels(this.address());
    }

    @NativeType(value="FMOD_CHANNELMASK *")
    public IntBuffer bufferchannelmask() {
        return FMOD_DSP_BUFFER_ARRAY.nbufferchannelmask(this.address());
    }

    @NativeType(value="float **")
    public PointerBuffer buffers() {
        return FMOD_DSP_BUFFER_ARRAY.nbuffers(this.address());
    }

    @NativeType(value="FMOD_SPEAKERMODE")
    public int speakermode() {
        return FMOD_DSP_BUFFER_ARRAY.nspeakermode(this.address());
    }

    public FMOD_DSP_BUFFER_ARRAY numbuffers(int value) {
        FMOD_DSP_BUFFER_ARRAY.nnumbuffers(this.address(), value);
        return this;
    }

    public FMOD_DSP_BUFFER_ARRAY buffernumchannels(@NativeType(value="int *") IntBuffer value) {
        FMOD_DSP_BUFFER_ARRAY.nbuffernumchannels(this.address(), value);
        return this;
    }

    public FMOD_DSP_BUFFER_ARRAY bufferchannelmask(@NativeType(value="FMOD_CHANNELMASK *") IntBuffer value) {
        FMOD_DSP_BUFFER_ARRAY.nbufferchannelmask(this.address(), value);
        return this;
    }

    public FMOD_DSP_BUFFER_ARRAY buffers(@NativeType(value="float **") PointerBuffer value) {
        FMOD_DSP_BUFFER_ARRAY.nbuffers(this.address(), value);
        return this;
    }

    public FMOD_DSP_BUFFER_ARRAY speakermode(@NativeType(value="FMOD_SPEAKERMODE") int value) {
        FMOD_DSP_BUFFER_ARRAY.nspeakermode(this.address(), value);
        return this;
    }

    public FMOD_DSP_BUFFER_ARRAY set(int numbuffers, IntBuffer buffernumchannels, IntBuffer bufferchannelmask, PointerBuffer buffers, int speakermode) {
        this.numbuffers(numbuffers);
        this.buffernumchannels(buffernumchannels);
        this.bufferchannelmask(bufferchannelmask);
        this.buffers(buffers);
        this.speakermode(speakermode);
        return this;
    }

    public FMOD_DSP_BUFFER_ARRAY set(FMOD_DSP_BUFFER_ARRAY src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static FMOD_DSP_BUFFER_ARRAY malloc() {
        return new FMOD_DSP_BUFFER_ARRAY(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static FMOD_DSP_BUFFER_ARRAY calloc() {
        return new FMOD_DSP_BUFFER_ARRAY(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static FMOD_DSP_BUFFER_ARRAY create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new FMOD_DSP_BUFFER_ARRAY(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static FMOD_DSP_BUFFER_ARRAY create(long address) {
        return new FMOD_DSP_BUFFER_ARRAY(address, null);
    }

    public static @Nullable FMOD_DSP_BUFFER_ARRAY createSafe(long address) {
        return address == 0L ? null : new FMOD_DSP_BUFFER_ARRAY(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)FMOD_DSP_BUFFER_ARRAY.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = FMOD_DSP_BUFFER_ARRAY.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static FMOD_DSP_BUFFER_ARRAY malloc(MemoryStack stack) {
        return new FMOD_DSP_BUFFER_ARRAY(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static FMOD_DSP_BUFFER_ARRAY calloc(MemoryStack stack) {
        return new FMOD_DSP_BUFFER_ARRAY(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nnumbuffers(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)NUMBUFFERS));
    }

    public static IntBuffer nbuffernumchannels(long struct) {
        return MemoryUtil.memIntBuffer((long)MemoryUtil.memGetAddress((long)(struct + (long)BUFFERNUMCHANNELS)), (int)FMOD_DSP_BUFFER_ARRAY.nnumbuffers(struct));
    }

    public static IntBuffer nbufferchannelmask(long struct) {
        return MemoryUtil.memIntBuffer((long)MemoryUtil.memGetAddress((long)(struct + (long)BUFFERCHANNELMASK)), (int)FMOD_DSP_BUFFER_ARRAY.nnumbuffers(struct));
    }

    public static PointerBuffer nbuffers(long struct) {
        return MemoryUtil.memPointerBuffer((long)MemoryUtil.memGetAddress((long)(struct + (long)BUFFERS)), (int)FMOD_DSP_BUFFER_ARRAY.nnumbuffers(struct));
    }

    public static int nspeakermode(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)SPEAKERMODE));
    }

    public static void nnumbuffers(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)NUMBUFFERS), (int)value);
    }

    public static void nbuffernumchannels(long struct, IntBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)BUFFERNUMCHANNELS), (long)MemoryUtil.memAddress((IntBuffer)value));
    }

    public static void nbufferchannelmask(long struct, IntBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)BUFFERCHANNELMASK), (long)MemoryUtil.memAddress((IntBuffer)value));
    }

    public static void nbuffers(long struct, PointerBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)BUFFERS), (long)MemoryUtil.memAddress((CustomBuffer)value));
    }

    public static void nspeakermode(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)SPEAKERMODE), (int)value);
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)BUFFERNUMCHANNELS)));
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)BUFFERCHANNELMASK)));
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)BUFFERS)));
    }

    static {
        Struct.Layout layout = FMOD_DSP_BUFFER_ARRAY.__struct((Struct.Member[])new Struct.Member[]{FMOD_DSP_BUFFER_ARRAY.__member((int)4), FMOD_DSP_BUFFER_ARRAY.__member((int)POINTER_SIZE), FMOD_DSP_BUFFER_ARRAY.__member((int)POINTER_SIZE), FMOD_DSP_BUFFER_ARRAY.__member((int)POINTER_SIZE), FMOD_DSP_BUFFER_ARRAY.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        NUMBUFFERS = layout.offsetof(0);
        BUFFERNUMCHANNELS = layout.offsetof(1);
        BUFFERCHANNELMASK = layout.offsetof(2);
        BUFFERS = layout.offsetof(3);
        SPEAKERMODE = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<FMOD_DSP_BUFFER_ARRAY, Buffer>
    implements NativeResource {
        private static final FMOD_DSP_BUFFER_ARRAY ELEMENT_FACTORY = FMOD_DSP_BUFFER_ARRAY.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected FMOD_DSP_BUFFER_ARRAY getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public int numbuffers() {
            return FMOD_DSP_BUFFER_ARRAY.nnumbuffers(this.address());
        }

        @NativeType(value="int *")
        public IntBuffer buffernumchannels() {
            return FMOD_DSP_BUFFER_ARRAY.nbuffernumchannels(this.address());
        }

        @NativeType(value="FMOD_CHANNELMASK *")
        public IntBuffer bufferchannelmask() {
            return FMOD_DSP_BUFFER_ARRAY.nbufferchannelmask(this.address());
        }

        @NativeType(value="float **")
        public PointerBuffer buffers() {
            return FMOD_DSP_BUFFER_ARRAY.nbuffers(this.address());
        }

        @NativeType(value="FMOD_SPEAKERMODE")
        public int speakermode() {
            return FMOD_DSP_BUFFER_ARRAY.nspeakermode(this.address());
        }

        public Buffer numbuffers(int value) {
            FMOD_DSP_BUFFER_ARRAY.nnumbuffers(this.address(), value);
            return this;
        }

        public Buffer buffernumchannels(@NativeType(value="int *") IntBuffer value) {
            FMOD_DSP_BUFFER_ARRAY.nbuffernumchannels(this.address(), value);
            return this;
        }

        public Buffer bufferchannelmask(@NativeType(value="FMOD_CHANNELMASK *") IntBuffer value) {
            FMOD_DSP_BUFFER_ARRAY.nbufferchannelmask(this.address(), value);
            return this;
        }

        public Buffer buffers(@NativeType(value="float **") PointerBuffer value) {
            FMOD_DSP_BUFFER_ARRAY.nbuffers(this.address(), value);
            return this;
        }

        public Buffer speakermode(@NativeType(value="FMOD_SPEAKERMODE") int value) {
            FMOD_DSP_BUFFER_ARRAY.nspeakermode(this.address(), value);
            return this;
        }
    }
}

