/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.glfw;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;

public class GLFWNativeX11 {
    protected GLFWNativeX11() {
        throw new UnsupportedOperationException();
    }

    @NativeType(value="Display *")
    public static long glfwGetX11Display() {
        long __functionAddress = Functions.GetX11Display;
        return JNI.invokeP((long)__functionAddress);
    }

    @NativeType(value="RRCrtc")
    public static long glfwGetX11Adapter(@NativeType(value="GLFWmonitor *") long monitor) {
        long __functionAddress = Functions.GetX11Adapter;
        if (Checks.CHECKS) {
            Checks.check((long)monitor);
        }
        return JNI.invokePP((long)__functionAddress, (long)monitor);
    }

    @NativeType(value="RROutput")
    public static long glfwGetX11Monitor(@NativeType(value="GLFWmonitor *") long monitor) {
        long __functionAddress = Functions.GetX11Monitor;
        if (Checks.CHECKS) {
            Checks.check((long)monitor);
        }
        return JNI.invokePP((long)__functionAddress, (long)monitor);
    }

    @NativeType(value="Window")
    public static long glfwGetX11Window(@NativeType(value="GLFWwindow *") long window) {
        long __functionAddress = Functions.GetX11Window;
        if (Checks.CHECKS) {
            Checks.check((long)window);
        }
        return JNI.invokePP((long)__functionAddress, (long)window);
    }

    public static void nglfwSetX11SelectionString(long string) {
        long __functionAddress = Functions.SetX11SelectionString;
        JNI.invokePV((long)__functionAddress, (long)string);
    }

    public static void glfwSetX11SelectionString(@NativeType(value="char const *") ByteBuffer string) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)string);
        }
        GLFWNativeX11.nglfwSetX11SelectionString(MemoryUtil.memAddress((ByteBuffer)string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void glfwSetX11SelectionString(@NativeType(value="char const *") CharSequence string) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            ByteBuffer stringEncoded = stack.UTF8(string);
            GLFWNativeX11.nglfwSetX11SelectionString(MemoryUtil.memAddress((ByteBuffer)stringEncoded));
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nglfwGetX11SelectionString() {
        long __functionAddress = Functions.GetX11SelectionString;
        return JNI.invokeP((long)__functionAddress);
    }

    @Nullable
    @NativeType(value="char const *")
    public static String glfwGetX11SelectionString() {
        long __result = GLFWNativeX11.nglfwGetX11SelectionString();
        return MemoryUtil.memUTF8Safe((long)__result);
    }

    public static final class Functions {
        public static final long GetX11Display = APIUtil.apiGetFunctionAddress((FunctionProvider)GLFW.getLibrary(), (String)"glfwGetX11Display");
        public static final long GetX11Adapter = APIUtil.apiGetFunctionAddress((FunctionProvider)GLFW.getLibrary(), (String)"glfwGetX11Adapter");
        public static final long GetX11Monitor = APIUtil.apiGetFunctionAddress((FunctionProvider)GLFW.getLibrary(), (String)"glfwGetX11Monitor");
        public static final long GetX11Window = APIUtil.apiGetFunctionAddress((FunctionProvider)GLFW.getLibrary(), (String)"glfwGetX11Window");
        public static final long SetX11SelectionString = APIUtil.apiGetFunctionAddress((FunctionProvider)GLFW.getLibrary(), (String)"glfwSetX11SelectionString");
        public static final long GetX11SelectionString = APIUtil.apiGetFunctionAddress((FunctionProvider)GLFW.getLibrary(), (String)"glfwGetX11SelectionString");

        private Functions() {
        }
    }
}

