/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.glfw;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct GLFWimage")
public class GLFWImage
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int WIDTH;
    public static final int HEIGHT;
    public static final int PIXELS;

    public GLFWImage(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), GLFWImage.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    public int width() {
        return GLFWImage.nwidth(this.address());
    }

    public int height() {
        return GLFWImage.nheight(this.address());
    }

    @NativeType(value="unsigned char *")
    public ByteBuffer pixels(int capacity) {
        return GLFWImage.npixels(this.address(), capacity);
    }

    public GLFWImage width(int value) {
        GLFWImage.nwidth(this.address(), value);
        return this;
    }

    public GLFWImage height(int value) {
        GLFWImage.nheight(this.address(), value);
        return this;
    }

    public GLFWImage pixels(@NativeType(value="unsigned char *") ByteBuffer value) {
        GLFWImage.npixels(this.address(), value);
        return this;
    }

    public GLFWImage set(int width, int height, ByteBuffer pixels) {
        this.width(width);
        this.height(height);
        this.pixels(pixels);
        return this;
    }

    public GLFWImage set(GLFWImage src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static GLFWImage malloc() {
        return (GLFWImage)GLFWImage.wrap(GLFWImage.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static GLFWImage calloc() {
        return (GLFWImage)GLFWImage.wrap(GLFWImage.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static GLFWImage create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (GLFWImage)GLFWImage.wrap(GLFWImage.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static GLFWImage create(long address) {
        return (GLFWImage)GLFWImage.wrap(GLFWImage.class, (long)address);
    }

    @Nullable
    public static GLFWImage createSafe(long address) {
        return address == 0L ? null : (GLFWImage)GLFWImage.wrap(GLFWImage.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)GLFWImage.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)GLFWImage.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)GLFWImage.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = GLFWImage.__create((int)capacity, (int)SIZEOF);
        return (Buffer)GLFWImage.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)GLFWImage.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)GLFWImage.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static GLFWImage mallocStack() {
        return GLFWImage.mallocStack(MemoryStack.stackGet());
    }

    public static GLFWImage callocStack() {
        return GLFWImage.callocStack(MemoryStack.stackGet());
    }

    public static GLFWImage mallocStack(MemoryStack stack) {
        return (GLFWImage)GLFWImage.wrap(GLFWImage.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static GLFWImage callocStack(MemoryStack stack) {
        return (GLFWImage)GLFWImage.wrap(GLFWImage.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return GLFWImage.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return GLFWImage.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)GLFWImage.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)GLFWImage.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int nwidth(long struct) {
        return UNSAFE.getInt(null, struct + (long)WIDTH);
    }

    public static int nheight(long struct) {
        return UNSAFE.getInt(null, struct + (long)HEIGHT);
    }

    public static ByteBuffer npixels(long struct, int capacity) {
        return MemoryUtil.memByteBuffer((long)MemoryUtil.memGetAddress((long)(struct + (long)PIXELS)), (int)capacity);
    }

    public static void nwidth(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)WIDTH, value);
    }

    public static void nheight(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)HEIGHT, value);
    }

    public static void npixels(long struct, ByteBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PIXELS), (long)MemoryUtil.memAddress((ByteBuffer)value));
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)PIXELS)));
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            GLFWImage.validate(array + Integer.toUnsignedLong(i) * (long)SIZEOF);
        }
    }

    static {
        Struct.Layout layout = GLFWImage.__struct((Struct.Member[])new Struct.Member[]{GLFWImage.__member((int)4), GLFWImage.__member((int)4), GLFWImage.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        WIDTH = layout.offsetof(0);
        HEIGHT = layout.offsetof(1);
        PIXELS = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<GLFWImage, Buffer>
    implements NativeResource {
        private static final GLFWImage ELEMENT_FACTORY = GLFWImage.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected GLFWImage getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public int width() {
            return GLFWImage.nwidth(this.address());
        }

        public int height() {
            return GLFWImage.nheight(this.address());
        }

        @NativeType(value="unsigned char *")
        public ByteBuffer pixels(int capacity) {
            return GLFWImage.npixels(this.address(), capacity);
        }

        public Buffer width(int value) {
            GLFWImage.nwidth(this.address(), value);
            return this;
        }

        public Buffer height(int value) {
            GLFWImage.nheight(this.address(), value);
            return this;
        }

        public Buffer pixels(@NativeType(value="unsigned char *") ByteBuffer value) {
            GLFWImage.npixels(this.address(), value);
            return this;
        }
    }
}

