/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.hwloc;

import java.nio.ByteBuffer;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.util.hwloc.HWLoc;

public class HWLocLinux {
    protected HWLocLinux() {
        throw new UnsupportedOperationException();
    }

    public static int hwloc_linux_set_tid_cpubind(@NativeType(value="hwloc_topology_t") long topology, @NativeType(value="pid_t") int tid, @NativeType(value="hwloc_const_cpuset_t") long set) {
        long __functionAddress = Functions.linux_set_tid_cpubind;
        if (Checks.CHECKS) {
            Checks.check((long)topology);
            Checks.check((long)set);
        }
        return JNI.invokePPI((long)topology, (int)tid, (long)set, (long)__functionAddress);
    }

    public static int hwloc_linux_get_tid_cpubind(@NativeType(value="hwloc_topology_t") long topology, @NativeType(value="pid_t") int tid, @NativeType(value="hwloc_cpuset_t") long set) {
        long __functionAddress = Functions.linux_get_tid_cpubind;
        if (Checks.CHECKS) {
            Checks.check((long)topology);
            Checks.check((long)set);
        }
        return JNI.invokePPI((long)topology, (int)tid, (long)set, (long)__functionAddress);
    }

    public static int hwloc_linux_get_tid_last_cpu_location(@NativeType(value="hwloc_topology_t") long topology, @NativeType(value="pid_t") int tid, @NativeType(value="hwloc_bitmap_t") long set) {
        long __functionAddress = Functions.linux_get_tid_last_cpu_location;
        if (Checks.CHECKS) {
            Checks.check((long)topology);
            Checks.check((long)set);
        }
        return JNI.invokePPI((long)topology, (int)tid, (long)set, (long)__functionAddress);
    }

    public static int nhwloc_linux_read_path_as_cpumask(long path, long set) {
        long __functionAddress = Functions.linux_read_path_as_cpumask;
        if (Checks.CHECKS) {
            Checks.check((long)set);
        }
        return JNI.invokePPI((long)path, (long)set, (long)__functionAddress);
    }

    public static int hwloc_linux_read_path_as_cpumask(@NativeType(value="char const *") ByteBuffer path, @NativeType(value="hwloc_bitmap_t") long set) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)path);
        }
        return HWLocLinux.nhwloc_linux_read_path_as_cpumask(MemoryUtil.memAddress((ByteBuffer)path), set);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int hwloc_linux_read_path_as_cpumask(@NativeType(value="char const *") CharSequence path, @NativeType(value="hwloc_bitmap_t") long set) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nASCII(path, true);
            long pathEncoded = stack.getPointerAddress();
            int n = HWLocLinux.nhwloc_linux_read_path_as_cpumask(pathEncoded, set);
            return n;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static final class Functions {
        public static final long linux_set_tid_cpubind = APIUtil.apiGetFunctionAddress((FunctionProvider)HWLoc.getLibrary(), (String)"hwloc_linux_set_tid_cpubind");
        public static final long linux_get_tid_cpubind = APIUtil.apiGetFunctionAddress((FunctionProvider)HWLoc.getLibrary(), (String)"hwloc_linux_get_tid_cpubind");
        public static final long linux_get_tid_last_cpu_location = APIUtil.apiGetFunctionAddress((FunctionProvider)HWLoc.getLibrary(), (String)"hwloc_linux_get_tid_last_cpu_location");
        public static final long linux_read_path_as_cpumask = APIUtil.apiGetFunctionAddress((FunctionProvider)HWLoc.getLibrary(), (String)"hwloc_linux_read_path_as_cpumask");

        private Functions() {
        }
    }
}

