/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.ktx;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class ktxBasisParams
extends Struct<ktxBasisParams>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int STRUCTSIZE;
    public static final int UASTC;
    public static final int VERBOSE;
    public static final int NOSSE;
    public static final int THREADCOUNT;
    public static final int COMPRESSIONLEVEL;
    public static final int QUALITYLEVEL;
    public static final int MAXENDPOINTS;
    public static final int ENDPOINTRDOTHRESHOLD;
    public static final int MAXSELECTORS;
    public static final int SELECTORRDOTHRESHOLD;
    public static final int INPUTSWIZZLE;
    public static final int NORMALMAP;
    public static final int SEPARATERGTORGB_A;
    public static final int PRESWIZZLE;
    public static final int NOENDPOINTRDO;
    public static final int NOSELECTORRDO;
    public static final int UASTCFLAGS;
    public static final int UASTCRDO;
    public static final int UASTCRDOQUALITYSCALAR;
    public static final int UASTCRDODICTSIZE;
    public static final int UASTCRDOMAXSMOOTHBLOCKERRORSCALE;
    public static final int UASTCRDOMAXSMOOTHBLOCKSTDDEV;
    public static final int UASTCRDODONTFAVORSIMPLERMODES;
    public static final int UASTCRDONOMULTITHREADING;

    protected ktxBasisParams(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected ktxBasisParams create(long address, @Nullable ByteBuffer container) {
        return new ktxBasisParams(address, container);
    }

    public ktxBasisParams(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), ktxBasisParams.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="ktx_uint32_t")
    public int structSize() {
        return ktxBasisParams.nstructSize(this.address());
    }

    @NativeType(value="ktx_bool_t")
    public boolean uastc() {
        return ktxBasisParams.nuastc(this.address());
    }

    @NativeType(value="ktx_bool_t")
    public boolean verbose() {
        return ktxBasisParams.nverbose(this.address());
    }

    @NativeType(value="ktx_bool_t")
    public boolean noSSE() {
        return ktxBasisParams.nnoSSE(this.address());
    }

    @NativeType(value="ktx_uint32_t")
    public int threadCount() {
        return ktxBasisParams.nthreadCount(this.address());
    }

    @NativeType(value="ktx_uint32_t")
    public int compressionLevel() {
        return ktxBasisParams.ncompressionLevel(this.address());
    }

    @NativeType(value="ktx_uint32_t")
    public int qualityLevel() {
        return ktxBasisParams.nqualityLevel(this.address());
    }

    @NativeType(value="ktx_uint32_t")
    public int maxEndpoints() {
        return ktxBasisParams.nmaxEndpoints(this.address());
    }

    public float endpointRDOThreshold() {
        return ktxBasisParams.nendpointRDOThreshold(this.address());
    }

    @NativeType(value="ktx_uint32_t")
    public int maxSelectors() {
        return ktxBasisParams.nmaxSelectors(this.address());
    }

    public float selectorRDOThreshold() {
        return ktxBasisParams.nselectorRDOThreshold(this.address());
    }

    @NativeType(value="char[4]")
    public ByteBuffer inputSwizzle() {
        return ktxBasisParams.ninputSwizzle(this.address());
    }

    @NativeType(value="char")
    public byte inputSwizzle(int index) {
        return ktxBasisParams.ninputSwizzle(this.address(), index);
    }

    @NativeType(value="ktx_bool_t")
    public boolean normalMap() {
        return ktxBasisParams.nnormalMap(this.address());
    }

    @NativeType(value="ktx_bool_t")
    public boolean separateRGToRGB_A() {
        return ktxBasisParams.nseparateRGToRGB_A(this.address());
    }

    @NativeType(value="ktx_bool_t")
    public boolean preSwizzle() {
        return ktxBasisParams.npreSwizzle(this.address());
    }

    @NativeType(value="ktx_bool_t")
    public boolean noEndpointRDO() {
        return ktxBasisParams.nnoEndpointRDO(this.address());
    }

    @NativeType(value="ktx_bool_t")
    public boolean noSelectorRDO() {
        return ktxBasisParams.nnoSelectorRDO(this.address());
    }

    @NativeType(value="ktx_pack_uastc_flags")
    public int uastcFlags() {
        return ktxBasisParams.nuastcFlags(this.address());
    }

    @NativeType(value="ktx_bool_t")
    public boolean uastcRDO() {
        return ktxBasisParams.nuastcRDO(this.address());
    }

    public float uastcRDOQualityScalar() {
        return ktxBasisParams.nuastcRDOQualityScalar(this.address());
    }

    @NativeType(value="ktx_uint32_t")
    public int uastcRDODictSize() {
        return ktxBasisParams.nuastcRDODictSize(this.address());
    }

    public float uastcRDOMaxSmoothBlockErrorScale() {
        return ktxBasisParams.nuastcRDOMaxSmoothBlockErrorScale(this.address());
    }

    public float uastcRDOMaxSmoothBlockStdDev() {
        return ktxBasisParams.nuastcRDOMaxSmoothBlockStdDev(this.address());
    }

    @NativeType(value="ktx_bool_t")
    public boolean uastcRDODontFavorSimplerModes() {
        return ktxBasisParams.nuastcRDODontFavorSimplerModes(this.address());
    }

    @NativeType(value="ktx_bool_t")
    public boolean uastcRDONoMultithreading() {
        return ktxBasisParams.nuastcRDONoMultithreading(this.address());
    }

    public ktxBasisParams structSize(@NativeType(value="ktx_uint32_t") int value) {
        ktxBasisParams.nstructSize(this.address(), value);
        return this;
    }

    public ktxBasisParams uastc(@NativeType(value="ktx_bool_t") boolean value) {
        ktxBasisParams.nuastc(this.address(), value);
        return this;
    }

    public ktxBasisParams verbose(@NativeType(value="ktx_bool_t") boolean value) {
        ktxBasisParams.nverbose(this.address(), value);
        return this;
    }

    public ktxBasisParams noSSE(@NativeType(value="ktx_bool_t") boolean value) {
        ktxBasisParams.nnoSSE(this.address(), value);
        return this;
    }

    public ktxBasisParams threadCount(@NativeType(value="ktx_uint32_t") int value) {
        ktxBasisParams.nthreadCount(this.address(), value);
        return this;
    }

    public ktxBasisParams compressionLevel(@NativeType(value="ktx_uint32_t") int value) {
        ktxBasisParams.ncompressionLevel(this.address(), value);
        return this;
    }

    public ktxBasisParams qualityLevel(@NativeType(value="ktx_uint32_t") int value) {
        ktxBasisParams.nqualityLevel(this.address(), value);
        return this;
    }

    public ktxBasisParams maxEndpoints(@NativeType(value="ktx_uint32_t") int value) {
        ktxBasisParams.nmaxEndpoints(this.address(), value);
        return this;
    }

    public ktxBasisParams endpointRDOThreshold(float value) {
        ktxBasisParams.nendpointRDOThreshold(this.address(), value);
        return this;
    }

    public ktxBasisParams maxSelectors(@NativeType(value="ktx_uint32_t") int value) {
        ktxBasisParams.nmaxSelectors(this.address(), value);
        return this;
    }

    public ktxBasisParams selectorRDOThreshold(float value) {
        ktxBasisParams.nselectorRDOThreshold(this.address(), value);
        return this;
    }

    public ktxBasisParams inputSwizzle(@NativeType(value="char[4]") ByteBuffer value) {
        ktxBasisParams.ninputSwizzle(this.address(), value);
        return this;
    }

    public ktxBasisParams inputSwizzle(int index, @NativeType(value="char") byte value) {
        ktxBasisParams.ninputSwizzle(this.address(), index, value);
        return this;
    }

    public ktxBasisParams normalMap(@NativeType(value="ktx_bool_t") boolean value) {
        ktxBasisParams.nnormalMap(this.address(), value);
        return this;
    }

    public ktxBasisParams separateRGToRGB_A(@NativeType(value="ktx_bool_t") boolean value) {
        ktxBasisParams.nseparateRGToRGB_A(this.address(), value);
        return this;
    }

    public ktxBasisParams preSwizzle(@NativeType(value="ktx_bool_t") boolean value) {
        ktxBasisParams.npreSwizzle(this.address(), value);
        return this;
    }

    public ktxBasisParams noEndpointRDO(@NativeType(value="ktx_bool_t") boolean value) {
        ktxBasisParams.nnoEndpointRDO(this.address(), value);
        return this;
    }

    public ktxBasisParams noSelectorRDO(@NativeType(value="ktx_bool_t") boolean value) {
        ktxBasisParams.nnoSelectorRDO(this.address(), value);
        return this;
    }

    public ktxBasisParams uastcFlags(@NativeType(value="ktx_pack_uastc_flags") int value) {
        ktxBasisParams.nuastcFlags(this.address(), value);
        return this;
    }

    public ktxBasisParams uastcRDO(@NativeType(value="ktx_bool_t") boolean value) {
        ktxBasisParams.nuastcRDO(this.address(), value);
        return this;
    }

    public ktxBasisParams uastcRDOQualityScalar(float value) {
        ktxBasisParams.nuastcRDOQualityScalar(this.address(), value);
        return this;
    }

    public ktxBasisParams uastcRDODictSize(@NativeType(value="ktx_uint32_t") int value) {
        ktxBasisParams.nuastcRDODictSize(this.address(), value);
        return this;
    }

    public ktxBasisParams uastcRDOMaxSmoothBlockErrorScale(float value) {
        ktxBasisParams.nuastcRDOMaxSmoothBlockErrorScale(this.address(), value);
        return this;
    }

    public ktxBasisParams uastcRDOMaxSmoothBlockStdDev(float value) {
        ktxBasisParams.nuastcRDOMaxSmoothBlockStdDev(this.address(), value);
        return this;
    }

    public ktxBasisParams uastcRDODontFavorSimplerModes(@NativeType(value="ktx_bool_t") boolean value) {
        ktxBasisParams.nuastcRDODontFavorSimplerModes(this.address(), value);
        return this;
    }

    public ktxBasisParams uastcRDONoMultithreading(@NativeType(value="ktx_bool_t") boolean value) {
        ktxBasisParams.nuastcRDONoMultithreading(this.address(), value);
        return this;
    }

    public ktxBasisParams set(int structSize, boolean uastc, boolean verbose, boolean noSSE, int threadCount, int compressionLevel, int qualityLevel, int maxEndpoints, float endpointRDOThreshold, int maxSelectors, float selectorRDOThreshold, ByteBuffer inputSwizzle, boolean normalMap, boolean separateRGToRGB_A, boolean preSwizzle, boolean noEndpointRDO, boolean noSelectorRDO, int uastcFlags, boolean uastcRDO, float uastcRDOQualityScalar, int uastcRDODictSize, float uastcRDOMaxSmoothBlockErrorScale, float uastcRDOMaxSmoothBlockStdDev, boolean uastcRDODontFavorSimplerModes, boolean uastcRDONoMultithreading) {
        this.structSize(structSize);
        this.uastc(uastc);
        this.verbose(verbose);
        this.noSSE(noSSE);
        this.threadCount(threadCount);
        this.compressionLevel(compressionLevel);
        this.qualityLevel(qualityLevel);
        this.maxEndpoints(maxEndpoints);
        this.endpointRDOThreshold(endpointRDOThreshold);
        this.maxSelectors(maxSelectors);
        this.selectorRDOThreshold(selectorRDOThreshold);
        this.inputSwizzle(inputSwizzle);
        this.normalMap(normalMap);
        this.separateRGToRGB_A(separateRGToRGB_A);
        this.preSwizzle(preSwizzle);
        this.noEndpointRDO(noEndpointRDO);
        this.noSelectorRDO(noSelectorRDO);
        this.uastcFlags(uastcFlags);
        this.uastcRDO(uastcRDO);
        this.uastcRDOQualityScalar(uastcRDOQualityScalar);
        this.uastcRDODictSize(uastcRDODictSize);
        this.uastcRDOMaxSmoothBlockErrorScale(uastcRDOMaxSmoothBlockErrorScale);
        this.uastcRDOMaxSmoothBlockStdDev(uastcRDOMaxSmoothBlockStdDev);
        this.uastcRDODontFavorSimplerModes(uastcRDODontFavorSimplerModes);
        this.uastcRDONoMultithreading(uastcRDONoMultithreading);
        return this;
    }

    public ktxBasisParams set(ktxBasisParams src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static ktxBasisParams malloc() {
        return new ktxBasisParams(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static ktxBasisParams calloc() {
        return new ktxBasisParams(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static ktxBasisParams create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new ktxBasisParams(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static ktxBasisParams create(long address) {
        return new ktxBasisParams(address, null);
    }

    public static @Nullable ktxBasisParams createSafe(long address) {
        return address == 0L ? null : new ktxBasisParams(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)ktxBasisParams.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = ktxBasisParams.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static ktxBasisParams malloc(MemoryStack stack) {
        return new ktxBasisParams(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static ktxBasisParams calloc(MemoryStack stack) {
        return new ktxBasisParams(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nstructSize(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)STRUCTSIZE));
    }

    public static boolean nuastc(long struct) {
        return MemoryUtil.memGetByte((long)(struct + (long)UASTC)) != 0;
    }

    public static boolean nverbose(long struct) {
        return MemoryUtil.memGetByte((long)(struct + (long)VERBOSE)) != 0;
    }

    public static boolean nnoSSE(long struct) {
        return MemoryUtil.memGetByte((long)(struct + (long)NOSSE)) != 0;
    }

    public static int nthreadCount(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)THREADCOUNT));
    }

    public static int ncompressionLevel(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)COMPRESSIONLEVEL));
    }

    public static int nqualityLevel(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)QUALITYLEVEL));
    }

    public static int nmaxEndpoints(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)MAXENDPOINTS));
    }

    public static float nendpointRDOThreshold(long struct) {
        return MemoryUtil.memGetFloat((long)(struct + (long)ENDPOINTRDOTHRESHOLD));
    }

    public static int nmaxSelectors(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)MAXSELECTORS));
    }

    public static float nselectorRDOThreshold(long struct) {
        return MemoryUtil.memGetFloat((long)(struct + (long)SELECTORRDOTHRESHOLD));
    }

    public static ByteBuffer ninputSwizzle(long struct) {
        return MemoryUtil.memByteBuffer((long)(struct + (long)INPUTSWIZZLE), (int)4);
    }

    public static byte ninputSwizzle(long struct, int index) {
        return MemoryUtil.memGetByte((long)(struct + (long)INPUTSWIZZLE + Checks.check((int)index, (int)4) * 1L));
    }

    public static boolean nnormalMap(long struct) {
        return MemoryUtil.memGetByte((long)(struct + (long)NORMALMAP)) != 0;
    }

    public static boolean nseparateRGToRGB_A(long struct) {
        return MemoryUtil.memGetByte((long)(struct + (long)SEPARATERGTORGB_A)) != 0;
    }

    public static boolean npreSwizzle(long struct) {
        return MemoryUtil.memGetByte((long)(struct + (long)PRESWIZZLE)) != 0;
    }

    public static boolean nnoEndpointRDO(long struct) {
        return MemoryUtil.memGetByte((long)(struct + (long)NOENDPOINTRDO)) != 0;
    }

    public static boolean nnoSelectorRDO(long struct) {
        return MemoryUtil.memGetByte((long)(struct + (long)NOSELECTORRDO)) != 0;
    }

    public static int nuastcFlags(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)UASTCFLAGS));
    }

    public static boolean nuastcRDO(long struct) {
        return MemoryUtil.memGetByte((long)(struct + (long)UASTCRDO)) != 0;
    }

    public static float nuastcRDOQualityScalar(long struct) {
        return MemoryUtil.memGetFloat((long)(struct + (long)UASTCRDOQUALITYSCALAR));
    }

    public static int nuastcRDODictSize(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)UASTCRDODICTSIZE));
    }

    public static float nuastcRDOMaxSmoothBlockErrorScale(long struct) {
        return MemoryUtil.memGetFloat((long)(struct + (long)UASTCRDOMAXSMOOTHBLOCKERRORSCALE));
    }

    public static float nuastcRDOMaxSmoothBlockStdDev(long struct) {
        return MemoryUtil.memGetFloat((long)(struct + (long)UASTCRDOMAXSMOOTHBLOCKSTDDEV));
    }

    public static boolean nuastcRDODontFavorSimplerModes(long struct) {
        return MemoryUtil.memGetByte((long)(struct + (long)UASTCRDODONTFAVORSIMPLERMODES)) != 0;
    }

    public static boolean nuastcRDONoMultithreading(long struct) {
        return MemoryUtil.memGetByte((long)(struct + (long)UASTCRDONOMULTITHREADING)) != 0;
    }

    public static void nstructSize(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)STRUCTSIZE), (int)value);
    }

    public static void nuastc(long struct, boolean value) {
        MemoryUtil.memPutByte((long)(struct + (long)UASTC), (byte)(value ? (byte)1 : 0));
    }

    public static void nverbose(long struct, boolean value) {
        MemoryUtil.memPutByte((long)(struct + (long)VERBOSE), (byte)(value ? (byte)1 : 0));
    }

    public static void nnoSSE(long struct, boolean value) {
        MemoryUtil.memPutByte((long)(struct + (long)NOSSE), (byte)(value ? (byte)1 : 0));
    }

    public static void nthreadCount(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)THREADCOUNT), (int)value);
    }

    public static void ncompressionLevel(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)COMPRESSIONLEVEL), (int)value);
    }

    public static void nqualityLevel(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)QUALITYLEVEL), (int)value);
    }

    public static void nmaxEndpoints(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)MAXENDPOINTS), (int)value);
    }

    public static void nendpointRDOThreshold(long struct, float value) {
        MemoryUtil.memPutFloat((long)(struct + (long)ENDPOINTRDOTHRESHOLD), (float)value);
    }

    public static void nmaxSelectors(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)MAXSELECTORS), (int)value);
    }

    public static void nselectorRDOThreshold(long struct, float value) {
        MemoryUtil.memPutFloat((long)(struct + (long)SELECTORRDOTHRESHOLD), (float)value);
    }

    public static void ninputSwizzle(long struct, ByteBuffer value) {
        if (Checks.CHECKS) {
            Checks.checkGT((java.nio.Buffer)value, (int)4);
        }
        MemoryUtil.memCopy((long)MemoryUtil.memAddress((ByteBuffer)value), (long)(struct + (long)INPUTSWIZZLE), (long)(value.remaining() * 1));
    }

    public static void ninputSwizzle(long struct, int index, byte value) {
        MemoryUtil.memPutByte((long)(struct + (long)INPUTSWIZZLE + Checks.check((int)index, (int)4) * 1L), (byte)value);
    }

    public static void nnormalMap(long struct, boolean value) {
        MemoryUtil.memPutByte((long)(struct + (long)NORMALMAP), (byte)(value ? (byte)1 : 0));
    }

    public static void nseparateRGToRGB_A(long struct, boolean value) {
        MemoryUtil.memPutByte((long)(struct + (long)SEPARATERGTORGB_A), (byte)(value ? (byte)1 : 0));
    }

    public static void npreSwizzle(long struct, boolean value) {
        MemoryUtil.memPutByte((long)(struct + (long)PRESWIZZLE), (byte)(value ? (byte)1 : 0));
    }

    public static void nnoEndpointRDO(long struct, boolean value) {
        MemoryUtil.memPutByte((long)(struct + (long)NOENDPOINTRDO), (byte)(value ? (byte)1 : 0));
    }

    public static void nnoSelectorRDO(long struct, boolean value) {
        MemoryUtil.memPutByte((long)(struct + (long)NOSELECTORRDO), (byte)(value ? (byte)1 : 0));
    }

    public static void nuastcFlags(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)UASTCFLAGS), (int)value);
    }

    public static void nuastcRDO(long struct, boolean value) {
        MemoryUtil.memPutByte((long)(struct + (long)UASTCRDO), (byte)(value ? (byte)1 : 0));
    }

    public static void nuastcRDOQualityScalar(long struct, float value) {
        MemoryUtil.memPutFloat((long)(struct + (long)UASTCRDOQUALITYSCALAR), (float)value);
    }

    public static void nuastcRDODictSize(long struct, int value) {
        MemoryUtil.memPutInt((long)(struct + (long)UASTCRDODICTSIZE), (int)value);
    }

    public static void nuastcRDOMaxSmoothBlockErrorScale(long struct, float value) {
        MemoryUtil.memPutFloat((long)(struct + (long)UASTCRDOMAXSMOOTHBLOCKERRORSCALE), (float)value);
    }

    public static void nuastcRDOMaxSmoothBlockStdDev(long struct, float value) {
        MemoryUtil.memPutFloat((long)(struct + (long)UASTCRDOMAXSMOOTHBLOCKSTDDEV), (float)value);
    }

    public static void nuastcRDODontFavorSimplerModes(long struct, boolean value) {
        MemoryUtil.memPutByte((long)(struct + (long)UASTCRDODONTFAVORSIMPLERMODES), (byte)(value ? (byte)1 : 0));
    }

    public static void nuastcRDONoMultithreading(long struct, boolean value) {
        MemoryUtil.memPutByte((long)(struct + (long)UASTCRDONOMULTITHREADING), (byte)(value ? (byte)1 : 0));
    }

    static {
        Struct.Layout layout = ktxBasisParams.__struct((Struct.Member[])new Struct.Member[]{ktxBasisParams.__member((int)4), ktxBasisParams.__member((int)1), ktxBasisParams.__member((int)1), ktxBasisParams.__member((int)1), ktxBasisParams.__member((int)4), ktxBasisParams.__member((int)4), ktxBasisParams.__member((int)4), ktxBasisParams.__member((int)4), ktxBasisParams.__member((int)4), ktxBasisParams.__member((int)4), ktxBasisParams.__member((int)4), ktxBasisParams.__array((int)1, (int)4), ktxBasisParams.__member((int)1), ktxBasisParams.__member((int)1), ktxBasisParams.__member((int)1), ktxBasisParams.__member((int)1), ktxBasisParams.__member((int)1), ktxBasisParams.__member((int)4), ktxBasisParams.__member((int)1), ktxBasisParams.__member((int)4), ktxBasisParams.__member((int)4), ktxBasisParams.__member((int)4), ktxBasisParams.__member((int)4), ktxBasisParams.__member((int)1), ktxBasisParams.__member((int)1)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        STRUCTSIZE = layout.offsetof(0);
        UASTC = layout.offsetof(1);
        VERBOSE = layout.offsetof(2);
        NOSSE = layout.offsetof(3);
        THREADCOUNT = layout.offsetof(4);
        COMPRESSIONLEVEL = layout.offsetof(5);
        QUALITYLEVEL = layout.offsetof(6);
        MAXENDPOINTS = layout.offsetof(7);
        ENDPOINTRDOTHRESHOLD = layout.offsetof(8);
        MAXSELECTORS = layout.offsetof(9);
        SELECTORRDOTHRESHOLD = layout.offsetof(10);
        INPUTSWIZZLE = layout.offsetof(11);
        NORMALMAP = layout.offsetof(12);
        SEPARATERGTORGB_A = layout.offsetof(13);
        PRESWIZZLE = layout.offsetof(14);
        NOENDPOINTRDO = layout.offsetof(15);
        NOSELECTORRDO = layout.offsetof(16);
        UASTCFLAGS = layout.offsetof(17);
        UASTCRDO = layout.offsetof(18);
        UASTCRDOQUALITYSCALAR = layout.offsetof(19);
        UASTCRDODICTSIZE = layout.offsetof(20);
        UASTCRDOMAXSMOOTHBLOCKERRORSCALE = layout.offsetof(21);
        UASTCRDOMAXSMOOTHBLOCKSTDDEV = layout.offsetof(22);
        UASTCRDODONTFAVORSIMPLERMODES = layout.offsetof(23);
        UASTCRDONOMULTITHREADING = layout.offsetof(24);
    }

    public static class Buffer
    extends StructBuffer<ktxBasisParams, Buffer>
    implements NativeResource {
        private static final ktxBasisParams ELEMENT_FACTORY = ktxBasisParams.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected ktxBasisParams getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="ktx_uint32_t")
        public int structSize() {
            return ktxBasisParams.nstructSize(this.address());
        }

        @NativeType(value="ktx_bool_t")
        public boolean uastc() {
            return ktxBasisParams.nuastc(this.address());
        }

        @NativeType(value="ktx_bool_t")
        public boolean verbose() {
            return ktxBasisParams.nverbose(this.address());
        }

        @NativeType(value="ktx_bool_t")
        public boolean noSSE() {
            return ktxBasisParams.nnoSSE(this.address());
        }

        @NativeType(value="ktx_uint32_t")
        public int threadCount() {
            return ktxBasisParams.nthreadCount(this.address());
        }

        @NativeType(value="ktx_uint32_t")
        public int compressionLevel() {
            return ktxBasisParams.ncompressionLevel(this.address());
        }

        @NativeType(value="ktx_uint32_t")
        public int qualityLevel() {
            return ktxBasisParams.nqualityLevel(this.address());
        }

        @NativeType(value="ktx_uint32_t")
        public int maxEndpoints() {
            return ktxBasisParams.nmaxEndpoints(this.address());
        }

        public float endpointRDOThreshold() {
            return ktxBasisParams.nendpointRDOThreshold(this.address());
        }

        @NativeType(value="ktx_uint32_t")
        public int maxSelectors() {
            return ktxBasisParams.nmaxSelectors(this.address());
        }

        public float selectorRDOThreshold() {
            return ktxBasisParams.nselectorRDOThreshold(this.address());
        }

        @NativeType(value="char[4]")
        public ByteBuffer inputSwizzle() {
            return ktxBasisParams.ninputSwizzle(this.address());
        }

        @NativeType(value="char")
        public byte inputSwizzle(int index) {
            return ktxBasisParams.ninputSwizzle(this.address(), index);
        }

        @NativeType(value="ktx_bool_t")
        public boolean normalMap() {
            return ktxBasisParams.nnormalMap(this.address());
        }

        @NativeType(value="ktx_bool_t")
        public boolean separateRGToRGB_A() {
            return ktxBasisParams.nseparateRGToRGB_A(this.address());
        }

        @NativeType(value="ktx_bool_t")
        public boolean preSwizzle() {
            return ktxBasisParams.npreSwizzle(this.address());
        }

        @NativeType(value="ktx_bool_t")
        public boolean noEndpointRDO() {
            return ktxBasisParams.nnoEndpointRDO(this.address());
        }

        @NativeType(value="ktx_bool_t")
        public boolean noSelectorRDO() {
            return ktxBasisParams.nnoSelectorRDO(this.address());
        }

        @NativeType(value="ktx_pack_uastc_flags")
        public int uastcFlags() {
            return ktxBasisParams.nuastcFlags(this.address());
        }

        @NativeType(value="ktx_bool_t")
        public boolean uastcRDO() {
            return ktxBasisParams.nuastcRDO(this.address());
        }

        public float uastcRDOQualityScalar() {
            return ktxBasisParams.nuastcRDOQualityScalar(this.address());
        }

        @NativeType(value="ktx_uint32_t")
        public int uastcRDODictSize() {
            return ktxBasisParams.nuastcRDODictSize(this.address());
        }

        public float uastcRDOMaxSmoothBlockErrorScale() {
            return ktxBasisParams.nuastcRDOMaxSmoothBlockErrorScale(this.address());
        }

        public float uastcRDOMaxSmoothBlockStdDev() {
            return ktxBasisParams.nuastcRDOMaxSmoothBlockStdDev(this.address());
        }

        @NativeType(value="ktx_bool_t")
        public boolean uastcRDODontFavorSimplerModes() {
            return ktxBasisParams.nuastcRDODontFavorSimplerModes(this.address());
        }

        @NativeType(value="ktx_bool_t")
        public boolean uastcRDONoMultithreading() {
            return ktxBasisParams.nuastcRDONoMultithreading(this.address());
        }

        public Buffer structSize(@NativeType(value="ktx_uint32_t") int value) {
            ktxBasisParams.nstructSize(this.address(), value);
            return this;
        }

        public Buffer uastc(@NativeType(value="ktx_bool_t") boolean value) {
            ktxBasisParams.nuastc(this.address(), value);
            return this;
        }

        public Buffer verbose(@NativeType(value="ktx_bool_t") boolean value) {
            ktxBasisParams.nverbose(this.address(), value);
            return this;
        }

        public Buffer noSSE(@NativeType(value="ktx_bool_t") boolean value) {
            ktxBasisParams.nnoSSE(this.address(), value);
            return this;
        }

        public Buffer threadCount(@NativeType(value="ktx_uint32_t") int value) {
            ktxBasisParams.nthreadCount(this.address(), value);
            return this;
        }

        public Buffer compressionLevel(@NativeType(value="ktx_uint32_t") int value) {
            ktxBasisParams.ncompressionLevel(this.address(), value);
            return this;
        }

        public Buffer qualityLevel(@NativeType(value="ktx_uint32_t") int value) {
            ktxBasisParams.nqualityLevel(this.address(), value);
            return this;
        }

        public Buffer maxEndpoints(@NativeType(value="ktx_uint32_t") int value) {
            ktxBasisParams.nmaxEndpoints(this.address(), value);
            return this;
        }

        public Buffer endpointRDOThreshold(float value) {
            ktxBasisParams.nendpointRDOThreshold(this.address(), value);
            return this;
        }

        public Buffer maxSelectors(@NativeType(value="ktx_uint32_t") int value) {
            ktxBasisParams.nmaxSelectors(this.address(), value);
            return this;
        }

        public Buffer selectorRDOThreshold(float value) {
            ktxBasisParams.nselectorRDOThreshold(this.address(), value);
            return this;
        }

        public Buffer inputSwizzle(@NativeType(value="char[4]") ByteBuffer value) {
            ktxBasisParams.ninputSwizzle(this.address(), value);
            return this;
        }

        public Buffer inputSwizzle(int index, @NativeType(value="char") byte value) {
            ktxBasisParams.ninputSwizzle(this.address(), index, value);
            return this;
        }

        public Buffer normalMap(@NativeType(value="ktx_bool_t") boolean value) {
            ktxBasisParams.nnormalMap(this.address(), value);
            return this;
        }

        public Buffer separateRGToRGB_A(@NativeType(value="ktx_bool_t") boolean value) {
            ktxBasisParams.nseparateRGToRGB_A(this.address(), value);
            return this;
        }

        public Buffer preSwizzle(@NativeType(value="ktx_bool_t") boolean value) {
            ktxBasisParams.npreSwizzle(this.address(), value);
            return this;
        }

        public Buffer noEndpointRDO(@NativeType(value="ktx_bool_t") boolean value) {
            ktxBasisParams.nnoEndpointRDO(this.address(), value);
            return this;
        }

        public Buffer noSelectorRDO(@NativeType(value="ktx_bool_t") boolean value) {
            ktxBasisParams.nnoSelectorRDO(this.address(), value);
            return this;
        }

        public Buffer uastcFlags(@NativeType(value="ktx_pack_uastc_flags") int value) {
            ktxBasisParams.nuastcFlags(this.address(), value);
            return this;
        }

        public Buffer uastcRDO(@NativeType(value="ktx_bool_t") boolean value) {
            ktxBasisParams.nuastcRDO(this.address(), value);
            return this;
        }

        public Buffer uastcRDOQualityScalar(float value) {
            ktxBasisParams.nuastcRDOQualityScalar(this.address(), value);
            return this;
        }

        public Buffer uastcRDODictSize(@NativeType(value="ktx_uint32_t") int value) {
            ktxBasisParams.nuastcRDODictSize(this.address(), value);
            return this;
        }

        public Buffer uastcRDOMaxSmoothBlockErrorScale(float value) {
            ktxBasisParams.nuastcRDOMaxSmoothBlockErrorScale(this.address(), value);
            return this;
        }

        public Buffer uastcRDOMaxSmoothBlockStdDev(float value) {
            ktxBasisParams.nuastcRDOMaxSmoothBlockStdDev(this.address(), value);
            return this;
        }

        public Buffer uastcRDODontFavorSimplerModes(@NativeType(value="ktx_bool_t") boolean value) {
            ktxBasisParams.nuastcRDODontFavorSimplerModes(this.address(), value);
            return this;
        }

        public Buffer uastcRDONoMultithreading(@NativeType(value="ktx_bool_t") boolean value) {
            ktxBasisParams.nuastcRDONoMultithreading(this.address(), value);
            return this;
        }
    }
}

