/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.libdivide;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct libdivide_s32_t")
public class LibDivideS32
extends Struct<LibDivideS32>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int MAGIC;
    public static final int MORE;

    protected LibDivideS32(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected LibDivideS32 create(long address, @Nullable ByteBuffer container) {
        return new LibDivideS32(address, container);
    }

    public LibDivideS32(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), LibDivideS32.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="int32_t")
    public int magic() {
        return LibDivideS32.nmagic(this.address());
    }

    @NativeType(value="uint8_t")
    public byte more() {
        return LibDivideS32.nmore(this.address());
    }

    public LibDivideS32 magic(@NativeType(value="int32_t") int value) {
        LibDivideS32.nmagic(this.address(), value);
        return this;
    }

    public LibDivideS32 more(@NativeType(value="uint8_t") byte value) {
        LibDivideS32.nmore(this.address(), value);
        return this;
    }

    public LibDivideS32 set(int magic, byte more) {
        this.magic(magic);
        this.more(more);
        return this;
    }

    public LibDivideS32 set(LibDivideS32 src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static LibDivideS32 malloc() {
        return new LibDivideS32(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static LibDivideS32 calloc() {
        return new LibDivideS32(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static LibDivideS32 create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new LibDivideS32(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static LibDivideS32 create(long address) {
        return new LibDivideS32(address, null);
    }

    @Nullable
    public static LibDivideS32 createSafe(long address) {
        return address == 0L ? null : new LibDivideS32(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)LibDivideS32.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = LibDivideS32.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static LibDivideS32 mallocStack() {
        return LibDivideS32.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static LibDivideS32 callocStack() {
        return LibDivideS32.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static LibDivideS32 mallocStack(MemoryStack stack) {
        return LibDivideS32.malloc(stack);
    }

    @Deprecated
    public static LibDivideS32 callocStack(MemoryStack stack) {
        return LibDivideS32.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return LibDivideS32.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return LibDivideS32.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return LibDivideS32.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return LibDivideS32.calloc(capacity, stack);
    }

    public static LibDivideS32 malloc(MemoryStack stack) {
        return new LibDivideS32(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static LibDivideS32 calloc(MemoryStack stack) {
        return new LibDivideS32(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nmagic(long struct) {
        return UNSAFE.getInt(null, struct + (long)MAGIC);
    }

    public static byte nmore(long struct) {
        return UNSAFE.getByte(null, struct + (long)MORE);
    }

    public static void nmagic(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)MAGIC, value);
    }

    public static void nmore(long struct, byte value) {
        UNSAFE.putByte(null, struct + (long)MORE, value);
    }

    static {
        Struct.Layout layout = LibDivideS32.__struct((Struct.Member[])new Struct.Member[]{LibDivideS32.__member((int)4), LibDivideS32.__member((int)1)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        MAGIC = layout.offsetof(0);
        MORE = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<LibDivideS32, Buffer>
    implements NativeResource {
        private static final LibDivideS32 ELEMENT_FACTORY = LibDivideS32.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected LibDivideS32 getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="int32_t")
        public int magic() {
            return LibDivideS32.nmagic(this.address());
        }

        @NativeType(value="uint8_t")
        public byte more() {
            return LibDivideS32.nmore(this.address());
        }

        public Buffer magic(@NativeType(value="int32_t") int value) {
            LibDivideS32.nmagic(this.address(), value);
            return this;
        }

        public Buffer more(@NativeType(value="uint8_t") byte value) {
            LibDivideS32.nmore(this.address(), value);
            return this;
        }
    }
}

