/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.llvm;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class CXCompletionResult
extends Struct<CXCompletionResult>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int CURSORKIND;
    public static final int COMPLETIONSTRING;

    protected CXCompletionResult(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected CXCompletionResult create(long address, @Nullable ByteBuffer container) {
        return new CXCompletionResult(address, container);
    }

    public CXCompletionResult(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), CXCompletionResult.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="enum CXCursorKind")
    public int CursorKind() {
        return CXCompletionResult.nCursorKind(this.address());
    }

    @NativeType(value="CXCompletionString")
    public long CompletionString() {
        return CXCompletionResult.nCompletionString(this.address());
    }

    public static CXCompletionResult malloc() {
        return new CXCompletionResult(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static CXCompletionResult calloc() {
        return new CXCompletionResult(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static CXCompletionResult create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new CXCompletionResult(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static CXCompletionResult create(long address) {
        return new CXCompletionResult(address, null);
    }

    @Nullable
    public static CXCompletionResult createSafe(long address) {
        return address == 0L ? null : new CXCompletionResult(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)CXCompletionResult.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = CXCompletionResult.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static CXCompletionResult mallocStack() {
        return CXCompletionResult.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static CXCompletionResult callocStack() {
        return CXCompletionResult.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static CXCompletionResult mallocStack(MemoryStack stack) {
        return CXCompletionResult.malloc(stack);
    }

    @Deprecated
    public static CXCompletionResult callocStack(MemoryStack stack) {
        return CXCompletionResult.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return CXCompletionResult.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return CXCompletionResult.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return CXCompletionResult.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return CXCompletionResult.calloc(capacity, stack);
    }

    public static CXCompletionResult malloc(MemoryStack stack) {
        return new CXCompletionResult(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static CXCompletionResult calloc(MemoryStack stack) {
        return new CXCompletionResult(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nCursorKind(long struct) {
        return UNSAFE.getInt(null, struct + (long)CURSORKIND);
    }

    public static long nCompletionString(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)COMPLETIONSTRING));
    }

    static {
        Struct.Layout layout = CXCompletionResult.__struct((Struct.Member[])new Struct.Member[]{CXCompletionResult.__member((int)4), CXCompletionResult.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        CURSORKIND = layout.offsetof(0);
        COMPLETIONSTRING = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<CXCompletionResult, Buffer>
    implements NativeResource {
        private static final CXCompletionResult ELEMENT_FACTORY = CXCompletionResult.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected CXCompletionResult getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="enum CXCursorKind")
        public int CursorKind() {
            return CXCompletionResult.nCursorKind(this.address());
        }

        @NativeType(value="CXCompletionString")
        public long CompletionString() {
            return CXCompletionResult.nCompletionString(this.address());
        }
    }
}

