/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.llvm;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.PointerBuffer;
import org.lwjgl.llvm.LLVMCore;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.SharedLibrary;

public class LLVMObject {
    public static final int LLVMBinaryTypeArchive = 0;
    public static final int LLVMBinaryTypeMachOUniversalBinary = 1;
    public static final int LLVMBinaryTypeCOFFImportFile = 2;
    public static final int LLVMBinaryTypeIR = 3;
    public static final int LLVMBinaryTypeWinRes = 4;
    public static final int LLVMBinaryTypeCOFF = 5;
    public static final int LLVMBinaryTypeELF32L = 6;
    public static final int LLVMBinaryTypeELF32B = 7;
    public static final int LLVMBinaryTypeELF64L = 8;
    public static final int LLVMBinaryTypeELF64B = 9;
    public static final int LLVMBinaryTypeMachO32L = 10;
    public static final int LLVMBinaryTypeMachO32B = 11;
    public static final int LLVMBinaryTypeMachO64L = 12;
    public static final int LLVMBinaryTypeMachO64B = 13;
    public static final int LLVMBinaryTypeWasm = 14;
    public static final int LLVMBinaryTypeOffload = 15;

    protected LLVMObject() {
        throw new UnsupportedOperationException();
    }

    public static long nLLVMCreateBinary(long MemBuf, long Context, long ErrorMessage) {
        long __functionAddress = Functions.CreateBinary;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)MemBuf);
        }
        return JNI.invokePPPP((long)MemBuf, (long)Context, (long)ErrorMessage, (long)__functionAddress);
    }

    @NativeType(value="LLVMBinaryRef")
    public static long LLVMCreateBinary(@NativeType(value="LLVMMemoryBufferRef") long MemBuf, @NativeType(value="LLVMContextRef") long Context, @NativeType(value="char **") PointerBuffer ErrorMessage) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)ErrorMessage, (int)1);
        }
        return LLVMObject.nLLVMCreateBinary(MemBuf, Context, MemoryUtil.memAddress((CustomBuffer)ErrorMessage));
    }

    public static void LLVMDisposeBinary(@NativeType(value="LLVMBinaryRef") long BR) {
        long __functionAddress = Functions.DisposeBinary;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)BR);
        }
        JNI.invokePV((long)BR, (long)__functionAddress);
    }

    @NativeType(value="LLVMMemoryBufferRef")
    public static long LLVMBinaryCopyMemoryBuffer(@NativeType(value="LLVMBinaryRef") long BR) {
        long __functionAddress = Functions.BinaryCopyMemoryBuffer;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)BR);
        }
        return JNI.invokePP((long)BR, (long)__functionAddress);
    }

    @NativeType(value="LLVMBinaryType")
    public static int LLVMBinaryGetType(@NativeType(value="LLVMBinaryRef") long BR) {
        long __functionAddress = Functions.BinaryGetType;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)BR);
        }
        return JNI.invokePI((long)BR, (long)__functionAddress);
    }

    public static long nLLVMMachOUniversalBinaryCopyObjectForArch(long BR, long Arch, long ArchLen, long ErrorMessage) {
        long __functionAddress = Functions.MachOUniversalBinaryCopyObjectForArch;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)BR);
        }
        return JNI.invokePPPPP((long)BR, (long)Arch, (long)ArchLen, (long)ErrorMessage, (long)__functionAddress);
    }

    @NativeType(value="LLVMBinaryRef")
    public static long LLVMMachOUniversalBinaryCopyObjectForArch(@NativeType(value="LLVMBinaryRef") long BR, @NativeType(value="char const *") ByteBuffer Arch, @NativeType(value="char **") PointerBuffer ErrorMessage) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)ErrorMessage, (int)1);
        }
        return LLVMObject.nLLVMMachOUniversalBinaryCopyObjectForArch(BR, MemoryUtil.memAddress((ByteBuffer)Arch), Arch.remaining(), MemoryUtil.memAddress((CustomBuffer)ErrorMessage));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMBinaryRef")
    public static long LLVMMachOUniversalBinaryCopyObjectForArch(@NativeType(value="LLVMBinaryRef") long BR, @NativeType(value="char const *") CharSequence Arch, @NativeType(value="char **") PointerBuffer ErrorMessage) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)ErrorMessage, (int)1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            int ArchEncodedLength = stack.nUTF8(Arch, false);
            long ArchEncoded = stack.getPointerAddress();
            long l = LLVMObject.nLLVMMachOUniversalBinaryCopyObjectForArch(BR, ArchEncoded, ArchEncodedLength, MemoryUtil.memAddress((CustomBuffer)ErrorMessage));
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    @NativeType(value="LLVMSectionIteratorRef")
    public static long LLVMObjectFileCopySectionIterator(@NativeType(value="LLVMBinaryRef") long BR) {
        long __functionAddress = Functions.ObjectFileCopySectionIterator;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)BR);
        }
        return JNI.invokePP((long)BR, (long)__functionAddress);
    }

    @NativeType(value="LLVMBool")
    public static boolean LLVMObjectFileIsSectionIteratorAtEnd(@NativeType(value="LLVMBinaryRef") long BR, @NativeType(value="LLVMSectionIteratorRef") long SI) {
        long __functionAddress = Functions.ObjectFileIsSectionIteratorAtEnd;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)BR);
            Checks.check((long)SI);
        }
        return JNI.invokePPI((long)BR, (long)SI, (long)__functionAddress) != 0;
    }

    @NativeType(value="LLVMSymbolIteratorRef")
    public static long LLVMObjectFileCopySymbolIterator(@NativeType(value="LLVMBinaryRef") long BR) {
        long __functionAddress = Functions.ObjectFileCopySymbolIterator;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)BR);
        }
        return JNI.invokePP((long)BR, (long)__functionAddress);
    }

    @NativeType(value="LLVMBool")
    public static boolean LLVMObjectFileIsSymbolIteratorAtEnd(@NativeType(value="LLVMBinaryRef") long BR, @NativeType(value="LLVMSymbolIteratorRef") long SI) {
        long __functionAddress = Functions.ObjectFileIsSymbolIteratorAtEnd;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)BR);
            Checks.check((long)SI);
        }
        return JNI.invokePPI((long)BR, (long)SI, (long)__functionAddress) != 0;
    }

    public static void LLVMDisposeSectionIterator(@NativeType(value="LLVMSectionIteratorRef") long SI) {
        long __functionAddress = Functions.DisposeSectionIterator;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)SI);
        }
        JNI.invokePV((long)SI, (long)__functionAddress);
    }

    public static void LLVMMoveToNextSection(@NativeType(value="LLVMSectionIteratorRef") long SI) {
        long __functionAddress = Functions.MoveToNextSection;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)SI);
        }
        JNI.invokePV((long)SI, (long)__functionAddress);
    }

    public static void LLVMMoveToContainingSection(@NativeType(value="LLVMSectionIteratorRef") long Sect, @NativeType(value="LLVMSymbolIteratorRef") long Sym) {
        long __functionAddress = Functions.MoveToContainingSection;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)Sect);
            Checks.check((long)Sym);
        }
        JNI.invokePPV((long)Sect, (long)Sym, (long)__functionAddress);
    }

    public static void LLVMDisposeSymbolIterator(@NativeType(value="LLVMSymbolIteratorRef") long SI) {
        long __functionAddress = Functions.DisposeSymbolIterator;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)SI);
        }
        JNI.invokePV((long)SI, (long)__functionAddress);
    }

    public static void LLVMMoveToNextSymbol(@NativeType(value="LLVMSymbolIteratorRef") long SI) {
        long __functionAddress = Functions.MoveToNextSymbol;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)SI);
        }
        JNI.invokePV((long)SI, (long)__functionAddress);
    }

    public static long nLLVMGetSectionName(long SI) {
        long __functionAddress = Functions.GetSectionName;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)SI);
        }
        return JNI.invokePP((long)SI, (long)__functionAddress);
    }

    @Nullable
    @NativeType(value="char const *")
    public static String LLVMGetSectionName(@NativeType(value="LLVMSectionIteratorRef") long SI) {
        long __result = LLVMObject.nLLVMGetSectionName(SI);
        return MemoryUtil.memUTF8Safe((long)__result);
    }

    @NativeType(value="uint64_t")
    public static long LLVMGetSectionSize(@NativeType(value="LLVMSectionIteratorRef") long SI) {
        long __functionAddress = Functions.GetSectionSize;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)SI);
        }
        return JNI.invokePJ((long)SI, (long)__functionAddress);
    }

    public static long nLLVMGetSectionContents(long SI) {
        long __functionAddress = Functions.GetSectionContents;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)SI);
        }
        return JNI.invokePP((long)SI, (long)__functionAddress);
    }

    @Nullable
    @NativeType(value="char const *")
    public static String LLVMGetSectionContents(@NativeType(value="LLVMSectionIteratorRef") long SI) {
        long __result = LLVMObject.nLLVMGetSectionContents(SI);
        return MemoryUtil.memUTF8Safe((long)__result);
    }

    @NativeType(value="uint64_t")
    public static long LLVMGetSectionAddress(@NativeType(value="LLVMSectionIteratorRef") long SI) {
        long __functionAddress = Functions.GetSectionAddress;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)SI);
        }
        return JNI.invokePJ((long)SI, (long)__functionAddress);
    }

    @NativeType(value="LLVMBool")
    public static boolean LLVMGetSectionContainsSymbol(@NativeType(value="LLVMSectionIteratorRef") long SI, @NativeType(value="LLVMSymbolIteratorRef") long Sym) {
        long __functionAddress = Functions.GetSectionContainsSymbol;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)SI);
            Checks.check((long)Sym);
        }
        return JNI.invokePPI((long)SI, (long)Sym, (long)__functionAddress) != 0;
    }

    @NativeType(value="LLVMRelocationIteratorRef")
    public static long LLVMGetRelocations(@NativeType(value="LLVMSectionIteratorRef") long Section) {
        long __functionAddress = Functions.GetRelocations;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)Section);
        }
        return JNI.invokePP((long)Section, (long)__functionAddress);
    }

    public static void LLVMDisposeRelocationIterator(@NativeType(value="LLVMRelocationIteratorRef") long RI) {
        long __functionAddress = Functions.DisposeRelocationIterator;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)RI);
        }
        JNI.invokePV((long)RI, (long)__functionAddress);
    }

    @NativeType(value="LLVMBool")
    public static boolean LLVMIsRelocationIteratorAtEnd(@NativeType(value="LLVMSectionIteratorRef") long Section, @NativeType(value="LLVMRelocationIteratorRef") long RI) {
        long __functionAddress = Functions.IsRelocationIteratorAtEnd;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)Section);
            Checks.check((long)RI);
        }
        return JNI.invokePPI((long)Section, (long)RI, (long)__functionAddress) != 0;
    }

    public static void LLVMMoveToNextRelocation(@NativeType(value="LLVMRelocationIteratorRef") long RI) {
        long __functionAddress = Functions.MoveToNextRelocation;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)RI);
        }
        JNI.invokePV((long)RI, (long)__functionAddress);
    }

    public static long nLLVMGetSymbolName(long SI) {
        long __functionAddress = Functions.GetSymbolName;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)SI);
        }
        return JNI.invokePP((long)SI, (long)__functionAddress);
    }

    @Nullable
    @NativeType(value="char const *")
    public static String LLVMGetSymbolName(@NativeType(value="LLVMSymbolIteratorRef") long SI) {
        long __result = LLVMObject.nLLVMGetSymbolName(SI);
        return MemoryUtil.memUTF8Safe((long)__result);
    }

    @NativeType(value="uint64_t")
    public static long LLVMGetSymbolAddress(@NativeType(value="LLVMSymbolIteratorRef") long SI) {
        long __functionAddress = Functions.GetSymbolAddress;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)SI);
        }
        return JNI.invokePJ((long)SI, (long)__functionAddress);
    }

    @NativeType(value="uint64_t")
    public static long LLVMGetSymbolSize(@NativeType(value="LLVMSymbolIteratorRef") long SI) {
        long __functionAddress = Functions.GetSymbolSize;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)SI);
        }
        return JNI.invokePJ((long)SI, (long)__functionAddress);
    }

    @NativeType(value="uint64_t")
    public static long LLVMGetRelocationOffset(@NativeType(value="LLVMRelocationIteratorRef") long RI) {
        long __functionAddress = Functions.GetRelocationOffset;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)RI);
        }
        return JNI.invokePJ((long)RI, (long)__functionAddress);
    }

    @NativeType(value="LLVMSymbolIteratorRef")
    public static long LLVMGetRelocationSymbol(@NativeType(value="LLVMRelocationIteratorRef") long RI) {
        long __functionAddress = Functions.GetRelocationSymbol;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)RI);
        }
        return JNI.invokePP((long)RI, (long)__functionAddress);
    }

    @NativeType(value="uint64_t")
    public static long LLVMGetRelocationType(@NativeType(value="LLVMRelocationIteratorRef") long RI) {
        long __functionAddress = Functions.GetRelocationType;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)RI);
        }
        return JNI.invokePJ((long)RI, (long)__functionAddress);
    }

    public static long nLLVMGetRelocationTypeName(long RI) {
        long __functionAddress = Functions.GetRelocationTypeName;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)RI);
        }
        return JNI.invokePP((long)RI, (long)__functionAddress);
    }

    @Nullable
    @NativeType(value="char const *")
    public static String LLVMGetRelocationTypeName(@NativeType(value="LLVMRelocationIteratorRef") long RI) {
        long __result = LLVMObject.nLLVMGetRelocationTypeName(RI);
        return MemoryUtil.memUTF8Safe((long)__result);
    }

    public static long nLLVMGetRelocationValueString(long RI) {
        long __functionAddress = Functions.GetRelocationValueString;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)RI);
        }
        return JNI.invokePP((long)RI, (long)__functionAddress);
    }

    @Nullable
    @NativeType(value="char const *")
    public static String LLVMGetRelocationValueString(@NativeType(value="LLVMRelocationIteratorRef") long RI) {
        long __result = LLVMObject.nLLVMGetRelocationValueString(RI);
        return MemoryUtil.memUTF8Safe((long)__result);
    }

    @NativeType(value="LLVMObjectFileRef")
    public static long LLVMCreateObjectFile(@NativeType(value="LLVMMemoryBufferRef") long MemBuf) {
        long __functionAddress = Functions.CreateObjectFile;
        if (Checks.CHECKS) {
            Checks.check((long)MemBuf);
        }
        return JNI.invokePP((long)MemBuf, (long)__functionAddress);
    }

    public static void LLVMDisposeObjectFile(@NativeType(value="LLVMObjectFileRef") long ObjectFile) {
        long __functionAddress = Functions.DisposeObjectFile;
        if (Checks.CHECKS) {
            Checks.check((long)ObjectFile);
        }
        JNI.invokePV((long)ObjectFile, (long)__functionAddress);
    }

    @NativeType(value="LLVMSectionIteratorRef")
    public static long LLVMGetSections(@NativeType(value="LLVMObjectFileRef") long ObjectFile) {
        long __functionAddress = Functions.GetSections;
        if (Checks.CHECKS) {
            Checks.check((long)ObjectFile);
        }
        return JNI.invokePP((long)ObjectFile, (long)__functionAddress);
    }

    @NativeType(value="LLVMBool")
    public static boolean LLVMIsSectionIteratorAtEnd(@NativeType(value="LLVMObjectFileRef") long ObjectFile, @NativeType(value="LLVMSectionIteratorRef") long SI) {
        long __functionAddress = Functions.IsSectionIteratorAtEnd;
        if (Checks.CHECKS) {
            Checks.check((long)ObjectFile);
            Checks.check((long)SI);
        }
        return JNI.invokePPI((long)ObjectFile, (long)SI, (long)__functionAddress) != 0;
    }

    @NativeType(value="LLVMSymbolIteratorRef")
    public static long LLVMGetSymbols(@NativeType(value="LLVMObjectFileRef") long ObjectFile) {
        long __functionAddress = Functions.GetSymbols;
        if (Checks.CHECKS) {
            Checks.check((long)ObjectFile);
        }
        return JNI.invokePP((long)ObjectFile, (long)__functionAddress);
    }

    @NativeType(value="LLVMBool")
    public static boolean LLVMIsSymbolIteratorAtEnd(@NativeType(value="LLVMObjectFileRef") long ObjectFile, @NativeType(value="LLVMSymbolIteratorRef") long SI) {
        long __functionAddress = Functions.IsSymbolIteratorAtEnd;
        if (Checks.CHECKS) {
            Checks.check((long)ObjectFile);
            Checks.check((long)SI);
        }
        return JNI.invokePPI((long)ObjectFile, (long)SI, (long)__functionAddress) != 0;
    }

    public static final class Functions {
        public static final long CreateBinary = APIUtil.apiGetFunctionAddressOptional((SharedLibrary)LLVMCore.getLibrary(), (String)"LLVMCreateBinary");
        public static final long DisposeBinary = APIUtil.apiGetFunctionAddressOptional((SharedLibrary)LLVMCore.getLibrary(), (String)"LLVMDisposeBinary");
        public static final long BinaryCopyMemoryBuffer = APIUtil.apiGetFunctionAddressOptional((SharedLibrary)LLVMCore.getLibrary(), (String)"LLVMBinaryCopyMemoryBuffer");
        public static final long BinaryGetType = APIUtil.apiGetFunctionAddressOptional((SharedLibrary)LLVMCore.getLibrary(), (String)"LLVMBinaryGetType");
        public static final long MachOUniversalBinaryCopyObjectForArch = APIUtil.apiGetFunctionAddressOptional((SharedLibrary)LLVMCore.getLibrary(), (String)"LLVMMachOUniversalBinaryCopyObjectForArch");
        public static final long ObjectFileCopySectionIterator = APIUtil.apiGetFunctionAddressOptional((SharedLibrary)LLVMCore.getLibrary(), (String)"LLVMObjectFileCopySectionIterator");
        public static final long ObjectFileIsSectionIteratorAtEnd = APIUtil.apiGetFunctionAddressOptional((SharedLibrary)LLVMCore.getLibrary(), (String)"LLVMObjectFileIsSectionIteratorAtEnd");
        public static final long ObjectFileCopySymbolIterator = APIUtil.apiGetFunctionAddressOptional((SharedLibrary)LLVMCore.getLibrary(), (String)"LLVMObjectFileCopySymbolIterator");
        public static final long ObjectFileIsSymbolIteratorAtEnd = APIUtil.apiGetFunctionAddressOptional((SharedLibrary)LLVMCore.getLibrary(), (String)"LLVMObjectFileIsSymbolIteratorAtEnd");
        public static final long DisposeSectionIterator = APIUtil.apiGetFunctionAddressOptional((SharedLibrary)LLVMCore.getLibrary(), (String)"LLVMDisposeSectionIterator");
        public static final long MoveToNextSection = APIUtil.apiGetFunctionAddressOptional((SharedLibrary)LLVMCore.getLibrary(), (String)"LLVMMoveToNextSection");
        public static final long MoveToContainingSection = APIUtil.apiGetFunctionAddressOptional((SharedLibrary)LLVMCore.getLibrary(), (String)"LLVMMoveToContainingSection");
        public static final long DisposeSymbolIterator = APIUtil.apiGetFunctionAddressOptional((SharedLibrary)LLVMCore.getLibrary(), (String)"LLVMDisposeSymbolIterator");
        public static final long MoveToNextSymbol = APIUtil.apiGetFunctionAddressOptional((SharedLibrary)LLVMCore.getLibrary(), (String)"LLVMMoveToNextSymbol");
        public static final long GetSectionName = APIUtil.apiGetFunctionAddressOptional((SharedLibrary)LLVMCore.getLibrary(), (String)"LLVMGetSectionName");
        public static final long GetSectionSize = APIUtil.apiGetFunctionAddressOptional((SharedLibrary)LLVMCore.getLibrary(), (String)"LLVMGetSectionSize");
        public static final long GetSectionContents = APIUtil.apiGetFunctionAddressOptional((SharedLibrary)LLVMCore.getLibrary(), (String)"LLVMGetSectionContents");
        public static final long GetSectionAddress = APIUtil.apiGetFunctionAddressOptional((SharedLibrary)LLVMCore.getLibrary(), (String)"LLVMGetSectionAddress");
        public static final long GetSectionContainsSymbol = APIUtil.apiGetFunctionAddressOptional((SharedLibrary)LLVMCore.getLibrary(), (String)"LLVMGetSectionContainsSymbol");
        public static final long GetRelocations = APIUtil.apiGetFunctionAddressOptional((SharedLibrary)LLVMCore.getLibrary(), (String)"LLVMGetRelocations");
        public static final long DisposeRelocationIterator = APIUtil.apiGetFunctionAddressOptional((SharedLibrary)LLVMCore.getLibrary(), (String)"LLVMDisposeRelocationIterator");
        public static final long IsRelocationIteratorAtEnd = APIUtil.apiGetFunctionAddressOptional((SharedLibrary)LLVMCore.getLibrary(), (String)"LLVMIsRelocationIteratorAtEnd");
        public static final long MoveToNextRelocation = APIUtil.apiGetFunctionAddressOptional((SharedLibrary)LLVMCore.getLibrary(), (String)"LLVMMoveToNextRelocation");
        public static final long GetSymbolName = APIUtil.apiGetFunctionAddressOptional((SharedLibrary)LLVMCore.getLibrary(), (String)"LLVMGetSymbolName");
        public static final long GetSymbolAddress = APIUtil.apiGetFunctionAddressOptional((SharedLibrary)LLVMCore.getLibrary(), (String)"LLVMGetSymbolAddress");
        public static final long GetSymbolSize = APIUtil.apiGetFunctionAddressOptional((SharedLibrary)LLVMCore.getLibrary(), (String)"LLVMGetSymbolSize");
        public static final long GetRelocationOffset = APIUtil.apiGetFunctionAddressOptional((SharedLibrary)LLVMCore.getLibrary(), (String)"LLVMGetRelocationOffset");
        public static final long GetRelocationSymbol = APIUtil.apiGetFunctionAddressOptional((SharedLibrary)LLVMCore.getLibrary(), (String)"LLVMGetRelocationSymbol");
        public static final long GetRelocationType = APIUtil.apiGetFunctionAddressOptional((SharedLibrary)LLVMCore.getLibrary(), (String)"LLVMGetRelocationType");
        public static final long GetRelocationTypeName = APIUtil.apiGetFunctionAddressOptional((SharedLibrary)LLVMCore.getLibrary(), (String)"LLVMGetRelocationTypeName");
        public static final long GetRelocationValueString = APIUtil.apiGetFunctionAddressOptional((SharedLibrary)LLVMCore.getLibrary(), (String)"LLVMGetRelocationValueString");
        public static final long CreateObjectFile = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMCreateObjectFile");
        public static final long DisposeObjectFile = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMDisposeObjectFile");
        public static final long GetSections = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMGetSections");
        public static final long IsSectionIteratorAtEnd = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMIsSectionIteratorAtEnd");
        public static final long GetSymbols = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMGetSymbols");
        public static final long IsSymbolIteratorAtEnd = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMIsSymbolIteratorAtEnd");

        private Functions() {
        }
    }
}

