/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.llvm;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.PointerBuffer;
import org.lwjgl.llvm.LLVMCore;
import org.lwjgl.llvm.LLVMOrcCAPIDefinitionGeneratorTryToGenerateFunctionI;
import org.lwjgl.llvm.LLVMOrcCDependenceMapPair;
import org.lwjgl.llvm.LLVMOrcCJITDylibSearchOrderElement;
import org.lwjgl.llvm.LLVMOrcCLookupSetElement;
import org.lwjgl.llvm.LLVMOrcCSymbolAliasMapPair;
import org.lwjgl.llvm.LLVMOrcCSymbolFlagsMapPair;
import org.lwjgl.llvm.LLVMOrcCSymbolMapPair;
import org.lwjgl.llvm.LLVMOrcDisposeCAPIDefinitionGeneratorFunctionI;
import org.lwjgl.llvm.LLVMOrcErrorReporterFunctionI;
import org.lwjgl.llvm.LLVMOrcExecutionSessionLookupHandleResultFunctionI;
import org.lwjgl.llvm.LLVMOrcGenericIRModuleOperationFunctionI;
import org.lwjgl.llvm.LLVMOrcIRTransformLayerTransformFunctionI;
import org.lwjgl.llvm.LLVMOrcMaterializationUnitDestroyFunctionI;
import org.lwjgl.llvm.LLVMOrcMaterializationUnitDiscardFunctionI;
import org.lwjgl.llvm.LLVMOrcMaterializationUnitMaterializeFunctionI;
import org.lwjgl.llvm.LLVMOrcObjectTransformLayerTransformFunctionI;
import org.lwjgl.llvm.LLVMOrcSymbolPredicateI;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.CustomBuffer;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.SharedLibrary;

public class LLVMOrc {
    public static final int LLVMJITSymbolGenericFlagsNone = 0;
    public static final int LLVMJITSymbolGenericFlagsExported = 1;
    public static final int LLVMJITSymbolGenericFlagsWeak = 2;
    public static final int LLVMJITSymbolGenericFlagsCallable = 4;
    public static final int LLVMJITSymbolGenericFlagsMaterializationSideEffectsOnly = 8;
    public static final int LLVMOrcLookupKindStatic = 0;
    public static final int LLVMOrcLookupKindDLSym = 1;
    public static final int LLVMOrcJITDylibLookupFlagsMatchExportedSymbolsOnly = 0;
    public static final int LLVMOrcJITDylibLookupFlagsMatchAllSymbols = 1;
    public static final int LLVMOrcSymbolLookupFlagsRequiredSymbol = 0;
    public static final int LLVMOrcSymbolLookupFlagsWeaklyReferencedSymbol = 1;

    protected LLVMOrc() {
        throw new UnsupportedOperationException();
    }

    public static void nLLVMOrcExecutionSessionSetErrorReporter(long ES, long ReportError, long Ctx) {
        long __functionAddress = Functions.OrcExecutionSessionSetErrorReporter;
        if (Checks.CHECKS) {
            Checks.check((long)ES);
            Checks.check((long)Ctx);
        }
        JNI.invokePPPV((long)ES, (long)ReportError, (long)Ctx, (long)__functionAddress);
    }

    public static void LLVMOrcExecutionSessionSetErrorReporter(@NativeType(value="LLVMOrcExecutionSessionRef") long ES, @NativeType(value="LLVMOrcErrorReporterFunction") LLVMOrcErrorReporterFunctionI ReportError, @NativeType(value="void *") long Ctx) {
        LLVMOrc.nLLVMOrcExecutionSessionSetErrorReporter(ES, ReportError.address(), Ctx);
    }

    @NativeType(value="LLVMOrcSymbolStringPoolRef")
    public static long LLVMOrcExecutionSessionGetSymbolStringPool(@NativeType(value="LLVMOrcExecutionSessionRef") long ES) {
        long __functionAddress = Functions.OrcExecutionSessionGetSymbolStringPool;
        if (Checks.CHECKS) {
            Checks.check((long)ES);
        }
        return JNI.invokePP((long)ES, (long)__functionAddress);
    }

    public static void LLVMOrcSymbolStringPoolClearDeadEntries(@NativeType(value="LLVMOrcSymbolStringPoolRef") long SSP) {
        long __functionAddress = Functions.OrcSymbolStringPoolClearDeadEntries;
        if (Checks.CHECKS) {
            Checks.check((long)SSP);
        }
        JNI.invokePV((long)SSP, (long)__functionAddress);
    }

    public static long nLLVMOrcExecutionSessionIntern(long ES, long Name) {
        long __functionAddress = Functions.OrcExecutionSessionIntern;
        if (Checks.CHECKS) {
            Checks.check((long)ES);
        }
        return JNI.invokePPP((long)ES, (long)Name, (long)__functionAddress);
    }

    @NativeType(value="LLVMOrcSymbolStringPoolEntryRef")
    public static long LLVMOrcExecutionSessionIntern(@NativeType(value="LLVMOrcExecutionSessionRef") long ES, @NativeType(value="char const *") ByteBuffer Name) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)Name);
        }
        return LLVMOrc.nLLVMOrcExecutionSessionIntern(ES, MemoryUtil.memAddress((ByteBuffer)Name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMOrcSymbolStringPoolEntryRef")
    public static long LLVMOrcExecutionSessionIntern(@NativeType(value="LLVMOrcExecutionSessionRef") long ES, @NativeType(value="char const *") CharSequence Name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMOrc.nLLVMOrcExecutionSessionIntern(ES, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void LLVMOrcRetainSymbolStringPoolEntry(@NativeType(value="LLVMOrcSymbolStringPoolEntryRef") long S) {
        long __functionAddress = Functions.OrcRetainSymbolStringPoolEntry;
        if (Checks.CHECKS) {
            Checks.check((long)S);
        }
        JNI.invokePV((long)S, (long)__functionAddress);
    }

    public static void nLLVMOrcExecutionSessionLookup(long ES, int K, long SearchOrder, long SearchOrderSize, long Symbols, long SymbolsSize, long HandleResult, long Ctx) {
        long __functionAddress = Functions.OrcExecutionSessionLookup;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)ES);
        }
        JNI.invokePPPPPPPV((long)ES, (int)K, (long)SearchOrder, (long)SearchOrderSize, (long)Symbols, (long)SymbolsSize, (long)HandleResult, (long)Ctx, (long)__functionAddress);
    }

    public static void LLVMOrcExecutionSessionLookup(@NativeType(value="LLVMOrcExecutionSessionRef") long ES, @NativeType(value="LLVMOrcLookupKind") int K, @Nullable @NativeType(value="LLVMOrcCJITDylibSearchOrder") LLVMOrcCJITDylibSearchOrderElement.Buffer SearchOrder, @Nullable @NativeType(value="LLVMOrcCLookupSet") LLVMOrcCLookupSetElement.Buffer Symbols, @NativeType(value="LLVMOrcExecutionSessionLookupHandleResultFunction") LLVMOrcExecutionSessionLookupHandleResultFunctionI HandleResult, @NativeType(value="void *") long Ctx) {
        LLVMOrc.nLLVMOrcExecutionSessionLookup(ES, K, MemoryUtil.memAddressSafe((Pointer)SearchOrder), Checks.remainingSafe((CustomBuffer)SearchOrder), MemoryUtil.memAddressSafe((Pointer)Symbols), Checks.remainingSafe((CustomBuffer)Symbols), HandleResult.address(), Ctx);
    }

    public static void LLVMOrcReleaseSymbolStringPoolEntry(@NativeType(value="LLVMOrcSymbolStringPoolEntryRef") long S) {
        long __functionAddress = Functions.OrcReleaseSymbolStringPoolEntry;
        if (Checks.CHECKS) {
            Checks.check((long)S);
        }
        JNI.invokePV((long)S, (long)__functionAddress);
    }

    public static long nLLVMOrcSymbolStringPoolEntryStr(long S) {
        long __functionAddress = Functions.OrcSymbolStringPoolEntryStr;
        if (Checks.CHECKS) {
            Checks.check((long)S);
        }
        return JNI.invokePP((long)S, (long)__functionAddress);
    }

    @Nullable
    @NativeType(value="char const *")
    public static String LLVMOrcSymbolStringPoolEntryStr(@NativeType(value="LLVMOrcSymbolStringPoolEntryRef") long S) {
        long __result = LLVMOrc.nLLVMOrcSymbolStringPoolEntryStr(S);
        return MemoryUtil.memUTF8Safe((long)__result);
    }

    public static void LLVMOrcReleaseResourceTracker(@NativeType(value="LLVMOrcResourceTrackerRef") long RT) {
        long __functionAddress = Functions.OrcReleaseResourceTracker;
        if (Checks.CHECKS) {
            Checks.check((long)RT);
        }
        JNI.invokePV((long)RT, (long)__functionAddress);
    }

    public static void LLVMOrcResourceTrackerTransferTo(@NativeType(value="LLVMOrcResourceTrackerRef") long SrcRT, @NativeType(value="LLVMOrcResourceTrackerRef") long DstRT) {
        long __functionAddress = Functions.OrcResourceTrackerTransferTo;
        if (Checks.CHECKS) {
            Checks.check((long)SrcRT);
            Checks.check((long)DstRT);
        }
        JNI.invokePPV((long)SrcRT, (long)DstRT, (long)__functionAddress);
    }

    @NativeType(value="LLVMErrorRef")
    public static long LLVMOrcResourceTrackerRemove(@NativeType(value="LLVMOrcResourceTrackerRef") long RT) {
        long __functionAddress = Functions.OrcResourceTrackerRemove;
        if (Checks.CHECKS) {
            Checks.check((long)RT);
        }
        return JNI.invokePP((long)RT, (long)__functionAddress);
    }

    public static void LLVMOrcDisposeDefinitionGenerator(@NativeType(value="LLVMOrcDefinitionGeneratorRef") long DG) {
        long __functionAddress = Functions.OrcDisposeDefinitionGenerator;
        if (Checks.CHECKS) {
            Checks.check((long)DG);
        }
        JNI.invokePV((long)DG, (long)__functionAddress);
    }

    public static void LLVMOrcDisposeMaterializationUnit(@NativeType(value="LLVMOrcMaterializationUnitRef") long MU) {
        long __functionAddress = Functions.OrcDisposeMaterializationUnit;
        if (Checks.CHECKS) {
            Checks.check((long)MU);
        }
        JNI.invokePV((long)MU, (long)__functionAddress);
    }

    public static long nLLVMOrcCreateCustomMaterializationUnit(long Name, long Ctx, long Syms, long NumSyms, long InitSym, long Materialize, long Discard, long Destroy) {
        long __functionAddress = Functions.OrcCreateCustomMaterializationUnit;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)Ctx);
        }
        return JNI.invokePPPPPPPPP((long)Name, (long)Ctx, (long)Syms, (long)NumSyms, (long)InitSym, (long)Materialize, (long)Discard, (long)Destroy, (long)__functionAddress);
    }

    @NativeType(value="LLVMOrcMaterializationUnitRef")
    public static long LLVMOrcCreateCustomMaterializationUnit(@NativeType(value="char const *") ByteBuffer Name, @NativeType(value="void *") long Ctx, @NativeType(value="LLVMOrcCSymbolFlagsMapPairs") LLVMOrcCSymbolFlagsMapPair.Buffer Syms, @NativeType(value="LLVMOrcSymbolStringPoolEntryRef") long InitSym, @NativeType(value="LLVMOrcMaterializationUnitMaterializeFunction") LLVMOrcMaterializationUnitMaterializeFunctionI Materialize, @NativeType(value="LLVMOrcMaterializationUnitDiscardFunction") LLVMOrcMaterializationUnitDiscardFunctionI Discard, @NativeType(value="LLVMOrcMaterializationUnitDestroyFunction") LLVMOrcMaterializationUnitDestroyFunctionI Destroy) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)Name);
        }
        return LLVMOrc.nLLVMOrcCreateCustomMaterializationUnit(MemoryUtil.memAddress((ByteBuffer)Name), Ctx, Syms.address(), Syms.remaining(), InitSym, Materialize.address(), Discard.address(), Destroy.address());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMOrcMaterializationUnitRef")
    public static long LLVMOrcCreateCustomMaterializationUnit(@NativeType(value="char const *") CharSequence Name, @NativeType(value="void *") long Ctx, @NativeType(value="LLVMOrcCSymbolFlagsMapPairs") LLVMOrcCSymbolFlagsMapPair.Buffer Syms, @NativeType(value="LLVMOrcSymbolStringPoolEntryRef") long InitSym, @NativeType(value="LLVMOrcMaterializationUnitMaterializeFunction") LLVMOrcMaterializationUnitMaterializeFunctionI Materialize, @NativeType(value="LLVMOrcMaterializationUnitDiscardFunction") LLVMOrcMaterializationUnitDiscardFunctionI Discard, @NativeType(value="LLVMOrcMaterializationUnitDestroyFunction") LLVMOrcMaterializationUnitDestroyFunctionI Destroy) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMOrc.nLLVMOrcCreateCustomMaterializationUnit(NameEncoded, Ctx, Syms.address(), Syms.remaining(), InitSym, Materialize.address(), Discard.address(), Destroy.address());
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMOrcAbsoluteSymbols(long Syms, long NumPairs) {
        long __functionAddress = Functions.OrcAbsoluteSymbols;
        return JNI.invokePPP((long)Syms, (long)NumPairs, (long)__functionAddress);
    }

    @NativeType(value="LLVMOrcMaterializationUnitRef")
    public static long LLVMOrcAbsoluteSymbols(@NativeType(value="LLVMOrcCSymbolMapPairs") LLVMOrcCSymbolMapPair.Buffer Syms) {
        return LLVMOrc.nLLVMOrcAbsoluteSymbols(Syms.address(), Syms.remaining());
    }

    public static long nLLVMOrcLazyReexports(long LCTM, long ISM, long SourceRef, long CallableAliases, long NumPairs) {
        long __functionAddress = Functions.OrcLazyReexports;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)LCTM);
            Checks.check((long)ISM);
            Checks.check((long)SourceRef);
        }
        return JNI.invokePPPPPP((long)LCTM, (long)ISM, (long)SourceRef, (long)CallableAliases, (long)NumPairs, (long)__functionAddress);
    }

    @NativeType(value="LLVMOrcMaterializationUnitRef")
    public static long LLVMOrcLazyReexports(@NativeType(value="LLVMOrcLazyCallThroughManagerRef") long LCTM, @NativeType(value="LLVMOrcIndirectStubsManagerRef") long ISM, @NativeType(value="LLVMOrcJITDylibRef") long SourceRef, @NativeType(value="LLVMOrcCSymbolAliasMapPairs") LLVMOrcCSymbolAliasMapPair.Buffer CallableAliases) {
        return LLVMOrc.nLLVMOrcLazyReexports(LCTM, ISM, SourceRef, CallableAliases.address(), CallableAliases.remaining());
    }

    public static void LLVMOrcDisposeMaterializationResponsibility(@NativeType(value="LLVMOrcMaterializationResponsibilityRef") long MR) {
        long __functionAddress = Functions.OrcDisposeMaterializationResponsibility;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)MR);
        }
        JNI.invokePV((long)MR, (long)__functionAddress);
    }

    @NativeType(value="LLVMOrcJITDylibRef")
    public static long LLVMOrcMaterializationResponsibilityGetTargetDylib(@NativeType(value="LLVMOrcMaterializationResponsibilityRef") long MR) {
        long __functionAddress = Functions.OrcMaterializationResponsibilityGetTargetDylib;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)MR);
        }
        return JNI.invokePP((long)MR, (long)__functionAddress);
    }

    @NativeType(value="LLVMOrcExecutionSessionRef")
    public static long LLVMOrcMaterializationResponsibilityGetExecutionSession(@NativeType(value="LLVMOrcMaterializationResponsibilityRef") long MR) {
        long __functionAddress = Functions.OrcMaterializationResponsibilityGetExecutionSession;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)MR);
        }
        return JNI.invokePP((long)MR, (long)__functionAddress);
    }

    public static long nLLVMOrcMaterializationResponsibilityGetSymbols(long MR, long NumPairs) {
        long __functionAddress = Functions.OrcMaterializationResponsibilityGetSymbols;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)MR);
        }
        return JNI.invokePPP((long)MR, (long)NumPairs, (long)__functionAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    @NativeType(value="LLVMOrcCSymbolFlagsMapPairs")
    public static LLVMOrcCSymbolFlagsMapPair.Buffer LLVMOrcMaterializationResponsibilityGetSymbols(@NativeType(value="LLVMOrcMaterializationResponsibilityRef") long MR) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        PointerBuffer NumPairs = stack.callocPointer(1);
        try {
            long __result = LLVMOrc.nLLVMOrcMaterializationResponsibilityGetSymbols(MR, MemoryUtil.memAddress((CustomBuffer)NumPairs));
            LLVMOrcCSymbolFlagsMapPair.Buffer buffer = LLVMOrcCSymbolFlagsMapPair.createSafe(__result, (int)NumPairs.get(0));
            return buffer;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nLLVMOrcDisposeCSymbolFlagsMap(long Pairs) {
        long __functionAddress = Functions.OrcDisposeCSymbolFlagsMap;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.invokePV((long)Pairs, (long)__functionAddress);
    }

    public static void LLVMOrcDisposeCSymbolFlagsMap(@NativeType(value="LLVMOrcCSymbolFlagsMapPairs") LLVMOrcCSymbolFlagsMapPair Pairs) {
        LLVMOrc.nLLVMOrcDisposeCSymbolFlagsMap(Pairs.address());
    }

    @NativeType(value="LLVMOrcSymbolStringPoolEntryRef")
    public static long LLVMOrcMaterializationResponsibilityGetInitializerSymbol(@NativeType(value="LLVMOrcMaterializationResponsibilityRef") long MR) {
        long __functionAddress = Functions.OrcMaterializationResponsibilityGetInitializerSymbol;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)MR);
        }
        return JNI.invokePP((long)MR, (long)__functionAddress);
    }

    public static long nLLVMOrcMaterializationResponsibilityGetRequestedSymbols(long MR, long NumSymbols) {
        long __functionAddress = Functions.OrcMaterializationResponsibilityGetRequestedSymbols;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)MR);
        }
        return JNI.invokePPP((long)MR, (long)NumSymbols, (long)__functionAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    @NativeType(value="LLVMOrcSymbolStringPoolEntryRef *")
    public static PointerBuffer LLVMOrcMaterializationResponsibilityGetRequestedSymbols(@NativeType(value="LLVMOrcMaterializationResponsibilityRef") long MR) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        PointerBuffer NumSymbols = stack.callocPointer(1);
        try {
            long __result = LLVMOrc.nLLVMOrcMaterializationResponsibilityGetRequestedSymbols(MR, MemoryUtil.memAddress((CustomBuffer)NumSymbols));
            PointerBuffer pointerBuffer = MemoryUtil.memPointerBufferSafe((long)__result, (int)((int)NumSymbols.get(0)));
            return pointerBuffer;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void nLLVMOrcDisposeSymbols(long Symbols) {
        long __functionAddress = Functions.OrcDisposeSymbols;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        JNI.invokePV((long)Symbols, (long)__functionAddress);
    }

    public static void LLVMOrcDisposeSymbols(@NativeType(value="LLVMOrcSymbolStringPoolEntryRef *") PointerBuffer Symbols) {
        LLVMOrc.nLLVMOrcDisposeSymbols(MemoryUtil.memAddress((CustomBuffer)Symbols));
    }

    public static long nLLVMOrcMaterializationResponsibilityNotifyResolved(long MR, long Symbols, long NumPairs) {
        long __functionAddress = Functions.OrcMaterializationResponsibilityNotifyResolved;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)MR);
        }
        return JNI.invokePPPP((long)MR, (long)Symbols, (long)NumPairs, (long)__functionAddress);
    }

    @NativeType(value="LLVMErrorRef")
    public static long LLVMOrcMaterializationResponsibilityNotifyResolved(@NativeType(value="LLVMOrcMaterializationResponsibilityRef") long MR, @NativeType(value="LLVMOrcCSymbolMapPairs") LLVMOrcCSymbolMapPair.Buffer Symbols) {
        return LLVMOrc.nLLVMOrcMaterializationResponsibilityNotifyResolved(MR, Symbols.address(), Symbols.remaining());
    }

    @NativeType(value="LLVMErrorRef")
    public static long LLVMOrcMaterializationResponsibilityNotifyEmitted(@NativeType(value="LLVMOrcMaterializationResponsibilityRef") long MR) {
        long __functionAddress = Functions.OrcMaterializationResponsibilityNotifyEmitted;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)MR);
        }
        return JNI.invokePP((long)MR, (long)__functionAddress);
    }

    public static long nLLVMOrcMaterializationResponsibilityDefineMaterializing(long MR, long Pairs, long NumPairs) {
        long __functionAddress = Functions.OrcMaterializationResponsibilityDefineMaterializing;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)MR);
        }
        return JNI.invokePPPP((long)MR, (long)Pairs, (long)NumPairs, (long)__functionAddress);
    }

    @NativeType(value="LLVMErrorRef")
    public static long LLVMOrcMaterializationResponsibilityDefineMaterializing(@NativeType(value="LLVMOrcMaterializationResponsibilityRef") long MR, @NativeType(value="LLVMOrcCSymbolFlagsMapPairs") LLVMOrcCSymbolFlagsMapPair.Buffer Pairs) {
        return LLVMOrc.nLLVMOrcMaterializationResponsibilityDefineMaterializing(MR, Pairs.address(), Pairs.remaining());
    }

    public static void LLVMOrcMaterializationResponsibilityFailMaterialization(@NativeType(value="LLVMOrcMaterializationResponsibilityRef") long MR) {
        long __functionAddress = Functions.OrcMaterializationResponsibilityFailMaterialization;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)MR);
        }
        JNI.invokePV((long)MR, (long)__functionAddress);
    }

    @NativeType(value="LLVMErrorRef")
    public static long LLVMOrcMaterializationResponsibilityReplace(@NativeType(value="LLVMOrcMaterializationResponsibilityRef") long MR, @NativeType(value="LLVMOrcMaterializationUnitRef") long MU) {
        long __functionAddress = Functions.OrcMaterializationResponsibilityReplace;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)MR);
            Checks.check((long)MU);
        }
        return JNI.invokePPP((long)MR, (long)MU, (long)__functionAddress);
    }

    public static long nLLVMOrcMaterializationResponsibilityDelegate(long MR, long Symbols, long NumSymbols, long Result) {
        long __functionAddress = Functions.OrcMaterializationResponsibilityDelegate;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)MR);
        }
        return JNI.invokePPPPP((long)MR, (long)Symbols, (long)NumSymbols, (long)Result, (long)__functionAddress);
    }

    @NativeType(value="LLVMErrorRef")
    public static long LLVMOrcMaterializationResponsibilityDelegate(@NativeType(value="LLVMOrcMaterializationResponsibilityRef") long MR, @NativeType(value="LLVMOrcSymbolStringPoolEntryRef *") PointerBuffer Symbols, @NativeType(value="LLVMOrcMaterializationResponsibilityRef *") PointerBuffer Result) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)Result, (int)1);
        }
        return LLVMOrc.nLLVMOrcMaterializationResponsibilityDelegate(MR, MemoryUtil.memAddress((CustomBuffer)Symbols), Symbols.remaining(), MemoryUtil.memAddress((CustomBuffer)Result));
    }

    public static void nLLVMOrcMaterializationResponsibilityAddDependencies(long MR, long Name, long Dependencies, long NumPairs) {
        long __functionAddress = Functions.OrcMaterializationResponsibilityAddDependencies;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)MR);
            Checks.check((long)Name);
        }
        JNI.invokePPPPV((long)MR, (long)Name, (long)Dependencies, (long)NumPairs, (long)__functionAddress);
    }

    public static void LLVMOrcMaterializationResponsibilityAddDependencies(@NativeType(value="LLVMOrcMaterializationResponsibilityRef") long MR, @NativeType(value="LLVMOrcSymbolStringPoolEntryRef") long Name, @NativeType(value="LLVMOrcCDependenceMapPairs") LLVMOrcCDependenceMapPair.Buffer Dependencies) {
        LLVMOrc.nLLVMOrcMaterializationResponsibilityAddDependencies(MR, Name, Dependencies.address(), Dependencies.remaining());
    }

    public static void nLLVMOrcMaterializationResponsibilityAddDependenciesForAll(long MR, long Dependencies, long NumPairs) {
        long __functionAddress = Functions.OrcMaterializationResponsibilityAddDependenciesForAll;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)MR);
        }
        JNI.invokePPPV((long)MR, (long)Dependencies, (long)NumPairs, (long)__functionAddress);
    }

    public static void LLVMOrcMaterializationResponsibilityAddDependenciesForAll(@NativeType(value="LLVMOrcMaterializationResponsibilityRef") long MR, @NativeType(value="LLVMOrcCDependenceMapPairs") LLVMOrcCDependenceMapPair.Buffer Dependencies) {
        LLVMOrc.nLLVMOrcMaterializationResponsibilityAddDependenciesForAll(MR, Dependencies.address(), Dependencies.remaining());
    }

    public static long nLLVMOrcExecutionSessionCreateBareJITDylib(long ES, long Name) {
        long __functionAddress = Functions.OrcExecutionSessionCreateBareJITDylib;
        if (Checks.CHECKS) {
            Checks.check((long)ES);
        }
        return JNI.invokePPP((long)ES, (long)Name, (long)__functionAddress);
    }

    @NativeType(value="LLVMOrcJITDylibRef")
    public static long LLVMOrcExecutionSessionCreateBareJITDylib(@NativeType(value="LLVMOrcExecutionSessionRef") long ES, @NativeType(value="char const *") ByteBuffer Name) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)Name);
        }
        return LLVMOrc.nLLVMOrcExecutionSessionCreateBareJITDylib(ES, MemoryUtil.memAddress((ByteBuffer)Name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMOrcJITDylibRef")
    public static long LLVMOrcExecutionSessionCreateBareJITDylib(@NativeType(value="LLVMOrcExecutionSessionRef") long ES, @NativeType(value="char const *") CharSequence Name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMOrc.nLLVMOrcExecutionSessionCreateBareJITDylib(ES, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMOrcExecutionSessionCreateJITDylib(long ES, long Result, long Name) {
        long __functionAddress = Functions.OrcExecutionSessionCreateJITDylib;
        if (Checks.CHECKS) {
            Checks.check((long)ES);
        }
        return JNI.invokePPPP((long)ES, (long)Result, (long)Name, (long)__functionAddress);
    }

    @NativeType(value="LLVMErrorRef")
    public static long LLVMOrcExecutionSessionCreateJITDylib(@NativeType(value="LLVMOrcExecutionSessionRef") long ES, @NativeType(value="LLVMOrcJITDylibRef *") PointerBuffer Result, @NativeType(value="char const *") ByteBuffer Name) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)Result, (int)1);
            Checks.checkNT1((ByteBuffer)Name);
        }
        return LLVMOrc.nLLVMOrcExecutionSessionCreateJITDylib(ES, MemoryUtil.memAddress((CustomBuffer)Result), MemoryUtil.memAddress((ByteBuffer)Name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMErrorRef")
    public static long LLVMOrcExecutionSessionCreateJITDylib(@NativeType(value="LLVMOrcExecutionSessionRef") long ES, @NativeType(value="LLVMOrcJITDylibRef *") PointerBuffer Result, @NativeType(value="char const *") CharSequence Name) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)Result, (int)1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMOrc.nLLVMOrcExecutionSessionCreateJITDylib(ES, MemoryUtil.memAddress((CustomBuffer)Result), NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMOrcExecutionSessionGetJITDylibByName(long ES, long Name) {
        long __functionAddress = Functions.OrcExecutionSessionGetJITDylibByName;
        if (Checks.CHECKS) {
            Checks.check((long)ES);
        }
        return JNI.invokePPP((long)ES, (long)Name, (long)__functionAddress);
    }

    @NativeType(value="LLVMOrcJITDylibRef")
    public static long LLVMOrcExecutionSessionGetJITDylibByName(@NativeType(value="LLVMOrcExecutionSessionRef") long ES, @NativeType(value="char const *") ByteBuffer Name) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)Name);
        }
        return LLVMOrc.nLLVMOrcExecutionSessionGetJITDylibByName(ES, MemoryUtil.memAddress((ByteBuffer)Name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMOrcJITDylibRef")
    public static long LLVMOrcExecutionSessionGetJITDylibByName(@NativeType(value="LLVMOrcExecutionSessionRef") long ES, @NativeType(value="char const *") CharSequence Name) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(Name, true);
            long NameEncoded = stack.getPointerAddress();
            long l = LLVMOrc.nLLVMOrcExecutionSessionGetJITDylibByName(ES, NameEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    @NativeType(value="LLVMOrcResourceTrackerRef")
    public static long LLVMOrcJITDylibCreateResourceTracker(@NativeType(value="LLVMOrcJITDylibRef") long JD) {
        long __functionAddress = Functions.OrcJITDylibCreateResourceTracker;
        if (Checks.CHECKS) {
            Checks.check((long)JD);
        }
        return JNI.invokePP((long)JD, (long)__functionAddress);
    }

    @NativeType(value="LLVMOrcResourceTrackerRef")
    public static long LLVMOrcJITDylibGetDefaultResourceTracker(@NativeType(value="LLVMOrcJITDylibRef") long JD) {
        long __functionAddress = Functions.OrcJITDylibGetDefaultResourceTracker;
        if (Checks.CHECKS) {
            Checks.check((long)JD);
        }
        return JNI.invokePP((long)JD, (long)__functionAddress);
    }

    @NativeType(value="LLVMErrorRef")
    public static long LLVMOrcJITDylibDefine(@NativeType(value="LLVMOrcJITDylibRef") long JD, @NativeType(value="LLVMOrcMaterializationUnitRef") long MU) {
        long __functionAddress = Functions.OrcJITDylibDefine;
        if (Checks.CHECKS) {
            Checks.check((long)JD);
            Checks.check((long)MU);
        }
        return JNI.invokePPP((long)JD, (long)MU, (long)__functionAddress);
    }

    @NativeType(value="LLVMErrorRef")
    public static long LLVMOrcJITDylibClear(@NativeType(value="LLVMOrcJITDylibRef") long JD) {
        long __functionAddress = Functions.OrcJITDylibClear;
        if (Checks.CHECKS) {
            Checks.check((long)JD);
        }
        return JNI.invokePP((long)JD, (long)__functionAddress);
    }

    public static void LLVMOrcJITDylibAddGenerator(@NativeType(value="LLVMOrcJITDylibRef") long JD, @NativeType(value="LLVMOrcDefinitionGeneratorRef") long DG) {
        long __functionAddress = Functions.OrcJITDylibAddGenerator;
        if (Checks.CHECKS) {
            Checks.check((long)JD);
            Checks.check((long)DG);
        }
        JNI.invokePPV((long)JD, (long)DG, (long)__functionAddress);
    }

    public static long nLLVMOrcCreateCustomCAPIDefinitionGenerator(long F, long Ctx, long Dispose) {
        long __functionAddress = Functions.OrcCreateCustomCAPIDefinitionGenerator;
        return JNI.invokePPPP((long)F, (long)Ctx, (long)Dispose, (long)__functionAddress);
    }

    @NativeType(value="LLVMOrcDefinitionGeneratorRef")
    public static long LLVMOrcCreateCustomCAPIDefinitionGenerator(@NativeType(value="LLVMOrcCAPIDefinitionGeneratorTryToGenerateFunction") LLVMOrcCAPIDefinitionGeneratorTryToGenerateFunctionI F, @NativeType(value="void *") long Ctx, @Nullable @NativeType(value="LLVMOrcDisposeCAPIDefinitionGeneratorFunction") LLVMOrcDisposeCAPIDefinitionGeneratorFunctionI Dispose) {
        return LLVMOrc.nLLVMOrcCreateCustomCAPIDefinitionGenerator(F.address(), Ctx, MemoryUtil.memAddressSafe((Pointer)Dispose));
    }

    public static void LLVMOrcLookupStateContinueLookup(@NativeType(value="LLVMOrcLookupStateRef") long S, @NativeType(value="LLVMErrorRef") long Err) {
        long __functionAddress = Functions.OrcLookupStateContinueLookup;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)S);
            Checks.check((long)Err);
        }
        JNI.invokePPV((long)S, (long)Err, (long)__functionAddress);
    }

    public static long nLLVMOrcCreateDynamicLibrarySearchGeneratorForProcess(long Result, byte GlobalPrefx, long Filter, long FilterCtx) {
        long __functionAddress = Functions.OrcCreateDynamicLibrarySearchGeneratorForProcess;
        return JNI.invokePBPPP((long)Result, (byte)GlobalPrefx, (long)Filter, (long)FilterCtx, (long)__functionAddress);
    }

    @NativeType(value="LLVMErrorRef")
    public static long LLVMOrcCreateDynamicLibrarySearchGeneratorForProcess(@NativeType(value="LLVMOrcDefinitionGeneratorRef *") PointerBuffer Result, @NativeType(value="char") byte GlobalPrefx, @Nullable @NativeType(value="LLVMOrcSymbolPredicate") LLVMOrcSymbolPredicateI Filter, @NativeType(value="void *") long FilterCtx) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)Result, (int)1);
        }
        return LLVMOrc.nLLVMOrcCreateDynamicLibrarySearchGeneratorForProcess(MemoryUtil.memAddress((CustomBuffer)Result), GlobalPrefx, MemoryUtil.memAddressSafe((Pointer)Filter), FilterCtx);
    }

    public static long nLLVMOrcCreateDynamicLibrarySearchGeneratorForPath(long Result, long FileName, byte GlobalPrefix, long Filter, long FilterCtx) {
        long __functionAddress = Functions.OrcCreateDynamicLibrarySearchGeneratorForPath;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.invokePPBPPP((long)Result, (long)FileName, (byte)GlobalPrefix, (long)Filter, (long)FilterCtx, (long)__functionAddress);
    }

    @NativeType(value="LLVMErrorRef")
    public static long LLVMOrcCreateDynamicLibrarySearchGeneratorForPath(@NativeType(value="LLVMOrcDefinitionGeneratorRef *") PointerBuffer Result, @NativeType(value="char const *") ByteBuffer FileName, @NativeType(value="char") byte GlobalPrefix, @Nullable @NativeType(value="LLVMOrcSymbolPredicate") LLVMOrcSymbolPredicateI Filter, @NativeType(value="void *") long FilterCtx) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)Result, (int)1);
            Checks.checkNT1((ByteBuffer)FileName);
        }
        return LLVMOrc.nLLVMOrcCreateDynamicLibrarySearchGeneratorForPath(MemoryUtil.memAddress((CustomBuffer)Result), MemoryUtil.memAddress((ByteBuffer)FileName), GlobalPrefix, MemoryUtil.memAddressSafe((Pointer)Filter), FilterCtx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMErrorRef")
    public static long LLVMOrcCreateDynamicLibrarySearchGeneratorForPath(@NativeType(value="LLVMOrcDefinitionGeneratorRef *") PointerBuffer Result, @NativeType(value="char const *") CharSequence FileName, @NativeType(value="char") byte GlobalPrefix, @Nullable @NativeType(value="LLVMOrcSymbolPredicate") LLVMOrcSymbolPredicateI Filter, @NativeType(value="void *") long FilterCtx) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)Result, (int)1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(FileName, true);
            long FileNameEncoded = stack.getPointerAddress();
            long l = LLVMOrc.nLLVMOrcCreateDynamicLibrarySearchGeneratorForPath(MemoryUtil.memAddress((CustomBuffer)Result), FileNameEncoded, GlobalPrefix, MemoryUtil.memAddressSafe((Pointer)Filter), FilterCtx);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static long nLLVMOrcCreateStaticLibrarySearchGeneratorForPath(long Result, long ObjLayer, long FileName, long TargetTriple) {
        long __functionAddress = Functions.OrcCreateStaticLibrarySearchGeneratorForPath;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)ObjLayer);
        }
        return JNI.invokePPPPP((long)Result, (long)ObjLayer, (long)FileName, (long)TargetTriple, (long)__functionAddress);
    }

    @NativeType(value="LLVMErrorRef")
    public static long LLVMOrcCreateStaticLibrarySearchGeneratorForPath(@NativeType(value="LLVMOrcDefinitionGeneratorRef *") PointerBuffer Result, @NativeType(value="LLVMOrcObjectLayerRef") long ObjLayer, @NativeType(value="char const *") ByteBuffer FileName, @Nullable @NativeType(value="char const *") ByteBuffer TargetTriple) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)Result, (int)1);
            Checks.checkNT1((ByteBuffer)FileName);
            Checks.checkNT1Safe((ByteBuffer)TargetTriple);
        }
        return LLVMOrc.nLLVMOrcCreateStaticLibrarySearchGeneratorForPath(MemoryUtil.memAddress((CustomBuffer)Result), ObjLayer, MemoryUtil.memAddress((ByteBuffer)FileName), MemoryUtil.memAddressSafe((ByteBuffer)TargetTriple));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMErrorRef")
    public static long LLVMOrcCreateStaticLibrarySearchGeneratorForPath(@NativeType(value="LLVMOrcDefinitionGeneratorRef *") PointerBuffer Result, @NativeType(value="LLVMOrcObjectLayerRef") long ObjLayer, @NativeType(value="char const *") CharSequence FileName, @Nullable @NativeType(value="char const *") CharSequence TargetTriple) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)Result, (int)1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(FileName, true);
            long FileNameEncoded = stack.getPointerAddress();
            stack.nUTF8Safe(TargetTriple, true);
            long TargetTripleEncoded = TargetTriple == null ? 0L : stack.getPointerAddress();
            long l = LLVMOrc.nLLVMOrcCreateStaticLibrarySearchGeneratorForPath(MemoryUtil.memAddress((CustomBuffer)Result), ObjLayer, FileNameEncoded, TargetTripleEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    @NativeType(value="LLVMOrcThreadSafeContextRef")
    public static long LLVMOrcCreateNewThreadSafeContext() {
        long __functionAddress = Functions.OrcCreateNewThreadSafeContext;
        return JNI.invokeP((long)__functionAddress);
    }

    @NativeType(value="LLVMContextRef")
    public static long LLVMOrcThreadSafeContextGetContext(@NativeType(value="LLVMOrcThreadSafeContextRef") long TSCtx) {
        long __functionAddress = Functions.OrcThreadSafeContextGetContext;
        if (Checks.CHECKS) {
            Checks.check((long)TSCtx);
        }
        return JNI.invokePP((long)TSCtx, (long)__functionAddress);
    }

    public static void LLVMOrcDisposeThreadSafeContext(@NativeType(value="LLVMOrcThreadSafeContextRef") long TSCtx) {
        long __functionAddress = Functions.OrcDisposeThreadSafeContext;
        if (Checks.CHECKS) {
            Checks.check((long)TSCtx);
        }
        JNI.invokePV((long)TSCtx, (long)__functionAddress);
    }

    @NativeType(value="LLVMOrcThreadSafeModuleRef")
    public static long LLVMOrcCreateNewThreadSafeModule(@NativeType(value="LLVMModuleRef") long M, @NativeType(value="LLVMOrcThreadSafeContextRef") long TSCtx) {
        long __functionAddress = Functions.OrcCreateNewThreadSafeModule;
        if (Checks.CHECKS) {
            Checks.check((long)M);
            Checks.check((long)TSCtx);
        }
        return JNI.invokePPP((long)M, (long)TSCtx, (long)__functionAddress);
    }

    public static void LLVMOrcDisposeThreadSafeModule(@NativeType(value="LLVMOrcThreadSafeModuleRef") long TSM) {
        long __functionAddress = Functions.OrcDisposeThreadSafeModule;
        if (Checks.CHECKS) {
            Checks.check((long)TSM);
        }
        JNI.invokePV((long)TSM, (long)__functionAddress);
    }

    public static long nLLVMOrcThreadSafeModuleWithModuleDo(long TSM, long F, long Ctx) {
        long __functionAddress = Functions.OrcThreadSafeModuleWithModuleDo;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)TSM);
            Checks.check((long)Ctx);
        }
        return JNI.invokePPPP((long)TSM, (long)F, (long)Ctx, (long)__functionAddress);
    }

    @NativeType(value="LLVMErrorRef")
    public static long LLVMOrcThreadSafeModuleWithModuleDo(@NativeType(value="LLVMOrcThreadSafeModuleRef") long TSM, @NativeType(value="LLVMOrcGenericIRModuleOperationFunction") LLVMOrcGenericIRModuleOperationFunctionI F, @NativeType(value="void *") long Ctx) {
        return LLVMOrc.nLLVMOrcThreadSafeModuleWithModuleDo(TSM, F.address(), Ctx);
    }

    public static long nLLVMOrcJITTargetMachineBuilderDetectHost(long Result) {
        long __functionAddress = Functions.OrcJITTargetMachineBuilderDetectHost;
        return JNI.invokePP((long)Result, (long)__functionAddress);
    }

    @NativeType(value="LLVMErrorRef")
    public static long LLVMOrcJITTargetMachineBuilderDetectHost(@NativeType(value="LLVMOrcJITTargetMachineBuilderRef *") PointerBuffer Result) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)Result, (int)1);
        }
        return LLVMOrc.nLLVMOrcJITTargetMachineBuilderDetectHost(MemoryUtil.memAddress((CustomBuffer)Result));
    }

    @NativeType(value="LLVMOrcJITTargetMachineBuilderRef")
    public static long LLVMOrcJITTargetMachineBuilderCreateFromTargetMachine(@NativeType(value="LLVMTargetMachineRef") long TM) {
        long __functionAddress = Functions.OrcJITTargetMachineBuilderCreateFromTargetMachine;
        if (Checks.CHECKS) {
            Checks.check((long)TM);
        }
        return JNI.invokePP((long)TM, (long)__functionAddress);
    }

    public static void LLVMOrcDisposeJITTargetMachineBuilder(@NativeType(value="LLVMOrcJITTargetMachineBuilderRef") long JTMB) {
        long __functionAddress = Functions.OrcDisposeJITTargetMachineBuilder;
        if (Checks.CHECKS) {
            Checks.check((long)JTMB);
        }
        JNI.invokePV((long)JTMB, (long)__functionAddress);
    }

    public static long nLLVMOrcJITTargetMachineBuilderGetTargetTriple(long JTMB) {
        long __functionAddress = Functions.OrcJITTargetMachineBuilderGetTargetTriple;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)JTMB);
        }
        return JNI.invokePP((long)JTMB, (long)__functionAddress);
    }

    @Nullable
    @NativeType(value="char *")
    public static String LLVMOrcJITTargetMachineBuilderGetTargetTriple(@NativeType(value="LLVMOrcJITTargetMachineBuilderRef") long JTMB) {
        long __result = LLVMOrc.nLLVMOrcJITTargetMachineBuilderGetTargetTriple(JTMB);
        return MemoryUtil.memUTF8Safe((long)__result);
    }

    public static void nLLVMOrcJITTargetMachineBuilderSetTargetTriple(long JTMB, long TargetTriple) {
        long __functionAddress = Functions.OrcJITTargetMachineBuilderSetTargetTriple;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)JTMB);
        }
        JNI.invokePPV((long)JTMB, (long)TargetTriple, (long)__functionAddress);
    }

    public static void LLVMOrcJITTargetMachineBuilderSetTargetTriple(@NativeType(value="LLVMOrcJITTargetMachineBuilderRef") long JTMB, @NativeType(value="char const *") ByteBuffer TargetTriple) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)TargetTriple);
        }
        LLVMOrc.nLLVMOrcJITTargetMachineBuilderSetTargetTriple(JTMB, MemoryUtil.memAddress((ByteBuffer)TargetTriple));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void LLVMOrcJITTargetMachineBuilderSetTargetTriple(@NativeType(value="LLVMOrcJITTargetMachineBuilderRef") long JTMB, @NativeType(value="char const *") CharSequence TargetTriple) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(TargetTriple, true);
            long TargetTripleEncoded = stack.getPointerAddress();
            LLVMOrc.nLLVMOrcJITTargetMachineBuilderSetTargetTriple(JTMB, TargetTripleEncoded);
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    @NativeType(value="LLVMErrorRef")
    public static long LLVMOrcObjectLayerAddObjectFile(@NativeType(value="LLVMOrcObjectLayerRef") long ObjLayer, @NativeType(value="LLVMOrcJITDylibRef") long JD, @NativeType(value="LLVMMemoryBufferRef") long ObjBuffer) {
        long __functionAddress = Functions.OrcObjectLayerAddObjectFile;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)ObjLayer);
            Checks.check((long)JD);
            Checks.check((long)ObjBuffer);
        }
        return JNI.invokePPPP((long)ObjLayer, (long)JD, (long)ObjBuffer, (long)__functionAddress);
    }

    @NativeType(value="LLVMErrorRef")
    public static long LLVMOrcObjectLayerAddObjectFileWithRT(@NativeType(value="LLVMOrcObjectLayerRef") long ObjLayer, @NativeType(value="LLVMOrcResourceTrackerRef") long RT, @NativeType(value="LLVMMemoryBufferRef") long ObjBuffer) {
        long __functionAddress = Functions.OrcObjectLayerAddObjectFileWithRT;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)ObjLayer);
            Checks.check((long)RT);
            Checks.check((long)ObjBuffer);
        }
        return JNI.invokePPPP((long)ObjLayer, (long)RT, (long)ObjBuffer, (long)__functionAddress);
    }

    public static void LLVMOrcObjectLayerEmit(@NativeType(value="LLVMOrcObjectLayerRef") long ObjLayer, @NativeType(value="LLVMOrcMaterializationResponsibilityRef") long R, @NativeType(value="LLVMMemoryBufferRef") long ObjBuffer) {
        long __functionAddress = Functions.OrcObjectLayerEmit;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)ObjLayer);
            Checks.check((long)R);
            Checks.check((long)ObjBuffer);
        }
        JNI.invokePPPV((long)ObjLayer, (long)R, (long)ObjBuffer, (long)__functionAddress);
    }

    public static void LLVMOrcDisposeObjectLayer(@NativeType(value="LLVMOrcObjectLayerRef") long ObjLayer) {
        long __functionAddress = Functions.OrcDisposeObjectLayer;
        if (Checks.CHECKS) {
            Checks.check((long)ObjLayer);
        }
        JNI.invokePV((long)ObjLayer, (long)__functionAddress);
    }

    public static void LLVMOrcIRTransformLayerEmit(@NativeType(value="LLVMOrcIRTransformLayerRef") long IRTransformLayer, @NativeType(value="LLVMOrcMaterializationResponsibilityRef") long MR, @NativeType(value="LLVMOrcThreadSafeModuleRef") long TSM) {
        long __functionAddress = Functions.OrcIRTransformLayerEmit;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)IRTransformLayer);
            Checks.check((long)MR);
            Checks.check((long)TSM);
        }
        JNI.invokePPPV((long)IRTransformLayer, (long)MR, (long)TSM, (long)__functionAddress);
    }

    public static void nLLVMOrcIRTransformLayerSetTransform(long IRTransformLayer, long TransformFunction, long Ctx) {
        long __functionAddress = Functions.OrcIRTransformLayerSetTransform;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)IRTransformLayer);
            Checks.check((long)Ctx);
        }
        JNI.invokePPPV((long)IRTransformLayer, (long)TransformFunction, (long)Ctx, (long)__functionAddress);
    }

    public static void LLVMOrcIRTransformLayerSetTransform(@NativeType(value="LLVMOrcIRTransformLayerRef") long IRTransformLayer, @NativeType(value="LLVMOrcIRTransformLayerTransformFunction") LLVMOrcIRTransformLayerTransformFunctionI TransformFunction, @NativeType(value="void *") long Ctx) {
        LLVMOrc.nLLVMOrcIRTransformLayerSetTransform(IRTransformLayer, TransformFunction.address(), Ctx);
    }

    public static void nLLVMOrcObjectTransformLayerSetTransform(long ObjTransformLayer, long TransformFunction, long Ctx) {
        long __functionAddress = Functions.OrcObjectTransformLayerSetTransform;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)ObjTransformLayer);
            Checks.check((long)Ctx);
        }
        JNI.invokePPPV((long)ObjTransformLayer, (long)TransformFunction, (long)Ctx, (long)__functionAddress);
    }

    public static void LLVMOrcObjectTransformLayerSetTransform(@NativeType(value="LLVMOrcObjectTransformLayerRef") long ObjTransformLayer, @NativeType(value="LLVMOrcObjectTransformLayerTransformFunction") LLVMOrcObjectTransformLayerTransformFunctionI TransformFunction, @NativeType(value="void *") long Ctx) {
        LLVMOrc.nLLVMOrcObjectTransformLayerSetTransform(ObjTransformLayer, TransformFunction.address(), Ctx);
    }

    public static long nLLVMOrcCreateLocalIndirectStubsManager(long TargetTriple) {
        long __functionAddress = Functions.OrcCreateLocalIndirectStubsManager;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.invokePP((long)TargetTriple, (long)__functionAddress);
    }

    @NativeType(value="LLVMOrcIndirectStubsManagerRef")
    public static long LLVMOrcCreateLocalIndirectStubsManager(@NativeType(value="char const *") ByteBuffer TargetTriple) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)TargetTriple);
        }
        return LLVMOrc.nLLVMOrcCreateLocalIndirectStubsManager(MemoryUtil.memAddress((ByteBuffer)TargetTriple));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMOrcIndirectStubsManagerRef")
    public static long LLVMOrcCreateLocalIndirectStubsManager(@NativeType(value="char const *") CharSequence TargetTriple) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(TargetTriple, true);
            long TargetTripleEncoded = stack.getPointerAddress();
            long l = LLVMOrc.nLLVMOrcCreateLocalIndirectStubsManager(TargetTripleEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void LLVMOrcDisposeIndirectStubsManager(@NativeType(value="LLVMOrcIndirectStubsManagerRef") long ISM) {
        long __functionAddress = Functions.OrcDisposeIndirectStubsManager;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)ISM);
        }
        JNI.invokePV((long)ISM, (long)__functionAddress);
    }

    public static long nLLVMOrcCreateLocalLazyCallThroughManager(long TargetTriple, long ES, long ErrorHandlerAddr, long LCTM) {
        long __functionAddress = Functions.OrcCreateLocalLazyCallThroughManager;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)ES);
        }
        return JNI.invokePPJPP((long)TargetTriple, (long)ES, (long)ErrorHandlerAddr, (long)LCTM, (long)__functionAddress);
    }

    @NativeType(value="LLVMErrorRef")
    public static long LLVMOrcCreateLocalLazyCallThroughManager(@NativeType(value="char const *") ByteBuffer TargetTriple, @NativeType(value="LLVMOrcExecutionSessionRef") long ES, @NativeType(value="LLVMOrcJITTargetAddress") long ErrorHandlerAddr, @NativeType(value="LLVMOrcLazyCallThroughManagerRef *") PointerBuffer LCTM) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)TargetTriple);
            Checks.check((CustomBuffer)LCTM, (int)1);
        }
        return LLVMOrc.nLLVMOrcCreateLocalLazyCallThroughManager(MemoryUtil.memAddress((ByteBuffer)TargetTriple), ES, ErrorHandlerAddr, MemoryUtil.memAddress((CustomBuffer)LCTM));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMErrorRef")
    public static long LLVMOrcCreateLocalLazyCallThroughManager(@NativeType(value="char const *") CharSequence TargetTriple, @NativeType(value="LLVMOrcExecutionSessionRef") long ES, @NativeType(value="LLVMOrcJITTargetAddress") long ErrorHandlerAddr, @NativeType(value="LLVMOrcLazyCallThroughManagerRef *") PointerBuffer LCTM) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)LCTM, (int)1);
        }
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(TargetTriple, true);
            long TargetTripleEncoded = stack.getPointerAddress();
            long l = LLVMOrc.nLLVMOrcCreateLocalLazyCallThroughManager(TargetTripleEncoded, ES, ErrorHandlerAddr, MemoryUtil.memAddress((CustomBuffer)LCTM));
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void LLVMOrcDisposeLazyCallThroughManager(@NativeType(value="LLVMOrcLazyCallThroughManagerRef") long LCTM) {
        long __functionAddress = Functions.OrcDisposeLazyCallThroughManager;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)LCTM);
        }
        JNI.invokePV((long)LCTM, (long)__functionAddress);
    }

    public static long nLLVMOrcCreateDumpObjects(long DumpDir, long IdentifierOverride) {
        long __functionAddress = Functions.OrcCreateDumpObjects;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
        }
        return JNI.invokePPP((long)DumpDir, (long)IdentifierOverride, (long)__functionAddress);
    }

    @NativeType(value="LLVMOrcDumpObjectsRef")
    public static long LLVMOrcCreateDumpObjects(@NativeType(value="char const *") ByteBuffer DumpDir, @NativeType(value="char const *") ByteBuffer IdentifierOverride) {
        if (Checks.CHECKS) {
            Checks.checkNT1((ByteBuffer)DumpDir);
            Checks.checkNT1((ByteBuffer)IdentifierOverride);
        }
        return LLVMOrc.nLLVMOrcCreateDumpObjects(MemoryUtil.memAddress((ByteBuffer)DumpDir), MemoryUtil.memAddress((ByteBuffer)IdentifierOverride));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NativeType(value="LLVMOrcDumpObjectsRef")
    public static long LLVMOrcCreateDumpObjects(@NativeType(value="char const *") CharSequence DumpDir, @NativeType(value="char const *") CharSequence IdentifierOverride) {
        MemoryStack stack = MemoryStack.stackGet();
        int stackPointer = stack.getPointer();
        try {
            stack.nUTF8(DumpDir, true);
            long DumpDirEncoded = stack.getPointerAddress();
            stack.nUTF8(IdentifierOverride, true);
            long IdentifierOverrideEncoded = stack.getPointerAddress();
            long l = LLVMOrc.nLLVMOrcCreateDumpObjects(DumpDirEncoded, IdentifierOverrideEncoded);
            return l;
        }
        finally {
            stack.setPointer(stackPointer);
        }
    }

    public static void LLVMOrcDisposeDumpObjects(@NativeType(value="LLVMOrcDumpObjectsRef") long DumpObjects) {
        long __functionAddress = Functions.OrcDisposeDumpObjects;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)DumpObjects);
        }
        JNI.invokePV((long)DumpObjects, (long)__functionAddress);
    }

    public static long nLLVMOrcDumpObjects_CallOperator(long DumpObjects, long ObjBuffer) {
        long __functionAddress = Functions.OrcDumpObjects_CallOperator;
        if (Checks.CHECKS) {
            Checks.check((long)__functionAddress);
            Checks.check((long)DumpObjects);
        }
        return JNI.invokePPP((long)DumpObjects, (long)ObjBuffer, (long)__functionAddress);
    }

    @NativeType(value="LLVMErrorRef")
    public static long LLVMOrcDumpObjects_CallOperator(@NativeType(value="LLVMOrcDumpObjectsRef") long DumpObjects, @NativeType(value="LLVMMemoryBufferRef *") PointerBuffer ObjBuffer) {
        if (Checks.CHECKS) {
            Checks.check((CustomBuffer)ObjBuffer, (int)1);
        }
        return LLVMOrc.nLLVMOrcDumpObjects_CallOperator(DumpObjects, MemoryUtil.memAddress((CustomBuffer)ObjBuffer));
    }

    public static final class Functions {
        public static final long OrcExecutionSessionSetErrorReporter = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMOrcExecutionSessionSetErrorReporter");
        public static final long OrcExecutionSessionGetSymbolStringPool = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMOrcExecutionSessionGetSymbolStringPool");
        public static final long OrcSymbolStringPoolClearDeadEntries = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMOrcSymbolStringPoolClearDeadEntries");
        public static final long OrcExecutionSessionIntern = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMOrcExecutionSessionIntern");
        public static final long OrcRetainSymbolStringPoolEntry = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMOrcRetainSymbolStringPoolEntry");
        public static final long OrcExecutionSessionLookup = APIUtil.apiGetFunctionAddressOptional((SharedLibrary)LLVMCore.getLibrary(), (String)"LLVMOrcExecutionSessionLookup");
        public static final long OrcReleaseSymbolStringPoolEntry = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMOrcReleaseSymbolStringPoolEntry");
        public static final long OrcSymbolStringPoolEntryStr = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMOrcSymbolStringPoolEntryStr");
        public static final long OrcReleaseResourceTracker = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMOrcReleaseResourceTracker");
        public static final long OrcResourceTrackerTransferTo = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMOrcResourceTrackerTransferTo");
        public static final long OrcResourceTrackerRemove = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMOrcResourceTrackerRemove");
        public static final long OrcDisposeDefinitionGenerator = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMOrcDisposeDefinitionGenerator");
        public static final long OrcDisposeMaterializationUnit = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMOrcDisposeMaterializationUnit");
        public static final long OrcCreateCustomMaterializationUnit = APIUtil.apiGetFunctionAddressOptional((SharedLibrary)LLVMCore.getLibrary(), (String)"LLVMOrcCreateCustomMaterializationUnit");
        public static final long OrcAbsoluteSymbols = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMOrcAbsoluteSymbols");
        public static final long OrcLazyReexports = APIUtil.apiGetFunctionAddressOptional((SharedLibrary)LLVMCore.getLibrary(), (String)"LLVMOrcLazyReexports");
        public static final long OrcDisposeMaterializationResponsibility = APIUtil.apiGetFunctionAddressOptional((SharedLibrary)LLVMCore.getLibrary(), (String)"LLVMOrcDisposeMaterializationResponsibility");
        public static final long OrcMaterializationResponsibilityGetTargetDylib = APIUtil.apiGetFunctionAddressOptional((SharedLibrary)LLVMCore.getLibrary(), (String)"LLVMOrcMaterializationResponsibilityGetTargetDylib");
        public static final long OrcMaterializationResponsibilityGetExecutionSession = APIUtil.apiGetFunctionAddressOptional((SharedLibrary)LLVMCore.getLibrary(), (String)"LLVMOrcMaterializationResponsibilityGetExecutionSession");
        public static final long OrcMaterializationResponsibilityGetSymbols = APIUtil.apiGetFunctionAddressOptional((SharedLibrary)LLVMCore.getLibrary(), (String)"LLVMOrcMaterializationResponsibilityGetSymbols");
        public static final long OrcDisposeCSymbolFlagsMap = APIUtil.apiGetFunctionAddressOptional((SharedLibrary)LLVMCore.getLibrary(), (String)"LLVMOrcDisposeCSymbolFlagsMap");
        public static final long OrcMaterializationResponsibilityGetInitializerSymbol = APIUtil.apiGetFunctionAddressOptional((SharedLibrary)LLVMCore.getLibrary(), (String)"LLVMOrcMaterializationResponsibilityGetInitializerSymbol");
        public static final long OrcMaterializationResponsibilityGetRequestedSymbols = APIUtil.apiGetFunctionAddressOptional((SharedLibrary)LLVMCore.getLibrary(), (String)"LLVMOrcMaterializationResponsibilityGetRequestedSymbols");
        public static final long OrcDisposeSymbols = APIUtil.apiGetFunctionAddressOptional((SharedLibrary)LLVMCore.getLibrary(), (String)"LLVMOrcDisposeSymbols");
        public static final long OrcMaterializationResponsibilityNotifyResolved = APIUtil.apiGetFunctionAddressOptional((SharedLibrary)LLVMCore.getLibrary(), (String)"LLVMOrcMaterializationResponsibilityNotifyResolved");
        public static final long OrcMaterializationResponsibilityNotifyEmitted = APIUtil.apiGetFunctionAddressOptional((SharedLibrary)LLVMCore.getLibrary(), (String)"LLVMOrcMaterializationResponsibilityNotifyEmitted");
        public static final long OrcMaterializationResponsibilityDefineMaterializing = APIUtil.apiGetFunctionAddressOptional((SharedLibrary)LLVMCore.getLibrary(), (String)"LLVMOrcMaterializationResponsibilityDefineMaterializing");
        public static final long OrcMaterializationResponsibilityFailMaterialization = APIUtil.apiGetFunctionAddressOptional((SharedLibrary)LLVMCore.getLibrary(), (String)"LLVMOrcMaterializationResponsibilityFailMaterialization");
        public static final long OrcMaterializationResponsibilityReplace = APIUtil.apiGetFunctionAddressOptional((SharedLibrary)LLVMCore.getLibrary(), (String)"LLVMOrcMaterializationResponsibilityReplace");
        public static final long OrcMaterializationResponsibilityDelegate = APIUtil.apiGetFunctionAddressOptional((SharedLibrary)LLVMCore.getLibrary(), (String)"LLVMOrcMaterializationResponsibilityDelegate");
        public static final long OrcMaterializationResponsibilityAddDependencies = APIUtil.apiGetFunctionAddressOptional((SharedLibrary)LLVMCore.getLibrary(), (String)"LLVMOrcMaterializationResponsibilityAddDependencies");
        public static final long OrcMaterializationResponsibilityAddDependenciesForAll = APIUtil.apiGetFunctionAddressOptional((SharedLibrary)LLVMCore.getLibrary(), (String)"LLVMOrcMaterializationResponsibilityAddDependenciesForAll");
        public static final long OrcExecutionSessionCreateBareJITDylib = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMOrcExecutionSessionCreateBareJITDylib");
        public static final long OrcExecutionSessionCreateJITDylib = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMOrcExecutionSessionCreateJITDylib");
        public static final long OrcExecutionSessionGetJITDylibByName = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMOrcExecutionSessionGetJITDylibByName");
        public static final long OrcJITDylibCreateResourceTracker = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMOrcJITDylibCreateResourceTracker");
        public static final long OrcJITDylibGetDefaultResourceTracker = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMOrcJITDylibGetDefaultResourceTracker");
        public static final long OrcJITDylibDefine = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMOrcJITDylibDefine");
        public static final long OrcJITDylibClear = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMOrcJITDylibClear");
        public static final long OrcJITDylibAddGenerator = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMOrcJITDylibAddGenerator");
        public static final long OrcCreateCustomCAPIDefinitionGenerator = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMOrcCreateCustomCAPIDefinitionGenerator");
        public static final long OrcLookupStateContinueLookup = APIUtil.apiGetFunctionAddressOptional((SharedLibrary)LLVMCore.getLibrary(), (String)"LLVMOrcLookupStateContinueLookup");
        public static final long OrcCreateDynamicLibrarySearchGeneratorForProcess = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMOrcCreateDynamicLibrarySearchGeneratorForProcess");
        public static final long OrcCreateDynamicLibrarySearchGeneratorForPath = APIUtil.apiGetFunctionAddressOptional((SharedLibrary)LLVMCore.getLibrary(), (String)"LLVMOrcCreateDynamicLibrarySearchGeneratorForPath");
        public static final long OrcCreateStaticLibrarySearchGeneratorForPath = APIUtil.apiGetFunctionAddressOptional((SharedLibrary)LLVMCore.getLibrary(), (String)"LLVMOrcCreateStaticLibrarySearchGeneratorForPath");
        public static final long OrcCreateNewThreadSafeContext = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMOrcCreateNewThreadSafeContext");
        public static final long OrcThreadSafeContextGetContext = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMOrcThreadSafeContextGetContext");
        public static final long OrcDisposeThreadSafeContext = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMOrcDisposeThreadSafeContext");
        public static final long OrcCreateNewThreadSafeModule = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMOrcCreateNewThreadSafeModule");
        public static final long OrcDisposeThreadSafeModule = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMOrcDisposeThreadSafeModule");
        public static final long OrcThreadSafeModuleWithModuleDo = APIUtil.apiGetFunctionAddressOptional((SharedLibrary)LLVMCore.getLibrary(), (String)"LLVMOrcThreadSafeModuleWithModuleDo");
        public static final long OrcJITTargetMachineBuilderDetectHost = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMOrcJITTargetMachineBuilderDetectHost");
        public static final long OrcJITTargetMachineBuilderCreateFromTargetMachine = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMOrcJITTargetMachineBuilderCreateFromTargetMachine");
        public static final long OrcDisposeJITTargetMachineBuilder = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMOrcDisposeJITTargetMachineBuilder");
        public static final long OrcJITTargetMachineBuilderGetTargetTriple = APIUtil.apiGetFunctionAddressOptional((SharedLibrary)LLVMCore.getLibrary(), (String)"LLVMOrcJITTargetMachineBuilderGetTargetTriple");
        public static final long OrcJITTargetMachineBuilderSetTargetTriple = APIUtil.apiGetFunctionAddressOptional((SharedLibrary)LLVMCore.getLibrary(), (String)"LLVMOrcJITTargetMachineBuilderSetTargetTriple");
        public static final long OrcObjectLayerAddObjectFile = APIUtil.apiGetFunctionAddressOptional((SharedLibrary)LLVMCore.getLibrary(), (String)"LLVMOrcObjectLayerAddObjectFile");
        public static final long OrcObjectLayerAddObjectFileWithRT = APIUtil.apiGetFunctionAddressOptional((SharedLibrary)LLVMCore.getLibrary(), (String)"LLVMOrcObjectLayerAddObjectFileWithRT");
        public static final long OrcObjectLayerEmit = APIUtil.apiGetFunctionAddressOptional((SharedLibrary)LLVMCore.getLibrary(), (String)"LLVMOrcObjectLayerEmit");
        public static final long OrcDisposeObjectLayer = APIUtil.apiGetFunctionAddress((FunctionProvider)LLVMCore.getLibrary(), (String)"LLVMOrcDisposeObjectLayer");
        public static final long OrcIRTransformLayerEmit = APIUtil.apiGetFunctionAddressOptional((SharedLibrary)LLVMCore.getLibrary(), (String)"LLVMOrcIRTransformLayerEmit");
        public static final long OrcIRTransformLayerSetTransform = APIUtil.apiGetFunctionAddressOptional((SharedLibrary)LLVMCore.getLibrary(), (String)"LLVMOrcIRTransformLayerSetTransform");
        public static final long OrcObjectTransformLayerSetTransform = APIUtil.apiGetFunctionAddressOptional((SharedLibrary)LLVMCore.getLibrary(), (String)"LLVMOrcObjectTransformLayerSetTransform");
        public static final long OrcCreateLocalIndirectStubsManager = APIUtil.apiGetFunctionAddressOptional((SharedLibrary)LLVMCore.getLibrary(), (String)"LLVMOrcCreateLocalIndirectStubsManager");
        public static final long OrcDisposeIndirectStubsManager = APIUtil.apiGetFunctionAddressOptional((SharedLibrary)LLVMCore.getLibrary(), (String)"LLVMOrcDisposeIndirectStubsManager");
        public static final long OrcCreateLocalLazyCallThroughManager = APIUtil.apiGetFunctionAddressOptional((SharedLibrary)LLVMCore.getLibrary(), (String)"LLVMOrcCreateLocalLazyCallThroughManager");
        public static final long OrcDisposeLazyCallThroughManager = APIUtil.apiGetFunctionAddressOptional((SharedLibrary)LLVMCore.getLibrary(), (String)"LLVMOrcDisposeLazyCallThroughManager");
        public static final long OrcCreateDumpObjects = APIUtil.apiGetFunctionAddressOptional((SharedLibrary)LLVMCore.getLibrary(), (String)"LLVMOrcCreateDumpObjects");
        public static final long OrcDisposeDumpObjects = APIUtil.apiGetFunctionAddressOptional((SharedLibrary)LLVMCore.getLibrary(), (String)"LLVMOrcDisposeDumpObjects");
        public static final long OrcDumpObjects_CallOperator = APIUtil.apiGetFunctionAddressOptional((SharedLibrary)LLVMCore.getLibrary(), (String)"LLVMOrcDumpObjects_CallOperator");

        private Functions() {
        }
    }
}

