/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.llvm;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.llvm.LLVMJITSymbolFlags;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class LLVMOrcCSymbolFlagsMapPair
extends Struct<LLVMOrcCSymbolFlagsMapPair>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int NAME;
    public static final int FLAGS;

    protected LLVMOrcCSymbolFlagsMapPair(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected LLVMOrcCSymbolFlagsMapPair create(long address, @Nullable ByteBuffer container) {
        return new LLVMOrcCSymbolFlagsMapPair(address, container);
    }

    public LLVMOrcCSymbolFlagsMapPair(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), LLVMOrcCSymbolFlagsMapPair.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="LLVMOrcSymbolStringPoolEntryRef")
    public long Name() {
        return LLVMOrcCSymbolFlagsMapPair.nName(this.address());
    }

    public LLVMJITSymbolFlags Flags() {
        return LLVMOrcCSymbolFlagsMapPair.nFlags(this.address());
    }

    public LLVMOrcCSymbolFlagsMapPair Name(@NativeType(value="LLVMOrcSymbolStringPoolEntryRef") long value) {
        LLVMOrcCSymbolFlagsMapPair.nName(this.address(), value);
        return this;
    }

    public LLVMOrcCSymbolFlagsMapPair Flags(LLVMJITSymbolFlags value) {
        LLVMOrcCSymbolFlagsMapPair.nFlags(this.address(), value);
        return this;
    }

    public LLVMOrcCSymbolFlagsMapPair Flags(Consumer<LLVMJITSymbolFlags> consumer) {
        consumer.accept(this.Flags());
        return this;
    }

    public LLVMOrcCSymbolFlagsMapPair set(long Name, LLVMJITSymbolFlags Flags) {
        this.Name(Name);
        this.Flags(Flags);
        return this;
    }

    public LLVMOrcCSymbolFlagsMapPair set(LLVMOrcCSymbolFlagsMapPair src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static LLVMOrcCSymbolFlagsMapPair malloc() {
        return new LLVMOrcCSymbolFlagsMapPair(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static LLVMOrcCSymbolFlagsMapPair calloc() {
        return new LLVMOrcCSymbolFlagsMapPair(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static LLVMOrcCSymbolFlagsMapPair create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new LLVMOrcCSymbolFlagsMapPair(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static LLVMOrcCSymbolFlagsMapPair create(long address) {
        return new LLVMOrcCSymbolFlagsMapPair(address, null);
    }

    @Nullable
    public static LLVMOrcCSymbolFlagsMapPair createSafe(long address) {
        return address == 0L ? null : new LLVMOrcCSymbolFlagsMapPair(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)LLVMOrcCSymbolFlagsMapPair.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = LLVMOrcCSymbolFlagsMapPair.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    public static LLVMOrcCSymbolFlagsMapPair malloc(MemoryStack stack) {
        return new LLVMOrcCSymbolFlagsMapPair(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static LLVMOrcCSymbolFlagsMapPair calloc(MemoryStack stack) {
        return new LLVMOrcCSymbolFlagsMapPair(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static long nName(long struct) {
        return MemoryUtil.memGetAddress((long)(struct + (long)NAME));
    }

    public static LLVMJITSymbolFlags nFlags(long struct) {
        return LLVMJITSymbolFlags.create(struct + (long)FLAGS);
    }

    public static void nName(long struct, long value) {
        MemoryUtil.memPutAddress((long)(struct + (long)NAME), (long)Checks.check((long)value));
    }

    public static void nFlags(long struct, LLVMJITSymbolFlags value) {
        MemoryUtil.memCopy((long)value.address(), (long)(struct + (long)FLAGS), (long)LLVMJITSymbolFlags.SIZEOF);
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)NAME)));
    }

    static {
        Struct.Layout layout = LLVMOrcCSymbolFlagsMapPair.__struct((Struct.Member[])new Struct.Member[]{LLVMOrcCSymbolFlagsMapPair.__member((int)POINTER_SIZE), LLVMOrcCSymbolFlagsMapPair.__member((int)LLVMJITSymbolFlags.SIZEOF, (int)LLVMJITSymbolFlags.ALIGNOF)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        NAME = layout.offsetof(0);
        FLAGS = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<LLVMOrcCSymbolFlagsMapPair, Buffer>
    implements NativeResource {
        private static final LLVMOrcCSymbolFlagsMapPair ELEMENT_FACTORY = LLVMOrcCSymbolFlagsMapPair.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected LLVMOrcCSymbolFlagsMapPair getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="LLVMOrcSymbolStringPoolEntryRef")
        public long Name() {
            return LLVMOrcCSymbolFlagsMapPair.nName(this.address());
        }

        public LLVMJITSymbolFlags Flags() {
            return LLVMOrcCSymbolFlagsMapPair.nFlags(this.address());
        }

        public Buffer Name(@NativeType(value="LLVMOrcSymbolStringPoolEntryRef") long value) {
            LLVMOrcCSymbolFlagsMapPair.nName(this.address(), value);
            return this;
        }

        public Buffer Flags(LLVMJITSymbolFlags value) {
            LLVMOrcCSymbolFlagsMapPair.nFlags(this.address(), value);
            return this;
        }

        public Buffer Flags(Consumer<LLVMJITSymbolFlags> consumer) {
            consumer.accept(this.Flags());
            return this;
        }
    }
}

