/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.llvm;

import java.nio.ByteBuffer;
import org.jspecify.annotations.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class CXSourceRange
extends Struct<CXSourceRange>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int PTR_DATA;
    public static final int BEGIN_INT_DATA;
    public static final int END_INT_DATA;

    protected CXSourceRange(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected CXSourceRange create(long address, @Nullable ByteBuffer container) {
        return new CXSourceRange(address, container);
    }

    public CXSourceRange(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), CXSourceRange.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="void const *[2]")
    public PointerBuffer ptr_data() {
        return CXSourceRange.nptr_data(this.address());
    }

    @NativeType(value="void const *")
    public long ptr_data(int index) {
        return CXSourceRange.nptr_data(this.address(), index);
    }

    @NativeType(value="unsigned")
    public int begin_int_data() {
        return CXSourceRange.nbegin_int_data(this.address());
    }

    @NativeType(value="unsigned")
    public int end_int_data() {
        return CXSourceRange.nend_int_data(this.address());
    }

    public static CXSourceRange malloc() {
        return new CXSourceRange(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static CXSourceRange calloc() {
        return new CXSourceRange(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static CXSourceRange create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new CXSourceRange(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static CXSourceRange create(long address) {
        return new CXSourceRange(address, null);
    }

    public static @Nullable CXSourceRange createSafe(long address) {
        return address == 0L ? null : new CXSourceRange(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)CXSourceRange.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = CXSourceRange.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    public static @Nullable Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static CXSourceRange mallocStack() {
        return CXSourceRange.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static CXSourceRange callocStack() {
        return CXSourceRange.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static CXSourceRange mallocStack(MemoryStack stack) {
        return CXSourceRange.malloc(stack);
    }

    @Deprecated
    public static CXSourceRange callocStack(MemoryStack stack) {
        return CXSourceRange.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return CXSourceRange.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return CXSourceRange.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return CXSourceRange.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return CXSourceRange.calloc(capacity, stack);
    }

    public static CXSourceRange malloc(MemoryStack stack) {
        return new CXSourceRange(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static CXSourceRange calloc(MemoryStack stack) {
        return new CXSourceRange(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static PointerBuffer nptr_data(long struct) {
        return MemoryUtil.memPointerBuffer((long)(struct + (long)PTR_DATA), (int)2);
    }

    public static long nptr_data(long struct, int index) {
        return MemoryUtil.memGetAddress((long)(struct + (long)PTR_DATA + Checks.check((int)index, (int)2) * (long)POINTER_SIZE));
    }

    public static int nbegin_int_data(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)BEGIN_INT_DATA));
    }

    public static int nend_int_data(long struct) {
        return MemoryUtil.memGetInt((long)(struct + (long)END_INT_DATA));
    }

    static {
        Struct.Layout layout = CXSourceRange.__struct((Struct.Member[])new Struct.Member[]{CXSourceRange.__array((int)POINTER_SIZE, (int)2), CXSourceRange.__member((int)4), CXSourceRange.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        PTR_DATA = layout.offsetof(0);
        BEGIN_INT_DATA = layout.offsetof(1);
        END_INT_DATA = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<CXSourceRange, Buffer>
    implements NativeResource {
        private static final CXSourceRange ELEMENT_FACTORY = CXSourceRange.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer create(long address, @Nullable ByteBuffer container, int mark, int position, int limit, int capacity) {
            return new Buffer(address, container, mark, position, limit, capacity);
        }

        protected CXSourceRange getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="void const *[2]")
        public PointerBuffer ptr_data() {
            return CXSourceRange.nptr_data(this.address());
        }

        @NativeType(value="void const *")
        public long ptr_data(int index) {
            return CXSourceRange.nptr_data(this.address(), index);
        }

        @NativeType(value="unsigned")
        public int begin_int_data() {
            return CXSourceRange.nbegin_int_data(this.address());
        }

        @NativeType(value="unsigned")
        public int end_int_data() {
            return CXSourceRange.nend_int_data(this.address());
        }
    }
}

